/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.SeedStatus;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;
import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.messaging.MessageLogEntryDAO;
import gov.va.med.esr.common.persistent.messaging.SeedingLogEntryDAO;
import gov.va.med.esr.common.rule.service.AssociationRuleService;
import gov.va.med.esr.common.rule.service.ClinicalDeterminationRuleService;
import gov.va.med.esr.common.rule.service.ContactInfoRuleService;
import gov.va.med.esr.common.rule.service.DemographicRuleService;
import gov.va.med.esr.common.rule.service.EligibilityEnrollmentRuleService;
import gov.va.med.esr.common.rule.service.EligibilityFactorRuleService;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.rule.service.FinancialInfoRuleService;
import gov.va.med.esr.common.rule.service.InsuranceRuleService;
import gov.va.med.esr.common.rule.service.MilitaryRuleService;
import gov.va.med.esr.common.rule.service.POWRuleService;
import gov.va.med.esr.common.rule.service.PurpleHeartRuleService;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.AddProxyPreferredFacilityException;
import gov.va.med.esr.service.impl.VOAApplicationServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.esr.service.trigger.RetransmitTriggerEvent;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.ps.model.PatientIdentifier;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.Validate;

public class MessagingServiceImpl
extends AbstractRuleAwareServiceImpl
implements MessagingService {
    private static final long serialVersionUID = -1936162067559837119L;
    private static final String ORUZ12 = "ORUZ12-E";
    private static final String ORUZ13 = "ORUZ13-E";
    private static final String QRYZ11 = "QRYZ11";
    private static final String QRYZ10 = "QRYZ10";
    private static final String RETRANSMIT_EVENT = "messaging.retransmit";
    private static final String VOA_CLE_CANNOT_BE_DETERMINED = "Veteran CL Eligibility cannot be determined";
    private static VAFacility VOA_VA_FACILITY = null;
    private static WorkflowService workflowService = null;
    private Map diagnosisMap;
    private Map procedureMap;
    private Map conditionMap;
    private UniqueIdentifierGenerator generator = null;
    private MessageLogEntryDAO messageLogEntryDAO = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private RegistryService registryService = null;
    private TriggerRouter triggerRouter = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private EntityCacheManager entityCacheManager;
    private SeedingLogEntryDAO seedingLogEntryDAO = null;
    private SystemParameterService systemParameterService = null;
    private PreferredFacilityService preferredFacilityService = null;
    private static final Integer defaultIncomeYear = new Integer(Calendar.getInstance().get(1) - 1);

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }

    public MessageLogEntryDAO getMessageLogEntryDAO() {
        return this.messageLogEntryDAO;
    }

    public void setMessageLogEntryDAO(MessageLogEntryDAO messageLogEntryDAO) {
        this.messageLogEntryDAO = messageLogEntryDAO;
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public SeedingLogEntryDAO getSeedingLogEntryDAO() {
        return this.seedingLogEntryDAO;
    }

    public void setSeedingLogEntryDAO(SeedingLogEntryDAO seedingLogEntryDAO) {
        this.seedingLogEntryDAO = seedingLogEntryDAO;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.systemParameterService, (String)"systemParameterService is required");
        Validate.notNull((Object)this.messageLogEntryDAO, (String)"MessageLogEntryDAO is required");
        Validate.notNull((Object)this.triggerRouter, (String)"triggerRouter is required");
        Validate.notNull((Object)this.triggerEventCacheManager, (String)"triggerEventCacheManager is required");
        Validate.notNull((Object)this.entityCacheManager, (String)"entityCacheManager is required");
    }

    @Override
    public String generateControlIdentifier() throws ServiceException {
        return this.generator.generate().toString();
    }

    @Override
    public SiteIdentity getIdentity(Person person, VAFacility vaFacility) throws ServiceException {
        Validate.notNull((Object)((Object)vaFacility), (String)"VAFacility can not be null");
        SiteIdentity siteId2 = null;
        if (person != null) {
            Set sites = this.findSitesOfRecord(person);
            for (SiteIdentity siteId2 : sites) {
                if (!siteId2.getVaFacility().getCode().equals(vaFacility.getCode())) continue;
                return siteId2;
            }
        }
        siteId2 = new SiteIdentity();
        siteId2.setVaFacility(vaFacility);
        return siteId2;
    }

    @Override
    public Set getMatchingTraits(PersonIdentityTraits identityTraits) throws ServiceException {
        return this.getPsDelegateService().unattendedSearch(identityTraits);
    }

    @Override
    public void logMessage(MessageLogEntry entry) throws ServiceException {
        try {
            if (entry.getEntityKey() == null) {
                this.messageLogEntryDAO.saveObject((Object)entry);
            } else {
                MessageLogEntry cachedEntry = (MessageLogEntry)((Object)this.messageLogEntryDAO.getByKey(entry.getEntityKey()));
                cachedEntry.setAckDate(entry.getAckDate());
                cachedEntry.setAckType(entry.getAckType());
                cachedEntry.setErrorText(entry.getErrorText());
                cachedEntry.setInternalErrorText(entry.getInternalErrorText());
                cachedEntry.setStatus(entry.getStatus());
                this.messageLogEntryDAO.saveObject((Object)cachedEntry);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log message ", (Throwable)ex);
        }
    }

    @Override
    public MessageLogEntry getMessageLogEntryById(BigDecimal id) throws ServiceException {
        MessageLogEntry mle = null;
        try {
            mle = this.messageLogEntryDAO.getById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public MessageLogEntryLite getMessageLogEntryLiteById(BigDecimal id) throws ServiceException {
        MessageLogEntryLite mle = null;
        try {
            mle = this.messageLogEntryDAO.getMessageLogEntryLiteById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry lite by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public MessageLogEntry getMessageLogEntry(String id) throws ServiceException {
        MessageLogEntry mle = null;
        try {
            mle = this.messageLogEntryDAO.getByControlId(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public MessageLogEntry getMessageLogEntryByBatchControlNumber(String id) throws ServiceException {
        MessageLogEntry mle = null;
        try {
            mle = this.messageLogEntryDAO.getByBatchControlId(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by batch id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public Set findSitesOfRecord(Person person) throws ServiceException {
        return person == null ? new HashSet() : this.getPsDelegateService().getSites(person.getVPIDEntityKey());
    }

    public List search(SearchQueryInfo criteria) throws ServiceException {
        List list = null;
        try {
            list = this.messageLogEntryDAO.find(criteria);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get the Messages matchong the criteria", (Throwable)ex);
        }
        return list;
    }

    @Override
    public Person processNonQueryZ11(Person incoming, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A person to be updated must not be null ");
        Validate.notNull((Object)((Object)verificationInfo), (String)"A verification info must not be null ");
        Person onFile = this.getPersonService().getPerson(incoming.getPersonEntityKey());
        this.validateEnrollmentDetermination(onFile);
        boolean qmse = this.getMilitaryRuleService().hasQualifyingMse(onFile, verificationInfo);
        verificationInfo.setHasQualifyingMse(qmse);
        Person updated = this.getProcessVBARuleService().verifyEligibility(incoming, onFile, verificationInfo);
        if (verificationInfo.isTriggerEnrollmentProcess()) {
            updated = this.getEligibilityEnrollmentService().assessEEImpact(updated, false, false);
            this.getEventRuleService().manageMessageEvents(updated);
            updated.removeAllInProcessFinancials();
            Person pristinePerson = (Person)this.entityCacheManager.getItem(updated.getEntityKey());
            if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)updated)) {
                this.triggerEventCacheManager.removeTriggerEvents();
            } else {
                if (incoming.getServiceConnectionAward() != null && updated.getServiceConnectionAward() != null && incoming.getServiceConnectionAward().getUnemployable() == null) {
                    updated.getServiceConnectionAward().setUnemployable(null);
                }
                EligibilityEnrollmentRuleService ers = this.getEnrollmentRuleService();
                ers.processHandBookTriggers(updated, onFile, null, verificationInfo);
                updated = this.getPersonService().save(updated);
            }
        }
        this.getEventRuleService().processPersonEventsForPensionBulletin(updated);
        try {
            this.postProcessVOASubmission(updated, "VBA_QUERY_RESPONSE", null);
        }
        catch (AddProxyPreferredFacilityException pfex) {
            this.logger.error((Object)("Process VBA Query Response Error: Unable to add Proxy PF for a VOA Submission. person_id= " + updated.getEntityKey().getKeyValueAsString()));
        }
        return updated;
    }

    @Override
    public Person processORUZ04(Person person) throws ServiceException {
        return person;
    }

    @Override
    public Person processORUZ05(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson(incoming.getPersonEntityKey());
        this.validateEnrollmentDetermination(onFile);
        this.getContactInfoRuleService().processAddresses(incoming.getAddresses(), onFile, null);
        Person pristinePerson = (Person)this.entityCacheManager.getItem(onFile.getEntityKey());
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)onFile)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            this.getPersonService().save(onFile);
        }
        return onFile;
    }

    @Override
    public Person processVOA(Person incoming, VAFacility sendingFacility, VerificationInfo verificationInfo, boolean isAnonymoysLOA1, List<PatientIdentifier> correlations) throws ServiceException, AddProxyPreferredFacilityException {
        Validate.notNull((Object)((Object)incoming), (String)"A incoming Person must not be null");
        Validate.notNull((Object)((Object)sendingFacility), (String)"A sending facility must not be null");
        if (this.logger.isDebugEnabled() && incoming != null) {
            this.logger.debug((Object)("MessagingServiceImpl.processVOA(): Start processing VOA rules for person VPID= " + incoming.getVPIDValue()));
        }
        PersonEntityKey personKey = null;
        personKey = incoming.getPersonEntityKey();
        Person onFile = null;
        if (incoming.isJustAdded() || incoming.getIdentityTraits() != null && incoming.getIdentityTraits().getNames() != null) {
            onFile = this.getPersonService().getPerson(personKey, incoming.getIdentityTraits());
            onFile.setJustAdded(true);
        } else {
            onFile = this.getPersonService().getPerson(personKey);
        }
        boolean isNewPerson = false;
        if (onFile.getEnrollmentDeterminations() == null || onFile.getEnrollmentDeterminations().size() == 0) {
            isNewPerson = true;
        }
        EligibilityFactorRuleService efrs = this.getEligibilityFactorRuleService();
        efrs.processNewVeteran(incoming, onFile);
        ContactInfoRuleService contactInfoRuleservice = this.getContactInfoRuleService();
        contactInfoRuleservice.processAddresses(incoming.getAddresses(), onFile, sendingFacility);
        contactInfoRuleservice.processPhones(incoming, onFile, sendingFacility);
        contactInfoRuleservice.processElectronicAddresses(incoming.getEmails(), onFile, sendingFacility);
        InsuranceRuleService insRuleService = this.getInsuranceRuleService();
        insRuleService.manageInsurancePolicies(incoming.getInsurances(), onFile, sendingFacility);
        insRuleService.processMedicaidFactor(incoming.getMedicaidFactor(), onFile);
        AssociationRuleService associationRuleService = this.getAssociationRuleService();
        associationRuleService.processAssociations(incoming.getAssociations(), onFile, sendingFacility);
        POWRuleService powRuleService = this.getPowRuleService();
        powRuleService.processPOW(incoming, onFile, sendingFacility);
        PurpleHeartRuleService phRuleService = this.getPurpleHeartRuleService();
        phRuleService.processPurpleHeart(incoming, onFile, verificationInfo, sendingFacility);
        this.getRegistryService().linkPersonRegistries(incoming, onFile, false);
        ClinicalDeterminationRuleService cdrs = this.getClinicalDeterminationRuleService();
        cdrs.processClinicalDetermination(incoming, onFile, sendingFacility, null);
        EligibilityEnrollmentRuleService ers = this.getEnrollmentRuleService();
        ers.processPerson(incoming, onFile, sendingFacility, verificationInfo, false);
        ers.processReceivedEligibilities(incoming, onFile, verificationInfo, false);
        ers.processIneligibility(incoming, onFile, sendingFacility, verificationInfo, false);
        MilitaryRuleService mrs = this.getMilitaryRuleService();
        mrs.processMilitaryService(sendingFacility, null, incoming.getMilitaryService(), onFile, null);
        mrs.calculatePeriodOfService(incoming, onFile, "MS", sendingFacility);
        DemographicRuleService drs = this.getDemographicRuleService();
        drs.processDemographicInfo(sendingFacility, incoming, onFile, false);
        Map incomeTests = incoming.getIncomeTests();
        Map financialStatements = incoming.getFinancialStatements();
        Map patientVisitSummaries = incoming.getPatientVisitSummaries();
        Map beneficiaryTravels = incoming.getBeneficiaryTravels();
        FinancialInfoRuleService frs = this.getFinancialInfoRuleService();
        EEResultInfo info = new EEResultInfo();
        if (MapUtils.isNotEmpty((Map)incomeTests) || MapUtils.isNotEmpty((Map)financialStatements) || MapUtils.isNotEmpty((Map)patientVisitSummaries) || MapUtils.isNotEmpty((Map)beneficiaryTravels)) {
            Integer incomeYear = this.getIncomeYear(incomeTests, financialStatements, patientVisitSummaries, beneficiaryTravels);
            if (incomeYear != null && incomeYear == 0) {
                if (MapUtils.isNotEmpty((Map)incomeTests)) {
                    IncomeTest test = incoming.getIncomeTest(incomeYear);
                    test.setIncomeYear(defaultIncomeYear);
                    incoming.setIncomeTest(incomeYear, null);
                    incoming.setIncomeTest(defaultIncomeYear, test);
                } else if (MapUtils.isNotEmpty((Map)financialStatements)) {
                    FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
                    stmt.setIncomeYear(defaultIncomeYear);
                    incoming.setFinancialStatement(incomeYear, null);
                    incoming.setFinancialStatement(defaultIncomeYear, stmt);
                } else if (MapUtils.isNotEmpty((Map)patientVisitSummaries)) {
                    ((SiteYear)((Object)patientVisitSummaries.keySet().iterator().next())).setYear(defaultIncomeYear);
                } else {
                    ((SiteYear)((Object)beneficiaryTravels.keySet().iterator().next())).setYear(defaultIncomeYear);
                }
                incomeYear = defaultIncomeYear;
            }
            frs.processFinancialInfo(incomeYear, sendingFacility, incoming, onFile, info, false);
        }
        this.getProcessVBARuleService().processVBAData(incoming, sendingFacility, onFile, verificationInfo);
        incoming.setVeteran(onFile.getVeteran());
        if (!isAnonymoysLOA1 && isNewPerson) {
            incoming.setJustAdded(true);
        }
        EEResultInfo clvInfo = new EEResultInfo();
        efrs.processSpecialFactors(incoming, sendingFacility, onFile, false, clvInfo);
        if (VOA_CLE_CANNOT_BE_DETERMINED.equals(clvInfo.getCLVErrorReason())) {
            return onFile;
        }
        efrs.processIncompetenceRuling(incoming.getIncompetenceRuling(), onFile);
        efrs.processEmergencyResponseIndicator(incoming, onFile);
        Person calculatedPerson = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false, false, sendingFacility);
        this.getEventRuleService().processMessageEvents(onFile, sendingFacility, verificationInfo, info.isZ10Sent());
        Person pristinePerson = (Person)this.entityCacheManager.getItem(calculatedPerson.getEntityKey());
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)calculatedPerson)) {
            this.logger.info((Object)"incoming person is same as onFile person in processVOA()");
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            Set pfs;
            this.logger.info((Object)"incoming person is defferent than onFile person in processVOA()");
            if (this.getSystemParameterService().getMSDSReconIndicator().booleanValue() && this.buildMSDRecord(pristinePerson, calculatedPerson)) {
                this.logger.info((Object)"Reconciliation taking place");
                mrs.processSeedingMilitaryService(onFile.getMilitaryService(), onFile);
                this.updateSeedingLogEntry(calculatedPerson, SeedStatus.COMPLETE.getCode(), verificationInfo.getMessageControlId());
                this.logger.info((Object)"Completed Reconciliation");
            }
            this.getEventRuleService().processPersonEventsForPensionBulletin(calculatedPerson);
            ers.processHandBookTriggers(calculatedPerson, onFile, null, verificationInfo);
            if (calculatedPerson.getMostRecentPreferredFacility() == null && (pfs = calculatedPerson.getPreferredFacilities()) != null && pfs.size() > 0) {
                this.getPreferredFacilityService().setCalculatedMostRecentPreferredFacility(calculatedPerson);
            }
            if (incoming.getVOAIndicator() != null) {
                calculatedPerson.setVOAIndicator(incoming.getVOAIndicator());
            }
            this.postProcessVOASubmission(calculatedPerson, "VOA_SUBMISSION", correlations);
            this.logger.info((Object)"saving the calculated person - processVOA()");
            this.logger.info((Object)"setting income test to the calculated person");
            try {
                onFile = this.getPersonService().save(calculatedPerson);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception occurred while trying to save the person in ADR: " + e));
            }
            if (isNewPerson) {
                this.logger.info((Object)"new person");
                this.postProcessVOASubmission(calculatedPerson, "VOA_SUBMISSION", correlations);
                this.getHelperService().addToSSNVerificationQueue(incoming);
            }
        }
        if (this.logger.isDebugEnabled() && incoming != null) {
            this.logger.debug((Object)("MessagingServiceImpl.processVOA(): END processing VOA rules for person VPID= " + incoming.getVPIDValue()));
        }
        return onFile;
    }

    @Override
    public void postProcessVOASubmission(Person onFile, String process, List<PatientIdentifier> correlations) throws ServiceException, AddProxyPreferredFacilityException {
        if (onFile.getEnrollmentDetermination() == null || !VOAApplicationServiceImpl.VOA_IND_1.equals(onFile.getVOAIndicator()) && !VOAApplicationServiceImpl.VOA_IND_2.equals(onFile.getVOAIndicator())) {
            return;
        }
        Person clonePerson = (Person)((Object)onFile.clone());
        if (clonePerson.getEnrollmentDetermination().getEnrollmentStatus() != null) {
            boolean isEnrollStatusPending = false;
            String statusCd = clonePerson.getEnrollmentDetermination().getEnrollmentStatus().getCode();
            boolean bl = isEnrollStatusPending = EnrollmentStatus.CODE_PENDING.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_MEANS_TEST_REQUIRED.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_NO_ELIGIBILITY_CODE_IN_VIVA.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_OTHER.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_PURPLE_HEART_UNCONFIRMED.getCode().equals(statusCd);
            if (isEnrollStatusPending) {
                if (!("VOA_SUBMISSION".equals(process) || "MSDS_QUERY_RESPONSE".equals(process) && AACIndicator.CODE_AAC_QUERIED_PENDING.getCode().equals(this.getVBAQueryStatus(clonePerson)))) {
                    if (workflowService == null) {
                        workflowService = (WorkflowService)this.getComponent("workflowService", WorkflowService.class);
                    }
                    workflowService.autoCreateCase(clonePerson, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "VOA Submission with Determined Enrollment Status of PENDING");
                    if (clonePerson.getEmails() != null && clonePerson.getEmails().size() > 0) {
                        String[] toList = new String[clonePerson.getEmails().size()];
                        int i = 0;
                        Iterator it = clonePerson.getEmails().iterator();
                        while (it.hasNext()) {
                            toList[i] = ((Email)((Object)it.next())).getAddress();
                            ++i;
                        }
                        if (this.getBulletinService() != null) {
                            try {
                                this.getBulletinService().sendSimpleMailMessage(null, toList, null, "Department of Veterans Affairs; Online Form VOA submission", "Dear " + clonePerson.getLegalName().getGivenName() + " " + clonePerson.getLegalName().getFamilyName() + ", We have begun processing your application for enrollment. However, we need additional information to complete your application. Someone from the Health Eligibility Center or your Preferred Facility will be contacting you with further information. Or you may contact the Health Eligibility Center at 404-828-5257.");
                            }
                            catch (Throwable t) {
                                this.logger.error((Object)("Enrollment Status = PENDING, cannot send VOA_NOTIFY_VET_NEED_MORE_INFO email notification for personId= " + clonePerson.getEntityKey().getKeyValueAsString() + "\nError Message: " + t.getMessage()));
                            }
                        }
                    }
                }
                this.removeMsgTriggersToVistA();
            } else {
                this.closeVOAPendingWkCase(clonePerson);
                if (VOAApplicationServiceImpl.VOA_IND_2.equals(clonePerson.getVOAIndicator())) {
                    try {
                        this.getPersonService().addPreferredFacilityCorrelation(clonePerson, correlations);
                    }
                    catch (ServiceException ex) {
                        workflowService.autoCreateCase(clonePerson, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Request for VOA Proxy Preferred Facility Patient Record Create Failed");
                        throw new AddProxyPreferredFacilityException(ex);
                    }
                    onFile.setVOAIndicator(VOAApplicationServiceImpl.VOA_IND_1);
                    this.getPersonService().updateVOAIndicator(onFile);
                    if (!"VOA_SUBMISSION".equals(process)) {
                        if (VOA_VA_FACILITY == null) {
                            VOA_VA_FACILITY = this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_MHV.getCode());
                        }
                        this.getInsuranceRuleService().postProcessVOASubmissions(clonePerson.getInsurances(), clonePerson, VOA_VA_FACILITY);
                        this.getEventRuleService().postProcessVOASubmissions(clonePerson);
                    }
                }
            }
        }
    }

    private void closeVOAPendingWkCase(Person person) throws ServiceException {
        List<WorkflowCase> wkLst = this.getWorkflowService().getOpenWorkItemLst(person, this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()));
        WorkflowCase wfc = null;
        for (int i = 0; i < wkLst.size(); ++i) {
            wfc = wkLst.get(i);
            if (!this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.NEW.getName()).equals((Object)wfc.getStatus().getStatusValue()) || !"VOA Submission with Determined Enrollment Status of PENDING".equalsIgnoreCase(wfc.getErrorMessage())) continue;
            this.getWorkflowService().close(wfc);
        }
    }

    private String getVBAQueryStatus(Person person) {
        EligibilityVerification ev = person != null ? person.getEligibilityVerification() : null;
        AACIndicator indicator = ev != null ? ev.getAacIndicator() : null;
        return indicator != null ? indicator.getCode() : null;
    }

    private void removeMsgTriggersToVistA() {
        if (this.triggerEventCacheManager.getTriggerEvents() == null || this.triggerEventCacheManager.getTriggerEvents().size() == 0) {
            return;
        }
        Iterator iter = this.triggerEventCacheManager.getTriggerEvents().iterator();
        HashSet newTriggerEvents = new HashSet();
        while (iter.hasNext()) {
            TriggerIdentity tid;
            Object item = iter.next();
            if (item instanceof PersonTriggerEvent && (tid = ((PersonTriggerEvent)((Object)item)).getTriggerIdentity()).getDestinationType() != null && CommonTrigger.DestinationType.MESSAGING.getName().equals(tid.getDestinationType().getName()) && tid.getTargetType() != null && CommonTrigger.TargetType.VISTA.getName().equals(tid.getTargetType().getName()) && tid.getDestinationType() != null && !CommonTrigger.DispatchType.QUERY.getName().equals(tid.getDestinationType().getName()) && tid instanceof PersonTriggerIdentity && ((PersonTriggerIdentity)tid).getApplicableDataTypes() != null && !((PersonTriggerIdentity)tid).getApplicableDataTypes().contains((Object)PersonTrigger.DataType.ELIGIBILITY)) continue;
            newTriggerEvents.add(item);
        }
        this.triggerEventCacheManager.removeTriggerEvents();
        if (newTriggerEvents.size() > 0) {
            this.triggerEventCacheManager.storeTriggerEvents(newTriggerEvents);
        }
    }

    private void consolidateMsgTriggers(Set incomingMsgTriggers) {
        if (this.triggerEventCacheManager.getTriggerEvents() != null && this.triggerEventCacheManager.getTriggerEvents().size() > 0) {
            Iterator iter = this.triggerEventCacheManager.getTriggerEvents().iterator();
            HashSet newTriggerEvents = new HashSet();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!(item instanceof PersonTriggerEvent)) continue;
                TriggerIdentity tid = ((PersonTriggerEvent)((Object)item)).getTriggerIdentity();
                if (!CommonTrigger.DestinationType.MESSAGING.getName().equals(tid.getDestinationType().getName()) || !CommonTrigger.TargetType.VISTA.getName().equals(tid.getTargetType().getName())) continue;
                newTriggerEvents.add(item);
            }
            this.triggerEventCacheManager.removeTriggerEvents();
            if (newTriggerEvents.size() > 0) {
                this.triggerEventCacheManager.storeTriggerEvents(newTriggerEvents);
            }
        }
        if (incomingMsgTriggers != null && incomingMsgTriggers.size() > 0) {
            this.triggerEventCacheManager.storeTriggerEvents(incomingMsgTriggers);
        }
    }

    @Override
    public Person processZ07(Person person, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        String dfn;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MessagingServiceImpl.processORUZ07(): Start processing rules for person " + person.getPersonEntityKey().getKeyValueAsString()));
        }
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        PersonEntityKey personKey = null;
        personKey = person.getPersonEntityKey();
        Person onFile = this.getPersonService().getPerson(personKey);
        boolean isNewPerson = false;
        if (onFile.getEnrollmentDeterminations() == null || onFile.getEnrollmentDeterminations().size() == 0) {
            isNewPerson = true;
        }
        if (onFile == null) {
            throw new ServiceException("Cannot process person. onFile person not found for personKey " + personKey.getKeyValueAsString());
        }
        String string = dfn = verificationInfo != null ? verificationInfo.getDfn() : null;
        if (isNewPerson && onFile.getPreferredFacility() == null) {
            this.logger.info((Object)("Defaulting PF for new Z07 for person: " + person.getPersonEntityKey().getKeyValueAsString()));
            PreferredFacility pf = new PreferredFacility();
            pf.setAssignmentDate(new Date());
            pf.setFacility(sendingFacility);
            pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_ESR.getCode()));
            onFile.addPreferredFacility(pf);
        }
        if (Boolean.FALSE.equals(onFile.isVeteran()) && Boolean.TRUE.equals(person.isVeteran())) {
            this.logger.error((Object)"VistA is not allowed to change on file Non Veteran status to Veteran status.");
            throw new ServiceException("VistA is not allowed to change on file Non Veteran status to Veteran status for personKey " + personKey.getKeyValueAsString());
        }
        EligibilityFactorRuleService efrs = this.getEligibilityFactorRuleService();
        efrs.processNewVeteran(person, onFile);
        ContactInfoRuleService contactInfoRuleservice = this.getContactInfoRuleService();
        if (verificationInfo == null) {
            verificationInfo = new VerificationInfo();
        }
        contactInfoRuleservice.processAddresses(person.getAddresses(), onFile, sendingFacility, verificationInfo);
        contactInfoRuleservice.processPhones(person, onFile, sendingFacility);
        contactInfoRuleservice.processElectronicAddresses(person.getEmails(), onFile, sendingFacility);
        InsuranceRuleService insRuleService = this.getInsuranceRuleService();
        insRuleService.processInsurancePolicies(person.getInsurances(), onFile, sendingFacility);
        insRuleService.processMedicaidFactor(person.getMedicaidFactor(), onFile);
        AssociationRuleService associationRuleService = this.getAssociationRuleService();
        associationRuleService.processAssociations(person.getAssociations(), onFile, sendingFacility);
        POWRuleService powRuleService = this.getPowRuleService();
        powRuleService.processPOW(person, onFile, sendingFacility);
        PurpleHeartRuleService phRuleService = this.getPurpleHeartRuleService();
        phRuleService.processPurpleHeart(person, onFile, verificationInfo, sendingFacility);
        this.getRegistryService().linkPersonRegistries(person, onFile, false);
        CatastrophicDisability cd = person.getCatastrophicDisability();
        if (cd != null && cd.isCatastrophicallyDisabled() != null && cd.isCatastrophicallyDisabled().booleanValue() && cd.getCDDescriptors().isEmpty()) {
            this.convertCDOnly(person);
        }
        ClinicalDeterminationRuleService cdrs = this.getClinicalDeterminationRuleService();
        cdrs.processClinicalDetermination(person, onFile, sendingFacility, null);
        EligibilityEnrollmentRuleService ers = this.getEnrollmentRuleService();
        ers.processPerson(person, onFile, sendingFacility, verificationInfo, false);
        ers.processReceivedEligibilities(person, onFile, verificationInfo, false);
        ers.processIneligibility(person, onFile, sendingFacility, verificationInfo, false);
        MilitaryRuleService mrs = this.getMilitaryRuleService();
        mrs.processMilitaryService(sendingFacility, dfn, person.getMilitaryService(), onFile, null);
        mrs.calculatePeriodOfService(person, onFile, "MS", null);
        DemographicRuleService drs = this.getDemographicRuleService();
        drs.processDemographicInfo(sendingFacility, person, onFile, false);
        Map incomeTests = person.getIncomeTests();
        Map financialStatements = person.getFinancialStatements();
        Map patientVisitSummaries = person.getPatientVisitSummaries();
        Map beneficiaryTravels = person.getBeneficiaryTravels();
        FinancialInfoRuleService frs = this.getFinancialInfoRuleService();
        EEResultInfo info = new EEResultInfo();
        if (MapUtils.isNotEmpty((Map)incomeTests) || MapUtils.isNotEmpty((Map)financialStatements) || MapUtils.isNotEmpty((Map)patientVisitSummaries) || MapUtils.isNotEmpty((Map)beneficiaryTravels)) {
            Integer incomeYear = this.getIncomeYear(incomeTests, financialStatements, patientVisitSummaries, beneficiaryTravels);
            frs.processFinancialInfo(incomeYear, sendingFacility, person, onFile, info, true);
        }
        frs.processFeeBasis(sendingFacility, person, onFile, false);
        this.getProcessVBARuleService().processVBAData(person, sendingFacility, onFile, verificationInfo);
        person.setVeteran(onFile.getVeteran());
        efrs.processSpecialFactors(person, sendingFacility, onFile, false);
        efrs.processIncompetenceRuling(person.getIncompetenceRuling(), onFile);
        efrs.processEmergencyResponseIndicator(person, onFile);
        Person calculatedPerson = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false, false, sendingFacility);
        this.getEventRuleService().processMessageEvents(onFile, sendingFacility, verificationInfo, info.isZ10Sent());
        calculatedPerson.removeAllInProcessFinancials();
        Person pristinePerson = (Person)this.entityCacheManager.getItem(calculatedPerson.getEntityKey());
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)calculatedPerson)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            if (person.getServiceConnectionAward() != null && calculatedPerson.getServiceConnectionAward() != null && person.getServiceConnectionAward().getUnemployable() == null) {
                calculatedPerson.getServiceConnectionAward().setUnemployable(null);
            }
            if (this.getSystemParameterService().getMSDSReconIndicator().booleanValue() && this.buildMSDRecord(pristinePerson, calculatedPerson)) {
                this.logger.info((Object)"Reconciliation taking place");
                mrs.processSeedingMilitaryService(onFile.getMilitaryService(), onFile);
                this.updateSeedingLogEntry(calculatedPerson, SeedStatus.COMPLETE.getCode(), verificationInfo.getMessageControlId());
                this.logger.info((Object)"Completed Reconciliation");
            }
            this.getEventRuleService().processPersonEventsForPensionBulletin(calculatedPerson);
            ers.processHandBookTriggers(calculatedPerson, onFile, null, verificationInfo);
            if (isNewPerson) {
                this.getHelperService().addToSSNVerificationQueue(person);
            }
            onFile = this.getPersonService().save(calculatedPerson);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MessagingServiceImpl.processORUZ07(): End processing rules for person " + person.getPersonEntityKey().getKeyValueAsString()));
        }
        return onFile;
    }

    @Override
    public Person processAddPerson(Person incoming, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Validate.notNull((Object)((Object)sendingFacility), (String)"A sending facility must not be null");
        Person onFile = this.getPersonService().get200ESRPerson(incoming.getPersonEntityKey());
        if (onFile == null) {
            throw new ServiceException("Cannot process person. onFile person not found for" + incoming.getPersonEntityKey());
        }
        if (sendingFacility.getCode().equals("200ESR")) {
            sendingFacility = this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode());
        }
        onFile.setVeteran(incoming.getVeteran());
        EligibilityEnrollmentRuleService ers = this.getEnrollmentRuleService();
        ers.processServiceConnectedIndicator(incoming);
        ers.manageReceivedEligibilities(incoming, onFile);
        ers.manageIneligibility(incoming, onFile);
        ers.manageApplication(incoming.getApplication(), onFile);
        ers.manageHealthBenefitProfile(incoming, onFile);
        EligibilityFactorRuleService efrs = this.getEligibilityFactorRuleService();
        efrs.manageSpecialFactors(incoming, onFile);
        efrs.processIncompetenceRuling(incoming.getIncompetenceRuling(), onFile);
        efrs.processEmergencyResponseIndicator(incoming, onFile);
        efrs.manageNewVeteranFromAddPerson(incoming, onFile);
        efrs.manageMonetaryBenefitAward(incoming.getMonetaryBenefitAward(), onFile);
        efrs.processServiceConnectionAward(incoming.getServiceConnectionAward(), onFile);
        if (!AbstractEntity.matchesDomainValues((AbstractEntity)incoming.getPurpleHeart(), (AbstractEntity)onFile.getPurpleHeart())) {
            this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);
            PurpleHeart incomingPurpleHeart = incoming.getPurpleHeart();
            if (incomingPurpleHeart != null && onFile != null && incomingPurpleHeart.getRegistryTrait() == null) {
                RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_PH_REGISTRY.getCode());
                this.getRegistryService().linkPersonRegistry(incomingPurpleHeart, onFile.getPurpleHeart(), incoming, onFile, regType, true);
            }
        }
        if (!AbstractEntity.matchesDomainValues((AbstractEntity)incoming.getPermanentAddress(), (AbstractEntity)onFile.getPermanentAddress()) && incoming.getPermanentAddress() != null) {
            incoming.getPermanentAddress().setChangeDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
        }
        ContactInfoRuleService contactInfoRuleservice = this.getContactInfoRuleService();
        contactInfoRuleservice.manageAddresses(incoming.getAddresses(), onFile, true);
        contactInfoRuleservice.managePhones(incoming.getPhones(), onFile, true);
        contactInfoRuleservice.manageElectronicAddresses(incoming.getEmails(), onFile);
        InsuranceRuleService insRuleService = this.getInsuranceRuleService();
        insRuleService.manageInsurancePolicies(incoming.getInsurances(), onFile, sendingFacility);
        insRuleService.manageMedicaidFactor(incoming.getMedicaidFactor(), onFile);
        AssociationRuleService associationRuleService = this.getAssociationRuleService();
        associationRuleService.processAssociations(incoming.getAssociations(), onFile, sendingFacility);
        PrisonerOfWar incomingPOW = incoming.getPrisonerOfWar();
        this.getPowRuleService().managePOW(incoming, onFile);
        if (incomingPOW != null && onFile != null && incomingPOW.getRegistryTrait() == null) {
            RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_POW_REGISTRY.getCode());
            this.getRegistryService().linkPersonRegistry(incomingPOW, onFile.getPrisonerOfWar(), incoming, onFile, regType, true);
        }
        ClinicalDeterminationRuleService cdrs = this.getClinicalDeterminationRuleService();
        cdrs.processClinicalDetermination(incoming, onFile, sendingFacility, null);
        MilitaryRuleService mrs = this.getMilitaryRuleService();
        onFile = mrs.manageMilitaryService(incoming.getMilitaryService(), onFile);
        mrs.calculatePeriodOfService(incoming, onFile, "MS", null);
        SHAD incomingShad = incoming.getShad();
        if (incomingShad != null && onFile != null && incomingShad.getRegistryTrait() == null) {
            RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_SHAD_REGISTRY.getCode());
            this.getRegistryService().linkPersonRegistry(incomingShad, onFile.getShad(), incoming, onFile, regType, true);
        }
        DemographicRuleService drs = this.getDemographicRuleService();
        drs.manageDemographicInfo(incoming, onFile);
        Map incomeTests = incoming.getIncomeTests();
        Map financialStatements = incoming.getFinancialStatements();
        Map patientVisitSummaries = incoming.getPatientVisitSummaries();
        Map beneficiaryTravels = incoming.getBeneficiaryTravels();
        EEResultInfo info = new EEResultInfo();
        if (MapUtils.isNotEmpty((Map)incomeTests) || MapUtils.isNotEmpty((Map)financialStatements) || MapUtils.isNotEmpty((Map)patientVisitSummaries) || MapUtils.isNotEmpty((Map)beneficiaryTravels)) {
            FinancialInfoRuleService frs = this.getFinancialInfoRuleService();
            Integer incomeYear = this.getIncomeYear(incomeTests, financialStatements, patientVisitSummaries, beneficiaryTravels);
            if (incomeYear != null) {
                frs.manageFinancialAssessment(incomeYear, sendingFacility, incoming, onFile, info);
            }
        }
        Person calculatedPerson = this.getEligibilityEnrollmentService().assessEEImpact(onFile, true, false, sendingFacility);
        EventRuleService eventRuleService = this.getEventRuleService();
        verificationInfo.setUnsolicitedType(null);
        eventRuleService.processMessageEvents(onFile, verificationInfo, info.isZ10Sent(), true);
        eventRuleService.managePersonEvents(onFile);
        Person pristinePerson = (Person)this.entityCacheManager.getItem(calculatedPerson.getEntityKey());
        this.getHelperService().addToSSNVerificationQueue(pristinePerson);
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)calculatedPerson)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            ers.processHandBookTriggers(incoming, onFile, null, verificationInfo);
            onFile = this.getPersonService().save(calculatedPerson, true);
        }
        return onFile;
    }

    @Override
    public Person processORUZ12(Person person, VAFacility sendingFacility) throws ServiceException {
        return this.receiveZ12Z13Data(person, sendingFacility, ORUZ12);
    }

    @Override
    public Person processORUZ13(Person person, VAFacility sendingFacility) throws ServiceException {
        return this.receiveZ12Z13Data(person, sendingFacility, ORUZ13);
    }

    @Override
    public void processQRYZ10(Person person, Integer incomeYear, IncomingMessageInfo incomingMessageInfo) throws ServiceException {
        this.processQRYMessages(person, incomeYear, incomingMessageInfo, QRYZ10);
    }

    @Override
    public void processQRYZ11(Person person, IncomingMessageInfo incomingMessageInfo) throws ServiceException {
        this.processQRYMessages(person, null, incomingMessageInfo, QRYZ11);
    }

    @Override
    public void triggerRetransmission(BigDecimal identifier) throws ServiceException {
        RetransmitTriggerEvent event = new RetransmitTriggerEvent(identifier, true);
        event.setName(RETRANSMIT_EVENT);
        this.triggerRouter.processTriggerEvent((TriggerEvent)event);
    }

    @Override
    public void triggerQRYZ07(Person person, VAFacility facility, Integer incomeYear, boolean handleAfterCommit) throws ServiceException {
        Validate.notNull((Object)((Object)facility), (String)"Facility can not be null");
        Validate.notNull((Object)incomeYear, (String)"Income Year can not be null");
        Validate.notNull((Object)((Object)person), (String)"Person can not be null");
        HashSet<VAFacility> sites = new HashSet<VAFacility>(1);
        sites.add(facility);
        IncomeYearTriggerEvent incomeEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.FULL_DATA);
        incomeEvent.setIncomeYear(incomeYear);
        incomeEvent.setPersonId(person.getPersonEntityKey());
        incomeEvent.setIdentityTraits(person.getIdentityTraits());
        incomeEvent.setTargetSites(sites);
        if (handleAfterCommit) {
            HashSet<IncomeYearTriggerEvent> events = new HashSet<IncomeYearTriggerEvent>(1);
            events.add(incomeEvent);
            this.triggerEventCacheManager.storeTriggerEvents(events);
        } else {
            this.triggerRouter.processTriggerEvent((TriggerEvent)incomeEvent);
        }
    }

    @Override
    public void triggerQRYZ07(Person person, VAFacility facility, Integer incomeYear) throws ServiceException {
        this.triggerQRYZ07(person, facility, incomeYear, false);
    }

    @Override
    public VAFacility findSiteLastTransmittedMsg(EntityKey personId) throws ServiceException {
        try {
            String siteCode = this.getMessageLogEntryDAO().findSiteLastTransmittedMsg(personId);
            if (siteCode != null) {
                return this.getLookupService().getVaFacilityByCode(siteCode);
            }
            return null;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to Retrieve the Site that last trsmitted the Message", (Throwable)e);
        }
    }

    @Override
    public boolean processCDConversion(Person incoming) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MessagingServiceImpl.processCDConversion(): Start CD conversion for person " + incoming.getPersonEntityKey().getKeyValueAsString()));
        }
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        PersonEntityKey personKey = incoming.getPersonEntityKey();
        Person onFile = this.getPersonService().getPerson(personKey);
        if (onFile == null) {
            throw new ServiceException("Cannot process person. onFile person not found for personKey " + personKey.getKeyValueAsString());
        }
        boolean z11Required = this.convertCDOnly(onFile);
        if (z11Required) {
            this.getEventRuleService().processMessageEvents(onFile);
        }
        this.getPersonService().save(onFile);
        return z11Required;
    }

    @Override
    public boolean convertCDOnly(Person person) throws ServiceException {
        CatastrophicDisability cd = person.getCatastrophicDisability();
        HashSet<CDDescriptor> descriptorsToAdd = new HashSet<CDDescriptor>();
        boolean existsAlready = false;
        if (cd != null) {
            Set<CDDescriptor> descriptors = cd.getCDDescriptors();
            if (descriptors.size() > 0) {
                existsAlready = true;
            }
            Set conditions = cd.getConditions();
            for (CDCondition cdCondition : conditions) {
                String code = cdCondition.getCondition().getCode();
                String translated = (String)this.getConditionMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            Set procedures = cd.getProcedures();
            for (CDProcedure cdProcedure : procedures) {
                String code = cdProcedure.getProcedure().getCode();
                String translated = (String)this.getProcedureMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            Set diagnoses = cd.getDiagnoses();
            for (CDDiagnosis cdDiagnosis : diagnoses) {
                String code = cdDiagnosis.getDiagnosis().getCode();
                String translated = (String)this.getDiagnosisMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            for (CDDescriptor descriptorToAdd : descriptorsToAdd) {
                boolean exists = false;
                for (CDDescriptor descriptor : descriptors) {
                    if (!descriptor.getDescriptorType().getCode().equals(descriptorToAdd.getDescriptorType().getCode())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                cd.addCDDescriptor(descriptorToAdd);
            }
        }
        return descriptorsToAdd.size() > 0 || existsAlready;
    }

    private CDDescriptor buildCDDescriptor(String code) throws ServiceException {
        CDDescriptor cdd = new CDDescriptor();
        cdd.setDescriptorType(this.getLookupService().getDescriptorTypeByCode(code));
        return cdd;
    }

    private Person receiveZ12Z13Data(Person person, VAFacility sendingFacility, String context) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson(person.getPersonEntityKey());
        this.validateEnrollmentDetermination(onFile);
        VerificationInfo vi = new VerificationInfo(null, context, null);
        this.getDemographicRuleService().processDemographicInfo(sendingFacility, person, onFile, vi);
        Person calculated = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false, false);
        EventRuleService ers = this.getEventRuleService();
        ers.processMessageEvents(calculated, vi);
        ers.processPersonEvents(calculated);
        ers.manageHandBookEvents(calculated);
        Person pristinePerson = (Person)this.entityCacheManager.getItem(onFile.getEntityKey());
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)calculated)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            onFile = this.getPersonService().save(calculated);
        }
        return onFile;
    }

    private void processQRYMessages(Person person, Integer incomeYear, IncomingMessageInfo incomingMessageInfo, String context) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson(person.getPersonEntityKey());
        VerificationInfo vi = new VerificationInfo(null, context, null);
        this.getEventRuleService().processMessageEvents(onFile, incomeYear, incomingMessageInfo, vi);
    }

    private Integer getIncomeYear(Map incomeTests, Map financialStatements, Map patientVisitSummaries, Map beneficiaryTravels) {
        Integer incomeYear = MapUtils.isNotEmpty((Map)incomeTests) ? (Integer)incomeTests.keySet().iterator().next() : (MapUtils.isNotEmpty((Map)financialStatements) ? (Integer)financialStatements.keySet().iterator().next() : (MapUtils.isNotEmpty((Map)patientVisitSummaries) ? ((SiteYear)((Object)patientVisitSummaries.keySet().iterator().next())).getYear() : ((SiteYear)((Object)beneficiaryTravels.keySet().iterator().next())).getYear()));
        return incomeYear;
    }

    @Override
    public boolean hasProcessedInboundMessage(String messageControlNumber, String stationNumber) throws ServiceException {
        try {
            return this.messageLogEntryDAO.hasProcessedInboundMessage(messageControlNumber, stationNumber);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to execute DAO", (Throwable)e);
        }
    }

    @Override
    public List findVoaAaAckLogEntryByPersonId(EntityKey personId) throws ServiceException {
        try {
            return this.messageLogEntryDAO.findVoaAaAckLogEntryByPersonId(personId);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to execute DAO", (Throwable)e);
        }
    }

    @Override
    public Person processK21(Person person, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MessagingServiceImpl.processRSPK21(): Start processing rules for person " + person.getPersonEntityKey().getKeyValueAsString()));
        }
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson(person.getPersonEntityKey());
        String dfn = verificationInfo != null ? verificationInfo.getDfn() : null;
        MilitaryRuleService mrs = this.getMilitaryRuleService();
        mrs.processMilitaryService(sendingFacility, dfn, person.getMilitaryService(), onFile, null);
        mrs.processSeedingMilitaryService(person.getMilitaryService(), onFile);
        Person pristinePerson = (Person)this.entityCacheManager.getItem(onFile.getEntityKey());
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)onFile)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            this.getPersonService().save(onFile);
        }
        return onFile;
    }

    @Override
    public void triggerQRYZ21(PersonEntityKey key, String VPID2) throws ServiceException {
        Validate.notNull((Object)key, (String)"PersonEntityKey must not be null");
        Validate.notNull((Object)VPID2, (String)"VPID must not be null");
        VPIDEntityKey entityKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        PersonIdentityTraits identityTraits = this.getPsDelegateService().getIdentityTraits(entityKey);
        PersonTriggerEvent personTriggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.ELIGIBILITY);
        personTriggerEvent.setPersonId(key);
        personTriggerEvent.setIdentityTraits(identityTraits);
        this.getTriggerRouter().processTriggerEvent((TriggerEvent)personTriggerEvent);
    }

    private boolean buildMSDRecord(Person pristinePerson, Person calculatedPerson) throws ServiceException {
        boolean seed = false;
        List seedingLogEntry = this.getSeedingLogEntrybyPerson(calculatedPerson);
        if (pristinePerson.getEnrollmentDetermination() == null) {
            if (calculatedPerson.isVeteran().booleanValue()) {
                seed = true;
            }
        } else if (seedingLogEntry != null && !seedingLogEntry.isEmpty() && !AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson.getMilitaryService(), (AbstractEntity)calculatedPerson.getMilitaryService())) {
            seed = true;
        }
        return seed;
    }

    private List getSeedingLogEntrybyPerson(Person person) throws ServiceException {
        List seedingLogEntry = null;
        try {
            seedingLogEntry = this.seedingLogEntryDAO.find(person);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log seeding  ", (Throwable)ex);
        }
        return seedingLogEntry;
    }

    private void updateSeedingLogEntry(Person person, String code, String messageControlId) throws ServiceException {
        SeedingLogEntry sle;
        if (this.getSeedingLogEntrybyPerson(person) == null || this.getSeedingLogEntrybyPerson(person).isEmpty()) {
            sle = new SeedingLogEntry();
            sle.setPersonId((BigDecimal)person.getPersonEntityKey().getKeyValue());
        } else {
            sle = (SeedingLogEntry)((Object)this.getSeedingLogEntrybyPerson(person).get(0));
        }
        sle.setOriginatingProcess("ProcessZ07:" + messageControlId);
        sle.setStatus(this.getLookupService().getSeedStatusByCode(code));
        try {
            this.seedingLogEntryDAO.saveObject((Object)sle);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get seedingDAO  ", (Throwable)ex);
        }
    }

    private WorkflowService getWorkflowService() throws ServiceException {
        if (workflowService == null) {
            workflowService = (WorkflowService)this.getComponent("workflowService", WorkflowService.class);
        }
        return workflowService;
    }

    @Override
    public void processTriggerBroker(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person can not be null");
        Person onFile = this.getPersonService().getPerson(person.getPersonEntityKey());
        this.getEventRuleService().processMessageEvents(onFile, true);
    }

    public Map getDiagnosisMap() {
        return this.diagnosisMap;
    }

    public void setDiagnosisMap(Map diagnosisMap) {
        this.diagnosisMap = diagnosisMap;
    }

    public Map getProcedureMap() {
        return this.procedureMap;
    }

    public void setProcedureMap(Map procedureMap) {
        this.procedureMap = procedureMap;
    }

    public Map getConditionMap() {
        return this.conditionMap;
    }

    public void setConditionMap(Map conditionMap) {
        this.conditionMap = conditionMap;
    }
}

