/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.esr.service.IdmServiceVO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.impl.IdMSearchInfo;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.ps.model.PatientIdentifier;
import gov.va.oit.oed.vaww.MCCIIN000002UV01Document;
import gov.va.oit.oed.vaww.PRPAIN201301UV02Document;
import gov.va.oit.oed.vaww.PRPAIN201302UV02Document;
import gov.va.oit.oed.vaww.PRPAIN201305UV02Document;
import gov.va.oit.oed.vaww.PRPAIN201306UV02Document;
import gov.va.oit.oed.vaww.PRPAIN201309UV02Document;
import gov.va.oit.oed.vaww.PRPAIN201310UV02Document;
import gov.va.oit.oed.vaww.VAIdMStub;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import v3.hl7_org.AD;
import v3.hl7_org.ANY;
import v3.hl7_org.ActClassControlAct;
import v3.hl7_org.AddressUse;
import v3.hl7_org.AdxpAdditionalLocator;
import v3.hl7_org.AdxpCity;
import v3.hl7_org.AdxpCountry;
import v3.hl7_org.AdxpPostalCode;
import v3.hl7_org.AdxpState;
import v3.hl7_org.AdxpStreetAddressLine;
import v3.hl7_org.BL;
import v3.hl7_org.CD;
import v3.hl7_org.CE;
import v3.hl7_org.COCTMT090003UV01AssignedEntity;
import v3.hl7_org.COCTMT090003UV01Organization;
import v3.hl7_org.COCTMT090100UV01AssignedPerson;
import v3.hl7_org.COCTMT090100UV01Person;
import v3.hl7_org.COCTMT150000UV02Organization;
import v3.hl7_org.COCTMT150002UV01Organization;
import v3.hl7_org.COCTMT150003UV03Organization;
import v3.hl7_org.CS;
import v3.hl7_org.CommunicationFunctionType;
import v3.hl7_org.EN;
import v3.hl7_org.EnFamily;
import v3.hl7_org.EnGiven;
import v3.hl7_org.EnPrefix;
import v3.hl7_org.EnSuffix;
import v3.hl7_org.EntityClassDevice;
import v3.hl7_org.HomeAddressUse;
import v3.hl7_org.II;
import v3.hl7_org.INT;
import v3.hl7_org.IVLTS;
import v3.hl7_org.MCCIMT000100UV01AttentionLine;
import v3.hl7_org.MCCIMT000100UV01Device;
import v3.hl7_org.MCCIMT000100UV01Receiver;
import v3.hl7_org.MCCIMT000100UV01Sender;
import v3.hl7_org.MCCIMT000200UV01Acknowledgement;
import v3.hl7_org.MCCIMT000300UV01Acknowledgement;
import v3.hl7_org.MCCIMT000300UV01AcknowledgementDetail;
import v3.hl7_org.MFMIMT700701UV01Custodian;
import v3.hl7_org.MFMIMT700701UV01DataEnterer;
import v3.hl7_org.MFMIMT700711UV01QueryAck;
import v3.hl7_org.PN;
import v3.hl7_org.PRPAIN201301UV02;
import v3.hl7_org.PRPAIN201301UV02MFMIMT700701UV01ControlActProcess;
import v3.hl7_org.PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent;
import v3.hl7_org.PRPAIN201301UV02MFMIMT700701UV01Subject1;
import v3.hl7_org.PRPAIN201301UV02MFMIMT700701UV01Subject2;
import v3.hl7_org.PRPAIN201302UV02;
import v3.hl7_org.PRPAIN201302UV02MFMIMT700701UV01ControlActProcess;
import v3.hl7_org.PRPAIN201302UV02MFMIMT700701UV01RegistrationEvent;
import v3.hl7_org.PRPAIN201302UV02MFMIMT700701UV01Subject1;
import v3.hl7_org.PRPAIN201302UV02MFMIMT700701UV01Subject2;
import v3.hl7_org.PRPAIN201305UV02;
import v3.hl7_org.PRPAIN201305UV02QUQIMT021001UV01ControlActProcess;
import v3.hl7_org.PRPAIN201306UV02;
import v3.hl7_org.PRPAIN201306UV02MFMIMT700711UV01ControlActProcess;
import v3.hl7_org.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import v3.hl7_org.PRPAIN201309UV02;
import v3.hl7_org.PRPAIN201309UV02QUQIMT021001UV01ControlActProcess;
import v3.hl7_org.PRPAIN201310UV02;
import v3.hl7_org.PRPAIN201310UV02MFMIMT700711UV01RegistrationEvent;
import v3.hl7_org.PRPAIN201310UV02MFMIMT700711UV01Subject1;
import v3.hl7_org.PRPAMT201301UV02BirthPlace;
import v3.hl7_org.PRPAMT201301UV02OtherIDs;
import v3.hl7_org.PRPAMT201301UV02Patient;
import v3.hl7_org.PRPAMT201301UV02Person;
import v3.hl7_org.PRPAMT201302UV02AdministrativeObservation;
import v3.hl7_org.PRPAMT201302UV02AdministrativeObservationId;
import v3.hl7_org.PRPAMT201302UV02BirthPlace;
import v3.hl7_org.PRPAMT201302UV02OtherIDs;
import v3.hl7_org.PRPAMT201302UV02OtherIDsId;
import v3.hl7_org.PRPAMT201302UV02Patient;
import v3.hl7_org.PRPAMT201302UV02PatientId;
import v3.hl7_org.PRPAMT201302UV02PatientPatientPerson;
import v3.hl7_org.PRPAMT201302UV02Person;
import v3.hl7_org.PRPAMT201302UV02Subject4;
import v3.hl7_org.PRPAMT201304UV02Patient;
import v3.hl7_org.PRPAMT201306UV02LivingSubjectAdministrativeGender;
import v3.hl7_org.PRPAMT201306UV02LivingSubjectBirthTime;
import v3.hl7_org.PRPAMT201306UV02LivingSubjectId;
import v3.hl7_org.PRPAMT201306UV02LivingSubjectName;
import v3.hl7_org.PRPAMT201306UV02MatchCriterionList;
import v3.hl7_org.PRPAMT201306UV02MinimumDegreeMatch;
import v3.hl7_org.PRPAMT201306UV02OtherIDsScopingOrganization;
import v3.hl7_org.PRPAMT201306UV02ParameterList;
import v3.hl7_org.PRPAMT201306UV02PatientAddress;
import v3.hl7_org.PRPAMT201306UV02PatientTelecom;
import v3.hl7_org.PRPAMT201306UV02QueryByParameter;
import v3.hl7_org.PRPAMT201307UV02ParameterList;
import v3.hl7_org.PRPAMT201307UV02PatientIdentifier;
import v3.hl7_org.PRPAMT201307UV02QueryByParameter;
import v3.hl7_org.PRPAMT201310UV02BirthPlace;
import v3.hl7_org.PRPAMT201310UV02OtherIDs;
import v3.hl7_org.PRPAMT201310UV02Patient;
import v3.hl7_org.PRPAMT201310UV02Person;
import v3.hl7_org.PRPAMT201310UV02Subject;
import v3.hl7_org.ParticipationTargetSubject;
import v3.hl7_org.PersonNameUseLegalByBOT;
import v3.hl7_org.QUQIMT021001UV01AuthorOrPerformer;
import v3.hl7_org.QUQIMT021001UV01DataEnterer;
import v3.hl7_org.RoleClassContact;
import v3.hl7_org.ST;
import v3.hl7_org.SXCMTS;
import v3.hl7_org.TEL;
import v3.hl7_org.TS;
import v3.hl7_org.XActMoodIntentEvent;
import v3.hl7_org.XParticipationAuthorPerformer;

public class IdmWebServiceDelegateImpl
extends AbstractComponent
implements IdmWebServiceDelegate {
    private static final long serialVersionUID = 8534341805323475694L;
    private static Hashtable idmBadAddressTable = IdmWebServiceDelegateImpl.initIdmBadAddressTable();
    private static final String BAD_ADDRESS = "BAD";
    private static final String HOME_PERMANENT = "HP";
    private static final String PART_TYPE_ADL = "ADL";
    private static final String MOTHERS_MAIDEN_NAME_TYPE = "C";
    private static final String ALIAS_NAME_TYPE = "P";
    private static final String IDM_DOES_NOT_EXIST = "Does Not Exist";
    private static final String COMPOSITE_NO_HISTORY = "MVI.COMP1";
    private static final String ESR_CORRELATION = "200ESR";
    private static final String YES = "Y";
    private static final String NO = "N";
    private DAOOperations genericDAO;
    private static final String QUERY_GET_SSA_VER_DETAIL = "idmWsDelegateQuery_GetSsaVerificationDetailByVpid";
    private static final String QRY_SSA_PARAM_NAME = "vpid";
    private long webServiceTimeout;
    private String idmServiceEndPoint = null;
    private LookupService lookupService = null;
    private String BGS_ExternalKey = "VOA";
    private String BGS_applicationName = "MVI";
    private String BGS_CLIENT_MACHINE = null;
    private String msName = null;
    private String processingCode = null;
    private String esrStationNumber = null;
    public static final String ROOT_VA_OID = "2.16.840.1.113883.4.349";
    public static final String SSN_OID = "2.16.840.1.113883.4.1";
    public static final String VA_OID_EXT_PREFIX = "MCID";
    public static final String INTERACTION_ID_ROOT = "2.16.840.1.113883.1.6";
    public static final String SCOPING_ORG_OID = "1.2.840.114350.1.13.99997.2.3412";
    public static final String PROCESSING_MODE_CODE = "T";
    public static final String ACCEPT_ACK_CODE = "AL";
    public static final String APPLICATION_ACCEPT = "AA";
    public static final String REC_TYPE_CODE = "RCV";
    public static final String REC_CLASS_CODE = "DEV";
    public static final String REG_CLASS_CODE = "REG";
    public static final String REC_DETERMINER_CODE = "INSTANCE";
    public static final String REC_VA_OID = "2.16.840.113883.4.349";
    public static final String SND_TYPE_CODE = "SND";
    public static final String SND_CLASS_CODE = "DEV";
    public static final String SND_DETERMINER_CODE = "INSTANCE";
    public static final String SND_VA_OID = "1.2.840.114350.1.13.99997.2.7788";
    public static final String CACT_CLASS_CODE = "CACT";
    public static final String CACT_MOOD_CODE = "EVN";
    public static final String CACT_CODE_SYSTEM = "2.16.840.1.113883.1.6";
    public static final String QRY_ROOT = "1.2.840.114350.1.13.99999.4567.34";
    public static final String QRY_STATUS = "new";
    public static final String QRY_RES_PRIORITY_CD = "I";
    public static final String PATIENT_ID_ROOT = "2.16.840.1.113883.4.349";
    public static final String CORRELATION_VIEW = "COR";
    public static final String DoD_TEST_OID = "2.16.840.1.113883.3.364";
    public static final String DoD_PROD_OID = "2.16.840.1.113883.3.42.10001.100001.12";
    private static String[] BGSCredentialsArray = null;
    private EnvironmentParamService environmentParamService;

    public String getIdmServiceEndPoint() {
        return this.idmServiceEndPoint;
    }

    public void setIdmServiceEndPoint(String idmServiceEndPoint) {
        this.idmServiceEndPoint = idmServiceEndPoint;
    }

    public String getProcessingCode() {
        return this.processingCode;
    }

    public void setProcessingCode(String processingCode) {
        this.processingCode = processingCode;
    }

    public String getEsrStationNumber() {
        return this.esrStationNumber;
    }

    public void setEsrStationNumber(String esrStationNumber) {
        this.esrStationNumber = esrStationNumber;
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations genericDAO) {
        this.genericDAO = genericDAO;
    }

    public EnvironmentParamService getEnvironmentParamService() {
        return this.environmentParamService;
    }

    public void setEnvironmentParamService(EnvironmentParamService environmentParamService) {
        this.environmentParamService = environmentParamService;
    }

    public String getMsName() {
        if (this.msName == null) {
            this.msName = "JUnit";
        }
        return this.msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public long getWebServiceTimeout() {
        return this.webServiceTimeout;
    }

    public void setWebServiceTimeout(long webServiceTimeout) {
        this.webServiceTimeout = webServiceTimeout;
    }

    @Override
    public List getCorrelationsByFullyQualifiedIdentifier(String fullyQualifiedId) throws ServiceException {
        if (fullyQualifiedId.indexOf("200DOD") > 0) {
            return this.getCorrelations(fullyQualifiedId, DoD_TEST_OID);
        }
        return this.getCorrelations(fullyQualifiedId, "2.16.840.1.113883.4.349");
    }

    @Override
    public List getCorrelationsByVPID(VPIDEntityKey key) throws ServiceException {
        return this.getCorrelations(key.getVPID() + "^NI", "2.16.840.1.113883.4.349");
    }

    private List getCorrelations(String fullyQualifiedId, String oid) throws ServiceException {
        ArrayList<PatientIdentifier> identities = new ArrayList<PatientIdentifier>();
        PRPAIN201309UV02Document pRPA_IN201309UV0212 = (PRPAIN201309UV02Document)this.getXmlObject(PRPAIN201309UV02Document.class);
        PRPAIN201309UV02 pPRPAIN201309UV02 = pRPA_IN201309UV0212.addNewPRPAIN201309UV02();
        Date currentDate = Calendar.getInstance().getTime();
        String uniqueId = this.generateUniqueID(currentDate);
        this.populateHeaderRoot(pPRPAIN201309UV02.addNewId(), uniqueId);
        this.populateCreationTime(pPRPAIN201309UV02.addNewCreationTime(), currentDate);
        this.populateInteractionId(pPRPAIN201309UV02.addNewInteractionId(), "PRPA_IN201309UV02");
        this.populateProcessingCode(pPRPAIN201309UV02.addNewProcessingCode());
        this.populateProcessingModeCode(pPRPAIN201309UV02.addNewProcessingModeCode());
        this.populateAcceptAckCode(pPRPAIN201309UV02.addNewAcceptAckCode());
        this.populateReceiver(pPRPAIN201309UV02.addNewReceiver());
        this.populateSender(pPRPAIN201309UV02.addNewSender());
        PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = pPRPAIN201309UV02.addNewControlActProcess();
        controlActProcess.setClassCode(ActClassControlAct.Enum.forString((String)CACT_CLASS_CODE));
        controlActProcess.setMoodCode(XActMoodIntentEvent.Enum.forString((String)CACT_MOOD_CODE));
        CD code = controlActProcess.addNewCode();
        code.setCode("PRPA_TE201309UV02");
        code.setCodeSystem("2.16.840.1.113883.1.6");
        QUQIMT021001UV01AuthorOrPerformer authorOrPerformer = controlActProcess.addNewAuthorOrPerformer();
        authorOrPerformer.setTypeCode(XParticipationAuthorPerformer.Enum.forString((String)"AUT"));
        PRPAMT201307UV02QueryByParameter queryByParameter = controlActProcess.addNewQueryByParameter();
        II queryId = queryByParameter.addNewQueryId();
        queryId.setRoot(this.getMsName());
        queryId.setExtension(uniqueId);
        CS statusCode = queryByParameter.addNewStatusCode();
        statusCode.setCode(QRY_STATUS);
        CS priorityCode = queryByParameter.addNewResponsePriorityCode();
        priorityCode.setCode(QRY_RES_PRIORITY_CD);
        PRPAMT201307UV02ParameterList paramList = queryByParameter.addNewParameterList();
        PRPAMT201307UV02PatientIdentifier pi = paramList.addNewPatientIdentifier();
        II pivalue = pi.addNewValue();
        pivalue.setRoot(oid);
        pivalue.setExtension(fullyQualifiedId);
        ST piSematicsText = pi.addNewSemanticsText();
        piSematicsText.newCursor().setTextValue("Patient.Id");
        PRPAIN201310UV02Document responseDocument = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceRequest: " + pRPA_IN201309UV0212));
        }
        try {
            VAIdMStub stub = new VAIdMStub(this.getIdmServiceEndPoint());
            stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(this.webServiceTimeout);
            responseDocument = stub.PRPA_IN201309UV02(pRPA_IN201309UV0212);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceResponse: " + responseDocument));
        }
        PRPAIN201310UV02 response = responseDocument.getPRPAIN201310UV02();
        String responseCode = null;
        MCCIMT000300UV01Acknowledgement[] ack = response.getAcknowledgementArray();
        if (ack.length > 0) {
            responseCode = ack[0].getTypeCode().getCode();
        }
        if (!APPLICATION_ACCEPT.equals(responseCode) && this.logger.isErrorEnabled()) {
            this.logger.error((Object)("getCorrelationsByVPID return error :" + ack[0].getAcknowledgementDetailArray()[0].getText().newCursor().getTextValue()));
            return null;
        }
        PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjects = response.getControlActProcess().getSubjectArray();
        for (int i = 0; subjects != null && i < subjects.length; ++i) {
            for (int j = 0; j < subjects.length; ++j) {
                PRPAIN201310UV02MFMIMT700711UV01Subject1 sub1 = subjects[j];
                PRPAIN201310UV02MFMIMT700711UV01RegistrationEvent regEvent = sub1.getRegistrationEvent();
                regEvent.getClassCode();
                PRPAMT201304UV02Patient patient = regEvent.getSubject1().getPatient();
                II[] ids = patient.getIdArray();
                for (int k = 0; k < ids.length; ++k) {
                    II currId = ids[k];
                    String ext = currId.getExtension();
                    PatientIdentifier identifier = new PatientIdentifier(ext);
                    if ("PI".equalsIgnoreCase(identifier.getIdentityType()) && ("A".equalsIgnoreCase(identifier.getIdState()) || ESR_CORRELATION.equalsIgnoreCase(identifier.getStationNumber()))) {
                        identities.add(identifier);
                        continue;
                    }
                    if ("PI".equalsIgnoreCase(identifier.getIdentityType())) continue;
                    identities.add(identifier);
                }
            }
        }
        return identities;
    }

    @Override
    public Set<PersonIdentityTraits> searchWithCompositeCall(PersonIdentityTraits traits, IdMSearchInfo searchInfo) throws ServiceException {
        Set<PersonIdentityTraits> traitsSet = this.search(null, false, searchInfo, null, traits, COMPOSITE_NO_HISTORY, false);
        if (traitsSet != null) {
            return this.overlaySSNVerificationStatus(traitsSet);
        }
        return null;
    }

    @Override
    public Set<PersonIdentityTraits> search(PersonIdentityTraits traits, boolean attendedSearch) throws ServiceException {
        Set<PersonIdentityTraits> traitsSet = this.search(null, false, null, null, traits, null, attendedSearch);
        if (traitsSet != null) {
            return this.overlaySSNVerificationStatus(traitsSet);
        }
        return null;
    }

    @Override
    public PersonIdentityTraits getESRCorrelation(VPIDEntityKey vpid) throws ServiceException {
        FullyQualifiedIdentity id = new FullyQualifiedIdentity(vpid.getVPID(), this.esrStationNumber);
        Set<PersonIdentityTraits> resultTraits = this.search(id, false, null, CORRELATION_VIEW, null, null, false);
        if (resultTraits == null || resultTraits.isEmpty()) {
            throw new ServiceException("Person Not Found: Search returned null for getESRCorrelation, vpid = " + vpid.getKeyValueAsString());
        }
        if (resultTraits.size() > 1) {
            throw new ServiceException("getESRCorrleation returned multiple for vpid = " + vpid.getKeyValueAsString());
        }
        return resultTraits.iterator().next();
    }

    private String getProperErrorMessage(MCCIMT000300UV01Acknowledgement ack) {
        String errorMessage = ack.getAcknowledgementDetailArray()[0].getText().newCursor().getTextValue();
        if (errorMessage.indexOf(IDM_DOES_NOT_EXIST) >= 0) {
            return "No Record Found: " + errorMessage;
        }
        if (errorMessage.indexOf("Invalid") >= 0 && (errorMessage.indexOf("checkdigit") >= 0 || errorMessage.indexOf("format") >= 0)) {
            return "VPID Exception: " + errorMessage;
        }
        return errorMessage;
    }

    private Set<PersonIdentityTraits> search(FullyQualifiedIdentity id, boolean isSearchByDfn, IdMSearchInfo searchInfo, String responseGroupId, PersonIdentityTraits traits, String compositeCode, boolean attendedSearch) throws ServiceException {
        PRPAIN201305UV02Document pPRPAIN201305UV02Doc = this.createSearchRequest(id, responseGroupId, traits, compositeCode, searchInfo, attendedSearch);
        PRPAIN201306UV02Document response = null;
        Set resultTraits = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceRequest: " + pPRPAIN201305UV02Doc));
        }
        try {
            VAIdMStub stub = new VAIdMStub(this.getIdmServiceEndPoint());
            stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(this.webServiceTimeout);
            response = stub.PRPA_IN201305UV02(pPRPAIN201305UV02Doc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdmServiceResponse: " + response));
            }
            if (response == null) {
                return null;
            }
            if (searchInfo != null && response.getPRPAIN201306UV02().getId() != null) {
                searchInfo.setSearchToken(response.getPRPAIN201306UV02().getId().getExtension());
            }
            String responseCode = null;
            MCCIMT000300UV01Acknowledgement[] ack = response.getPRPAIN201306UV02().getAcknowledgementArray();
            if (ack.length > 0) {
                responseCode = ack[0].getTypeCode().getCode();
            }
            if (!APPLICATION_ACCEPT.equals(responseCode)) {
                String errorMessage = this.getProperErrorMessage(ack[0]);
                if (searchInfo != null && searchInfo.isExtendedSearch() && id != null) {
                    this.logger.error((Object)("VOA Level 1 user retrieve by fully qualified identity= " + (Object)((Object)id) + " returns error :" + errorMessage));
                    return null;
                }
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("search by fully qualified identity returns error :" + errorMessage));
                }
                throw new ServiceException(errorMessage);
            }
            PRPAIN201306UV02MFMIMT700711UV01ControlActProcess controlActproess = response.getPRPAIN201306UV02().getControlActProcess();
            MFMIMT700711UV01QueryAck queryAck = controlActproess.getQueryAck();
            if (queryAck != null && queryAck.getQueryResponseCode() != null) {
                String queryAckResponseCode = queryAck.getQueryResponseCode().getCode();
                if (queryAckResponseCode != null && "QE".equals(queryAckResponseCode)) {
                    throw new MaxRecordsExceededException(-1, 10, "Search Idm Service exceeded allowable limit of 10 matched records.");
                }
                if ("NF".equals(queryAckResponseCode)) {
                    return null;
                }
                if (!"OK".equals(queryAckResponseCode)) {
                    throw new ServiceException("Unknown response code for Search:" + queryAckResponseCode);
                }
            }
            resultTraits = this.parseSearchResponse(response, isSearchByDfn, searchInfo);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (resultTraits == null || resultTraits.size() == 0) {
            return null;
        }
        return resultTraits;
    }

    @Override
    public PersonIdentityTraits searchWithCompositeCall(FullyQualifiedIdentity id, boolean isSearchByDfn, IdMSearchInfo searchInfo) throws ServiceException {
        Set<PersonIdentityTraits> resultTraits = this.search(id, isSearchByDfn, searchInfo, null, null, COMPOSITE_NO_HISTORY, false);
        if (resultTraits == null || resultTraits.size() == 0) {
            return null;
        }
        return this.overlaySSNVerificationStatus((PersonIdentityTraits)((Object)resultTraits.toArray()[0]));
    }

    @Override
    public PersonIdentityTraits search(FullyQualifiedIdentity id, boolean attendedSearch) throws ServiceException {
        Set<PersonIdentityTraits> resultTraits = this.search(id, false, null, null, null, null, attendedSearch);
        if (resultTraits == null || resultTraits.size() == 0) {
            return null;
        }
        return this.overlaySSNVerificationStatus((PersonIdentityTraits)((Object)resultTraits.toArray()[0]));
    }

    private PersonIdentityTraits overlaySSNVerificationStatus(PersonIdentityTraits pvTraits) throws ServiceException {
        if (pvTraits != null && pvTraits.getSsn() != null && pvTraits.getSsn().getSsaVerificationStatus() == null && this.hasCompletedSsaVerification(pvTraits.getVpid())) {
            PersonIdentityTraits esrTraits;
            block4: {
                esrTraits = null;
                try {
                    esrTraits = this.getESRCorrelation(pvTraits.getVpid());
                }
                catch (ServiceException se) {
                    if (se.getMessage().indexOf(IDM_DOES_NOT_EXIST) >= 0) break block4;
                    throw se;
                }
            }
            if (esrTraits != null && esrTraits.getSsn() != null && esrTraits.getSsn().getSsaVerificationStatus() != null) {
                pvTraits.getSsn().setSsaVerificationStatus(esrTraits.getSsn().getSsaVerificationStatus());
            }
        }
        return pvTraits;
    }

    private boolean hasCompletedSsaVerification(VPIDEntityKey vpid) throws ServiceException {
        if (vpid == null) {
            return false;
        }
        try {
            List list = this.getGenericDAO().findByNamedQueryAndNamedParam(QUERY_GET_SSA_VER_DETAIL, QRY_SSA_PARAM_NAME, (Object)vpid.getKeyValueAsString());
            if (list == null || list.isEmpty() || list.get(0) == null) {
                return false;
            }
        }
        catch (DAOException e) {
            throw new ServiceException("DAO query failed to find ssa verification status by vpid", (Throwable)e);
        }
        catch (Exception ex) {
            throw new ServiceException("Unknown IdmWsDelegate error in find ssa verification status by vpid", (Throwable)ex);
        }
        return true;
    }

    private Set<PersonIdentityTraits> overlaySSNVerificationStatus(Set<PersonIdentityTraits> mviTraitsSet) throws ServiceException {
        HashSet<PersonIdentityTraits> overlayedTraitsList = new HashSet<PersonIdentityTraits>();
        for (PersonIdentityTraits traits : mviTraitsSet) {
            overlayedTraitsList.add(this.overlaySSNVerificationStatus(traits));
        }
        return overlayedTraitsList;
    }

    @Override
    public VPIDEntityKey addPerson(IdmServiceVO idmServiceVO, IdMSearchInfo searchInfo) throws ServiceException {
        CE ce = this.execute1301(idmServiceVO, true, false, false, true, searchInfo);
        if (ce != null && "ICN".equals(ce.getDisplayName())) {
            String longVPID = VPIDEntityKeyImpl.getLongVPID(ce.getCode());
            VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(longVPID);
            return key;
        }
        return null;
    }

    @Override
    public VPIDEntityKey addCorrelation(IdmServiceVO idmServiceVO) throws ServiceException {
        CE ce = this.execute1301(idmServiceVO, true, true, false, false, null);
        if (ce != null && ce.getCode() != null && ce.getCode().indexOf(ESR_CORRELATION) > 0) {
            String longVPID = VPIDEntityKeyImpl.getLongVPID(ce.getCode().split("\\^")[0]);
            VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(longVPID);
            return key;
        }
        return null;
    }

    @Override
    public FullyQualifiedIdentity addPreferredFacility(IdmServiceVO idmServiceVO) throws ServiceException {
        CE ce = this.execute1301(idmServiceVO, true, false, true, false, null);
        if (ce != null && "IEN".equals(ce.getDisplayName())) {
            String[] codes = ce.getCode().split("\\^");
            return new FullyQualifiedIdentity(codes[0], codes[2]);
        }
        return null;
    }

    @Override
    public void updatePerson(IdmServiceVO idmServiceVO) throws ServiceException {
        this.execute1302(idmServiceVO);
    }

    private CE execute1301(IdmServiceVO idmServiceVO, boolean searchByPass, boolean isAddCorrelation, boolean isAddPreferredFacility, boolean isAddPerson, IdMSearchInfo searchInfo) throws ServiceException {
        PRPAIN201301UV02Document pPRPAIN201301UV02Document = this.create1301Request();
        PRPAIN201301UV02 pPRPAIN201301UV02 = this.populate1301RequestHeaders(pPRPAIN201301UV02Document, searchInfo);
        PRPAIN201301UV02MFMIMT700701UV01ControlActProcess controlActProcess = this.add1301ControlActprocess(pPRPAIN201301UV02);
        PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent regEvent = controlActProcess.getSubjectArray()[0].getRegistrationEvent();
        PRPAIN201301UV02MFMIMT700701UV01Subject2 sub1 = regEvent.addNewSubject1();
        sub1.setTypeCode(ParticipationTargetSubject.Enum.forString((String)"SBJ"));
        PRPAMT201301UV02Patient patient = sub1.addNewPatient();
        patient.setClassCode("PAT");
        II patientId = patient.addNewId();
        patientId.setRoot("2.16.840.1.113883.4.349");
        if ((isAddCorrelation || isAddPreferredFacility) && idmServiceVO.getVpid() != null) {
            patientId.setExtension(idmServiceVO.getVpid().getVPID());
        }
        if (isAddCorrelation || isAddPreferredFacility) {
            patientId.setNullFlavor("NA");
        } else if (searchByPass) {
            patientId.setNullFlavor("ASKU");
        } else {
            patientId.setNullFlavor("UNK");
        }
        patient.addNewStatusCode().setCode("active");
        COCTMT150003UV03Organization providerOrg = patient.addNewProviderOrganization();
        providerOrg.setClassCode("ORG");
        providerOrg.setDeterminerCode("INSTANCE");
        providerOrg.addNewId();
        providerOrg.addNewContactParty().setClassCode(RoleClassContact.Enum.forString((String)"CON"));
        PRPAMT201301UV02Person person = patient.addNewPatientPerson();
        this.populate1301Person(person, idmServiceVO, isAddCorrelation, isAddPreferredFacility);
        MFMIMT700701UV01Custodian custodian = regEvent.addNewCustodian();
        custodian.setTypeCode("CST");
        COCTMT090003UV01AssignedEntity assignedEntity = custodian.addNewAssignedEntity();
        assignedEntity.setClassCode("ASSIGNED");
        assignedEntity.addNewId().setRoot("2.16.840.1.113883.4.349");
        COCTMT090003UV01Organization assignedOrg = assignedEntity.addNewAssignedOrganization();
        assignedOrg.setClassCode("ORG");
        assignedOrg.setDeterminerCode("INSTANCE");
        EN name = assignedOrg.addNewName();
        name.newCursor().setTextValue(this.getEsrStationNumber());
        MCCIIN000002UV01Document responseDocument = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceRequest: " + pPRPAIN201301UV02Document));
        }
        try {
            VAIdMStub stub = new VAIdMStub(this.getIdmServiceEndPoint());
            stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(this.webServiceTimeout);
            responseDocument = stub.PRPA_IN201301UV02(pPRPAIN201301UV02Document);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdmServiceResponse: " + responseDocument));
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (responseDocument != null) {
            MCCIMT000200UV01Acknowledgement ack = responseDocument.getMCCIIN000002UV01().getAcknowledgementArray()[0];
            String responseCode = ack.getTypeCode().getCode();
            if (!APPLICATION_ACCEPT.equals(responseCode)) {
                String errorMessage = ack.getAcknowledgementDetailArray()[0].getText().newCursor().getTextValue();
                if (errorMessage != null && errorMessage.indexOf("ERROR Add Preferred Treating Facility MPI response") != -1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)("Error communicating to VistA. Please re-submit the Complete Registration action; get the return code from the server:" + errorMessage));
                    }
                    return null;
                }
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("parseSearchResponse return error :" + errorMessage));
                }
                throw new ServiceException(errorMessage);
            }
            return ack.getAcknowledgementDetailArray()[0].getCode();
        }
        return null;
    }

    private PRPAIN201301UV02Document create1301Request() throws ServiceException {
        PRPAIN201301UV02Document pPRPAIN201301UV02Document = (PRPAIN201301UV02Document)this.getXmlObject(PRPAIN201301UV02Document.class);
        return pPRPAIN201301UV02Document;
    }

    private PRPAIN201302UV02Document create1302Request() throws ServiceException {
        PRPAIN201302UV02Document pPRPAIN201302UV02Document = (PRPAIN201302UV02Document)this.getXmlObject(PRPAIN201302UV02Document.class);
        return pPRPAIN201302UV02Document;
    }

    private PRPAIN201301UV02 populate1301RequestHeaders(PRPAIN201301UV02Document pPRPAIN201301UV02Document, IdMSearchInfo searchInfo) {
        PRPAIN201301UV02 pPRPAIN201301UV02 = pPRPAIN201301UV02Document.addNewPRPAIN201301UV02();
        Date currentDate = Calendar.getInstance().getTime();
        String uniqueId = this.generateUniqueID(currentDate);
        this.populateHeaderRoot(pPRPAIN201301UV02.addNewId(), uniqueId);
        this.populateCreationTime(pPRPAIN201301UV02.addNewCreationTime(), currentDate);
        if (searchInfo != null && searchInfo.isAddPersonExplicit()) {
            pPRPAIN201301UV02.addNewVersionCode().setCode("3.0");
            MCCIMT000100UV01AttentionLine atten = pPRPAIN201301UV02.addNewAttentionLine();
            atten.addNewKeyWordText().newCursor().setTextValue("Search.Token");
            atten.addNewValue().newCursor().setTextValue(searchInfo.getSearchToken());
        }
        this.populateInteractionId(pPRPAIN201301UV02.addNewInteractionId(), "PRPA_IN201301UV02");
        this.populateProcessingCode(pPRPAIN201301UV02.addNewProcessingCode());
        this.populateProcessingModeCode(pPRPAIN201301UV02.addNewProcessingModeCode());
        this.populateAcceptAckCode(pPRPAIN201301UV02.addNewAcceptAckCode());
        this.populateReceiver(pPRPAIN201301UV02.addNewReceiver());
        this.populateSender(pPRPAIN201301UV02.addNewSender());
        return pPRPAIN201301UV02;
    }

    private PRPAIN201302UV02 populate1302RequestHeaders(PRPAIN201302UV02Document pPRPAIN201302UV02Document) {
        PRPAIN201302UV02 pPRPAIN201302UV02 = pPRPAIN201302UV02Document.addNewPRPAIN201302UV02();
        Date currentDate = Calendar.getInstance().getTime();
        String uniqueId = this.generateUniqueID(currentDate);
        this.populateHeaderRoot(pPRPAIN201302UV02.addNewId(), uniqueId);
        this.populateCreationTime(pPRPAIN201302UV02.addNewCreationTime(), currentDate);
        this.populateInteractionId(pPRPAIN201302UV02.addNewInteractionId(), "PRPA_IN201302UV02");
        this.populateProcessingCode(pPRPAIN201302UV02.addNewProcessingCode());
        this.populateProcessingModeCode(pPRPAIN201302UV02.addNewProcessingModeCode());
        this.populateAcceptAckCode(pPRPAIN201302UV02.addNewAcceptAckCode());
        this.populateReceiver(pPRPAIN201302UV02.addNewReceiver());
        this.populateSender(pPRPAIN201302UV02.addNewSender());
        return pPRPAIN201302UV02;
    }

    private PRPAIN201301UV02MFMIMT700701UV01ControlActProcess add1301ControlActprocess(PRPAIN201301UV02 pPRPAIN201301UV02) {
        PRPAIN201301UV02MFMIMT700701UV01ControlActProcess controlActProcess = pPRPAIN201301UV02.addNewControlActProcess();
        controlActProcess.setClassCode(ActClassControlAct.Enum.forString((String)CACT_CLASS_CODE));
        controlActProcess.setMoodCode(XActMoodIntentEvent.Enum.forString((String)CACT_MOOD_CODE));
        CD code = controlActProcess.addNewCode();
        code.setCode("PRPA_TE201301UV02");
        code.setCodeSystem("2.16.840.1.113883.1.6");
        PRPAIN201301UV02MFMIMT700701UV01Subject1 subject = controlActProcess.addNewSubject();
        MFMIMT700701UV01DataEnterer dataEnterer = controlActProcess.addNewDataEnterer();
        dataEnterer.setTypeCode("ENT");
        dataEnterer.setContextControlCode("AP");
        COCTMT090100UV01AssignedPerson assignedPerson = dataEnterer.addNewAssignedPerson();
        assignedPerson.setClassCode("ASSIGNED");
        COCTMT090100UV01Person assignedPerson1 = assignedPerson.addNewAssignedPerson();
        assignedPerson1.setClassCode("PSN");
        assignedPerson1.setDeterminerCode("INSTANCE");
        EN assignedPersonName = assignedPerson1.addNewName();
        String auditUserId = SecurityContextHelper.getSecurityContext().getUserName(true);
        assignedPersonName.newCursor().setTextValue(auditUserId);
        subject.setTypeCode("SUBJ");
        PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent regEvent = subject.addNewRegistrationEvent();
        regEvent.setClassCode(REG_CLASS_CODE);
        regEvent.setMoodCode(CACT_MOOD_CODE);
        II regId = regEvent.addNewId();
        regId.setNullFlavor("NA");
        CS statusCode = regEvent.addNewStatusCode();
        statusCode.setCode("active");
        return controlActProcess;
    }

    private PRPAIN201302UV02MFMIMT700701UV01ControlActProcess add1302ControlActprocess(PRPAIN201302UV02 pPRPAIN201302UV02) {
        PRPAIN201302UV02MFMIMT700701UV01ControlActProcess controlActProcess = pPRPAIN201302UV02.addNewControlActProcess();
        controlActProcess.setClassCode(ActClassControlAct.Enum.forString((String)CACT_CLASS_CODE));
        controlActProcess.setMoodCode(XActMoodIntentEvent.Enum.forString((String)CACT_MOOD_CODE));
        CD code = controlActProcess.addNewCode();
        code.setCode("PRPA_TE201302UV02");
        code.setCodeSystem("2.16.840.1.113883.1.6");
        PRPAIN201302UV02MFMIMT700701UV01Subject1 subject = controlActProcess.addNewSubject();
        MFMIMT700701UV01DataEnterer dataEnterer = controlActProcess.addNewDataEnterer();
        dataEnterer.setTypeCode("ENT");
        dataEnterer.setContextControlCode("AP");
        COCTMT090100UV01AssignedPerson assignedPerson = dataEnterer.addNewAssignedPerson();
        assignedPerson.setClassCode("ASSIGNED");
        COCTMT090100UV01Person assignedPerson1 = assignedPerson.addNewAssignedPerson();
        assignedPerson1.setClassCode("PSN");
        assignedPerson1.setDeterminerCode("INSTANCE");
        EN assignedPersonName = assignedPerson1.addNewName();
        String auditUserId = SecurityContextHelper.getSecurityContext().getUserName(true);
        assignedPersonName.newCursor().setTextValue(auditUserId);
        subject.setTypeCode("SUBJ");
        PRPAIN201302UV02MFMIMT700701UV01RegistrationEvent regEvent = subject.addNewRegistrationEvent();
        regEvent.setClassCode(REG_CLASS_CODE);
        regEvent.setMoodCode(CACT_MOOD_CODE);
        II regId = regEvent.addNewId();
        regId.setNullFlavor("NA");
        CS statusCode = regEvent.addNewStatusCode();
        statusCode.setCode("active");
        return controlActProcess;
    }

    private void populate1301Person(PRPAMT201301UV02Person person, IdmServiceVO idmServiceVO, boolean isAddCorrelation, boolean isAddPreferredFacility) throws ServiceException {
        String mothersMaidenName;
        EnFamily family;
        EnGiven given;
        ArrayList<Object> useList;
        PN personName;
        String suffix;
        String prefix;
        String middleName;
        String lastName;
        String givenName;
        Set names = idmServiceVO.getNames();
        Name legalName = null;
        Name aliasName = null;
        if (names != null && names.size() > 0) {
            legalName = this.getLegalNameFromSet(names);
            aliasName = this.getAliasNameFromSet(names);
        }
        if (legalName != null) {
            givenName = legalName.getGivenName();
            lastName = legalName.getFamilyName();
            middleName = legalName.getMiddleName();
            prefix = legalName.getPrefix();
            suffix = legalName.getSuffix();
            personName = person.addNewName();
            useList = new ArrayList<Object>();
            useList.add(PersonNameUseLegalByBOT.Enum.forString((String)"L"));
            personName.setUse(useList);
            if (givenName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(givenName);
            }
            if (middleName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(middleName);
            }
            if (lastName != null) {
                family = personName.addNewFamily();
                family.newCursor().setTextValue(lastName);
            }
            if (prefix != null && prefix.length() > 0) {
                EnPrefix enPrefix = personName.addNewPrefix();
                enPrefix.newCursor().setTextValue(prefix);
            }
            if (suffix != null && suffix.length() > 0) {
                EnSuffix enSuffix = personName.addNewSuffix();
                enSuffix.newCursor().setTextValue(suffix);
            }
        }
        if (aliasName != null) {
            givenName = aliasName.getGivenName();
            lastName = aliasName.getFamilyName();
            middleName = aliasName.getMiddleName();
            prefix = aliasName.getPrefix();
            suffix = aliasName.getSuffix();
            personName = person.addNewName();
            useList = new ArrayList();
            useList.add(ALIAS_NAME_TYPE);
            personName.setUse(useList);
            if (givenName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(givenName);
            }
            if (middleName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(middleName);
            }
            if (lastName != null) {
                family = personName.addNewFamily();
                family.newCursor().setTextValue(lastName);
            }
        }
        if ((mothersMaidenName = idmServiceVO.getMothersMaidenName()) != null) {
            PN personName2 = person.addNewName();
            ArrayList<String> useList2 = new ArrayList<String>();
            useList2.add(MOTHERS_MAIDEN_NAME_TYPE);
            personName2.setUse(useList2);
            EnFamily family2 = personName2.addNewFamily();
            family2.newCursor().setTextValue(mothersMaidenName);
        }
        if (idmServiceVO.getGender() != null) {
            person.addNewAdministrativeGenderCode().setCode(idmServiceVO.getGender().getCode());
        }
        if (idmServiceVO.getBirthRecord() != null) {
            PRPAMT201301UV02BirthPlace birthPlace;
            if (idmServiceVO.getBirthRecord().getMultipleBirth() != null) {
                BL bl = person.addNewMultipleBirthInd();
                bl.setValue(idmServiceVO.getBirthRecord().getMultipleBirth().booleanValue());
            }
            if (idmServiceVO.getBirthRecord().getBirthDate() != null) {
                person.addNewBirthTime().setValue(idmServiceVO.getBirthRecord().getBirthDate().getyyyyMMddFormat());
            }
            if ((birthPlace = person.addNewBirthPlace()) != null) {
                String countryCode;
                String stateCode;
                AD birthAdd = birthPlace.addNewAddr();
                BirthRecord bRecord = idmServiceVO.getBirthRecord();
                String city = bRecord.getCity();
                if (city != null) {
                    AdxpCity pcity = birthAdd.addNewCity();
                    pcity.newCursor().setTextValue(city);
                }
                if ((stateCode = bRecord.getState()) != null) {
                    AdxpState pstate = birthAdd.addNewState();
                    pstate.newCursor().setTextValue(stateCode);
                }
                if ((countryCode = bRecord.getCountry()) != null) {
                    AdxpCountry pcountry = birthAdd.addNewCountry();
                    pcountry.newCursor().setTextValue(countryCode);
                }
            }
        }
        if (idmServiceVO.getAddressByType(AddressType.CODE_PERMANENT_ADDRESS.getCode()) != null) {
            Address address = idmServiceVO.getAddressByType(AddressType.CODE_PERMANENT_ADDRESS.getName());
            this.populateAddress(person.addNewAddr(), address);
        }
        if (idmServiceVO.getHomePhone() != null) {
            this.populatePhone(idmServiceVO.getHomePhone(), person.addNewTelecom());
        }
        if (idmServiceVO.getSsn() != null) {
            PRPAMT201301UV02OtherIDs otherIds = person.addNewAsOtherIDs();
            otherIds.setClassCode("SSN");
            II ssnId = otherIds.addNewId();
            if (idmServiceVO.getSsn().getSsaVerificationStatus() != null) {
                String ssaVerificationStatusCode = idmServiceVO.getSsn().getSsaVerificationStatus().getCode();
                otherIds.addNewStatusCode().setCode(ssaVerificationStatusCode);
            }
            ssnId.setExtension(idmServiceVO.getSsn().getFormattedSsnText());
            ssnId.setRoot(SSN_OID);
            this.populateScopingOrganization(otherIds.addNewScopingOrganization(), SSN_OID);
        }
        PRPAMT201301UV02OtherIDs icnOtherIds = person.addNewAsOtherIDs();
        icnOtherIds.setClassCode("PAT");
        II icnid = icnOtherIds.addNewId();
        icnid.setRoot("2.16.840.1.113883.4.349");
        this.populateScopingOrganization(icnOtherIds.addNewScopingOrganization(), "2.16.840.1.113883.4.349");
        if (isAddCorrelation) {
            if (idmServiceVO.getVpid() != null) {
                icnid.setExtension(idmServiceVO.getVpid().getVPID() + "^PI^" + this.getEsrStationNumber() + "^USVHA");
            }
        } else if (isAddPreferredFacility) {
            icnid.setExtension(idmServiceVO.getVpid().getVPID() + "^PI^" + this.getEsrStationNumber() + "^USVHA");
            String prefFacilityStNum = null;
            VAFacility prefFacility = idmServiceVO.getPreferredFacilty();
            if (prefFacility != null) {
                prefFacilityStNum = prefFacility.getStationNumber();
            }
            icnid.setExtension("PROXY_VISTA^PI^" + prefFacilityStNum + "^USVHA");
        } else {
            icnid.setExtension("USE_ICN^PI^200ESR^USVHA");
        }
        if (isAddPreferredFacility) {
            PRPAMT201301UV02OtherIDs patientType = person.addNewAsOtherIDs();
            patientType.setClassCode("patientServiceConnected");
            II serviceConnectcedId = patientType.addNewId();
            serviceConnectcedId.setExtension(this.getYesNoValue(idmServiceVO.isServiceConnected()));
            serviceConnectcedId.setRoot("2.16.840.1.113883.4.349");
            this.populateScopingOrganization(patientType.addNewScopingOrganization(), "2.16.840.1.113883.4.349");
            PRPAMT201301UV02OtherIDs veteran = person.addNewAsOtherIDs();
            veteran.setClassCode("patientType");
            II veteranId = veteran.addNewId();
            veteranId.setExtension(idmServiceVO.getPatientType());
            veteranId.setRoot("2.16.840.1.113883.4.349");
            this.populateScopingOrganization(veteran.addNewScopingOrganization(), "2.16.840.1.113883.4.349");
        }
        PRPAMT201301UV02OtherIDs veteran = person.addNewAsOtherIDs();
        veteran.setClassCode("patientVeteran");
        II veteranId = veteran.addNewId();
        veteranId.setExtension(this.getYesNoValue(idmServiceVO.isVeteran()));
        veteranId.setRoot("2.16.840.1.113883.4.349");
        this.populateScopingOrganization(veteran.addNewScopingOrganization(), "2.16.840.1.113883.4.349");
    }

    private Name getLegalNameFromSet(Set names) {
        for (Name currName : names) {
            if (currName.getType() == null || !NameType.LEGAL_NAME.getCode().equals(currName.getType().getCode())) continue;
            return currName;
        }
        return null;
    }

    private Name getAliasNameFromSet(Set names) {
        for (Name currName : names) {
            if (currName.getType() == null || !NameType.ALIAS_NAME.getCode().equals(currName.getType().getCode())) continue;
            return currName;
        }
        return null;
    }

    private void populate1302Person(PRPAMT201302UV02Person person, IdmServiceVO idmServiceVO) throws ServiceException {
        String mothersMaidenName;
        EnFamily family;
        EnGiven given;
        ArrayList<Object> useList;
        PN personName;
        String suffix;
        String prefix;
        String middleName;
        String lastName;
        String givenName;
        Set names = idmServiceVO.getNames();
        Name legalName = null;
        Name aliasName = null;
        if (names != null && names.size() > 0) {
            legalName = this.getLegalNameFromSet(names);
            aliasName = this.getAliasNameFromSet(names);
        }
        if (legalName != null) {
            givenName = legalName.getGivenName();
            lastName = legalName.getFamilyName();
            middleName = legalName.getMiddleName();
            prefix = legalName.getPrefix();
            suffix = legalName.getSuffix();
            personName = person.addNewName();
            useList = new ArrayList<Object>();
            useList.add(PersonNameUseLegalByBOT.Enum.forString((String)"L"));
            personName.setUse(useList);
            if (givenName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(givenName);
            }
            if (middleName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(middleName);
            }
            if (lastName != null) {
                family = personName.addNewFamily();
                family.newCursor().setTextValue(lastName);
            }
            if (prefix != null && prefix.length() > 0) {
                EnPrefix enPrefix = personName.addNewPrefix();
                enPrefix.newCursor().setTextValue(prefix);
            }
            if (suffix != null && suffix.length() > 0) {
                EnSuffix enSuffix = personName.addNewSuffix();
                enSuffix.newCursor().setTextValue(suffix);
            }
        }
        if (aliasName != null) {
            givenName = aliasName.getGivenName();
            lastName = aliasName.getFamilyName();
            middleName = aliasName.getMiddleName();
            prefix = aliasName.getPrefix();
            suffix = aliasName.getSuffix();
            personName = person.addNewName();
            useList = new ArrayList();
            useList.add(ALIAS_NAME_TYPE);
            personName.setUse(useList);
            if (givenName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(givenName);
            }
            if (middleName != null) {
                given = personName.addNewGiven();
                given.newCursor().setTextValue(middleName);
            }
            if (lastName != null) {
                family = personName.addNewFamily();
                family.newCursor().setTextValue(lastName);
            }
        }
        if ((mothersMaidenName = idmServiceVO.getMothersMaidenName()) != null) {
            PN personName2 = person.addNewName();
            ArrayList<String> useList2 = new ArrayList<String>();
            useList2.add(MOTHERS_MAIDEN_NAME_TYPE);
            personName2.setUse(useList2);
            if (mothersMaidenName != null) {
                EnFamily family2 = personName2.addNewFamily();
                family2.newCursor().setTextValue(mothersMaidenName);
            }
        }
        if (idmServiceVO.getGender() != null) {
            person.addNewAdministrativeGenderCode().setCode(idmServiceVO.getGender().getCode());
        }
        if (idmServiceVO.getBirthRecord() != null) {
            PRPAMT201302UV02BirthPlace birthPlace;
            if (idmServiceVO.getBirthRecord().getMultipleBirth() != null) {
                BL bl = person.addNewMultipleBirthInd();
                bl.setValue(idmServiceVO.getBirthRecord().getMultipleBirth().booleanValue());
            }
            if (idmServiceVO.getBirthRecord().getBirthDate() != null) {
                person.addNewBirthTime().setValue(idmServiceVO.getBirthRecord().getBirthDate().getyyyyMMddFormat());
            }
            if ((birthPlace = person.addNewBirthPlace()) != null) {
                String countryCode;
                String stateCode;
                AD birthAdd = birthPlace.addNewAddr();
                BirthRecord bRecord = idmServiceVO.getBirthRecord();
                String city = bRecord.getCity();
                if (city != null) {
                    AdxpCity pcity = birthAdd.addNewCity();
                    pcity.newCursor().setTextValue(city);
                }
                if ((stateCode = bRecord.getState()) != null) {
                    AdxpState pstate = birthAdd.addNewState();
                    pstate.newCursor().setTextValue(stateCode);
                }
                if ((countryCode = bRecord.getCountry()) != null) {
                    AdxpCountry pcountry = birthAdd.addNewCountry();
                    pcountry.newCursor().setTextValue(countryCode);
                }
            }
        }
        if (idmServiceVO.getAddressByType(AddressType.CODE_PERMANENT_ADDRESS.getCode()) != null) {
            Address address = idmServiceVO.getAddressByType(AddressType.CODE_PERMANENT_ADDRESS.getName());
            this.populateAddress(person.addNewAddr(), address);
        }
        if (idmServiceVO.getHomePhone() != null) {
            this.populatePhone(idmServiceVO.getHomePhone(), person.addNewTelecom());
        }
        if (idmServiceVO.getSsn() != null) {
            SSN ssn = idmServiceVO.getSsn();
            PRPAMT201302UV02OtherIDs otherIds = person.addNewAsOtherIDs();
            otherIds.setClassCode("SSN");
            PRPAMT201302UV02OtherIDsId ssnId = otherIds.addNewId();
            ssnId.setExtension(ssn.getFormattedSsnText());
            ssnId.setRoot(SSN_OID);
            if (ssn.getSsaVerificationStatus() != null) {
                String ssaVerificationStatusCode = ssn.getSsaVerificationStatus().getCode();
                otherIds.addNewStatusCode().setCode(ssaVerificationStatusCode);
                if (SSAVerificationStatus.IN_PROCESS.getCode().equals(ssaVerificationStatusCode) && ssn.getSsaSentDate() != null) {
                    otherIds.addNewEffectiveTime().setValue(new SimpleDateFormat("yyyyMMdd").format(ssn.getSsaSentDate()));
                } else if (SSAVerificationStatus.INVALID_PER_SSA.getCode().equals(ssaVerificationStatusCode) && ssn.getSsaReceivedDate() != null) {
                    otherIds.addNewEffectiveTime().setValue(new SimpleDateFormat("yyyyMMdd").format(ssn.getSsaReceivedDate()));
                } else if (SSAVerificationStatus.VERIFIED.getCode().equals(ssaVerificationStatusCode) && ssn.getSsaVerificationDate() != null) {
                    otherIds.addNewEffectiveTime().setValue(new SimpleDateFormat("yyyyMMdd").format(ssn.getSsaVerificationDate()));
                }
            }
            if (ssn.getPseudoSSNReason() != null) {
                otherIds.setNullFlavor("OTH");
                otherIds.addNewStatusCode().setCode(ssn.getPseudoSSNReason().getCode());
                ssnId.setRoot("2.16.840.1.113883.4.349");
            }
            COCTMT150002UV01Organization scopingorganization = otherIds.addNewScopingOrganization();
            this.populateScopingOrganization(scopingorganization, SSN_OID);
            if (ssn.getSourceOfChange() != null) {
                scopingorganization.addNewCode().setCode(ssn.getSourceOfChange().getCode());
                scopingorganization.getCode().setDisplayName(ssn.getSourceOfChange().getDescription());
                if (ssn.getSsaMessage() != null) {
                    scopingorganization.getCode().addNewOriginalText().newCursor().setTextValue(ssn.getSsaMessage().getDescription());
                }
            }
        }
        PRPAMT201302UV02OtherIDs icnOtherIds = person.addNewAsOtherIDs();
        icnOtherIds.setClassCode("PAT");
        PRPAMT201302UV02OtherIDsId icnid = icnOtherIds.addNewId();
        icnid.setRoot("2.16.840.1.113883.4.349");
        this.populateScopingOrganization(icnOtherIds.addNewScopingOrganization(), "2.16.840.1.113883.4.349");
        if (idmServiceVO.getVpid() != null) {
            icnid.setExtension(idmServiceVO.getVpid().getVPID() + "^PI^" + this.getEsrStationNumber() + "^USVHA");
        }
    }

    private void populateAddress(AD addressTag, Address address) {
        if (address != null) {
            String zipCode;
            String stateCode;
            String countryCode;
            ArrayList<Object> useList = new ArrayList<Object>();
            if (address.getBadAddressReason() != null) {
                useList.add(AddressUse.Member.Enum.forString((String)BAD_ADDRESS));
                addressTag.setUse(useList);
                AdxpAdditionalLocator additionalLocator = addressTag.addNewAdditionalLocator();
                additionalLocator.setPartType(PART_TYPE_ADL);
                additionalLocator.newCursor().setTextValue((String)idmBadAddressTable.get(address.getBadAddressReason().getCode()));
            } else {
                useList.add(HomeAddressUse.Enum.forString((String)HOME_PERMANENT));
                addressTag.setUse(useList);
            }
            String addressLine1 = address.getLine1();
            String addressLine2 = address.getLine2();
            String addressLine3 = address.getLine3();
            ArrayList<String> addressLineList = new ArrayList<String>();
            if (addressLine1 != null && addressLine1.length() > 0) {
                addressLineList.add(addressLine1);
            }
            if (addressLine2 != null && addressLine2.length() > 0) {
                addressLineList.add(addressLine2);
            }
            if (addressLine3 != null && addressLine3.length() > 0) {
                addressLineList.add(addressLine3);
            }
            for (int i = 0; i < addressLineList.size(); ++i) {
                String addressLine = (String)addressLineList.get(i);
                AdxpStreetAddressLine line = addressTag.addNewStreetAddressLine();
                line.newCursor().setTextValue(addressLine);
            }
            String city = address.getCity();
            if (city != null) {
                AdxpCity pcity = addressTag.addNewCity();
                pcity.newCursor().setTextValue(city);
            }
            if ((countryCode = address.getCountry()) != null) {
                AdxpCountry pcountry = addressTag.addNewCountry();
                pcountry.newCursor().setTextValue(countryCode);
            }
            if (Country.isUSAddress(countryCode)) {
                stateCode = address.getState();
                zipCode = address.getZipCode();
            } else {
                stateCode = address.getProvince();
                zipCode = address.getPostalCode();
            }
            if (stateCode != null) {
                AdxpState pstate = addressTag.addNewState();
                pstate.newCursor().setTextValue(stateCode);
            }
            if (zipCode != null) {
                String zipPlus4 = address.getZipPlus4();
                if (zipPlus4 != null && zipPlus4.length() > 0) {
                    zipCode = zipCode + "-" + zipPlus4;
                }
                AdxpPostalCode postalCode = addressTag.addNewPostalCode();
                postalCode.newCursor().setTextValue(zipCode);
            }
        }
    }

    private void populatePhone(Phone phone, TEL tel) {
        tel.setValue(phone.getPhoneNumber());
        ArrayList<HomeAddressUse.Enum> useList = new ArrayList<HomeAddressUse.Enum>();
        useList.add(HomeAddressUse.Enum.forString((String)HOME_PERMANENT));
        tel.setUse(useList);
    }

    private PRPAIN201305UV02Document createSearchRequest(FullyQualifiedIdentity id, String responseGroupId, PersonIdentityTraits traits, String compositeCode, IdMSearchInfo searchInfo, boolean attendedSearch) throws ServiceException {
        PRPAIN201305UV02Document pPRPAIN201305UV02Doc = (PRPAIN201305UV02Document)this.getXmlObject(PRPAIN201305UV02Document.class);
        PRPAIN201305UV02 pPRPAIN201305UV02 = pPRPAIN201305UV02Doc.addNewPRPAIN201305UV02();
        Date currentDate = Calendar.getInstance().getTime();
        String uniqueId = this.generateUniqueID(currentDate);
        this.populateHeaderRoot(pPRPAIN201305UV02.addNewId(), uniqueId);
        this.populateCreationTime(pPRPAIN201305UV02.addNewCreationTime(), currentDate);
        if (searchInfo != null && searchInfo.isExtendedSearch()) {
            pPRPAIN201305UV02.addNewVersionCode().setCode("3.0");
        }
        this.populateInteractionId(pPRPAIN201305UV02.addNewInteractionId(), "PRPA_IN201305UV02");
        this.populateProcessingCode(pPRPAIN201305UV02.addNewProcessingCode());
        this.populateProcessingModeCode(pPRPAIN201305UV02.addNewProcessingModeCode());
        this.populateAcceptAckCode(pPRPAIN201305UV02.addNewAcceptAckCode());
        this.populateReceiver(pPRPAIN201305UV02.addNewReceiver());
        this.populateSender(pPRPAIN201305UV02.addNewSender());
        PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = pPRPAIN201305UV02.addNewControlActProcess();
        controlActProcess.setClassCode(ActClassControlAct.Enum.forString((String)CACT_CLASS_CODE));
        controlActProcess.setMoodCode(XActMoodIntentEvent.Enum.forString((String)CACT_MOOD_CODE));
        CD code = controlActProcess.addNewCode();
        code.setCode("PRPA_TE201305UV02");
        code.setCodeSystem("2.16.840.1.113883.1.6");
        if (searchInfo != null && searchInfo.isExtendedSearch()) {
            this.populateExtendedSearchDataEnterer(controlActProcess, searchInfo);
        } else {
            QUQIMT021001UV01AuthorOrPerformer authorOrPerformer = controlActProcess.addNewAuthorOrPerformer();
            authorOrPerformer.setTypeCode(XParticipationAuthorPerformer.Enum.forString((String)"AUT"));
        }
        PRPAMT201306UV02QueryByParameter queryByParameter = controlActProcess.addNewQueryByParameter();
        II queryId = queryByParameter.addNewQueryId();
        queryId.setRoot(this.getMsName());
        queryId.setExtension(uniqueId);
        CS statusCode = queryByParameter.addNewStatusCode();
        statusCode.setCode(QRY_STATUS);
        if (compositeCode != null) {
            queryByParameter.addNewModifyCode().setCode(compositeCode);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("composite search flag: " + compositeCode));
            }
        }
        CS priorityCode = queryByParameter.addNewResponsePriorityCode();
        priorityCode.setCode(QRY_RES_PRIORITY_CD);
        INT initQuantity = queryByParameter.addNewInitialQuantity();
        if (id != null || compositeCode != null || !attendedSearch) {
            initQuantity.setValue(new BigInteger("1"));
        } else {
            initQuantity.setValue(new BigInteger("10"));
        }
        if (responseGroupId != null) {
            II responseElementGroupId = queryByParameter.addNewResponseElementGroupId();
            responseElementGroupId.setExtension(responseGroupId);
            responseElementGroupId.setRoot("2.16.840.1.113883.4.349");
        }
        PRPAMT201306UV02MatchCriterionList matchCriterionList = queryByParameter.addNewMatchCriterionList();
        PRPAMT201306UV02MinimumDegreeMatch minimumDegreeMatch = matchCriterionList.addNewMinimumDegreeMatch();
        ANY value = minimumDegreeMatch.addNewValue();
        PRPAMT201306UV02ParameterList parameterList = queryByParameter.addNewParameterList();
        this.populateSearchParameterList(parameterList, id, traits, searchInfo);
        return pPRPAIN201305UV02Doc;
    }

    private void populateExtendedSearchDataEnterer(PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess, IdMSearchInfo searchInfo) {
        QUQIMT021001UV01DataEnterer enterer = controlActProcess.addNewDataEnterer();
        enterer.setContextControlCode("AP");
        enterer.setTypeCode("ENT");
        COCTMT090100UV01AssignedPerson assPerson = enterer.addNewAssignedPerson();
        assPerson.setClassCode("ASSIGNED");
        II idSec = assPerson.addNewId();
        idSec.setRoot("2.16.840.1.113883.3.2017");
        idSec.setExtension(searchInfo.getDataEntererExtension());
        COCTMT090100UV01Person assPerson2 = assPerson.addNewAssignedPerson();
        assPerson2.setDeterminerCode("INSTANCE");
        assPerson2.setClassCode("PSN");
        EN name = assPerson2.addNewName();
        name.addNewGiven().newCursor().setTextValue(searchInfo.getDataEntererGivenName());
        name.addNewFamily().newCursor().setTextValue(searchInfo.getDataEntererFamilyName());
        COCTMT150000UV02Organization repOrg = assPerson.addNewRepresentedOrganization();
        repOrg.setClassCode("ORG");
        repOrg.setDeterminerCode("INSTANCE");
        II idSec2 = repOrg.addNewId();
        idSec2.setRoot("2.16.840.1.113883.4.349");
        idSec2.setExtension(searchInfo.getDataEntererFamilyName() + ", " + searchInfo.getDataEntererGivenName());
        repOrg.addNewCode().setCode(this.BGS_ExternalKey);
        repOrg.addNewDesc().newCursor().setTextValue(this.BGS_applicationName);
        repOrg.addNewTelecom().setValue(this.getHostName());
    }

    private String getHostName() {
        if (this.BGS_CLIENT_MACHINE != null) {
            return this.BGS_CLIENT_MACHINE;
        }
        try {
            this.BGS_CLIENT_MACHINE = InetAddress.getLocalHost().getHostName();
            if (StringUtils.isNotEmpty((String)this.BGS_CLIENT_MACHINE)) {
                return this.BGS_CLIENT_MACHINE;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.BGS_CLIENT_MACHINE = System.getenv("COMPUTERNAME");
        if (this.BGS_CLIENT_MACHINE != null) {
            return this.BGS_CLIENT_MACHINE;
        }
        this.BGS_CLIENT_MACHINE = System.getenv("HOSTNAME");
        if (this.BGS_CLIENT_MACHINE != null) {
            return this.BGS_CLIENT_MACHINE;
        }
        this.BGS_CLIENT_MACHINE = this.getMsName();
        return this.BGS_CLIENT_MACHINE;
    }

    private void populateSearchParameterList(PRPAMT201306UV02ParameterList parameterList, FullyQualifiedIdentity id, PersonIdentityTraits traits, IdMSearchInfo searchInfo) {
        String phone;
        Address address;
        ImpreciseDate birthDate;
        String ssnText;
        if (id != null) {
            II uniqueId = parameterList.addNewId();
            uniqueId.setExtension(id.getIdmExtension());
            uniqueId.setRoot("2.16.840.1.113883.4.349");
            if (searchInfo != null && searchInfo.isExtendedSearch()) {
                this.setMVIOrchestration(parameterList);
            }
            return;
        }
        Set names = traits.getNames();
        Name legalName = null;
        if (names != null && names.size() > 0) {
            legalName = this.getLegalNameFromSet(names);
        }
        if (legalName != null) {
            EnGiven given;
            String givenName = legalName.getGivenName();
            String lastName = legalName.getFamilyName();
            String middleName = legalName.getMiddleName();
            PRPAMT201306UV02LivingSubjectName livingSubjectName = parameterList.addNewLivingSubjectName();
            EN name = livingSubjectName.addNewValue();
            ArrayList<PersonNameUseLegalByBOT.Enum> useList = new ArrayList<PersonNameUseLegalByBOT.Enum>();
            useList.add(PersonNameUseLegalByBOT.Enum.forString((String)"L"));
            name.setUse(useList);
            if (givenName != null) {
                given = name.addNewGiven();
                given.newCursor().setTextValue(givenName);
            }
            if (middleName != null) {
                given = name.addNewGiven();
                given.newCursor().setTextValue(middleName);
            }
            if (lastName != null) {
                EnFamily family = name.addNewFamily();
                family.newCursor().setTextValue(lastName);
            }
            ST livingSubST = livingSubjectName.addNewSemanticsText();
            livingSubST.newCursor().setTextValue("LivingSubject.name");
        }
        if ((ssnText = traits.getSsnText()) != null && ssnText.length() > 0) {
            PRPAMT201306UV02LivingSubjectId livingSubId = parameterList.addNewLivingSubjectId();
            II subSSN = livingSubId.addNewValue();
            subSSN.setRoot(SSN_OID);
            subSSN.setExtension(traits.getSsn().getSsnText());
            ST semantics = livingSubId.addNewSemanticsText();
            semantics.newCursor().setTextValue("OtherIDs.scopingOrganization.id");
        }
        String dobText = null;
        BirthRecord birthRecord = traits.getBirthRecord();
        if (birthRecord != null && (birthDate = birthRecord.getBirthDate()) != null) {
            dobText = birthDate.getyyyyMMddFormat();
        }
        if (dobText != null) {
            PRPAMT201306UV02LivingSubjectBirthTime birthTime = parameterList.addNewLivingSubjectBirthTime();
            IVLTS birthTimeValue = birthTime.addNewValue();
            birthTimeValue.setValue(dobText);
            ST semantics = birthTime.addNewSemanticsText();
            semantics.newCursor().setTextValue("LivingSubject.birthTime");
        }
        String genderCode = null;
        if (traits.getGender() != null) {
            genderCode = traits.getGender().getCode();
        }
        if (genderCode != null) {
            PRPAMT201306UV02LivingSubjectAdministrativeGender livingSubGender = parameterList.addNewLivingSubjectAdministrativeGender();
            CE genderCodeValue = livingSubGender.addNewValue();
            genderCodeValue.setCode(genderCode);
            ST semantics = livingSubGender.addNewSemanticsText();
            semantics.newCursor().setTextValue("LivingSubject.administrativeGender");
        }
        if ((address = traits.getAddressByType(AddressType.CODE_PERMANENT_ADDRESS.getName())) != null) {
            PRPAMT201306UV02PatientAddress pAddress = parameterList.addNewPatientAddress();
            AD addressValue = pAddress.addNewValue();
            this.populateAddress(addressValue, address);
        }
        String string = phone = address != null ? address.getPhoneNumber() : null;
        if (phone != null) {
            PRPAMT201306UV02PatientTelecom teleCom = parameterList.addNewPatientTelecom();
            TEL tel = teleCom.addNewValue();
            tel.setValue(phone);
            ArrayList<HomeAddressUse.Enum> useList = new ArrayList<HomeAddressUse.Enum>();
            useList.add(HomeAddressUse.Enum.forString((String)HOME_PERMANENT));
            tel.setUse(useList);
        }
        if (searchInfo != null && searchInfo.isExtendedSearch()) {
            this.setMVIOrchestration(parameterList);
        }
    }

    private void setMVIOrchestration(PRPAMT201306UV02ParameterList parameterList) {
        PRPAMT201306UV02OtherIDsScopingOrganization scopingOrg = parameterList.addNewOtherIDsScopingOrganization();
        II val = scopingOrg.addNewValue();
        val.setRoot("2.16.840.1.113883.4.349");
        val.setExtension("VBA");
        ST semantics = scopingOrg.addNewSemanticsText();
        semantics.newCursor().setTextValue("MVI.ORCHESTRATION");
    }

    private Set parseSearchResponse(PRPAIN201306UV02Document responseDocument, boolean isSearchByDfn, IdMSearchInfo searchInfo) throws Exception {
        if (responseDocument == null || responseDocument.getPRPAIN201306UV02() == null) {
            return null;
        }
        PRPAIN201306UV02 response = responseDocument.getPRPAIN201306UV02();
        MCCIMT000300UV01Acknowledgement[] ack = response.getAcknowledgementArray();
        int matchThreshhold = -1;
        int potentialThreshhold = -1;
        MCCIMT000300UV01AcknowledgementDetail[] ackDetails = ack[0].getAcknowledgementDetailArray();
        for (int i = 0; ackDetails != null && i < ackDetails.length; ++i) {
            MCCIMT000300UV01AcknowledgementDetail ackDetail = ackDetails[i];
            if ("MVI".equals(ackDetail.getCode().getCodeSystem())) {
                String disName = ackDetail.getCode().getDisplayName();
                String code = ackDetail.getCode().getCode();
                int codeInt = -1;
                if (code != null) {
                    codeInt = Integer.parseInt(code);
                }
                if ("IMT".equals(disName)) {
                    matchThreshhold = codeInt;
                    continue;
                }
                if (!"PDT".equals(disName)) continue;
                potentialThreshhold = codeInt;
                continue;
            }
            matchThreshhold = -1;
            potentialThreshhold = -1;
        }
        PRPAIN201306UV02MFMIMT700711UV01ControlActProcess controlActprocess = response.getControlActProcess();
        MFMIMT700711UV01QueryAck queryAck = controlActprocess.getQueryAck();
        if (queryAck != null && queryAck.getQueryResponseCode() != null) {
            String queryAckResponseCode = queryAck.getQueryResponseCode().getCode();
            if (queryAckResponseCode != null && "QE".equals(queryAckResponseCode)) {
                throw new MaxRecordsExceededException(-1, 10, "Search Idm Service exceeded allowable limit of 10 matched records.");
            }
            if ("NF".equals(queryAckResponseCode)) {
                return null;
            }
            if (!"OK".equals(queryAckResponseCode)) {
                throw new ServiceException("Unknown response code for Search:" + queryAckResponseCode);
            }
        }
        String dfn = null;
        if (isSearchByDfn && controlActprocess.getQueryByParameter() != null) {
            PRPAMT201306UV02ParameterList qryList = controlActprocess.getQueryByParameter().getParameterList();
            PatientIdentifier identifier = null;
            if (qryList != null) {
                II id = qryList.getId();
                String idValue = id.getExtension();
                identifier = new PatientIdentifier(idValue);
                dfn = identifier.getIdentity();
            }
        }
        PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjects = response.getControlActProcess().getSubjectArray();
        HashSet<PersonIdentityTraits> responseTraits = new HashSet<PersonIdentityTraits>();
        for (int i = 0; subjects != null && i < subjects.length; ++i) {
            PRPAIN201306UV02MFMIMT700711UV01Subject1 subject = subjects[i];
            PRPAMT201310UV02Patient patient = subject.getRegistrationEvent().getSubject1().getPatient();
            PersonIdentityTraits trait = this.parsePatientTraits(patient, dfn, matchThreshhold, potentialThreshhold);
            responseTraits.add(trait);
        }
        return responseTraits;
    }

    private PersonIdentityTraits parsePatientTraits(PRPAMT201310UV02Patient patient, String dfnParam, int matchThreshhold, int potentialThreshhold) throws Exception {
        TS dodTs;
        PRPAMT201310UV02BirthPlace bPlace;
        PersonIdentityTraits trait = new PersonIdentityTraits();
        II[] ids = patient.getIdArray();
        HashSet<SiteIdentity> siteIdentities = new HashSet<SiteIdentity>();
        ArrayList<PatientIdentifier> identifierLst = new ArrayList<PatientIdentifier>();
        for (int i = 0; ids != null && i < ids.length; ++i) {
            SiteIdentity siteIdentity;
            II id = ids[i];
            String idValue = id.getExtension();
            PatientIdentifier identifier = new PatientIdentifier(idValue);
            identifierLst.add(identifier);
            if ("NI".equals(identifier.getIdentityType()) && "200M".equals(identifier.getStationNumber())) {
                String vpidInCorrelation = identifier.getIdentity();
                VPIDEntityKey longVPID = CommonEntityKeyFactory.createVPIDEntityKey(VPIDEntityKeyImpl.getLongVPID(vpidInCorrelation));
                trait.setVpid(longVPID);
                String idState = identifier.getIdState();
                trait.setIDState(idState);
                if ("PCE".equalsIgnoreCase(idState)) {
                    trait.setHasPendingUpdates(true);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("has Pending Updates: " + trait.isHasPendingUpdates()));
                this.logger.debug((Object)("vpid status: " + trait.getIDState()));
                continue;
            }
            if ("PI".equals(identifier.getIdentityType()) && ESR_CORRELATION.equals(identifier.getStationNumber())) {
                trait.set200ESRCorrelation(YES);
                continue;
            }
            if (!"PI".equalsIgnoreCase(identifier.getIdentityType()) || !"USVHA".equalsIgnoreCase(identifier.getAssigningAuthority()) || ESR_CORRELATION.equalsIgnoreCase(identifier.getStationNumber())) continue;
            if (dfnParam != null) {
                String idState = identifier.getIdState();
                trait.setIDState(idState);
                String dfnValue = identifier.getIdentity();
                if (dfnValue.equalsIgnoreCase(dfnParam) && "H".equalsIgnoreCase(idState)) {
                    trait.setDeprecated(true);
                }
            }
            if ((siteIdentity = this.getPatientSiteIdentity(identifier)) == null) continue;
            siteIdentities.add(siteIdentity);
            trait.setSiteIdentities(siteIdentities);
        }
        trait.setAllCorrelations(identifierLst);
        if (trait.has200ESRCorrelation() == null) {
            trait.set200ESRCorrelation(NO);
        }
        PRPAMT201310UV02Person pPerson = patient.getPatientPerson();
        HashSet<Name> names = new HashSet<Name>();
        PN[] pns = pPerson.getNameArray();
        int j = 0;
        while (pns != null & j < pns.length) {
            PN pn = pns[j];
            String nameUse = null;
            List useList = pn.getUse();
            if (useList != null && useList.size() > 0 && MOTHERS_MAIDEN_NAME_TYPE.equals(nameUse = useList.get(0).toString())) {
                EnFamily[] familyNames = pn.getFamilyArray();
                if (familyNames != null && familyNames.length > 0) {
                    trait.setMothersMaidenName(familyNames[0].newCursor().getTextValue());
                }
            } else {
                EnSuffix[] suffixArr;
                EnPrefix[] prefixArr;
                EnGiven[] givenNames;
                Name name = new Name();
                EnFamily[] familyNames = pn.getFamilyArray();
                if (familyNames != null && familyNames.length > 0) {
                    name.setFamilyName(familyNames[0].newCursor().getTextValue());
                }
                if ((givenNames = pn.getGivenArray()) != null && givenNames.length > 0) {
                    name.setGivenName(givenNames[0].newCursor().getTextValue());
                }
                if (givenNames != null && givenNames.length > 1) {
                    name.setMiddleName(givenNames[1].newCursor().getTextValue());
                }
                if ((prefixArr = pn.getPrefixArray()) != null && prefixArr.length > 0) {
                    name.setPrefix(prefixArr[0].newCursor().getTextValue());
                }
                if ((suffixArr = pn.getSuffixArray()) != null && suffixArr.length > 0) {
                    name.setSuffix(suffixArr[0].newCursor().getTextValue());
                }
                if (nameUse != null) {
                    name.setType(this.getLookupService().getNameTypeByCode(nameUse));
                }
                names.add(name);
            }
            ++j;
        }
        trait.setNames(names);
        CE ce = pPerson.getAdministrativeGenderCode();
        if (ce != null && ce.getCode() != null && !ce.getCode().equalsIgnoreCase("null")) {
            trait.setGender(this.getLookupService().getGenderByCode(ce.getCode()));
        }
        BirthRecord brecord = new BirthRecord();
        TS ts = pPerson.getBirthTime();
        if (ts != null) {
            brecord.setBirthDate(new ImpreciseDate(ts.getValue()));
        }
        if ((bPlace = pPerson.getBirthPlace()) != null) {
            AD bPlaceAddress = bPlace.getAddr();
            Address bAddress = this.parseAddress(bPlaceAddress);
            brecord.setCity(bAddress.getCity());
            brecord.setState(bAddress.getState());
            brecord.setCountry(bAddress.getCountry());
        }
        if (pPerson.getMultipleBirthInd() != null) {
            brecord.setMultipleBirth(new Boolean(pPerson.getMultipleBirthInd().getValue()));
        }
        if ((dodTs = pPerson.getDeceasedTime()) != null) {
            trait.setDateOfDeathText(dodTs.getValue());
        }
        if (pPerson.getMaritalStatusCode() != null) {
            String maritalStatusCode = pPerson.getMaritalStatusCode().getCode();
            MaritalStatus mstatus = this.getLookupService().getMaritalStatusByCode(maritalStatusCode);
        }
        trait.setBirthRecord(brecord);
        PRPAMT201310UV02Subject[] subjectOf1 = patient.getSubjectOf1Array();
        if (subjectOf1 != null && subjectOf1.length > 0) {
            ANY val = subjectOf1[0].getQueryMatchObservation().getValue();
            XmlCursor valCursor = val.newCursor();
            while (valCursor.toNextToken() != null && valCursor.getName() != null) {
                String attributeName = valCursor.getName().getLocalPart();
                String attributeValue = valCursor.getTextValue();
                if (!"value".equals(attributeName)) continue;
                float threshHoldValue = Float.parseFloat(attributeValue);
                if (threshHoldValue >= (float)matchThreshhold) {
                    trait.setIdmMatchType(2);
                    continue;
                }
                if (!((float)potentialThreshhold >= threshHoldValue)) continue;
                trait.setIdmMatchType(1);
            }
        }
        PRPAMT201310UV02OtherIDs[] otherIds = pPerson.getAsOtherIDsArray();
        SSN ssn = new SSN();
        boolean ssnSet = false;
        block3: for (int i = 0; otherIds != null && i < otherIds.length && !ssnSet; ++i) {
            if (!"SSN".equals(otherIds[i].getClassCode())) continue;
            II[] idArray = otherIds[i].getIdArray();
            for (int j2 = 0; idArray != null && j2 < idArray.length; ++j2) {
                if (SSN_OID.equals(idArray[j2].getRoot())) {
                    ssn.setSsnText(SSN.formatSSN(idArray[j2].getExtension()));
                    ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getCode()));
                    if (otherIds[i].getStatusCode() != null && otherIds[i].getStatusCode().getCode() != null && this.isSsnVerificationCode(otherIds[i].getStatusCode().getCode())) {
                        ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(otherIds[i].getStatusCode().getCode()));
                        IVLTS effectiveTimeTs = otherIds[i].getEffectiveTime();
                        Date effectiveDate = null;
                        if (effectiveTimeTs != null && !StringUtils.isBlank((String)effectiveTimeTs.getValue())) {
                            effectiveDate = new SimpleDateFormat("yyyyMMdd").parse(effectiveTimeTs.getValue());
                        }
                        if (SSAVerificationStatus.IN_PROCESS.getCode().equals(ssn.getSsaVerificationStatus().getCode())) {
                            ssn.setSsaSentDate(effectiveDate);
                        } else if (SSAVerificationStatus.INVALID_PER_SSA.getCode().equals(ssn.getSsaVerificationStatus().getCode())) {
                            ssn.setSsaReceivedDate(effectiveDate);
                        } else if (SSAVerificationStatus.VERIFIED.getCode().equals(ssn.getSsaVerificationStatus().getCode())) {
                            ssn.setSsaVerificationDate(effectiveDate);
                        }
                    }
                    trait.setSsn(ssn);
                    ssnSet = true;
                    continue block3;
                }
                if (!"2.16.840.1.113883.4.349".equals(idArray[j2].getRoot()) || !"OTH".equals(otherIds[i].getNullFlavor())) continue;
                ssn.setSsnText(SSN.formatSSN(idArray[j2].getExtension()));
                ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getCode()));
                if (otherIds[i].getStatusCode() != null && otherIds[i].getStatusCode().getCode() != null && this.isPsuedoSsnReasonCode(otherIds[i].getStatusCode().getCode())) {
                    ssn.setPseudoSSNReason(this.getLookupService().getPseudoSSNReasonByCode(otherIds[i].getStatusCode().getCode()));
                }
                trait.setSsn(ssn);
                ssnSet = true;
                continue block3;
            }
        }
        return trait;
    }

    public boolean isSupportedInEnvironment(VAFacility facility) throws ServiceException {
        return this.environmentParamService.isSupportedFacility(facility);
    }

    private SiteIdentity getPatientSiteIdentity(PatientIdentifier identifier) throws ServiceException {
        VAFacility facility = this.lookupService.getVaFacilityByCode(identifier.getStationNumber());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[ facility Identifier : " + facility.getIdentifier() + ", " + "Station #: " + facility.getStationNumber() + "]"));
        }
        if (this.isSupportedInEnvironment(facility)) {
            if (facility.getType().getIsMedicalTreating()) {
                SiteIdentity site = new SiteIdentity();
                site.setDfn(identifier.getIdentity());
                site.setVaFacility(facility);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[Site dfn: " + identifier.getIdentity() + ", " + "facility Identifier : " + facility.getIdentifier() + ", " + "Station #: " + identifier.getStationNumber() + "]"));
                }
                return site;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Site for facility with station #: " + facility.getStationNumber() + " excluded from the list because it is not supported by the environment."));
        }
        return null;
    }

    private boolean isSsnVerificationCode(String code) {
        return "0".equals(code) || "1".equals(code) || "2".equals(code) || "3".equals(code) || "4".equals(code);
    }

    private boolean isPsuedoSsnReasonCode(String code) {
        return "R".equals(code) || "S".equals(code) || NO.equals(code);
    }

    private Address parseAddress(AD ad) throws ServiceException {
        List useList;
        AdxpPostalCode[] postalCodes;
        AdxpCountry[] countries;
        AdxpState[] states;
        Address address = new Address();
        AdxpStreetAddressLine[] addressLines = ad.getStreetAddressLineArray();
        for (int k = 0; addressLines != null && k < addressLines.length; ++k) {
            AdxpStreetAddressLine line = addressLines[k];
            if (k == 0) {
                address.setLine1(line.newCursor().getTextValue());
            }
            if (k == 1) {
                address.setLine2(line.newCursor().getTextValue());
            }
            if (k != 2) continue;
            address.setLine3(line.newCursor().getTextValue());
        }
        AdxpCity[] cities = ad.getCityArray();
        if (cities != null && cities.length > 0) {
            address.setCity(cities[0].newCursor().getTextValue());
        }
        if ((states = ad.getStateArray()) != null && states.length > 0) {
            address.setState(states[0].newCursor().getTextValue());
        }
        if ((countries = ad.getCountryArray()) != null && countries.length > 0) {
            address.setCountry(countries[0].newCursor().getTextValue());
        }
        if ((postalCodes = ad.getPostalCodeArray()) != null && postalCodes.length > 0) {
            address.setPostalCode(postalCodes[0].newCursor().getTextValue());
        }
        if ((useList = ad.getUse()) != null && useList.size() > 0) {
            String addressType = useList.get(0).toString();
            AddressType sdsAddressType = this.getLookupService().getAddressTypeByCode(addressType);
            address.setType(sdsAddressType);
        }
        return address;
    }

    private XmlObject createDeathSourceFragment(DeathRecord record) throws XmlException {
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor xc = xo.newCursor();
        xc.toNextToken();
        xc.toNextToken();
        xc.insertAttributeWithValue("type", "CD");
        xc.insertAttributeWithValue("code", record.getDataSource().getCode());
        xc.insertAttributeWithValue("displayName", record.getDataSource().getDescription().toUpperCase());
        xc.dispose();
        return xo;
    }

    private void execute1302(IdmServiceVO idmServiceVO) throws ServiceException {
        MCCIMT000200UV01Acknowledgement ack;
        String responseCode;
        PRPAIN201302UV02Document pPRPAIN201302UV02Document = this.create1302Request();
        PRPAIN201302UV02 pPRPAIN201302UV02 = this.populate1302RequestHeaders(pPRPAIN201302UV02Document);
        PRPAIN201302UV02MFMIMT700701UV01ControlActProcess controlActProcess = this.add1302ControlActprocess(pPRPAIN201302UV02);
        PRPAIN201302UV02MFMIMT700701UV01RegistrationEvent regEvent = controlActProcess.getSubjectArray()[0].getRegistrationEvent();
        PRPAIN201302UV02MFMIMT700701UV01Subject2 sub1 = regEvent.addNewSubject1();
        sub1.setTypeCode(ParticipationTargetSubject.Enum.forString((String)"SBJ"));
        PRPAMT201302UV02Patient patient = sub1.addNewPatient();
        patient.setClassCode("PAT");
        PRPAMT201302UV02PatientId patientId = patient.addNewId();
        patientId.setRoot("2.16.840.1.113883.4.349");
        if (idmServiceVO.getVpid() != null) {
            patientId.setExtension(idmServiceVO.getVpid().getVPID());
        }
        patient.addNewStatusCode().setCode("active");
        COCTMT150003UV03Organization providerOrg = patient.addNewProviderOrganization();
        providerOrg.setClassCode("ORG");
        providerOrg.setDeterminerCode("INSTANCE");
        providerOrg.addNewId();
        providerOrg.addNewContactParty().setClassCode(RoleClassContact.Enum.forString((String)"CON"));
        PRPAMT201302UV02PatientPatientPerson person = patient.addNewPatientPerson();
        this.populate1302Person((PRPAMT201302UV02Person)person, idmServiceVO);
        boolean sendDeathFields = true;
        boolean isSourceNCA = false;
        if (idmServiceVO.getDeathRecord() != null && idmServiceVO.getDeathRecord().getDataSource() != null && idmServiceVO.getDeathRecord().getDataSource().getCode() != null && idmServiceVO.getDeathRecord().getDataSource().getCode().equals(DeathDataSource.CODE_NCA.getCode())) {
            isSourceNCA = true;
        }
        if (!this.getLookupService().getDODSharingInd() && idmServiceVO.getDeathEvent()) {
            this.logger.info((Object)"Not sending MVI death notification due to sharing indicator disabled");
            return;
        }
        if (idmServiceVO.getDeathEvent() && isSourceNCA) {
            this.logger.info((Object)("Not sending MVI death notification due to source NCA on person: " + idmServiceVO.getVpid().getKeyValueAsString()));
            return;
        }
        if (!idmServiceVO.getDeathEvent() && isSourceNCA) {
            sendDeathFields = false;
        }
        if (this.getLookupService().getDODSharingInd() && sendDeathFields && idmServiceVO.getDeathRecord() != null) {
            String auditUserId = SecurityContextHelper.getSecurityContext().getUserName(true);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            if (idmServiceVO.getDeathRecord().getDeathDate() == null && idmServiceVO.getDeathRecord().getLazarusDate() != null) {
                TS deathTime = person.addNewDeceasedTime();
                deathTime.setNullFlavor("NA");
            } else {
                PRPAMT201302UV02Subject4 subjectOf = patient.addNewSubjectOf();
                PRPAMT201302UV02AdministrativeObservation deathObservation = subjectOf.addNewAdministrativeObservation();
                deathObservation.setClassCode("VERIF");
                PRPAMT201302UV02AdministrativeObservationId id = deathObservation.addNewId();
                if (auditUserId.startsWith("VAMC")) {
                    id.setNullFlavor("NA");
                } else {
                    id.setExtension(auditUserId);
                }
                id.setRoot("2.16.840.1.113883.4.349");
                CD deathCode = deathObservation.addNewCode();
                deathCode.setCode("DOD_SOURCE");
                deathCode.setDisplayName("SOURCE_OF_NOTIFICATION");
                deathCode.setCodeSystem("2.16.840.1.113883.4.349");
                ANY notSource = deathObservation.addNewValue();
                if (idmServiceVO.getDeathRecord().getDeathDate() != null) {
                    TS deathTime = person.addNewDeceasedTime();
                    deathTime.setValue(CommonDateUtils.formatWithTime(idmServiceVO.getDeathRecord().getDeathDate(), "yyyyMMdd"));
                    person.setDeceasedTime(deathTime);
                }
                SXCMTS modDate = deathObservation.addNewEffectiveTime();
                modDate.setValue(dateFormat.format(idmServiceVO.getDeathRecord().getDeathReportDate()));
                try {
                    notSource.set(this.createDeathSourceFragment(idmServiceVO.getDeathRecord()));
                }
                catch (XmlException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
        MFMIMT700701UV01Custodian custodian = regEvent.addNewCustodian();
        custodian.setTypeCode("CST");
        COCTMT090003UV01AssignedEntity assignedEntity = custodian.addNewAssignedEntity();
        assignedEntity.setClassCode("ASSIGNED");
        assignedEntity.addNewId().setRoot("2.16.840.1.113883.4.349");
        COCTMT090003UV01Organization assignedOrg = assignedEntity.addNewAssignedOrganization();
        assignedOrg.setClassCode("ORG");
        assignedOrg.setDeterminerCode("INSTANCE");
        EN name = assignedOrg.addNewName();
        name.newCursor().setTextValue(this.getEsrStationNumber());
        MCCIIN000002UV01Document responseDocument = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceRequest: " + pPRPAIN201302UV02Document));
        }
        try {
            VAIdMStub stub = new VAIdMStub(this.getIdmServiceEndPoint());
            stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(this.webServiceTimeout);
            responseDocument = stub.PRPA_IN201302UV02(pPRPAIN201302UV02Document);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("IdmServiceResponse: " + responseDocument));
        }
        if (responseDocument != null && !APPLICATION_ACCEPT.equals(responseCode = (ack = responseDocument.getMCCIIN000002UV01().getAcknowledgementArray()[0]).getTypeCode().getCode())) {
            String errorMessage = ack.getAcknowledgementDetailArray()[0].getText().newCursor().getTextValue();
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("parse1302UpdateResponse returns error :" + errorMessage));
            }
            throw new ServiceException(errorMessage);
        }
    }

    public XmlObject getXmlObject(Class type) throws ServiceException {
        Method creatorMethod = null;
        try {
            if (XmlObject.class.isAssignableFrom(type)) {
                Class<?>[] declaredClasses = type.getDeclaredClasses();
                for (int i = 0; i < declaredClasses.length; ++i) {
                    Class<?> declaredClass = declaredClasses[i];
                    if (!declaredClass.getName().endsWith("$Factory")) continue;
                    creatorMethod = declaredClass.getMethod("newInstance", null);
                    break;
                }
            }
            if (creatorMethod != null) {
                return (XmlObject)creatorMethod.invoke(null, null);
            }
            throw new Exception("Creator not found!");
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            e.printStackTrace();
            while (t.getCause() != null) {
                t = t.getCause();
                t.printStackTrace();
            }
            throw new ServiceException((Throwable)e);
        }
    }

    private void populateHeaderRoot(II id, String uniqueId) {
        id.setRoot("2.16.840.1.113883.4.349");
        id.setExtension("MCID_" + uniqueId);
    }

    private String generateUniqueID(Date currentDate) {
        SimpleDateFormat dateFommat = new SimpleDateFormat("yyyyMMddHHmmss");
        String currDateStr = dateFommat.format(currentDate);
        String threadName = Thread.currentThread().getName();
        String serverName = this.getMsName();
        return serverName + "_" + threadName + "_" + currDateStr;
    }

    private void populateInteractionId(II id, String currentAction) {
        id.setRoot("2.16.840.1.113883.1.6");
        id.setExtension(currentAction);
    }

    private void populateProcessingCode(CS cs) {
        cs.setCode(this.getProcessingCode());
    }

    private void populateProcessingModeCode(CS cs) {
        cs.setCode(PROCESSING_MODE_CODE);
    }

    private void populateAcceptAckCode(CS cs) {
        cs.setCode(ACCEPT_ACK_CODE);
    }

    private MCCIMT000100UV01Receiver populateReceiver(MCCIMT000100UV01Receiver receiver) {
        receiver.setTypeCode(CommunicationFunctionType.Enum.forString((String)REC_TYPE_CODE));
        MCCIMT000100UV01Device device = receiver.addNewDevice();
        device.setClassCode(EntityClassDevice.Enum.forString((String)"DEV"));
        device.setDeterminerCode("INSTANCE");
        II deviceId = device.addNewId();
        deviceId.setRoot("2.16.840.1.113883.4.349");
        return receiver;
    }

    private MCCIMT000100UV01Sender populateSender(MCCIMT000100UV01Sender sender) {
        sender.setTypeCode(CommunicationFunctionType.Enum.forString((String)SND_TYPE_CODE));
        MCCIMT000100UV01Device device = sender.addNewDevice();
        device.setClassCode(EntityClassDevice.Enum.forString((String)"DEV"));
        device.setDeterminerCode("INSTANCE");
        sender.setDevice(device);
        II deviceId = device.addNewId();
        deviceId.setRoot("2.16.840.1.113883.4.349");
        deviceId.setExtension(this.getEsrStationNumber());
        return sender;
    }

    private void populateScopingOrganization(COCTMT150002UV01Organization scopingorganization, String oid) {
        scopingorganization.setClassCode("ORG");
        scopingorganization.setDeterminerCode("INSTANCE");
        II id = scopingorganization.addNewId();
        id.setRoot(oid);
    }

    private void populateCreationTime(TS creationTime, Date currentDate) {
        SimpleDateFormat dateFommat = new SimpleDateFormat("yyyyMMddHHmmss");
        String currDateStr = dateFommat.format(currentDate);
        creationTime.setValue(currDateStr);
    }

    private String getYesNoValue(boolean flag) {
        if (flag) {
            return YES;
        }
        return NO;
    }

    private String getIdMBadAdressString(String code) {
        return (String)idmBadAddressTable.get(code);
    }

    private static Hashtable initIdmBadAddressTable() {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put(BadAddressReason.CODE_UNDELIVERABLE.getCode(), "VAB1^[UNDELIVERABLE: Mail was returned or is otherwise known to be undeliverable]");
        tab.put(BadAddressReason.CODE_HOMELESS.getCode(), "VAB2^[HOMELESS: Veteran has no known address]");
        tab.put(BadAddressReason.CODE_OTHER.getCode(), "VAB3^[OTHER: Address could not be shared for some reason other than HOMELESS or UNDELIVERABLE]");
        tab.put(BadAddressReason.CODE_ADDRESS_NOT_FOUND.getCode(), "VAB4^[ADDRESS NOT FOUND: For use by HEC only]");
        return tab;
    }
}

