/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.impl.MessagingServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.Validate;

public class GenerateQRYZ11MessagingServiceImpl
extends MessagingServiceImpl
implements GenerateQRYZ11MessagingService {
    private static final long serialVersionUID = -4077153102997010638L;
    private WorkflowService workflowService = null;

    @Override
    public void generateMessage(PersonEntityKey key, String VPID2) throws ServiceException {
        VPIDEntityKey entityKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        PersonIdentityTraits identityTraits = this.getPsDelegateService().getIdentityTraits(entityKey);
        this.generateQRYZ11(key, identityTraits);
    }

    private void generateQRYZ11(PersonEntityKey key, PersonIdentityTraits identityTraits) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("GenerateQRYZ11MessagingServiceImpl.generateQRYZ11(): Generate QRY-Z11 for person " + key.getKeyValueAsString()));
        }
        Validate.notNull((Object)key, (String)"PersonEntityKey must not be null");
        Validate.notNull((Object)((Object)identityTraits), (String)"Identity Traits must not be null");
        PersonTriggerEvent personTriggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VBA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.ELIGIBILITY);
        personTriggerEvent.setPersonId(key);
        personTriggerEvent.setIdentityTraits(identityTraits);
        this.getTriggerRouter().processTriggerEvent((TriggerEvent)personTriggerEvent);
    }

    @Override
    public void generateMessageForPendingTraitsClock(Person person) throws ServiceException {
        if (person.isPersonLocked() && PersonLockedReason.PENDING_IDENTITY_TRAIT_UPDATES.getReason().equals(person.getPersonLockedReason().getReason())) {
            String errMsg = "VBA message not processed due to Pending Identity Traits, QRY~Z11 cannot be sent. vpid= " + person.getVPIDValue();
            this.createWorkloadCase(FunctionalGroup.DQ.getCode(), WkfCaseType.CODE_REVIEW_FILE.getCode(), null, errMsg, person.getPersonEntityKey());
            this.logger.error((Object)errMsg);
        } else {
            this.generateMessage(person.getPersonEntityKey(), person.getVPIDValue());
        }
    }

    private void createWorkloadCase(String groupType, String caseType, String issueType, String description, PersonEntityKey key) throws ServiceException {
        Validate.notNull((Object)groupType, (String)"A Group type must not be null");
        Validate.notNull((Object)caseType, (String)"A case type must not be null");
        WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
        caseInfo.setPersonEntityKey(key);
        try {
            caseInfo.setErrorMessage(description);
            caseInfo.setGroupType(this.getLookupService().getFunctionalGroupByCode(groupType));
            caseInfo.setCaseType(this.getLookupService().getWkfCaseTypeByCode(caseType));
            if (StringUtils.isNotEmpty((String)issueType)) {
                caseInfo.setIssueType(this.getLookupService().getWkfIssueTypeByCode(issueType));
            }
            this.getWorkflowService().autoCreateCase(caseInfo);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Case description: " + description));
                this.logger.debug((Object)("Case type: " + caseType));
                this.logger.debug((Object)"Failed to create case due to ", (Throwable)e);
            }
            throw new ServiceException("Failed to create a case", (Throwable)e);
        }
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

