/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.ee.EGTSettingDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public class EGTServiceImpl
extends AbstractRuleAwareServiceImpl
implements EGTService {
    private static final long serialVersionUID = 8932467141395519860L;
    private EGTSettingDAO egtDAO = null;
    private HistoryDAO egtHistoryDAO = null;
    private SchedulingService schedulingService = null;
    private JobDetail egtJobDetail = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.egtDAO, (String)"EGTSettingDAO is required");
        Validate.notNull((Object)this.egtHistoryDAO, (String)"HistoryDAO is required");
        Validate.notNull((Object)this.schedulingService, (String)"SchedulingService is required");
        Validate.notNull((Object)this.egtJobDetail, (String)"EGT process JobDetail is required");
    }

    @Override
    public EGTSetting getCurrentEGTSetting() throws ServiceException {
        EGTSetting egt = null;
        try {
            egt = this.egtDAO.getActive();
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getActiveEGTSetting by date", (Throwable)ex);
        }
        return egt;
    }

    @Override
    public Set getFutureEGTSettings() throws ServiceException {
        try {
            return this.egtDAO.getFutureEGTSettings();
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getActiveEGTSetting by date", (Throwable)ex);
        }
    }

    @Override
    public EGTSetting getActiveEGTSetting(Date asOf) throws ServiceException {
        EGTSetting egt = null;
        try {
            egt = this.egtDAO.getActive(asOf);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getActiveEGTSetting by date: " + asOf, (Throwable)ex);
        }
        return egt;
    }

    @Override
    public EGTSetting getEGTSetting(EntityKey key) throws ServiceException {
        try {
            return (EGTSetting)((Object)this.getEgtDAO().getByKey(key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Error loading EGTSetting using the key. ", (Throwable)ex);
        }
    }

    @Override
    public EGTSetting updateEGTSetting(EGTSetting egt) throws ServiceException {
        Validate.notNull((Object)((Object)egt), (String)"EGTSetting must not be null.");
        try {
            EGTSetting onFile = egt.getEntityKey() != null ? this.getEGTSetting(egt.getEntityKey()) : new EGTSetting();
            this.ensureEntityChanged((AbstractEntity)egt, (AbstractEntity)onFile);
            this.getEgtRuleService().manageEGT(egt, onFile);
            this.getEgtDAO().saveObject((Object)onFile);
            return onFile;
        }
        catch (DAOException ex) {
            throw new ServiceException("Error persisting EGTSetting Object.", (Throwable)ex);
        }
    }

    @Override
    public EGTSetting stopEGTProcessing() throws ServiceException {
        try {
            this.schedulingService.interrupt(this.egtJobDetail);
        }
        catch (SchedulerException ex) {
            throw new ServiceException("Error in interrupting EGTSetting batch process.", (Throwable)ex);
        }
        return this.getCurrentEGTSetting();
    }

    @Override
    public Set getEGTSettingHistoryChangeTimes() throws ServiceException {
        try {
            return this.egtHistoryDAO.getHistoryChangeTimes(null);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getEGTSettingHistoryByChangeTime(ChangeEvent changeEvent) throws ServiceException {
        try {
            return this.egtHistoryDAO.getHistoryByChangeTime(changeEvent);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateEnrollmentWithNewEGTSetting(List veteranIds, EGTSetting newSetting, Map siteStats) throws ServiceException {
        for (int v = 0; v < veteranIds.size(); ++v) {
            EnrollmentCategory category;
            PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl((BigDecimal)veteranIds.get(v));
            Person onFile = this.getPersonService().getPerson(key);
            Person calculated = this.getEnrollmentRuleService().determineEnrollment(onFile, newSetting);
            EnrollmentDetermination enrollment = calculated.getEnrollmentDetermination();
            EnrollmentStatus enrollmentStatus = enrollment != null ? enrollment.getEnrollmentStatus() : null;
            EnrollmentCategory enrollmentCategory = category = enrollmentStatus != null ? enrollmentStatus.getEnrollmentCategory() : null;
            if (category != null && EnrollmentCategory.CODE_NOT_ENROLLED.getCode().equals(category.getCode())) {
                Set sites = this.getPsDelegateService().getSites(calculated.getVPIDEntityKey());
                for (SiteIdentity siteIdentity : sites) {
                    this.incrementSiteCount(siteStats, siteIdentity.getVaFacility());
                }
            }
            this.getEventRuleService().handleCommonPostEvents(calculated, false);
            this.getPersonService().save(calculated);
        }
    }

    private synchronized void incrementSiteCount(Map siteStats, VAFacility vaFacility) {
        Integer currentCount = (Integer)siteStats.get((Object)vaFacility);
        currentCount = currentCount == null ? new Integer(1) : new Integer(currentCount + 1);
        siteStats.put(vaFacility, currentCount);
    }

    @Override
    public void saveEGTProcessStatistics(EGTProcessStatistic processStatistic) throws ServiceException {
        try {
            this.getEgtDAO().saveObject((Object)processStatistic);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to save the current EGTSetting. ", (Throwable)ex);
        }
    }

    @Override
    public EGTSetting saveAsCurrentEGTSetting(EGTSetting egt) throws ServiceException {
        EGTSetting currentEgt = null;
        try {
            currentEgt = this.egtDAO.getActive();
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get current EGTSetting. ", (Throwable)ex);
        }
        currentEgt.setCurrent(Boolean.FALSE);
        currentEgt.setDisable(Boolean.TRUE);
        egt.setPreviousEGT(currentEgt);
        egt.setDisable(Boolean.FALSE);
        egt.setCurrent(Boolean.TRUE);
        try {
            this.getEgtDAO().saveObject((Object)currentEgt);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get save existing EGTSetting.", (Throwable)ex);
        }
        try {
            this.getEgtDAO().saveObject((Object)egt);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get new EGTSetting.", (Throwable)ex);
        }
        return egt;
    }

    public EGTSettingDAO getEgtDAO() {
        return this.egtDAO;
    }

    public void setEgtDAO(EGTSettingDAO egtDAO) {
        this.egtDAO = egtDAO;
    }

    public HistoryDAO getEgtHistoryDAO() {
        return this.egtHistoryDAO;
    }

    public void setEgtHistoryDAO(HistoryDAO egtHistoryDAO) {
        this.egtHistoryDAO = egtHistoryDAO;
    }

    public JobDetail getEgtJobDetail() {
        return this.egtJobDetail;
    }

    public void setEgtJobDetail(JobDetail egtJobDetail) {
        this.egtJobDetail = egtJobDetail;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }
}

