/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.security.EEServiceRequest;
import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.common.model.security.EEServiceUser;
import gov.va.med.esr.common.persistent.security.SecurityDAO;
import gov.va.med.esr.service.EEServiceAdminService;
import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class EEServiceAdminServiceImpl
extends AbstractRuleAwareServiceImpl
implements EEServiceAdminService {
    private SecurityDAO securityDAO = null;

    public SecurityDAO getSecurityDAO() {
        return this.securityDAO;
    }

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    @Override
    public List getEEServiceRequests() throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequests();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public List getEEServiceLiteRequests() throws ServiceException {
        try {
            return this.securityDAO.getEEServiceLiteRequests();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceRequest getEEserviceRequest(EntityKey eeServiceRequestId) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequest(eeServiceRequestId);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public Set getEEServiceRequestFieldsByRequest(EntityKey eeServiceRequestId) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequestFieldsByRequest(eeServiceRequestId);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceRequestLite getEEserviceRequestLite(EntityKey eeServiceRequestId) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequestLite(eeServiceRequestId);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceRequest getEEServicerequestByName(String name) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequestByName(name);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceRequestLite getEEServicerequestLiteByName(String name) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceRequestLiteByName(name);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public void saveEEServiceRequest(EEServiceRequest eeServiceRequest) throws ServiceException {
        try {
            this.securityDAO.saveObject((Object)eeServiceRequest);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("Exception while saving EEServiceRequest: ", (Throwable)daoEx);
        }
    }

    @Override
    public List getEEServiceUsers() throws ServiceException {
        try {
            return this.securityDAO.getEEServiceUsers();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceUser getEEServiceUser(String userName) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceUserByName(userName);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    @Override
    public void saveEEServiceUser(EEServiceUser eeServiceUser) throws ServiceException {
        try {
            this.securityDAO.saveObject((Object)eeServiceUser);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("Exception while saving EEServiceRequest: ", (Throwable)daoEx);
        }
    }

    @Override
    public EEServiceUser getEEserviceUser(EntityKey eeServiceUserId) throws ServiceException {
        try {
            return this.securityDAO.getEEServiceUserById(eeServiceUserId);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyRequest(EESummary eeSummary, String accountName, String requestName) throws ServiceException {
        EEServiceRequestLite eeServiceRequest = null;
        try {
            eeServiceRequest = this.securityDAO.getEEServiceRequestLiteByName(requestName);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        Set allowedFields = this.getEEServiceRequestFieldsByRequest(eeServiceRequest.getEntityKey());
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        Map map = null;
        try {
            map = propUtils.describe((Object)eeSummary);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        String prefix = "eeSummary";
        Iterator itr = map.keySet().iterator();
        block8: while (true) {
            try {
                while (itr.hasNext()) {
                    Object value;
                    String keyName = (String)itr.next();
                    if ("class".equals(keyName) || (value = map.get(keyName)) == null) continue;
                    if (value instanceof ExternalComponent) {
                        boolean isNull = this.applyRoleToObject(value, prefix + "." + keyName, eeSummary, keyName, allowedFields);
                        if (!isNull) continue;
                        propUtils.setSimpleProperty((Object)eeSummary, keyName, null);
                        continue;
                    }
                    if (value instanceof ExternalComponent[]) {
                        boolean isAllNull = true;
                        ExternalComponent[] objArr = (ExternalComponent[])value;
                        for (int i = 0; i < objArr.length; ++i) {
                            ExternalComponent thisObj = objArr[i];
                            boolean isNull = this.applyRoleToObject(thisObj, prefix + "." + keyName, eeSummary, keyName, allowedFields);
                            if (isNull) {
                                thisObj = null;
                                propUtils.setSimpleProperty((Object)eeSummary, keyName, null);
                                continue;
                            }
                            isAllNull = false;
                        }
                        if (!isAllNull) continue;
                        propUtils.setSimpleProperty((Object)eeSummary, keyName, null);
                        continue;
                    }
                    try {
                        propUtils.setSimpleProperty(value, keyName, null);
                        continue block8;
                    }
                    catch (Exception e) {
                        throw new ServiceException((Throwable)e);
                        return;
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    private boolean applyRoleToObject(Object obj, String prefix, Object parentObject, String parentKeyName, Set allowedFields) throws ServiceException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        Map map = null;
        try {
            map = propUtils.describe(obj);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        boolean allisNull = true;
        for (String keyName : map.keySet()) {
            Object value;
            if ("class".equals(keyName) || (value = map.get(keyName)) == null) continue;
            if (value instanceof ExternalComponent) {
                boolean isNull = this.applyRoleToObject(value, prefix + "." + keyName, obj, keyName, allowedFields);
                if (!isNull) {
                    allisNull = false;
                    continue;
                }
                value = null;
                propUtils.setSimpleProperty(obj, keyName, null);
                continue;
            }
            if (value instanceof ExternalComponent[]) {
                ExternalComponent[] objArr = (ExternalComponent[])value;
                boolean isArrayNull = true;
                for (int i = 0; objArr != null && i < objArr.length; ++i) {
                    ExternalComponent thisObj = objArr[i];
                    boolean isNull = this.applyRoleToObject(thisObj, prefix + "." + keyName, obj, keyName, allowedFields);
                    if (!isNull) {
                        allisNull = false;
                        isArrayNull = false;
                        continue;
                    }
                    thisObj = null;
                    propUtils.setSimpleProperty(obj, keyName, null);
                }
                if (!isArrayNull) continue;
                value = null;
                propUtils.setSimpleProperty(parentObject, parentKeyName, null);
                continue;
            }
            try {
                String fieldName = prefix + "." + keyName;
                if (!allowedFields.contains(fieldName)) {
                    propUtils.setSimpleProperty(obj, keyName, null);
                    continue;
                }
                allisNull = false;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return allisNull;
    }
}

