/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.service.CompletedReportService;
import gov.va.med.esr.service.CompletedReportsSearchQueryInfo;
import gov.va.med.esr.service.impl.StandardReportServiceImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.util.ArrayList;
import java.util.List;

public class CompletedReportServiceImpl
extends StandardReportServiceImpl
implements CompletedReportService {
    private static final long serialVersionUID = 1L;

    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        ArrayList<SimpleCompletedReport> rptItems = new ArrayList<SimpleCompletedReport>();
        try {
            CompletedReportsSearchQueryInfo searchCriteria = (CompletedReportsSearchQueryInfo)searchQueryInfo;
            List allReports = this.getReportDAO().searchCompletedReports(searchCriteria);
            if (allReports != null) {
                for (SimpleCompletedReport completedReport : allReports) {
                    if (!this.isUserPermittedToScheduleRunDeleteArchive(searchCriteria.getUser(), completedReport.getStandardReport()) && !this.isUserPermittedToView(searchCriteria.getUser(), completedReport.getStandardReport())) continue;
                    rptItems.add(completedReport);
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("CompletedReports Search Failed.  searchQueryInfo = " + searchQueryInfo, (Throwable)e);
        }
        searchQueryInfo.setTotalNumberOfEntries(rptItems.size());
        return rptItems;
    }
}

