/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsLogSearchQueryInfo;
import gov.va.med.esr.common.model.comms.UndeliverableMailInfo;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class CommsLogServiceImpl
extends AbstractRuleAwareServiceImpl
implements CommsLogService {
    private static final long serialVersionUID = -4817235230296107829L;
    private CommsLogEntryDAO dao = null;
    private DemographicService demographicService = null;
    private CommsLetterRequestService letterRequestService = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.dao, (String)"dao is required");
        Validate.notNull((Object)this.letterRequestService, (String)"letterRequestService is required");
    }

    public CommsLogServiceImpl(CommsLogEntryDAO dao) {
        Validate.notNull((Object)dao, (String)"CommsLogEntryDAO is required.");
        this.dao = dao;
    }

    @Override
    public CommsLogEntry getCommsLogEntry(EntityKey key) throws ServiceException {
        try {
            return (CommsLogEntry)((Object)this.dao.getByKey(key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Error getting CommsLogEntry using key: " + key, (Throwable)ex);
        }
    }

    @Override
    public CommsLogEntry findByBarcode(String barcode) throws ServiceException {
        try {
            return this.dao.findCommsLogEntryByBarcode(barcode);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find CommsLogEntry for barcode: " + barcode, (Throwable)ex);
        }
    }

    @Override
    public void update(CommsLogEntry logEntry) throws ServiceException {
        try {
            this.dao.update(logEntry);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to update CommsLogEntry.", (Throwable)ex);
        }
    }

    @Override
    public void insert(CommsLogEntry logEntry) throws ServiceException {
        try {
            this.dao.insert(logEntry);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to insert CommsLogEntry.", (Throwable)ex);
        }
    }

    @Override
    public List findLogEntriesByPersonId(String personId) throws ServiceException {
        try {
            return this.dao.findCommsLogListByPersonId(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find CommsLogEntries by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public UndeliverableMailInfo findUndeliverableMailByBarcode(String barcode) throws ServiceException {
        UndeliverableMailInfo mailInfo = null;
        CommsLogEntry commsLogEntry = this.findByBarcode(barcode);
        if (commsLogEntry != null && commsLogEntry.isMailedByAAC()) {
            mailInfo = new UndeliverableMailInfo();
            mailInfo.setCommsLogEntry(commsLogEntry);
            mailInfo.setUpdatedAddress(this.getDemographicService().getUndeliverableMailUpdatedLetterAddress(mailInfo.getCommsLogEntry()));
        }
        return mailInfo;
    }

    @Override
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        if (!(searchQueryInfo instanceof CommsLogSearchQueryInfo)) {
            throw new ServiceException("searchQueryInfo is an instance of '" + searchQueryInfo.getClass().getName() + "' and must be an instance of 'CommsLogSearchQueryInfo'.");
        }
        CommsLogSearchQueryInfo commsLogSearchQueryInfo = (CommsLogSearchQueryInfo)searchQueryInfo;
        List commsLogEntries = null;
        try {
            commsLogEntries = this.dao.find(commsLogSearchQueryInfo);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to find CommsLogEntry objects based on the selected search criteria.", (Throwable)ex);
        }
        ArrayList<UndeliverableMailInfo> undeliverableMailEntries = new ArrayList<UndeliverableMailInfo>();
        if (commsLogEntries == null) {
            return undeliverableMailEntries;
        }
        for (CommsLogEntry commsLogEntry : commsLogEntries) {
            UndeliverableMailInfo undeliverableMailInfo = new UndeliverableMailInfo();
            undeliverableMailInfo.setCommsLogEntry(commsLogEntry);
            undeliverableMailInfo.setUpdatedAddress(this.getDemographicService().getUndeliverableMailUpdatedLetterAddress(commsLogEntry));
            undeliverableMailEntries.add(undeliverableMailInfo);
        }
        return undeliverableMailEntries;
    }

    @Override
    public void processUndeliverableMail(List commsLogEntries) throws ServiceException {
        this.getCommunicationRuleService().handleUndeliverableMail(commsLogEntries);
    }

    @Override
    public CommsLogEntry updateCommunicationLog(CommsLogEntry log) throws ServiceException {
        CommsLogEntry onFile = null;
        try {
            EntityKey key = log.getEntityKey();
            if (key != null) {
                onFile = (CommsLogEntry)((Object)this.dao.getByKey(key));
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to find CommsLogEntry by entity key: " + log.getEntityKey().getKeyValueAsString(), (Throwable)e);
        }
        if (onFile == null) {
            onFile = (CommsLogEntry)((Object)log.clone());
        }
        this.getCommunicationRuleService().manageCommunicationsLog(log, onFile);
        this.update(onFile);
        if (onFile.isCancelledByHec()) {
            this.letterRequestService.cancelLetterRequest(onFile);
        }
        return onFile;
    }

    @Override
    public void processAutomaticLetterRequests(Person person, Clock.Type clockType, String subject) throws ServiceException {
        this.getCommunicationRuleService().triggerAutomaticLetters(person, clockType, subject);
    }

    @Override
    public void handleMailingResponses(List responses) throws ServiceException {
        this.getCommunicationRuleService().handleMailingResponses(responses);
    }

    @Override
    public void handleMailingResponses(CommsLogEntry log) throws ServiceException {
        this.getCommunicationRuleService().handleMailingResponses(log);
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public CommsLetterRequestService getLetterRequestService() {
        return this.letterRequestService;
    }

    public void setLetterRequestService(CommsLetterRequestService letterRequestService) {
        this.letterRequestService = letterRequestService;
    }
}

