/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.DuplicatePrintRequestServiceException;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;

public class CommsLetterMessageProcessor
extends AbstractComponent
implements TriggerableService {
    private PersonService personService = null;
    private CommsLetterRequestService commsLetterRequestService = null;
    private HandBookService handBookService = null;

    public void trigger(TriggerEvent triggerEvent) throws ServiceException {
        block5: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received a trigger event " + triggerEvent));
            }
            LetterTriggerEvent letterTriggerEvent = (LetterTriggerEvent)triggerEvent;
            Person person = this.getPerson(letterTriggerEvent);
            LetterTriggerIdentity letterTriggerIdentity = (LetterTriggerIdentity)letterTriggerEvent.getTriggerIdentity();
            try {
                if (letterTriggerIdentity.getDataType().getCode().equals(ComLetterTemplateType.FORM_NUMBER_400H.getCode()) || letterTriggerIdentity.getDataType().getCode().equals(ComLetterTemplateType.FORM_NUMBER_400B.getCode()) || letterTriggerIdentity.getDataType().getCode().equals(ComLetterTemplateType.FORM_NUMBER_400F.getCode())) {
                    this.getHandBookService().requestHandBook(person.getEntityKey().getKeyValueAsString(), letterTriggerIdentity);
                } else {
                    this.commsLetterRequestService.requestLetter(person, letterTriggerIdentity, letterTriggerEvent);
                }
            }
            catch (DuplicatePrintRequestServiceException e) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn((Object)("Unable to insert a record for a letter print request....this may be because the batch process has not run yet to clear the tracking for Person Id[" + letterTriggerEvent.getPersonId().getKeyValueAsString() + "] and Form number[" + letterTriggerIdentity.getDataType().getCode() + "]"));
            }
        }
    }

    private Person getPerson(LetterTriggerEvent letterTriggerEvent) throws ServiceException {
        try {
            Person person = null;
            if (letterTriggerEvent.getIdentityTraits() != null) {
                person = this.personService.find(letterTriggerEvent.getIdentityTraits());
            } else {
                PersonEntityKey key = letterTriggerEvent.getPersonId();
                if (key != null) {
                    person = this.personService.getPerson(key);
                }
            }
            return person;
        }
        catch (ServiceException e) {
            throw new ServiceException("Error retrieving a person from the LetterTriggerEvent", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        if (this.personService == null) {
            throw new InvalidConfigurationException("personService must be set on " + ((Object)((Object)this)).getClass().getName());
        }
        if (this.commsLetterRequestService == null) {
            throw new InvalidConfigurationException("commsLetterRequestService must be set on " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CommsLetterRequestService getCommsLetterRequestService() {
        return this.commsLetterRequestService;
    }

    public void setCommsLetterRequestService(CommsLetterRequestService commsLetterRequestService) {
        this.commsLetterRequestService = commsLetterRequestService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }
}

