/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.comms.CommsBulletin;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.comms.CommsEmailBulletinDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.person.idmgmt.VPID;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.mail.SimpleMailMessage;

public class CommsEmailBulletinServiceImpl
extends AbstractComponent
implements CommsEmailBulletinService {
    private static final long serialVersionUID = 7123593184875571623L;
    public static final String TAG_VPID = "VPID";
    private static Hashtable bulletinTable = new Hashtable();
    private MailService mailService;
    private SimpleMailMessage message;
    private CommsEmailBulletinDAO dao = null;
    private PSDelegateService psDelegateService = null;
    private LookupService lookupService = null;
    private EnvironmentParamService environmentParamService;
    private static HashMap emailDomainNameMap = new HashMap();

    public CommsEmailBulletinServiceImpl(CommsEmailBulletinDAO emailDAO) {
        if (emailDAO == null) {
            throw new IllegalArgumentException("CommsEmailBulletinDAO is required as a parameter for constructor");
        }
        this.dao = emailDAO;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.dao, (String)"A dao of type CommsEmailBulletinDAO must be configured");
        Validate.notNull((Object)this.message, (String)"mesage is required");
        Validate.notNull((Object)this.mailService, (String)"mailService is required");
        Validate.notNull((Object)this.psDelegateService, (String)"psDelegateService is required");
        Validate.notNull((Object)this.lookupService, (String)"lookupService is required");
    }

    public SimpleMailMessage getMessage() {
        return this.message;
    }

    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    @Override
    public void sendEmailBulletin(BulletinTrigger.DataType bullName, Map dataMap, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)bullName), (String)"A bulletin must not be null");
        Validate.notNull((Object)bullName.getName(), (String)"A bulletin name must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send email bulletin: " + bullName.getName()));
        }
        String bulletinName = bullName.getName();
        CommsBulletin bulletin = this.getEmailBulletin(bulletinName);
        Hashtable<String, String> parameterValues = new Hashtable<String, String>(dataMap);
        if (bulletin != null) {
            Set personSites = person == null ? new HashSet() : this.getSites(person.getVPIDEntityKey());
            Map siteIdentityMap = this.getSiteIdentityMap(personSites);
            if (BulletinTrigger.DataType.HEC_NOTIFY_SITE_VETERAN_VERIFICATION.getName().equals(bulletin.getCommsBulletinName())) {
                String vistedSiteNames = this.getVisitedSitenames(personSites);
                parameterValues.put("SitesVeteranVisited", vistedSiteNames);
            }
            String recipientList = null;
            Map facilityEmailAddressMap = this.constructSiteRecipientList(bulletin, dataMap, person, personSites);
            if (StringUtils.isNotBlank((String)bulletin.getRecipient())) {
                recipientList = this.replaceParameters(bulletin.getRecipient(), parameterValues);
            }
            bulletinTable.put(bulletinName, bulletin);
            if (recipientList != null && facilityEmailAddressMap.size() == 0) {
                String[] toList = recipientList.split(",");
                String subject = this.replaceParameters(bulletin.getSubject(), parameterValues);
                String bodyText = this.generateEmailText(bulletin.getCommsBulletinText(), parameterValues, person, null);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to " + recipientList));
                }
                this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to " + recipientList));
                }
            } else if (facilityEmailAddressMap.size() > 0) {
                Set facilities = facilityEmailAddressMap.keySet();
                for (VAFacility facility : facilities) {
                    String emailAddressList = (String)facilityEmailAddressMap.get((Object)facility);
                    if (recipientList != null) {
                        emailAddressList = emailAddressList + "," + recipientList;
                    }
                    String[] toList = emailAddressList.split(",");
                    String subject = this.replaceParameters(bulletin.getSubject(), parameterValues);
                    String bodyText = this.generateEmailText(bulletin.getCommsBulletinText(), parameterValues, person, (SiteIdentity)((Object)siteIdentityMap.get((Object)facility)));
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to " + emailAddressList));
                    }
                    this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to " + emailAddressList));
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " is NOT configured with any recipients....ignoring"));
            }
        } else {
            ServiceException ex = new ServiceException("Email Bulletin with name: " + bulletinName + " does not exist");
            this.logger.error((Object)"ERROR email bulletin does not exist while sending an email bulletin", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void sendVOAWorkflowEmailBulletin(BulletinTrigger.DataType bullName, Map dataMap, Person person, String formType) throws ServiceException {
        Validate.notNull((Object)((Object)bullName), (String)"A bulletin must not be null");
        Validate.notNull((Object)bullName.getName(), (String)"A bulletin name must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send email bulletin: " + bullName.getName()));
        }
        String bulletinName = bullName.getName();
        CommsBulletin bulletin = this.getEmailBulletin(bulletinName);
        Hashtable<String, String> parameterValues = new Hashtable<String, String>(dataMap);
        if (bulletin != null) {
            Set personSites = person == null ? new HashSet() : this.getSites(person.getVPIDEntityKey());
            Map siteIdentityMap = this.getSiteIdentityMap(personSites);
            if (BulletinTrigger.DataType.HEC_NOTIFY_SITE_VETERAN_VERIFICATION.getName().equals(bulletin.getCommsBulletinName())) {
                String vistedSiteNames = this.getVisitedSitenames(personSites);
                parameterValues.put("SitesVeteranVisited", vistedSiteNames);
            }
            String recipientList = null;
            Map facilityEmailAddressMap = this.constructSiteRecipientList(bulletin, dataMap, person, personSites);
            if (StringUtils.isNotBlank((String)bulletin.getRecipient())) {
                recipientList = this.replaceParameters(bulletin.getRecipient(), parameterValues);
            }
            bulletinTable.put(bulletinName, bulletin);
            if (recipientList != null && facilityEmailAddressMap.size() == 0) {
                String[] toList = recipientList.split(",");
                String subject = null;
                subject = this.replaceParameters(bulletin.getSubject(), parameterValues) + " - " + formType;
                String bodyText = this.generateEmailText(bulletin.getCommsBulletinText(), parameterValues, person, null);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to " + recipientList));
                }
                this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to " + recipientList));
                }
            } else if (facilityEmailAddressMap.size() > 0) {
                Set facilities = facilityEmailAddressMap.keySet();
                for (VAFacility facility : facilities) {
                    String emailAddressList = (String)facilityEmailAddressMap.get((Object)facility);
                    if (recipientList != null) {
                        emailAddressList = emailAddressList + "," + recipientList;
                    }
                    String[] toList = emailAddressList.split(",");
                    String subject = this.replaceParameters(bulletin.getSubject(), parameterValues);
                    String bodyText = this.generateEmailText(bulletin.getCommsBulletinText(), parameterValues, person, (SiteIdentity)((Object)siteIdentityMap.get((Object)facility)));
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to " + emailAddressList));
                    }
                    this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to " + emailAddressList));
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " is NOT configured with any recipients....ignoring"));
            }
        } else {
            ServiceException ex = new ServiceException("Email Bulletin with name: " + bulletinName + " does not exist");
            this.logger.error((Object)"ERROR email bulletin does not exist while sending an email bulletin", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void sendEmailBulletinTo(BulletinTrigger.DataType bullName, Map dataMap, String[] toList) throws ServiceException {
        Validate.notNull((Object)((Object)bullName), (String)"A bulletin must not be null");
        Validate.notNull((Object)bullName.getName(), (String)"A bulletin name must not be null");
        Validate.notEmpty((Object[])toList, (String)"A bulletin To Email Addresses must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send email bulletin: " + bullName.getName()));
        }
        String bulletinName = bullName.getName();
        CommsBulletin bulletin = this.getEmailBulletin(bulletinName);
        Hashtable parameterValues = new Hashtable(dataMap);
        if (bulletin != null) {
            String subject = this.replaceParameters(bulletin.getSubject(), parameterValues);
            String bodyText = this.generateEmailText(bulletin.getCommsBulletinText(), parameterValues, null, null);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to " + toList));
            }
            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to " + toList));
            }
        } else {
            ServiceException ex = new ServiceException("Email Bulletin with name: " + bulletinName + " does not exist");
            this.logger.error((Object)"ERROR email bulletin does not exist while sending an email bulletin", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void sendEmailBulletin(BulletinTrigger.DataType bulletinType, String emailAddress) throws ServiceException {
        String bulletinName;
        CommsBulletin bulletin;
        Validate.notNull((Object)((Object)bulletinType), (String)"A bulletin must not be null");
        Validate.notNull((Object)bulletinType.getName(), (String)"A bulletin name must not be null");
        Validate.notNull((Object)emailAddress, (String)"emailAddress must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send email bulletin: " + bulletinType.getName()));
        }
        if ((bulletin = this.getEmailBulletin(bulletinName = bulletinType.getName())) != null && StringUtils.isNotBlank((String)bulletinName) && StringUtils.isNotBlank((String)emailAddress)) {
            String subject = bulletin.getSubject();
            String[] toList = new String[]{emailAddress};
            String bodyText = bulletin.getCommsBulletinText();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Sending Bulletin " + bulletin.getCommsBulletinName() + " to {" + emailAddress + "}"));
            }
            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bulletin " + bulletin.getCommsBulletinName() + " sent to {" + emailAddress + "}"));
            }
        } else {
            this.logger.error((Object)("Bulletin " + bulletinName + " is not found."));
        }
    }

    private CommsBulletin getEmailBulletin(String bulletinName) throws ServiceException {
        CommsBulletin bulletin = (CommsBulletin)bulletinTable.get(bulletinName);
        if (bulletin == null) {
            try {
                bulletin = this.dao.findEmailBulletinByName(bulletinName);
            }
            catch (DAOException daoex) {
                this.logger.error((Object)"Error to find a bulletin while sending an email bulletin", (Throwable)daoex);
                throw new ServiceException("Error finding Email Bulletin with name = " + bulletinName, (Throwable)daoex);
            }
            if (bulletin != null) {
                bulletinTable.put(bulletinName, bulletin);
            }
        }
        return bulletin;
    }

    private String getVisitedSitenames(Set personSites) {
        String vistedSitenames = " ";
        HashSet<String> descriptions = new HashSet<String>();
        for (SiteIdentity siteIdentity : personSites) {
            VAFacility facility = siteIdentity.getVaFacility();
            String facName = facility.getDescription();
            if (facName == null) continue;
            descriptions.add(facName);
        }
        if (descriptions.size() > 0) {
            vistedSitenames = StringUtils.join((Object[])descriptions.toArray(), (String)"; ");
        }
        return vistedSitenames;
    }

    private Map constructSiteRecipientList(CommsBulletin bulletin, Map dataMap, Person person, Set personSites) throws ServiceException {
        String siteRecipientPrefixList = bulletin.getSiteRecipientPrefixList();
        String siteReceivingIndicator = bulletin.getSiteReceivingIndicator();
        HashMap<VAFacility, String> facilityEmailAddressMap = new HashMap<VAFacility, String>();
        if (siteRecipientPrefixList == null) {
            return facilityEmailAddressMap;
        }
        String[] prefixList = siteRecipientPrefixList.split(",");
        HashSet<VAFacility> facilities = new HashSet<VAFacility>();
        if (CommsBulletin.SENDING_SITE.equals(siteReceivingIndicator)) {
            VAFacility facility;
            String stationNumber = (String)dataMap.get("SITE");
            if (stationNumber != null && this.psDelegateService.isSupportedInEnvironment(facility = (VAFacility)this.lookupService.getByCode(VAFacility.class, stationNumber))) {
                facilities.add(facility);
            }
        } else if (CommsBulletin.VETERAN_SITES.equals(siteReceivingIndicator)) {
            if (personSites == null) {
                personSites = this.getSites(person.getVPIDEntityKey());
            }
            for (SiteIdentity siteIdentity : personSites) {
                VAFacility facility = siteIdentity.getVaFacility();
                if (!this.psDelegateService.isSupportedInEnvironment(facility)) continue;
                facilities.add(facility);
            }
        }
        for (VAFacility facility : facilities) {
            String emailDomainName = null;
            if (facility != null) {
                emailDomainName = facility.getEmailDomainName();
            }
            if (emailDomainName == null) continue;
            boolean addedOneEmail = false;
            StringBuffer siteRecipients = null;
            for (int i = 0; i < prefixList.length; ++i) {
                String emailPrefix = prefixList[i];
                emailPrefix = emailPrefix.trim();
                emailPrefix = emailPrefix.replace(' ', '_');
                String siteEmail = emailPrefix + "@" + emailDomainName;
                if (!addedOneEmail) {
                    siteRecipients = new StringBuffer(siteEmail);
                    addedOneEmail = true;
                    continue;
                }
                siteRecipients.append(",");
                siteRecipients.append(siteEmail);
            }
            if (siteRecipients == null) continue;
            facilityEmailAddressMap.put(facility, siteRecipients.toString());
        }
        return facilityEmailAddressMap;
    }

    private String replaceParameters(String text, Hashtable dataTable) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Enumeration keys = dataTable.keys();
        String key = null;
        String value = null;
        String tag = null;
        String percentTag = null;
        if (dataTable != null && dataTable.size() > 0) {
            while (keys.hasMoreElements()) {
                Object obj;
                key = keys.nextElement().toString();
                if (key == null || (obj = dataTable.get(key)) == null) continue;
                value = dataTable.get(key).toString();
                tag = "~" + key + "~";
                text = text.replaceAll(tag, value);
                percentTag = "<" + key + ">";
                text = text.replaceAll(percentTag, value);
            }
        }
        return text;
    }

    private String generateEmailText(String bodyText, Hashtable dataTable, Person person, SiteIdentity siteIdentity) {
        if (bodyText == null || bodyText.length() == 0) {
            return bodyText;
        }
        String text = this.replaceParameters(bodyText, dataTable);
        String tag = "~VPID~";
        if (person != null) {
            String vpid = VPID.getShortVPID((String)person.getVPIDEntityKey().getVPID());
            if (siteIdentity != null) {
                String dfn = " DFN: " + siteIdentity.getDfn() + " STATION NUMBER: " + siteIdentity.getVaFacility().getStationNumber();
                text = text.replaceAll(tag, vpid + dfn);
            } else {
                text = text.replaceAll(tag, vpid);
            }
        }
        return text;
    }

    @Override
    public Hashtable getEmptyBulletinDataTable(String bulletinName) throws ServiceException {
        Hashtable<String, String> dataTab = new Hashtable<String, String>();
        CommsBulletin bulletin = this.getEmailBulletin(bulletinName);
        if (bulletin != null && bulletin.getCommsBulletinText() != null) {
            Pattern p;
            String text = bulletin.getCommsBulletinText();
            try {
                p = Pattern.compile("~\\w+~");
            }
            catch (PatternSyntaxException pe) {
                throw new ServiceException("Can not match data element pattern", (Throwable)pe);
            }
            Matcher m = p.matcher(text);
            String tag = null;
            while (m.find()) {
                tag = m.group();
                dataTab.put(tag.substring(1, tag.length() - 1), "");
            }
        }
        return dataTab;
    }

    @Override
    public void sendSimpleMailMessage(String from, String[] toList, String[] ccList, String subject, String bodyText) throws ServiceException {
        SimpleMailMessage msg = new SimpleMailMessage(this.message);
        if (StringUtils.isNotBlank((String)from)) {
            msg.setFrom(from);
        }
        msg.setTo(toList);
        msg.setCc(ccList);
        msg.setSubject(subject);
        this.mailService.send(bodyText, msg);
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public EnvironmentParamService getEnvironmentParamService() {
        return this.environmentParamService;
    }

    public void setEnvironmentParamService(EnvironmentParamService environmentParamService) {
        this.environmentParamService = environmentParamService;
    }

    private String getEmailDomainName(String stationNumber) {
        return (String)emailDomainNameMap.get(stationNumber);
    }

    private Set getSites(VPIDEntityKey vpidEntityKey) throws ServiceException {
        return this.psDelegateService.getSites(vpidEntityKey);
    }

    private Map getSiteIdentityMap(Set personSites) {
        HashMap<VAFacility, SiteIdentity> map = new HashMap<VAFacility, SiteIdentity>();
        if (personSites != null && personSites.size() > 0) {
            for (SiteIdentity siteIdentity : personSites) {
                map.put(siteIdentity.getVaFacility(), siteIdentity);
            }
        }
        return map;
    }

    static {
        emailDomainNameMap.put("358", "MANILA.TEST");
        emailDomainNameMap.put("402", "TOGUS.TEST");
        emailDomainNameMap.put("405", "WHITE-RIVER.TEST");
        emailDomainNameMap.put("436", "MONTANA.TEST");
        emailDomainNameMap.put("437", "FARGO.TEST");
        emailDomainNameMap.put("438", "SIOUX-FALLS.TEST");
        emailDomainNameMap.put("442", "CHEYENNE.TEST");
        emailDomainNameMap.put("452", "WICHITA.TEST");
        emailDomainNameMap.put("459", "HONOLULU.TEST");
        emailDomainNameMap.put("460", "WILMINGTON.TEST");
        emailDomainNameMap.put("463", "ANCHORAGE.TEST");
        emailDomainNameMap.put("500", "ALBANY.TEST");
        emailDomainNameMap.put("501", "ALBUQUERQUE.TEST");
        emailDomainNameMap.put("502", "ALEXANDRIA.TEST");
        emailDomainNameMap.put("503", "ALTOONA.TEST");
        emailDomainNameMap.put("504", "AMARILLO.TEST");
        emailDomainNameMap.put("505", "TACOMA.TEST");
        emailDomainNameMap.put("506", "ANN-ARBOR.TEST");
        emailDomainNameMap.put("508", "ATLANTA.TEST");
        emailDomainNameMap.put("509", "AUGUSTA.TEST");
        emailDomainNameMap.put("512", "BALTIMORE.TEST");
        emailDomainNameMap.put("513", "BATAVIA.TEST");
        emailDomainNameMap.put("514", "BATH.TEST");
        emailDomainNameMap.put("515", "BATTLE-CREEK.TEST");
        emailDomainNameMap.put("516", "BAY-PINES.TEST");
        emailDomainNameMap.put("517", "BECKLEY.TEST");
        emailDomainNameMap.put("518", "BEDFORD.TEST");
        emailDomainNameMap.put("519", "BIG-SPRING.TEST");
        emailDomainNameMap.put("520", "BILOXI.TEST");
        emailDomainNameMap.put("521", "BIRMINGHAM.TEST");
        emailDomainNameMap.put("522", "BONHAM.TEST");
        emailDomainNameMap.put("523", "BOSTON.TEST");
        emailDomainNameMap.put("525", "BROCKTON.TEST");
        emailDomainNameMap.put("526", "BRONX.TEST");
        emailDomainNameMap.put("527", "BROOKLYN.TEST");
        emailDomainNameMap.put("528", "V02.TEST");
        emailDomainNameMap.put("529", "BUTLER.TEST");
        emailDomainNameMap.put("531", "BOISE.TEST");
        emailDomainNameMap.put("532", "CANANDAIGUA.TEST");
        emailDomainNameMap.put("533", "CASTLE-POINT.TEST");
        emailDomainNameMap.put("534", "CHARLESTON.TEST");
        emailDomainNameMap.put("535", "CHICAGO-LAKE.TEST");
        emailDomainNameMap.put("537", "CHICAGO-WEST.TEST");
        emailDomainNameMap.put("538", "CHILLICOTHE.TEST");
        emailDomainNameMap.put("539", "CINCINNATI.TEST");
        emailDomainNameMap.put("540", "CLARKSBURG.TEST");
        emailDomainNameMap.put("541", "CLEVELAND.TEST");
        emailDomainNameMap.put("542", "COATESVILLE.TEST");
        emailDomainNameMap.put("543", "COLUMBIA-MO.TEST");
        emailDomainNameMap.put("544", "COLUMBIA-SC.TEST");
        emailDomainNameMap.put("546", "MIAMI.TEST");
        emailDomainNameMap.put("549", "DALLAS.TEST");
        emailDomainNameMap.put("550", "DANVILLE.TEST");
        emailDomainNameMap.put("552", "DAYTON.TEST");
        emailDomainNameMap.put("553", "DETROIT.TEST");
        emailDomainNameMap.put("554", "DENVER.TEST");
        emailDomainNameMap.put("555", "DES-MOINES.TEST");
        emailDomainNameMap.put("556", "N-CHICAGO.TEST");
        emailDomainNameMap.put("557", "DUBLIN.TEST");
        emailDomainNameMap.put("558", "DURHAM.TEST");
        emailDomainNameMap.put("561", "EAST-ORANGE.TEST");
        emailDomainNameMap.put("562", "ERIE.TEST");
        emailDomainNameMap.put("564", "FAYETTVL-AR.TEST");
        emailDomainNameMap.put("565", "FAYETTVL-NC.TEST");
        emailDomainNameMap.put("566", "FORT-HOWARD.TEST");
        emailDomainNameMap.put("567", "FORT-LYON.TEST");
        emailDomainNameMap.put("568", "BLACK-HILLS.TEST");
        emailDomainNameMap.put("569", "FORT-WAYNE.TEST");
        emailDomainNameMap.put("570", "FRESNO.TEST");
        emailDomainNameMap.put("573", "NORTH-FLORIDA.TEST");
        emailDomainNameMap.put("574", "GRAND-ISLAND.TEST");
        emailDomainNameMap.put("575", "GRAND-JUNCT.TEST");
        emailDomainNameMap.put("578", "HINES.TEST");
        emailDomainNameMap.put("579", "HOT-SPRINGS.TEST");
        emailDomainNameMap.put("580", "HOUSTON.TEST");
        emailDomainNameMap.put("581", "HUNTINGTON.TEST");
        emailDomainNameMap.put("583", "INDIANAPOLIS.TEST");
        emailDomainNameMap.put("584", "IOWA-CITY.TEST");
        emailDomainNameMap.put("585", "IRON-MTN.TEST");
        emailDomainNameMap.put("586", "JACKSON.TEST");
        emailDomainNameMap.put("589", "KANSAS-CITY.TEST");
        emailDomainNameMap.put("590", "HAMPTON.TEST");
        emailDomainNameMap.put("591", "KERRVILLE.TEST");
        emailDomainNameMap.put("594", "LAKE-CITY.TEST");
        emailDomainNameMap.put("595", "LEBANON.TEST");
        emailDomainNameMap.put("596", "LEXINGTON.TEST");
        emailDomainNameMap.put("597", "LINCOLN.TEST");
        emailDomainNameMap.put("598", "LITTLE-ROCK.TEST");
        emailDomainNameMap.put("599", "LIVERMORE.TEST");
        emailDomainNameMap.put("600", "LONG-BEACH.TEST");
        emailDomainNameMap.put("603", "LOUISVILLE.TEST");
        emailDomainNameMap.put("604", "LYONS.TEST");
        emailDomainNameMap.put("605", "LOMA-LINDA.TEST");
        emailDomainNameMap.put("607", "MADISON.TEST");
        emailDomainNameMap.put("608", "MANCHESTER.TEST");
        emailDomainNameMap.put("609", "MARION-IL.TEST");
        emailDomainNameMap.put("610", "NORTHERN-INDIANA.TEST");
        emailDomainNameMap.put("611", "MARLIN.TEST");
        emailDomainNameMap.put("612", "MARTINEZ.TEST");
        emailDomainNameMap.put("613", "MART6.FO-BAYPINES.MED.VA.GOV");
        emailDomainNameMap.put("614", "MEMPHIS.TEST");
        emailDomainNameMap.put("617", "MILES-CITY.TEST");
        emailDomainNameMap.put("618", "MINNEAPOLIS.TEST");
        emailDomainNameMap.put("619", "CENTRAL-ALABAMA.TEST");
        emailDomainNameMap.put("620", "MONTROSE.TEST");
        emailDomainNameMap.put("621", "MTN-HOME.TEST");
        emailDomainNameMap.put("622", "MURFREESBORO.TEST");
        emailDomainNameMap.put("623", "MUSKOGEE.TEST");
        emailDomainNameMap.put("626", "TENNESSEEVALLEY.TEST");
        emailDomainNameMap.put("627", "NEWINGTON.TEST");
        emailDomainNameMap.put("629", "NEW-ORLEANS.TEST");
        emailDomainNameMap.put("630", "NY-HARBOR.TEST");
        emailDomainNameMap.put("631", "NORTHAMPTON.TEST");
        emailDomainNameMap.put("632", "NORTHPORT.TEST");
        emailDomainNameMap.put("635", "OKLAHOMA.TEST");
        emailDomainNameMap.put("636", "CENTRAL-PLAINS.TEST");
        emailDomainNameMap.put("637", "ASHEVILLE.TEST");
        emailDomainNameMap.put("640", "PALO-ALTO.TEST");
        emailDomainNameMap.put("641", "PERRY-POINT.TEST");
        emailDomainNameMap.put("642", "PHILADELPHIA.TEST");
        emailDomainNameMap.put("644", "PHOENIX.TEST");
        emailDomainNameMap.put("645", "PITTS-HGHLND.TEST");
        emailDomainNameMap.put("646", "PITTSBURGH.TEST");
        emailDomainNameMap.put("647", "POPLAR-BLUFF.TEST");
        emailDomainNameMap.put("648", "PORTLAND.TEST");
        emailDomainNameMap.put("649", "PRESCOTT.TEST");
        emailDomainNameMap.put("650", "PROVIDENCE.TEST");
        emailDomainNameMap.put("652", "RICHMOND.TEST");
        emailDomainNameMap.put("653", "ROSEBURG.TEST");
        emailDomainNameMap.put("654", "RENO.TEST");
        emailDomainNameMap.put("655", "SAGINAW.TEST");
        emailDomainNameMap.put("656", "ST-CLOUD.TEST");
        emailDomainNameMap.put("657", "ST-LOUIS.TEST");
        emailDomainNameMap.put("658", "SALEM.TEST");
        emailDomainNameMap.put("659", "SALISBURY.TEST");
        emailDomainNameMap.put("660", "SALT-LAKE.TEST");
        emailDomainNameMap.put("662", "SANFRANCISCO.TEST");
        emailDomainNameMap.put("663", "PUGET-SOUND.TEST");
        emailDomainNameMap.put("664", "SAN-DIEGO.TEST");
        emailDomainNameMap.put("665", "SEPULVEDA.TEST");
        emailDomainNameMap.put("666", "SHERIDAN.TEST");
        emailDomainNameMap.put("667", "SHREVEPORT.TEST");
        emailDomainNameMap.put("668", "SPOKANE.TEST");
        emailDomainNameMap.put("670", "SYRACUSE.TEST");
        emailDomainNameMap.put("671", "SAN-ANTONIO.TEST");
        emailDomainNameMap.put("672", "SAN-JUAN.TEST");
        emailDomainNameMap.put("673", "TAMPA.TEST");
        emailDomainNameMap.put("674", "CENTRAL-TEXAS.TEST");
        emailDomainNameMap.put("676", "TOMAH.TEST");
        emailDomainNameMap.put("677", "TOPEKA.TEST");
        emailDomainNameMap.put("678", "TUCSON.TEST");
        emailDomainNameMap.put("679", "TUSCALOOSA.TEST");
        emailDomainNameMap.put("680", "TUSKEGEE.TEST");
        emailDomainNameMap.put("685", "WACO.TEST");
        emailDomainNameMap.put("686", "LEAVENWORTH.TEST");
        emailDomainNameMap.put("687", "WALLA-WALLA.TEST");
        emailDomainNameMap.put("688", "WASHINGTON.TEST");
        emailDomainNameMap.put("689", "WEST-HAVEN.TEST");
        emailDomainNameMap.put("691", "WEST-LA.TEST");
        emailDomainNameMap.put("692", "WHITE-CITY.TEST");
        emailDomainNameMap.put("693", "WILKES-BARRE.TEST");
        emailDomainNameMap.put("695", "MILWAUKEE.TEST");
        emailDomainNameMap.put("752", "LA-OPC.TEST");
        emailDomainNameMap.put("756", "EL-PASO.TEST");
        emailDomainNameMap.put("757", "COLUMBUS.TEST");
        emailDomainNameMap.put("758", "LAS-VEGAS.TEST");
        emailDomainNameMap.put("954", "VA.GOV");
        emailDomainNameMap.put("555A4", "KNOXVILLE.TEST");
        emailDomainNameMap.put("987", "CHEY6.FO-BAYPINES.MED.VA.GOV");
        emailDomainNameMap.put("988", "DAYT20.FO-BAYPINES.MED.VA.GOV");
        emailDomainNameMap.put("983", "CHYSHR.FO-BAYPINES.MED.VA.GOV");
        emailDomainNameMap.put("984", "DAYTSHR.FO-BAYPINES.MED.VA.GOV");
    }
}

