/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.AssociationService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class AssociationServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements AssociationService {
    private static final long serialVersionUID = 3698633383225444448L;

    @Override
    public Person updateAssociation(Person incoming, Association association) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Validate.notNull((Object)association, (String)"An association must not be null");
        PersonService personService = this.getPersonService();
        Person result = personService.getPerson((PersonEntityKey)incoming.getEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        Association resultAssociation = null;
        EntityKey entityKey = association.getEntityKey();
        if (entityKey != null) {
            resultAssociation = result.getAssociationByEntityKey(entityKey);
        }
        if (entityKey != null && incoming.getAssociationByEntityKey(entityKey) == null) {
            result.removeAssociation(association);
        } else {
            if (entityKey == null || !AbstractEntity.matchesDomainValues((AbstractEntity)association, (AbstractEntity)resultAssociation)) {
                association.setLastUpdateDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
            }
            if (!StringUtils.equals((String)association.getPrimaryPhone(), (String)(resultAssociation == null ? null : resultAssociation.getPrimaryPhone()))) {
                association.setPrimaryPhoneChangeDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
            }
            result = this.getAssociationRuleService().manageAssociation(association, result);
        }
        result = personService.save(result);
        return result;
    }
}

