/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import com.thoughtworks.xstream.XStream;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.persistent.person.ApplicationInProcessDAO;
import gov.va.med.esr.common.persistent.person.EnrollmentApplicationDAO;
import gov.va.med.esr.service.ApplicationInProcessService;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.lob.SerializableClob;

public class ApplicationInProcessServiceImpl
extends AbstractRuleAwareServiceImpl
implements ApplicationInProcessService {
    private static final long serialVersionUID = -5000532063516473278L;
    private ApplicationInProcessDAO applicationInProcessDAO = null;
    private EnrollmentApplicationDAO enrollmentApplicationDAO = null;
    private MessagingService messagingService = null;
    private CommsEmailBulletinService bulletinService = null;

    @Override
    public Person getInProcessPersonByIcn(String shortVPID) throws ServiceException {
        Validate.notNull((Object)shortVPID, (String)"Person VPID cannot be null");
        Person person = null;
        try {
            SerializableClob xml = this.getEnrollmentApplicationDAO().getInProcessPersonXmlByIcn(shortVPID);
            if (xml != null) {
                person = this.deserializeXML(xml);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Cannot get Person In Process by shortVPID: " + shortVPID, (Throwable)e);
        }
        catch (SQLException e) {
            throw new ServiceException("Cannot dezerialize Person in getInProcessPersonByIcn(String shortVPID) by shortVPID: " + shortVPID, (Throwable)e);
        }
        return person;
    }

    @Override
    public Person getCompletedPersonByIcn(String shortVPID) throws ServiceException {
        Validate.notNull((Object)shortVPID, (String)"Person VPID cannot be null");
        Person person = null;
        try {
            person = this.getApplicationInProcessDAO().getCompletedPersonByIcn(shortVPID);
        }
        catch (DAOException e) {
            throw new ServiceException("Cannot get AAP Complete Person by shortVPID: " + shortVPID, (Throwable)e);
        }
        return person;
    }

    @Override
    public EnrollmentApplication getEnrollmentApplicationByIcn(String shortVPID) throws ServiceException {
        Validate.notNull((Object)shortVPID, (String)"Person VPID cannot be null");
        try {
            EnrollmentApplication ea = this.getEnrollmentApplicationDAO().getByIcn(shortVPID);
            if (ea == null || ea.getApplicationInProcess() == null) {
                return null;
            }
            return ea;
        }
        catch (DAOException e) {
            throw new ServiceException("Cannot get Application by shortVPID: " + shortVPID, (Throwable)e);
        }
    }

    @Override
    public ApplicationInProcess getByIcn(String shortVPID) throws ServiceException {
        Validate.notNull((Object)shortVPID, (String)"Person VPID cannot be null");
        try {
            EnrollmentApplication ea = this.getEnrollmentApplicationDAO().getByIcn(shortVPID);
            if (ea == null || ea.getApplicationInProcess() == null) {
                return null;
            }
            return ea.getApplicationInProcess();
        }
        catch (DAOException e) {
            throw new ServiceException("Cannot get Application by shortVPID: " + shortVPID, (Throwable)e);
        }
    }

    @Override
    public List getApplicationStatusesByIcn(String shortVPID) throws ServiceException {
        Validate.notNull((Object)shortVPID, (String)"Person VPID cannot be null");
        ArrayList<ApplicationStatus> statusList = new ArrayList<ApplicationStatus>();
        try {
            List codes = this.getEnrollmentApplicationDAO().getApplicationStatusCodeListByIcn(shortVPID);
            if (codes == null || codes.size() == 0) {
                return statusList;
            }
            Iterator it = codes.iterator();
            while (it.hasNext()) {
                statusList.add(this.getLookupService().getApplicationStatusByCode((String)it.next()));
            }
            return statusList;
        }
        catch (DAOException e) {
            throw new ServiceException("Cannot get Application Statuses by shortVPID: " + shortVPID, (Throwable)e);
        }
    }

    @Override
    public boolean existsRecordWithStatus(List applicationStatusList, ApplicationStatus status) throws ServiceException {
        Validate.notNull((Object)((Object)status), (String)"Application Status cannot be null");
        if (applicationStatusList == null || applicationStatusList.size() == 0) {
            return false;
        }
        String code = status.getCode();
        Iterator it = applicationStatusList.iterator();
        while (it.hasNext()) {
            if (!((ApplicationStatus)((Object)it.next())).getCode().equals(code)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void savePersonInProcess(Person person, ApplicationStatus applicationStatus) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person cannot be null");
        Validate.notNull((Object)((Object)applicationStatus), (String)"applicationStatus cannot be null");
        EnrollmentApplication ea = null;
        ApplicationInProcess aip = null;
        try {
            ea = this.getEnrollmentApplicationByIcn(person.getVPIDEntityKey().getShortVPID());
            if (ea == null) {
                ea = new EnrollmentApplication();
                aip = new ApplicationInProcess();
                this.makeEnrollmentApplication(person, ea, applicationStatus);
                this.makeApplicationInProcess(person, aip);
                aip.setEnrollmentApplication(ea);
                ea.setApplicationInProcess(aip);
            } else {
                aip = ea.getApplicationInProcess();
                this.makeEnrollmentApplication(person, ea, applicationStatus);
                this.makeApplicationInProcess(person, aip);
            }
            this.getEnrollmentApplicationDAO().saveObject((Object)ea);
        }
        catch (DAOException e) {
            throw new ServiceException("Error saving InProcess Person registration.", (Throwable)e);
        }
    }

    @Override
    public boolean isInProcess(Person person) throws ServiceException {
        if (person == null) {
            return false;
        }
        Person inProcessPerson = this.getInProcessPersonByIcn(person.getVPIDEntityKey().getShortVPID());
        return inProcessPerson != null;
    }

    private void makeEnrollmentApplication(Person person, EnrollmentApplication ea, ApplicationStatus applicationStatus) throws ServiceException {
        if (person == null) {
            throw new ServiceException("Save in process received null person object");
        }
        if (ea.getPersonId() == null && person.getPersonEntityKey() != null) {
            ea.setPersonId(new BigDecimal(person.getPersonEntityKey().getKeyValueAsString()));
        }
        PersonIdentityTraits it = person.getIdentityTraits();
        ea.setLastName(it.getLegalName().getFamilyName());
        ea.setFirstName(it.getLegalName().getGivenName());
        ea.setMiddleName(it.getLegalName().getMiddleName());
        String ssnText = it.getSsnText();
        Set ssns = person.getSsns();
        if (ssnText == null && ssns != null) {
            for (SSN ssnObj : ssns) {
                ssnText = ssnObj.getSsnText();
            }
        }
        ea.setSsn(ssnText.replaceAll("-", ""));
        ea.setGender(it.getGender());
        ea.setDateOfBirth(it.getBirthRecord().getBirthDate().getDate());
        ea.setIcn(person.getVPIDEntityKey().getShortVPID());
        ea.setApplicationStatus(applicationStatus);
        ea.setSignatureDate(person.getEnrollmentSignatureDate());
        if (ApplicationStatus.NEW_APPLICATION.getCode().equals(applicationStatus.getCode())) {
            ea.setApplicationDate(new Date(System.currentTimeMillis()));
            ea.setApplicationMethod(this.getLookupService().getApplicationMethodByCode(ApplicationMethod.IN_PERSON.getCode()));
        }
    }

    private void makeApplicationInProcess(Person person, ApplicationInProcess aip) throws ServiceException {
        try {
            aip.setApplicationContentXML(this.serializeXML((Object)person));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private String serializeXML(Object p) {
        String xml = null;
        XStream xstream = new XStream();
        xml = xstream.toXML(p);
        return xml;
    }

    private Person deserializeXML(SerializableClob clob) throws SQLException {
        XStream xstream = new XStream();
        Person p = (Person)((Object)xstream.fromXML(clob.getAsciiStream()));
        return p;
    }

    public ApplicationInProcessDAO getApplicationInProcessDAO() {
        return this.applicationInProcessDAO;
    }

    public void setApplicationInProcessDAO(ApplicationInProcessDAO applicationInProcessDAO) {
        this.applicationInProcessDAO = applicationInProcessDAO;
    }

    public EnrollmentApplicationDAO getEnrollmentApplicationDAO() {
        return this.enrollmentApplicationDAO;
    }

    public void setEnrollmentApplicationDAO(EnrollmentApplicationDAO enrollmentApplicationDAO) {
        this.enrollmentApplicationDAO = enrollmentApplicationDAO;
    }

    @Override
    public Person processCompleteRegistration(Person incoming) throws ServiceException {
        String stationNumber = "200ESR";
        VAFacility sendingFacility = this.getLookupService().getVaFacilityByStationNumber(stationNumber);
        VerificationInfo info = new VerificationInfo();
        WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
        caseInfo.setTransmissionSite(sendingFacility);
        info.setWorkflowCaseInfo(caseInfo);
        this.getPersonService().updateProfileForAAP(incoming);
        FullyQualifiedIdentity identifier = this.getPersonService().addPreferredFacilityCorrelation(incoming);
        if (identifier != null && identifier.getStationNumber() != null) {
            Person onFile = this.getMessagingService().processAddPerson(incoming, sendingFacility, info);
            if (onFile.getEnrollmentDetermination() != null) {
                onFile.setPersonLockedReason(null);
            }
            this.savePersonInProcess(incoming, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.COMPLETE.getCode()));
            this.sendNotifySitePersonAddedBulletin(onFile, identifier.getIdValue(), identifier.getStationNumber());
            return onFile;
        }
        return null;
    }

    private void sendNotifySitePersonAddedBulletin(Person person, String dfn, String stationNumber) {
        try {
            Hashtable<String, String> dataTab = new Hashtable<String, String>();
            dataTab.put("VPID", person.getVPIDEntityKey().getShortVPID());
            dataTab.put("DFN", dfn);
            dataTab.put("STN", stationNumber);
            dataTab.put("SITE NAME", person.getMostRecentPreferredFacility().getFacilityName());
            CommsEmailBulletinService emailSrv = this.getBulletinService();
            emailSrv.sendEmailBulletin(BulletinTrigger.DataType.HEC_NOTIFY_SITE_PERSON_ADDED, dataTab, person);
        }
        catch (ServiceException e) {
            this.logger.error((Object)"InvalidMessageException", (Throwable)e);
        }
    }

    @Override
    public void processAddPersonStubAndSaveInProcess(Person incoming) throws ServiceException {
        this.getPersonService().addESRCorrelation(incoming);
        PersonEntityKey personKey = this.getPersonService().addPersonStub(incoming.getVPIDEntityKey());
        incoming.setIdentifier(personKey.getKeyValue());
        this.savePersonInProcess(incoming, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.NEW_APPLICATION.getCode()));
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    @Override
    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    @Override
    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }
}

