/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.EEResult;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;

public class MigrateEEResultAdvice
extends AbstractComponent
implements MethodInterceptor {
    private EntityCacheManager entityCacheManager;
    private TriggerEventCacheManager triggerEventCacheManager;
    private PersonHelperService personHelperService;
    private String modelPropertiesSetId;

    public Object invoke(MethodInvocation arg0) throws Throwable {
        EEResult result = (EEResult)arg0.proceed();
        if (result.isCalculated()) {
            Person incomingPerson = (Person)this.entityCacheManager.getItem((EntityKey)result.getPersonEntityKey());
            Person resultPerson = result.getUpdatedPerson();
            EnrollmentDetermination incomingEnrollmentDetermation = incomingPerson.getEnrollmentDetermination();
            EnrollmentDetermination resultEnrollmentDetermation = resultPerson.getEnrollmentDetermination();
            ServiceConnectionAward incomingSCA = incomingPerson.getServiceConnectionAward();
            ServiceConnectionAward resultSCA = resultPerson.getServiceConnectionAward();
            if (this.didAbstractEntityChange((AbstractEntity)incomingEnrollmentDetermation, (AbstractEntity)resultEnrollmentDetermation) || this.didAbstractEntityChange((AbstractEntity)incomingSCA, (AbstractEntity)resultSCA) || this.didIncomeTestDataChange(incomingPerson, resultPerson)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("EE data changed for Person: " + result.getPersonEntityKey().getKeyValueAsString()));
                }
                result.setEeChange(true);
                Set triggerEvents = this.triggerEventCacheManager.getTriggerEvents();
                Iterator itr = triggerEvents != null ? triggerEvents.iterator() : null;
                TriggerEvent event = null;
                while (itr != null && itr.hasNext()) {
                    event = (TriggerEvent)itr.next();
                    if (event instanceof BulletinTriggerEvent) {
                        result.addBulletinTriggerEvent((BulletinTriggerEvent)event);
                        continue;
                    }
                    if (event instanceof LetterTriggerEvent) {
                        result.addLetterTriggerEvent((LetterTriggerEvent)event);
                        continue;
                    }
                    if (!(event instanceof PersonTriggerEvent)) continue;
                    result.addHL7MessageTriggerEvent((PersonTriggerEvent)event);
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("EE data did NOT change for Person: " + result.getPersonEntityKey().getKeyValueAsString()));
                }
                this.triggerEventCacheManager.removeTriggerEvents();
                result.setEeChange(false);
            }
        }
        return result;
    }

    private boolean didAbstractEntityChange(AbstractEntity incoming, AbstractEntity result) {
        boolean changed = false;
        if (incoming == null && result != null) {
            changed = true;
        } else if (incoming != null && !incoming.isModelPropertiesEqual((Object)result, this.modelPropertiesSetId)) {
            changed = true;
        }
        if (changed && this.logger.isInfoEnabled()) {
            this.logger.info((Object)("EE data changed for class: " + result.getClass().getName()));
        }
        return changed;
    }

    private boolean didIncomeTestDataChange(Person incoming, Person result) {
        boolean changed = false;
        IncomeTest incomingCurrentIncomeTest = this.personHelperService.getCurrentIncomeTest(incoming);
        IncomeTest resultCurrentIncomeTest = this.personHelperService.getCurrentIncomeTest(result);
        if (incomingCurrentIncomeTest != null && resultCurrentIncomeTest == null || incomingCurrentIncomeTest == null && resultCurrentIncomeTest != null) {
            changed = true;
        }
        if (!changed && incomingCurrentIncomeTest != null && resultCurrentIncomeTest != null) {
            if (!incomingCurrentIncomeTest.getType().equals((Object)resultCurrentIncomeTest.getType())) {
                changed = true;
            } else {
                IncomeTestStatus incomingCopayExemptionStatus = incomingCurrentIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
                IncomeTestStatus incomingMeansTestStatus = incomingCurrentIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST);
                IncomeTestStatus resultCopayExemptionStatus = resultCurrentIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
                IncomeTestStatus resultMeansTestStatus = resultCurrentIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST);
                if (incomingCopayExemptionStatus != null && resultCopayExemptionStatus != null) {
                    if (incomingCopayExemptionStatus != null && resultCopayExemptionStatus == null || incomingCopayExemptionStatus == null && resultCopayExemptionStatus != null) {
                        changed = true;
                    } else if (!incomingCopayExemptionStatus.equals((Object)resultCopayExemptionStatus)) {
                        changed = true;
                    }
                }
                if (!changed && incomingMeansTestStatus != null && resultMeansTestStatus != null) {
                    if (incomingMeansTestStatus != null && resultMeansTestStatus == null || incomingMeansTestStatus == null && resultMeansTestStatus != null) {
                        changed = true;
                    } else if (!incomingMeansTestStatus.equals((Object)resultMeansTestStatus)) {
                        changed = true;
                    }
                }
            }
        }
        if (changed && this.logger.isInfoEnabled()) {
            this.logger.info((Object)"EE data changed for IncomeTest data");
        }
        return changed;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.entityCacheManager, (String)"entityCacheManager is required");
        Validate.notNull((Object)this.triggerEventCacheManager, (String)"triggerEventCacheManager is required");
        Validate.notNull((Object)this.personHelperService, (String)"personHelperService is required");
        Validate.notNull((Object)this.modelPropertiesSetId, (String)"modelPropertiesSetId is required");
    }

    public String getModelPropertiesSetId() {
        return this.modelPropertiesSetId;
    }

    public void setModelPropertiesSetId(String modelPropertiesSetId) {
        this.modelPropertiesSetId = modelPropertiesSetId;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }
}

