/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class EEResult
implements Serializable {
    private static final long serialVersionUID = 9093716638244007955L;
    private PersonEntityKey personEntityKey;
    private Person incomingPerson;
    private Person updatedPerson;
    private Set triggerEventsForHL7Messages;
    private Set triggerEventsForBulletins;
    private Set triggerEventsForLetters;
    private boolean eeChange;
    private boolean calculated;

    public EEResult(PersonEntityKey personEntityKey) {
        this.personEntityKey = personEntityKey;
    }

    public EEResult(Person updatedPerson) {
        this(null, updatedPerson);
    }

    public EEResult(Person incomingPerson, Person updatedPerson) {
        this.incomingPerson = incomingPerson;
        this.setUpdatedPerson(updatedPerson);
    }

    public Person getIncomingPerson() {
        return this.incomingPerson;
    }

    public void setIncomingPerson(Person incomingPerson) {
        this.incomingPerson = incomingPerson;
    }

    public Person getUpdatedPerson() {
        return this.updatedPerson;
    }

    public void setUpdatedPerson(Person updatedPerson) {
        this.updatedPerson = updatedPerson;
        if (updatedPerson != null) {
            this.personEntityKey = updatedPerson.getPersonEntityKey();
            this.calculated = true;
        }
    }

    public Set getTriggerEventsForBulletins() {
        return this.triggerEventsForBulletins;
    }

    public void setTriggerEventsForBulletins(Set triggerEventsForBulletins) {
        this.triggerEventsForBulletins = triggerEventsForBulletins;
    }

    public void addBulletinTriggerEvent(BulletinTriggerEvent event) {
        if (this.triggerEventsForBulletins == null) {
            this.triggerEventsForBulletins = new HashSet();
        }
        this.triggerEventsForBulletins.add(event);
    }

    public Set getTriggerEventsForLetters() {
        return this.triggerEventsForLetters;
    }

    public void setTriggerEventsForLetters(Set triggerEventsForLetters) {
        this.triggerEventsForLetters = triggerEventsForLetters;
    }

    public void addLetterTriggerEvent(LetterTriggerEvent event) {
        if (this.triggerEventsForLetters == null) {
            this.triggerEventsForLetters = new HashSet();
        }
        this.triggerEventsForLetters.add(event);
    }

    public Set getTriggerEventsForHL7Messages() {
        return this.triggerEventsForHL7Messages;
    }

    public void setTriggerEventsForHL7Messages(Set triggerEventsForHL7Messages) {
        this.triggerEventsForHL7Messages = triggerEventsForHL7Messages;
    }

    public void addHL7MessageTriggerEvent(PersonTriggerEvent event) {
        if (this.triggerEventsForHL7Messages == null) {
            this.triggerEventsForHL7Messages = new HashSet();
        }
        this.triggerEventsForHL7Messages.add(event);
    }

    public boolean isEeChange() {
        return this.eeChange;
    }

    public void setEeChange(boolean eeChange) {
        this.eeChange = eeChange;
    }

    public PersonEntityKey getPersonEntityKey() {
        return this.personEntityKey;
    }

    public void setPersonEntityKey(PersonEntityKey personEntityKey) {
        this.personEntityKey = personEntityKey;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }
}

