/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.util.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class MailingAddressHelper {
    private static Hashtable addrPriorityTab = new Hashtable();

    private static int getAddressPriority(String addrTypeCode) {
        if (addrTypeCode == null || addrTypeCode.length() == 0) {
            return 0;
        }
        Integer priority = (Integer)addrPriorityTab.get(addrTypeCode);
        return priority == null ? 0 : priority;
    }

    private static boolean isAddressValid(Address addr, Date today) {
        boolean validAddress = false;
        if (addr != null) {
            if (addr.isPermanent()) {
                if (addr.getBadAddressReason() == null || addr.getNcoaInvalidUndeliverableDate() == null || DateUtils.isEqualOrAfterIgnoreTime((Date)addr.getNcoaInvalidUndeliverableDate(), (Date)today)) {
                    validAddress = true;
                }
            } else {
                boolean validStartDate = false;
                boolean validEndDate = false;
                if (addr.getStartDate() == null || DateUtils.isEqualOrBeforeIgnoreTime((Date)ImpreciseDateUtils.getDateWithDefault(addr.getStartDate()), (Date)today)) {
                    validStartDate = true;
                }
                if (addr.getEndDate() == null || DateUtils.isEqualOrAfterIgnoreTime((Date)ImpreciseDateUtils.getDateWithDefault(addr.getEndDate()), (Date)today)) {
                    validEndDate = true;
                }
                validAddress = validStartDate && validEndDate;
            }
        }
        return validAddress;
    }

    public static Address selectAddressForMailing(Collection addresses) {
        if (addresses == null || addresses.size() == 0) {
            return null;
        }
        int currPriority = 0;
        int priority = 0;
        Address addr = null;
        Address addrToMail = null;
        Iterator iter = addresses.iterator();
        Date today = DateUtils.getCurrentDate();
        while (iter.hasNext()) {
            addr = (Address)iter.next();
            if (!MailingAddressHelper.isAddressValid(addr, today)) continue;
            if (addr != null && addr.getType() != null) {
                priority = MailingAddressHelper.getAddressPriority(addr.getType().getCode());
            }
            Person person = addr.getPerson();
            if (priority == (Integer)addrPriorityTab.get(AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode()) && !MailingAddressHelper.isConfAddrCategoriesContainsCategoryType(person, ConfidentialAddressCategoryType.CODE_ELIGIBILITY_ENROLLMENT.getCode())) {
                priority = 0;
            }
            if (priority <= currPriority) continue;
            addrToMail = addr;
            currPriority = priority;
        }
        return addrToMail;
    }

    private static boolean isConfAddrCategoriesContainsCategoryType(Person person, String confAddrType) {
        Set categoriesSource = person.getConfidentialAddressCategories();
        ConfidentialAddressCategory confAddrCat2 = null;
        for (ConfidentialAddressCategory confAddrCat2 : categoriesSource) {
            if (!confAddrCat2.getType().getCode().equals(confAddrType)) continue;
            return true;
        }
        return false;
    }

    public static Address selectAddressForMailing(Collection confidentialAddressCategories, Collection addresses) {
        if (addresses == null || addresses.size() == 0) {
            return null;
        }
        int currPriority = 0;
        int priority = 0;
        Address addr = null;
        Address addrToMail = null;
        Iterator iter = addresses.iterator();
        Date today = DateUtils.getCurrentDate();
        while (iter.hasNext()) {
            addr = (Address)iter.next();
            if (!MailingAddressHelper.isAddressValid(addr, today)) continue;
            priority = MailingAddressHelper.getAddressPriority(addr.getType().getCode());
            if (priority == (Integer)addrPriorityTab.get(AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode()) && !MailingAddressHelper.isConfAddrCategoriesContainsCategoryType(confidentialAddressCategories, ConfidentialAddressCategoryType.CODE_ELIGIBILITY_ENROLLMENT.getCode())) {
                priority = 0;
            }
            if (priority <= currPriority) continue;
            addrToMail = addr;
            currPriority = priority;
        }
        return addrToMail;
    }

    private static boolean isConfAddrCategoriesContainsCategoryType(Collection confidentialAddressCategoryList, String confAddrType) {
        if (confidentialAddressCategoryList == null || confidentialAddressCategoryList.size() == 0) {
            return false;
        }
        ConfidentialAddressCategory confAddrCat2 = null;
        for (ConfidentialAddressCategory confAddrCat2 : confidentialAddressCategoryList) {
            if (!confAddrCat2.getType().getCode().equals(confAddrType)) continue;
            return true;
        }
        return false;
    }

    static {
        addrPriorityTab.put(AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode(), new Integer(3));
        addrPriorityTab.put(AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getCode(), new Integer(2));
        addrPriorityTab.put(AddressType.CODE_PERMANENT_ADDRESS.getCode(), new Integer(1));
    }
}

