/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.ui.form;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.ui.form.FinancialDetailsData;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class FinancialDetailsForm
extends AbstractForm
implements Serializable {
    private static final long serialVersionUID = 480341561224445687L;
    private FinancialDetailsData financialsData = null;
    private Person person = null;
    private boolean allowedToAddFinancials = true;
    private boolean allowedToEditFinancials = true;
    private boolean allowedToUpdateNetWorth = true;
    private Boolean btFinancialInd = Boolean.TRUE;
    private List spouseFinacialsId;
    private List spouseSSN;
    private List spouseDisplaySSN;
    private List spouseRelationshipCode;
    private List spouseRelationship;
    private List spouseGenderCode;
    private List spouseGender;
    private List spouseName;
    private List spouseValid;
    private List spouseInactiveDate;
    private List spouseLivedWithPatient;
    private List spouseContributedToSupport;
    private List spouseMarriageDate;
    private List spouseTotalIncome;
    private List spouseIncomeFromRanch;
    private List spouseOtherIncome;
    private List spouseEduExpenses;
    private List spouseCashAsset;
    private List spouseRealAsset;
    private List spouseOtherAsset;
    private List spouseStocksAsset;
    private List spouseUSCivilServiceIncome;
    private List spouseInterestDividentAnuityIncome;
    private List spouseUnemploymentIncome;
    private List spouseSocialSecurityIncome;
    private List spouseMilitaryRetirementIncome;
    private List spouseRailroadRetirementIncome;
    private List spouseOtherRetirementIncome;
    private List spouseWorkersCompIncome;
    private List spouseFinacialsHashCode;
    private List spouseDebt;
    private List spouseActive;
    private List contributedToSpousalSupport;

    public FinancialDetailsForm() {
        this.initialize();
    }

    public FinancialDetailsData getFinancialsData() {
        return this.financialsData;
    }

    public void setFinancialsData(FinancialDetailsData finData) {
        this.financialsData = finData;
    }

    public boolean getAllowedToAddFinancials() {
        return this.allowedToAddFinancials;
    }

    public void setAllowedToAddFinancials(boolean allowedToAddFinancials) {
        this.allowedToAddFinancials = allowedToAddFinancials;
    }

    public boolean getAllowedToEditFinancials() {
        return this.allowedToEditFinancials;
    }

    public void setAllowedToEditFinancials(boolean allowedToEditFinancials) {
        this.allowedToEditFinancials = allowedToEditFinancials;
    }

    public boolean isAllowedToUpdateNetWorth() {
        return this.allowedToUpdateNetWorth;
    }

    public void setAllowedToUpdateNetWorth(boolean allowedToUpdateNetWorth) {
        this.allowedToUpdateNetWorth = allowedToUpdateNetWorth;
    }

    public Person getPerson() {
        return (Person)this.getVO();
    }

    protected AbstractEntity createValueObject() {
        return new Person();
    }

    public boolean getPost2005formatInd() {
        return this.financialsData.getPost2005formatInd();
    }

    public void setPost2005formatInd(boolean post2005formatInd) {
        this.financialsData.setPost2005formatInd(post2005formatInd);
    }

    public String getAgreeToPayDeductible() {
        return this.financialsData.getAgreeToPayDeductible();
    }

    public void setAgreeToPayDeductible(String agreeToPayDeductible) {
        this.financialsData.setAgreeToPayDeductible(agreeToPayDeductible);
    }

    public String getDiscloseFinIncome() {
        return this.financialsData.getDiscloseFinIncome();
    }

    public void setDiscloseFinIncome(String discloseFinIncome) {
        this.financialsData.setDiscloseFinIncome(discloseFinIncome);
    }

    public boolean getAskAdjudicationQuestion() {
        return this.financialsData.getAskAdjudicationQuestion();
    }

    public void setAskAdjudicationQuestion(boolean askAdjudicationQuestion) {
        this.financialsData.setAskAdjudicationQuestion(askAdjudicationQuestion);
    }

    public String getSendForAdjudication() {
        return this.financialsData.getSendForAdjudication();
    }

    public void setSendForAdjudication(String sendForAdjudication) {
        this.financialsData.setSendForAdjudication(sendForAdjudication);
    }

    public String getIncomeYear() {
        return this.financialsData.getIncomeYear();
    }

    public void setIncomeYear(String incomeYear) {
        this.financialsData.setIncomeYear(incomeYear);
    }

    public String getMarriedLastCalendarYear() {
        return this.financialsData.getMarriedLastCalendarYear();
    }

    public void setMarriedLastCalendarYear(String marriedLastCalendarYear) {
        this.financialsData.setMarriedLastCalendarYear(marriedLastCalendarYear);
    }

    public String getTestEffDate() {
        return this.financialsData.getTestEffDate();
    }

    public void setTestEffDate(String testEffDate) {
        this.financialsData.setTestEffDate(testEffDate);
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public boolean getNewIncomeTestInd() {
        return this.financialsData.getNewIncomeTestInd();
    }

    public void setNewIncomeTestInd(boolean isNewIncomeTest) {
        this.financialsData.setNewIncomeTestInd(isNewIncomeTest);
    }

    public boolean getIncomeTestAvaliableInd() {
        return this.financialsData.getIncomeTestAvaliableInd();
    }

    public void setIncomeTestAvaliableInd(boolean incomeTestAvaliableInd) {
        this.financialsData.setIncomeTestAvaliableInd(incomeTestAvaliableInd);
    }

    public String getSourceOfTest() {
        return this.financialsData.getSourceOfTest();
    }

    public void setSourceOfTest(String sourceOfTest) {
        this.financialsData.setSourceOfTest(sourceOfTest);
    }

    public String getCashAndBankAccountAsset() {
        return this.financialsData.getCashAndBankAccountAsset();
    }

    public void setCashAndBankAccountAsset(String cashAndBankAccountAsset) {
        this.financialsData.setCashAndBankAccountAsset(cashAndBankAccountAsset);
    }

    public String getAdjustedMedicalExpense() {
        return this.financialsData.getAdjustedMedicalExpense();
    }

    public void setAdjustedMedicalExpense(String adjustedMedicalExpense) {
        this.financialsData.setAdjustedMedicalExpense(adjustedMedicalExpense);
    }

    public List getDependentInfoList() {
        return this.financialsData.getDependentInfoList();
    }

    public void setDependentInfoList(List dependentInfoList) {
        this.financialsData.setDependentInfoList(dependentInfoList);
    }

    public String getEducationExpense() {
        return this.financialsData.getEducationExpense();
    }

    public void setEducationExpense(String educationExpense) {
        this.financialsData.setEducationExpense(educationExpense);
    }

    public String getNetIncomeFromFarmRanchOrBusiness() {
        return this.financialsData.getNetIncomeFromFarmRanchOrBusiness();
    }

    public void setNetIncomeFromFarmRanchOrBusiness(String netIncomeFromFarmRanchOrBusiness) {
        this.financialsData.setNetIncomeFromFarmRanchOrBusiness(netIncomeFromFarmRanchOrBusiness);
    }

    public String getOtherIncome() {
        return this.financialsData.getOtherIncome();
    }

    public void setOtherIncome(String otherIncome) {
        this.financialsData.setOtherIncome(otherIncome);
    }

    public String getOtherPropertyAsset() {
        return this.financialsData.getOtherPropertyAsset();
    }

    public void setOtherPropertyAsset(String otherPropertyAsset) {
        this.financialsData.setOtherPropertyAsset(otherPropertyAsset);
    }

    public String getRealPropertyAsset() {
        return this.financialsData.getRealPropertyAsset();
    }

    public void setRealPropertyAsset(String realPropertyAsset) {
        this.financialsData.setRealPropertyAsset(realPropertyAsset);
    }

    public String getStocksAsset() {
        return this.financialsData.getStocksAsset();
    }

    public void setStocksAsset(String stocksAsset) {
        this.financialsData.setStocksAsset(stocksAsset);
    }

    public String getDebt() {
        return this.financialsData.getDebt();
    }

    public void setDebt(String debt) {
        this.financialsData.setDebt(debt);
    }

    public String getInterestDividentAnuityIncome() {
        return this.financialsData.getInterestDividentAnuityIncome();
    }

    public void setInterestDividentAnuityIncome(String interestDividentAnuityIncome) {
        this.financialsData.setInterestDividentAnuityIncome(interestDividentAnuityIncome);
    }

    public String getMilitaryRetirementIncome() {
        return this.financialsData.getMilitaryRetirementIncome();
    }

    public void setMilitaryRetirementIncome(String militaryRetirementIncome) {
        this.financialsData.setMilitaryRetirementIncome(militaryRetirementIncome);
    }

    public String getOtherRetirementIncome() {
        return this.financialsData.getOtherRetirementIncome();
    }

    public void setOtherRetirementIncome(String otherRetirementIncome) {
        this.financialsData.setOtherRetirementIncome(otherRetirementIncome);
    }

    public String getRailroadRetirementIncome() {
        return this.financialsData.getRailroadRetirementIncome();
    }

    public void setRailroadRetirementIncome(String railroadRetirementIncome) {
        this.financialsData.setRailroadRetirementIncome(railroadRetirementIncome);
    }

    public String getSocialSecurityIncome() {
        return this.financialsData.getSocialSecurityIncome();
    }

    public void setSocialSecurityIncome(String socialSecurityIncome) {
        this.financialsData.setSocialSecurityIncome(socialSecurityIncome);
    }

    public String getUnemploymentIncome() {
        return this.financialsData.getUnemploymentIncome();
    }

    public void setUnemploymentIncome(String unemploymentIncome) {
        this.financialsData.setUnemploymentIncome(unemploymentIncome);
    }

    public String getUSCivilServiceIncome() {
        return this.financialsData.getUSCivilServiceIncome();
    }

    public void setUSCivilServiceIncome(String civilServiceIncome) {
        this.financialsData.setUSCivilServiceIncome(civilServiceIncome);
    }

    public String getWorkersCompIncome() {
        return this.financialsData.getWorkersCompIncome();
    }

    public void setWorkersCompIncome(String workersCompIncome) {
        this.financialsData.setWorkersCompIncome(workersCompIncome);
    }

    public SpouseFinancialInfoBean getSpouseInfo() {
        return this.financialsData.getSpouseInfo();
    }

    public void setSpouseInfo(SpouseFinancialInfoBean spouseInfo) {
        this.financialsData.setSpouseInfo(spouseInfo);
    }

    public String getTotalEmploymentIncome() {
        return this.financialsData.getTotalEmploymentIncome();
    }

    public void setTotalEmploymentIncome(String totalIncome) {
        this.financialsData.setTotalEmploymentIncome(totalIncome);
    }

    public String getName() {
        return this.financialsData.getName();
    }

    public void setName(String name) {
        this.financialsData.setName(name);
    }

    public String getFuneralBurialExpense() {
        return this.financialsData.getFuneralBurialExpense();
    }

    public void setFuneralBurialExpense(String funeralBurialExpense) {
        this.financialsData.setFuneralBurialExpense(funeralBurialExpense);
    }

    public String getNonReimbMedicalExpense() {
        return this.financialsData.getNonReimbMedicalExpense();
    }

    public void setNonReimbMedicalExpense(String nonReimbMedicalExpense) {
        this.financialsData.setNonReimbMedicalExpense(nonReimbMedicalExpense);
    }

    public String getDisplayName() {
        return this.financialsData.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.financialsData.setDisplayName(displayName);
    }

    public String getDepSSN(int index) {
        return this.financialsData.getDepSSN(index);
    }

    public void setDepSSN(int index, String ssn) {
        this.financialsData.setDepSSN(index, ssn);
    }

    public String getDepRelationshipCode(int index) {
        return this.financialsData.getDepRelationshipCode(index);
    }

    public void setDepRelationshipCode(int index, String relationshipCode) {
        this.financialsData.setDepRelationshipCode(index, relationshipCode);
    }

    public String getDepRelationship(int index) {
        return this.financialsData.getDepRelationship(index);
    }

    public void setDepRelationship(int index, String relationship) {
        this.financialsData.setDepRelationship(index, relationship);
    }

    public String getDepGenderCode(int index) {
        return this.financialsData.getDepGenderCode(index);
    }

    public void setDepGenderCode(int index, String gender) {
        this.financialsData.setDepGenderCode(index, gender);
    }

    public String getDepGender(int index) {
        return this.financialsData.getDepGender(index);
    }

    public void setDepGender(int index, String gender) {
        this.financialsData.setDepGender(index, gender);
    }

    public String getDepAmtContributed(int index) {
        return this.financialsData.getDepAmtContributed(index);
    }

    public void setDepAmtContributed(int index, String depAmtContributed) {
        this.financialsData.setDepAmtContributed(index, depAmtContributed);
    }

    public String getDepAttendedSchool(int index) {
        return this.financialsData.getDepAttendedSchool(index);
    }

    public void setDepAttendedSchool(int index, String depAttendedSchool) {
        this.financialsData.setDepAttendedSchool(index, depAttendedSchool);
    }

    public String getDepCashAsset(int index) {
        return this.financialsData.getDepCashAsset(index);
    }

    public void setDepCashAsset(int index, String depCashAsset) {
        this.financialsData.setDepCashAsset(index, depCashAsset);
    }

    public String getDepContributedToSupport(int index) {
        return this.financialsData.getDepContributedToSupport(index);
    }

    public void setDepContributedToSupport(int index, String depContributedToSupport) {
        this.financialsData.setDepContributedToSupport(index, depContributedToSupport);
    }

    public String getDepStocksAsset(int index) {
        return this.financialsData.getDepStocksAsset(index);
    }

    public void setDepStocksAsset(int index, String depStocksAsset) {
        this.financialsData.setDepStocksAsset(index, depStocksAsset);
    }

    public String getDepName(int index) {
        return this.financialsData.getDepName(index);
    }

    public void setDepName(int index, String depDisplayName) {
        this.financialsData.setDepName(index, depDisplayName);
    }

    public String getDepEduExpenses(int index) {
        return this.financialsData.getDepEduExpenses(index);
    }

    public void setDepEduExpenses(int index, String depEduExpenses) {
        this.financialsData.setDepEduExpenses(index, depEduExpenses);
    }

    public String getDepEffectiveDate(int index) {
        return this.financialsData.getDepEffectiveDate(index);
    }

    public void setDepEffectiveDate(int index, String depEffectiveDate) {
        this.financialsData.setDepEffectiveDate(index, depEffectiveDate);
    }

    public String getDepFinacialsId(int index) {
        return this.financialsData.getDepFinacialsId(index);
    }

    public void setDepFinacialsId(int index, String depFinacialsId) {
        this.financialsData.setDepFinacialsId(index, depFinacialsId);
    }

    public String getDepHasIncome(int index) {
        return this.financialsData.getDepHasIncome(index);
    }

    public void setDepHasIncome(int index, String depHasIncome) {
        this.financialsData.setDepHasIncome(index, depHasIncome);
    }

    public String getDepInactiveDate(int index) {
        return this.financialsData.getDepInactiveDate(index);
    }

    public void setDepInactiveDate(int index, String depInactiveDate) {
        this.financialsData.setDepInactiveDate(index, depInactiveDate);
    }

    public String getDepIncapableOfSelfSupport(int index) {
        return this.financialsData.getDepIncapableOfSelfSupport(index);
    }

    public void setDepIncapableOfSelfSupport(int index, String depIncapableOfSelfSupport) {
        this.financialsData.setDepIncapableOfSelfSupport(index, depIncapableOfSelfSupport);
    }

    public String getDepIncomeAvailableToPatient(int index) {
        return this.financialsData.getDepIncomeAvailableToPatient(index);
    }

    public void setDepIncomeAvailableToPatient(int index, String depIncomeAvailableToPatient) {
        this.financialsData.setDepIncomeAvailableToPatient(index, depIncomeAvailableToPatient);
    }

    public String getDepIncomeFromRanch(int index) {
        return this.financialsData.getDepIncomeFromRanch(index);
    }

    public void setDepIncomeFromRanch(int index, String depIncomeFromRanch) {
        this.financialsData.setDepIncomeFromRanch(index, depIncomeFromRanch);
    }

    public String getDepLivedWithPatient(int index) {
        return this.financialsData.getDepLivedWithPatient(index);
    }

    public void setDepLivedWithPatient(int index, String depLivedWithPatient) {
        this.financialsData.setDepLivedWithPatient(index, depLivedWithPatient);
    }

    public String getDepOtherAsset(int index) {
        return this.financialsData.getDepOtherAsset(index);
    }

    public void setDepOtherAsset(int index, String depOtherAsset) {
        this.financialsData.setDepOtherAsset(index, depOtherAsset);
    }

    public String getDepOtherIncome(int index) {
        return this.financialsData.getDepOtherIncome(index);
    }

    public void setDepOtherIncome(int index, String depOtherIncome) {
        this.financialsData.setDepOtherIncome(index, depOtherIncome);
    }

    public String getDepRealAsset(int index) {
        return this.financialsData.getDepRealAsset(index);
    }

    public void setDepRealAsset(int index, String depRealAsset) {
        this.financialsData.setDepRealAsset(index, depRealAsset);
    }

    public String getDepTotalIncome(int index) {
        return this.financialsData.getDepTotalIncome(index);
    }

    public void setDepTotalIncome(int index, String depTotalIncome) {
        this.financialsData.setDepTotalIncome(index, depTotalIncome);
    }

    public String getDepValid(int index) {
        return this.financialsData.getDepValid(index);
    }

    public void setDepValid(int index, String depValid) {
        this.financialsData.setDepValid(index, depValid);
    }

    public String getDepInterestDividentAnuityIncome(int index) {
        return this.financialsData.getDepInterestDividentAnuityIncome(index);
    }

    public void setDepInterestDividentAnuityIncome(int index, String depInterestDividentAnuityIncome) {
        this.financialsData.setDepInterestDividentAnuityIncome(index, depInterestDividentAnuityIncome);
    }

    public String getDepMilitaryRetirementIncome(int index) {
        return this.financialsData.getDepMilitaryRetirementIncome(index);
    }

    public void setDepMilitaryRetirementIncome(int index, String depMilitaryRetirementIncome) {
        this.financialsData.setDepMilitaryRetirementIncome(index, depMilitaryRetirementIncome);
    }

    public String getDepOtherRetirementIncome(int index) {
        return this.financialsData.getDepOtherRetirementIncome(index);
    }

    public void setDepOtherRetirementIncome(int index, String depOtherRetirementIncome) {
        this.financialsData.setDepOtherRetirementIncome(index, depOtherRetirementIncome);
    }

    public String getDepRailroadRetirementIncome(int index) {
        return this.financialsData.getDepRailroadRetirementIncome(index);
    }

    public void setDepRailroadRetirementIncome(int index, String depRailroadRetirementIncome) {
        this.financialsData.setDepRailroadRetirementIncome(index, depRailroadRetirementIncome);
    }

    public String getDepSocialSecurityIncome(int index) {
        return this.financialsData.getDepSocialSecurityIncome(index);
    }

    public void setDepSocialSecurityIncome(int index, String depSocialSecurityIncome) {
        this.financialsData.setDepSocialSecurityIncome(index, depSocialSecurityIncome);
    }

    public String getDepUnemploymentIncome(int index) {
        return this.financialsData.getDepUnemploymentIncome(index);
    }

    public void setDepUnemploymentIncome(int index, String depUnemploymentIncome) {
        this.financialsData.setDepUnemploymentIncome(index, depUnemploymentIncome);
    }

    public String getDepUSCivilServiceIncome(int index) {
        return this.financialsData.getDepUSCivilServiceIncome(index);
    }

    public void setDepUSCivilServiceIncome(int index, String depUSCivilServiceIncome) {
        this.financialsData.setDepUSCivilServiceIncome(index, depUSCivilServiceIncome);
    }

    public String getDepWorkersCompIncome(int index) {
        return this.financialsData.getDepWorkersCompIncome(index);
    }

    public void setDepWorkersCompIncome(int index, String depWorkersCompIncome) {
        this.financialsData.setDepWorkersCompIncome(index, depWorkersCompIncome);
    }

    public String getDepDisplaySSN(int index) {
        return this.financialsData.getDepDisplaySSN(index);
    }

    public void setDepDisplaySSN(int index, String depDisplaySSN) {
        this.financialsData.setDepDisplaySSN(index, depDisplaySSN);
    }

    public List getDepAmtContributedList() {
        return this.financialsData.getDepAmtContributedList();
    }

    public void setDepAmtContributedList(List depAmtContributedList) {
        this.financialsData.setDepAmtContributedList(depAmtContributedList);
    }

    public List getDepAttendedSchoolList() {
        return this.financialsData.getDepAttendedSchoolList();
    }

    public void setDepAttendedSchoolList(List depAttendedSchoolList) {
        this.financialsData.setDepAttendedSchoolList(depAttendedSchoolList);
    }

    public List getDepCashAssetList() {
        return this.financialsData.getDepCashAssetList();
    }

    public void setDepCashAssetList(List depCashAssetList) {
        this.financialsData.setDepCashAssetList(depCashAssetList);
    }

    public List getDepContributedToSupportList() {
        return this.financialsData.getDepContributedToSupportList();
    }

    public void setDepContributedToSupportList(List depContributedToSupportList) {
        this.financialsData.setDepContributedToSupportList(depContributedToSupportList);
    }

    public List getDepStocksAssetList() {
        return this.financialsData.getDepStocksAssetList();
    }

    public void setDepStocksAssetList(List depStocksList) {
        this.financialsData.setDepStocksAssetList(depStocksList);
    }

    public List getDepNameList() {
        return this.financialsData.getDepNameList();
    }

    public void setDepNameList(List depDisplayNameList) {
        this.financialsData.setDepNameList(depDisplayNameList);
    }

    public List getDepEduExpensesList() {
        return this.financialsData.getDepEduExpensesList();
    }

    public void setDepEduExpensesList(List depEduExpensesList) {
        this.financialsData.setDepEduExpensesList(depEduExpensesList);
    }

    public List getDepEffectiveDateList() {
        return this.financialsData.getDepEffectiveDateList();
    }

    public void setDepEffectiveDateList(List depEffectiveDateList) {
        this.financialsData.setDepEffectiveDateList(depEffectiveDateList);
    }

    public List getDepFinacialsIdList() {
        return this.financialsData.getDepFinacialsIdList();
    }

    public void setDepFinacialsIdList(List depFinacialsIdList) {
        this.financialsData.setDepFinacialsIdList(depFinacialsIdList);
    }

    public List getDepHasIncomeList() {
        return this.financialsData.getDepHasIncomeList();
    }

    public void setDepHasIncomeList(List depHasIncomeList) {
        this.financialsData.setDepHasIncomeList(depHasIncomeList);
    }

    public List getDepInactiveDateList() {
        return this.financialsData.getDepInactiveDateList();
    }

    public void setDepInactiveDateList(List depInactiveDateList) {
        this.financialsData.setDepInactiveDateList(depInactiveDateList);
    }

    public List getDepIncapableOfSelfSupportList() {
        return this.financialsData.getDepIncapableOfSelfSupportList();
    }

    public void setDepIncapableOfSelfSupportList(List depIncapableOfSelfSupportList) {
        this.financialsData.setDepIncapableOfSelfSupportList(depIncapableOfSelfSupportList);
    }

    public List getDepIncomeAvailableToPatientList() {
        return this.financialsData.getDepIncomeAvailableToPatientList();
    }

    public void setDepIncomeAvailableToPatientList(List depIncomeAvailableToPatientList) {
        this.financialsData.setDepIncomeAvailableToPatientList(depIncomeAvailableToPatientList);
    }

    public List getDepIncomeFromRanchList() {
        return this.financialsData.getDepIncomeFromRanchList();
    }

    public void setDepIncomeFromRanchList(List depIncomeFromRanchList) {
        this.financialsData.setDepIncomeFromRanchList(depIncomeFromRanchList);
    }

    public List getDepLivedWithPatientList() {
        return this.financialsData.getDepLivedWithPatientList();
    }

    public void setDepLivedWithPatientList(List depLivedWithPatientList) {
        this.financialsData.setDepLivedWithPatientList(depLivedWithPatientList);
    }

    public List getDepOtherAssetList() {
        return this.financialsData.getDepOtherAssetList();
    }

    public void setDepOtherAssetList(List depOtherAssetList) {
        this.financialsData.setDepOtherAssetList(depOtherAssetList);
    }

    public List getDepOtherIncomeList() {
        return this.financialsData.getDepOtherIncomeList();
    }

    public void setDepOtherIncomeList(List depOtherIncomeList) {
        this.financialsData.setDepOtherIncomeList(depOtherIncomeList);
    }

    public List getDepRealAssetList() {
        return this.financialsData.getDepRealAssetList();
    }

    public void setDepRealAssetList(List depRealAssetList) {
        this.financialsData.setDepRealAssetList(depRealAssetList);
    }

    public List getDepTotalIncomeList() {
        return this.financialsData.getDepTotalIncomeList();
    }

    public void setDepTotalIncomeList(List depTotalIncomeList) {
        this.financialsData.setDepTotalIncomeList(depTotalIncomeList);
    }

    public List getDepValidList() {
        return this.financialsData.getDepValidList();
    }

    public void setDepValidList(List depValidList) {
        this.financialsData.setDepValidList(depValidList);
    }

    public List getDepRelationshipList() {
        return this.financialsData.getDepRelationshipList();
    }

    public void setDepRelationshipList(List depRelationshipList) {
        this.financialsData.setDepRelationshipList(depRelationshipList);
    }

    public List getDepGenderList() {
        return this.financialsData.getDepGenderList();
    }

    public void setDepGenderList(List depGenderList) {
        this.financialsData.setDepGenderList(depGenderList);
    }

    public List getDepSSNList() {
        return this.financialsData.getDepSSNList();
    }

    public void setDepSSNList(List depSSNList) {
        this.financialsData.setDepSSNList(depSSNList);
    }

    public List getDepInterestDividentAnuityIncomeList() {
        return this.financialsData.getDepInterestDividentAnuityIncomeList();
    }

    public void setDepInterestDividentAnuityIncomeList(List depInterestDividentAnuityIncome) {
        this.financialsData.setDepInterestDividentAnuityIncomeList(depInterestDividentAnuityIncome);
    }

    public List getDepMilitaryRetirementIncomeList() {
        return this.financialsData.getDepMilitaryRetirementIncomeList();
    }

    public void setDepMilitaryRetirementIncomeList(List depMilitaryRetirementIncome) {
        this.financialsData.setDepMilitaryRetirementIncomeList(depMilitaryRetirementIncome);
    }

    public List getDepOtherRetirementIncomeList() {
        return this.financialsData.getDepOtherRetirementIncomeList();
    }

    public void setDepOtherRetirementIncomeList(List depOtherRetirementIncome) {
        this.financialsData.setDepOtherRetirementIncomeList(depOtherRetirementIncome);
    }

    public List getDepRailroadRetirementIncomeList() {
        return this.financialsData.getDepRailroadRetirementIncomeList();
    }

    public void setDepRailroadRetirementIncomeList(List depRailroadRetirementIncome) {
        this.financialsData.setDepRailroadRetirementIncomeList(depRailroadRetirementIncome);
    }

    public List getDepSocialSecurityIncomeList() {
        return this.financialsData.getDepSocialSecurityIncomeList();
    }

    public void setDepSocialSecurityIncomeList(List depSocialSecurityIncome) {
        this.financialsData.setDepSocialSecurityIncomeList(depSocialSecurityIncome);
    }

    public List getDepUnemploymentIncomeList() {
        return this.financialsData.getDepUnemploymentIncomeList();
    }

    public void setDepUnemploymentIncomeList(List depUnemploymentIncome) {
        this.financialsData.setDepUnemploymentIncomeList(depUnemploymentIncome);
    }

    public List getDepUSCivilServiceIncomeList() {
        return this.financialsData.getDepUSCivilServiceIncomeList();
    }

    public void setDepUSCivilServiceIncomeList(List depUSCivilServiceIncome) {
        this.financialsData.setDepUSCivilServiceIncomeList(depUSCivilServiceIncome);
    }

    public List getDepWorkersCompIncomeList() {
        return this.financialsData.getDepWorkersCompIncomeList();
    }

    public void setDepWorkersCompIncomeList(List depWorkersCompIncome) {
        this.financialsData.setDepWorkersCompIncomeList(depWorkersCompIncome);
    }

    public List getDepDisplaySSNList() {
        return this.financialsData.getDepDisplaySSNList();
    }

    public void setDepDisplaySSNList(List depDisplaySSN) {
        this.financialsData.setDepDisplaySSNList(depDisplaySSN);
    }

    public String getDepFinacialsHashCode(int index) {
        return this.financialsData.getDepFinacialsHashCode(index);
    }

    public List getDepFinacialsHashcodeList() {
        return this.financialsData.getDepFinacialsHashcodeList();
    }

    public void setDepFinacialsHashCode(int index, String depFinacialsHashCode) {
        this.financialsData.setDepFinacialsHashCode(index, depFinacialsHashCode);
    }

    public boolean isPendingAdjudication() {
        return this.financialsData.isPendingAdjudication();
    }

    public void setPendingAdjudication(boolean pendingAdjudication) {
        this.financialsData.setPendingAdjudication(pendingAdjudication);
    }

    public void addDependent() {
        this.financialsData.addDependent();
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
        MessageResources messageResources = this.getResources(request);
        ActionMessages messages = this.getActionMessages(request);
        this.validateIncomeTestEffectiveDate(messages, messageResources);
        this.validatePreviousIncomeYearTestEffectiveDate(messages, messageResources);
        List depFinancials = this.financialsData.getDepFinacialsIdList();
        for (int i = 0; i < depFinancials.size(); ++i) {
            this.validateDependentFinancials(i, messages, messageResources);
        }
        return messages;
    }

    public ActionMessages validateDependentFinancials(int depIndex, ActionMessages errors, MessageResources messageResources) {
        String label;
        String index = "[" + depIndex + "]";
        String depName = " for " + this.getDepName(depIndex);
        if (StringUtils.isNotEmpty((String)this.getDepTotalIncome(depIndex))) {
            label = messageResources.getMessage("label.income.totalEmployment");
            FinancialDetailsForm.validateDoubleRange(this.getDepTotalIncome(depIndex), "depTotalIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepIncomeFromRanch(depIndex))) {
            label = messageResources.getMessage("label.income.ranchFarm");
            FinancialDetailsForm.validateDoubleRange(this.getDepIncomeFromRanch(depIndex), "depIncomeFromRanch" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepOtherIncome(depIndex))) {
            label = messageResources.getMessage("label.income.other");
            FinancialDetailsForm.validateDoubleRange(this.getDepOtherIncome(depIndex), "depOtherIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepSocialSecurityIncome(depIndex))) {
            label = messageResources.getMessage("label.income.socialSecurity");
            FinancialDetailsForm.validateDoubleRange(this.getDepSocialSecurityIncome(depIndex), "depSocialSecurityIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepMilitaryRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.milRetirement");
            FinancialDetailsForm.validateDoubleRange(this.getDepMilitaryRetirementIncome(depIndex), "depMilitaryRetirementIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepRailroadRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.railRetirement");
            FinancialDetailsForm.validateDoubleRange(this.getDepRailroadRetirementIncome(depIndex), "depRailroadRetirementIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepUSCivilServiceIncome(depIndex))) {
            label = messageResources.getMessage("label.income.usCivilService");
            FinancialDetailsForm.validateDoubleRange(this.getDepUSCivilServiceIncome(depIndex), "depUSCivilServiceIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepUnemploymentIncome(depIndex))) {
            label = messageResources.getMessage("label.income.unemployment");
            FinancialDetailsForm.validateDoubleRange(this.getDepUnemploymentIncome(depIndex), "depUnemploymentIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepWorkersCompIncome(depIndex))) {
            label = messageResources.getMessage("label.income.workersComp");
            FinancialDetailsForm.validateDoubleRange(this.getDepWorkersCompIncome(depIndex), "depWorkersCompIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepOtherRetirementIncome(depIndex))) {
            label = messageResources.getMessage("label.income.otherRetirement");
            FinancialDetailsForm.validateDoubleRange(this.getDepOtherRetirementIncome(depIndex), "depOtherRetirementIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepInterestDividentAnuityIncome(depIndex))) {
            label = messageResources.getMessage("label.income.interst");
            FinancialDetailsForm.validateDoubleRange(this.getDepInterestDividentAnuityIncome(depIndex), "depInterestDividentAnuityIncome" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepCashAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.cash");
            FinancialDetailsForm.validateDoubleRange(this.getDepCashAsset(depIndex), "depCashAsset" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepRealAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.real");
            FinancialDetailsForm.validateDoubleRange(this.getDepRealAsset(depIndex), "depRealAsset" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepOtherAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.other");
            FinancialDetailsForm.validateDoubleRange(this.getDepOtherAsset(depIndex), "depOtherAsset" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepStocksAsset(depIndex))) {
            label = messageResources.getMessage("label.asset.stocks");
            FinancialDetailsForm.validateDoubleRange(this.getDepStocksAsset(depIndex), "depStocksAsset" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepEduExpenses(depIndex))) {
            label = messageResources.getMessage("label.expense.edu");
            FinancialDetailsForm.validateDoubleRange(this.getDepEduExpenses(depIndex), "depEduExpenses" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepAmtContributed(depIndex))) {
            label = messageResources.getMessage("label.dep.amtContributed");
            FinancialDetailsForm.validateDoubleRange(this.getDepAmtContributed(depIndex), "depAmtContributed" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepEffectiveDate(depIndex))) {
            label = messageResources.getMessage("label.dep.effDate");
            FinancialDetailsForm.validateImpreciseDate(this.getDepEffectiveDate(depIndex), "depEffectiveDate" + index, label + depName, errors);
        }
        if (StringUtils.isNotEmpty((String)this.getDepInactiveDate(depIndex))) {
            label = messageResources.getMessage("label.dep.inactiveDate");
            FinancialDetailsForm.validatePreciseDate(this.getDepInactiveDate(depIndex), "depInactiveDate" + index, label + depName, errors);
        }
        return errors;
    }

    private void validateIncomeTestEffectiveDate(ActionMessages messages, MessageResources messageResources) {
        if (StringUtils.isNotEmpty((String)this.financialsData.getTestEffDate()) && StringUtils.isNotEmpty((String)this.financialsData.getIncomeYear())) {
            try {
                Date effectiveDate = CommonDateUtils.getDate(this.financialsData.getTestEffDate());
                Date incomeYearEndDate = CommonDateUtils.getDate("12/31/" + this.financialsData.getIncomeYear());
                if (!incomeYearEndDate.before(effectiveDate)) {
                    String label = messageResources.getMessage("label.financials.testeffdate");
                    messages.add("testEffDate", new ActionMessage("errors.effectiveDateWithinIncomeYear", (Object)label));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void validatePreviousIncomeYearTestEffectiveDate(ActionMessages messages, MessageResources messageResources) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1) - 2;
        int incomeYear = Integer.parseInt(this.financialsData.getIncomeYear());
        if (StringUtils.isNotEmpty((String)this.financialsData.getTestEffDate()) && StringUtils.isNotEmpty((String)this.financialsData.getIncomeYear()) && incomeYear == year) {
            try {
                Date effectiveDate = CommonDateUtils.getDate(this.financialsData.getTestEffDate());
                calendar.setTime(effectiveDate);
                int effectiveDateYear = calendar.get(1);
                if (effectiveDateYear > incomeYear + 1) {
                    String label = messageResources.getMessage("label.financials.testeffdate");
                    messages.add("testEffDate", new ActionMessage("errors.effectiveDateWithinIncomeYearPlusOne", (Object)label));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static boolean validateImpreciseDate(String dateStr, String fieldName, String fieldLabel, ActionMessages errors) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return true;
        }
        boolean fieldValid = true;
        try {
            CommonDateUtils.getImpreciseDate(dateStr);
        }
        catch (Exception e) {
            fieldValid = false;
        }
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.imprecisedate", (Object)fieldLabel));
        }
        return fieldValid;
    }

    public static boolean validatePreciseDate(String dateStr, String fieldName, String fieldLabel, ActionMessages errors) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return true;
        }
        boolean fieldValid = true;
        try {
            boolean timeSupported = false;
            CommonDateUtils.getDate(dateStr, timeSupported);
        }
        catch (Exception e) {
            fieldValid = false;
        }
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.date", (Object)fieldLabel));
        }
        return fieldValid;
    }

    public static boolean validateDoubleRange(String fieldValue, String fieldName, String fieldLabel, ActionMessages errors) {
        boolean isValid = true;
        Double minValue = new Double(0.0);
        Double maxValue = new Double(9999999.99);
        try {
            Double d = new Double(fieldValue);
            if (d < 0.0 || d > 9999999.99) {
                errors.add(fieldName, new ActionMessage("errors.range", (Object)fieldLabel, (Object)minValue, (Object)maxValue));
                isValid = false;
            }
        }
        catch (NumberFormatException e) {
            errors.add(fieldName, new ActionMessage("errors.double", (Object)fieldLabel));
            isValid = false;
        }
        return isValid;
    }

    private void initialize() {
        this.financialsData = new FinancialDetailsData();
        this.spouseFinacialsId = new ArrayList();
        this.spouseSSN = new ArrayList();
        this.spouseDisplaySSN = new ArrayList();
        this.spouseRelationshipCode = new ArrayList();
        this.spouseRelationship = new ArrayList();
        this.spouseGenderCode = new ArrayList();
        this.spouseGender = new ArrayList();
        this.spouseName = new ArrayList();
        this.spouseValid = new ArrayList();
        this.spouseInactiveDate = new ArrayList();
        this.spouseLivedWithPatient = new ArrayList();
        this.spouseContributedToSupport = new ArrayList();
        this.spouseMarriageDate = new ArrayList();
        this.spouseTotalIncome = new ArrayList();
        this.spouseIncomeFromRanch = new ArrayList();
        this.spouseOtherIncome = new ArrayList();
        this.spouseEduExpenses = new ArrayList();
        this.spouseCashAsset = new ArrayList();
        this.spouseRealAsset = new ArrayList();
        this.spouseOtherAsset = new ArrayList();
        this.spouseStocksAsset = new ArrayList();
        this.spouseUSCivilServiceIncome = new ArrayList();
        this.spouseInterestDividentAnuityIncome = new ArrayList();
        this.spouseUnemploymentIncome = new ArrayList();
        this.spouseSocialSecurityIncome = new ArrayList();
        this.spouseMilitaryRetirementIncome = new ArrayList();
        this.spouseRailroadRetirementIncome = new ArrayList();
        this.spouseOtherRetirementIncome = new ArrayList();
        this.spouseWorkersCompIncome = new ArrayList();
        this.spouseFinacialsHashCode = new ArrayList();
        this.spouseDebt = new ArrayList();
        this.spouseActive = new ArrayList();
        this.contributedToSpousalSupport = new ArrayList();
    }

    public void addSpouse() {
        this.spouseFinacialsId.add("");
        this.spouseSSN.add("");
        this.spouseDisplaySSN.add("");
        this.spouseRelationshipCode.add("");
        this.spouseRelationship.add("");
        this.spouseGenderCode.add("");
        this.spouseGender.add("");
        this.spouseName.add("");
        this.spouseValid.add("");
        this.spouseInactiveDate.add("");
        this.spouseLivedWithPatient.add("");
        this.spouseContributedToSupport.add("");
        this.spouseMarriageDate.add("");
        this.spouseTotalIncome.add("");
        this.spouseIncomeFromRanch.add("");
        this.spouseOtherIncome.add("");
        this.spouseEduExpenses.add("");
        this.spouseCashAsset.add("");
        this.spouseRealAsset.add("");
        this.spouseOtherAsset.add("");
        this.spouseStocksAsset.add("");
        this.spouseUSCivilServiceIncome.add("");
        this.spouseInterestDividentAnuityIncome.add("");
        this.spouseUnemploymentIncome.add("");
        this.spouseSocialSecurityIncome.add("");
        this.spouseMilitaryRetirementIncome.add("");
        this.spouseRailroadRetirementIncome.add("");
        this.spouseOtherRetirementIncome.add("");
        this.spouseWorkersCompIncome.add("");
        this.spouseFinacialsHashCode.add("");
        this.spouseDebt.add("");
        this.spouseActive.add("");
        this.contributedToSpousalSupport.add("");
    }

    public String getSpouseActive(int index) {
        return (String)this.spouseActive.get(index);
    }

    public String getSpouseMarriageDate(int index) {
        return (String)this.spouseMarriageDate.get(index);
    }

    public String getSpouseCashAsset(int index) {
        return (String)this.spouseCashAsset.get(index);
    }

    public String getSpouseContributedToSupport(int index) {
        return (String)this.spouseContributedToSupport.get(index);
    }

    public String getSpouseDebt(int index) {
        return (String)this.spouseDebt.get(index);
    }

    public String getSpouseDisplaySSN(int index) {
        return (String)this.spouseDisplaySSN.get(index);
    }

    public String getSpouseEduExpenses(int index) {
        return (String)this.spouseEduExpenses.get(index);
    }

    public String getSpouseFinacialsHashCode(int index) {
        return (String)this.spouseFinacialsHashCode.get(index);
    }

    public String getSpouseFinacialsId(int index) {
        return (String)this.spouseFinacialsId.get(index);
    }

    public String getSpouseGender(int index) {
        return (String)this.spouseGender.get(index);
    }

    public String getSpouseGenderCode(int index) {
        return (String)this.spouseGenderCode.get(index);
    }

    public String getSpouseInactiveDate(int index) {
        return (String)this.spouseInactiveDate.get(index);
    }

    public String getSpouseIncomeFromRanch(int index) {
        return (String)this.spouseIncomeFromRanch.get(index);
    }

    public String getSpouseInterestDividentAnuityIncome(int index) {
        return (String)this.spouseInterestDividentAnuityIncome.get(index);
    }

    public String getSpouseLivedWithPatient(int index) {
        return (String)this.spouseLivedWithPatient.get(index);
    }

    public String getSpouseMilitaryRetirementIncome(int index) {
        return (String)this.spouseMilitaryRetirementIncome.get(index);
    }

    public String getSpouseName(int index) {
        return (String)this.spouseName.get(index);
    }

    public String getSpouseOtherAsset(int index) {
        return (String)this.spouseOtherAsset.get(index);
    }

    public String getSpouseOtherIncome(int index) {
        return (String)this.spouseOtherIncome.get(index);
    }

    public String getSpouseOtherRetirementIncome(int index) {
        return (String)this.spouseOtherRetirementIncome.get(index);
    }

    public String getSpouseRailroadRetirementIncome(int index) {
        return (String)this.spouseRailroadRetirementIncome.get(index);
    }

    public String getSpouseRealAsset(int index) {
        return (String)this.spouseRealAsset.get(index);
    }

    public String getSpouseRelationship(int index) {
        return (String)this.spouseRelationship.get(index);
    }

    public String getSpouseRelationshipCode(int index) {
        return (String)this.spouseRelationshipCode.get(index);
    }

    public String getSpouseSocialSecurityIncome(int index) {
        return (String)this.spouseSocialSecurityIncome.get(index);
    }

    public String getSpouseSSN(int index) {
        return (String)this.spouseSSN.get(index);
    }

    public String getSpouseStocksAsset(int index) {
        return (String)this.spouseStocksAsset.get(index);
    }

    public String getSpouseTotalIncome(int index) {
        return (String)this.spouseTotalIncome.get(index);
    }

    public String getSpouseUnemploymentIncome(int index) {
        return (String)this.spouseUnemploymentIncome.get(index);
    }

    public String getSpouseUSCivilServiceIncome(int index) {
        return (String)this.spouseUSCivilServiceIncome.get(index);
    }

    public String getSpouseValid(int index) {
        return (String)this.spouseValid.get(index);
    }

    public String getSpouseWorkersCompIncome(int index) {
        return (String)this.spouseWorkersCompIncome.get(index);
    }

    public void setSpouseActive(int index, String spouseActive) {
        this.setElement(this.spouseActive, index, spouseActive);
    }

    public void setSpouseMarriageDate(int index, String spouseMarriageDate) {
        this.setElement(this.spouseMarriageDate, index, spouseMarriageDate);
    }

    public void setSpouseCashAsset(int index, String spouseCashAsset) {
        this.setElement(this.spouseCashAsset, index, spouseCashAsset);
    }

    public void setSpouseContributedToSupport(int index, String spouseContributedToSupport) {
        this.setElement(this.spouseContributedToSupport, index, spouseContributedToSupport);
    }

    public void setSpouseDebt(int index, String spouseDebt) {
        this.setElement(this.spouseDebt, index, spouseDebt);
    }

    public void setSpouseDisplaySSN(int index, String spouseDisplaySSN) {
        this.setElement(this.spouseDisplaySSN, index, spouseDisplaySSN);
    }

    public void setSpouseEduExpenses(int index, String spouseEduExpenses) {
        this.setElement(this.spouseEduExpenses, index, spouseEduExpenses);
    }

    public void setSpouseFinacialsHashCode(int index, String spouseFinacialsHashCode) {
        this.setElement(this.spouseFinacialsHashCode, index, spouseFinacialsHashCode);
    }

    public void setSpouseFinacialsId(int index, String spouseFinacialsId) {
        this.setElement(this.spouseFinacialsId, index, spouseFinacialsId);
    }

    public void setSpouseGender(int index, String spouseGender) {
        this.setElement(this.spouseGender, index, spouseGender);
    }

    public void setSpouseGenderCode(int index, String spouseGenderCode) {
        this.setElement(this.spouseGenderCode, index, spouseGenderCode);
    }

    public void setSpouseInactiveDate(int index, String spouseInactiveDate) {
        this.setElement(this.spouseInactiveDate, index, spouseInactiveDate);
    }

    public void setSpouseIncomeFromRanch(int index, String spouseIncomeFromRanch) {
        this.setElement(this.spouseIncomeFromRanch, index, spouseIncomeFromRanch);
    }

    public void setSpouseInterestDividentAnuityIncome(int index, String spouseInterestDividentAnuityIncome) {
        this.setElement(this.spouseInterestDividentAnuityIncome, index, spouseInterestDividentAnuityIncome);
    }

    public void setSpouseLivedWithPatient(int index, String spouseLivedWithPatient) {
        this.setElement(this.spouseLivedWithPatient, index, spouseLivedWithPatient);
    }

    public void setSpouseMilitaryRetirementIncome(int index, String spouseMilitaryRetirementIncome) {
        this.setElement(this.spouseMilitaryRetirementIncome, index, spouseMilitaryRetirementIncome);
    }

    public void setSpouseName(int index, String spouseName) {
        this.setElement(this.spouseName, index, spouseName);
    }

    public void setSpouseOtherAsset(int index, String spouseOtherAsset) {
        this.setElement(this.spouseOtherAsset, index, spouseOtherAsset);
    }

    public void setSpouseOtherIncome(int index, String spouseOtherIncome) {
        this.setElement(this.spouseOtherIncome, index, spouseOtherIncome);
    }

    public void setSpouseOtherRetirementIncome(int index, String spouseOtherRetirementIncome) {
        this.setElement(this.spouseOtherRetirementIncome, index, spouseOtherRetirementIncome);
    }

    public void setSpouseRailroadRetirementIncome(int index, String spouseRailroadRetirementIncome) {
        this.setElement(this.spouseRailroadRetirementIncome, index, spouseRailroadRetirementIncome);
    }

    public void setSpouseRealAsset(int index, String spouseRealAsset) {
        this.setElement(this.spouseRealAsset, index, spouseRealAsset);
    }

    public void setSpouseRelationship(int index, String spouseRelationship) {
        this.setElement(this.spouseRelationship, index, spouseRelationship);
    }

    public void setSpouseRelationshipCode(int index, String spouseRelationshipCode) {
        this.setElement(this.spouseRelationshipCode, index, spouseRelationshipCode);
    }

    public void setSpouseSocialSecurityIncome(int index, String spouseSocialSecurityIncome) {
        this.setElement(this.spouseSocialSecurityIncome, index, spouseSocialSecurityIncome);
    }

    public void setSpouseSSN(int index, String spouseSSN) {
        this.setElement(this.spouseSSN, index, spouseSSN);
    }

    public void setSpouseStocksAsset(int index, String spouseStocksAsset) {
        this.setElement(this.spouseStocksAsset, index, spouseStocksAsset);
    }

    public void setSpouseTotalIncome(int index, String spouseTotalIncome) {
        this.setElement(this.spouseTotalIncome, index, spouseTotalIncome);
    }

    public void setSpouseUnemploymentIncome(int index, String spouseUnemploymentIncome) {
        this.setElement(this.spouseUnemploymentIncome, index, spouseUnemploymentIncome);
    }

    public void setSpouseUSCivilServiceIncome(int index, String spouseUSCivilServiceIncome) {
        this.setElement(this.spouseUSCivilServiceIncome, index, spouseUSCivilServiceIncome);
    }

    public void setSpouseValid(int index, String spouseValid) {
        this.setElement(this.spouseValid, index, spouseValid);
    }

    public void setSpouseWorkersCompIncome(int index, String spouseWorkersCompIncome) {
        this.setElement(this.spouseWorkersCompIncome, index, spouseWorkersCompIncome);
    }

    public List getSpouseActiveList() {
        return this.spouseActive;
    }

    public List getSpouseMarriageDateList() {
        return this.spouseMarriageDate;
    }

    public List getSpouseCashAssetList() {
        return this.spouseCashAsset;
    }

    public List getSpouseContributedToSupportList() {
        return this.spouseContributedToSupport;
    }

    public List getSpouseDebtList() {
        return this.spouseDebt;
    }

    public List getSpouseDisplaySSNList() {
        return this.spouseDisplaySSN;
    }

    public List getSpouseEduExpensesList() {
        return this.spouseEduExpenses;
    }

    public List getSpouseFinacialsHashCodeList() {
        return this.spouseFinacialsHashCode;
    }

    public List getSpouseFinacialsIdList() {
        return this.spouseFinacialsId;
    }

    public List getSpouseGenderList() {
        return this.spouseGender;
    }

    public List getSpouseGenderCodeList() {
        return this.spouseGenderCode;
    }

    public List getSpouseInactiveDateList() {
        return this.spouseInactiveDate;
    }

    public List getSpouseIncomeFromRanchList() {
        return this.spouseIncomeFromRanch;
    }

    public List getSpouseInterestDividentAnuityIncomeList() {
        return this.spouseInterestDividentAnuityIncome;
    }

    public List getSpouseLivedWithPatientList() {
        return this.spouseLivedWithPatient;
    }

    public List getSpouseMilitaryRetirementIncomeList() {
        return this.spouseMilitaryRetirementIncome;
    }

    public List getSpouseNameList() {
        return this.spouseName;
    }

    public List getSpouseOtherAssetList() {
        return this.spouseOtherAsset;
    }

    public List getSpouseOtherIncomeList() {
        return this.spouseOtherIncome;
    }

    public List getSpouseOtherRetirementIncomeList() {
        return this.spouseOtherRetirementIncome;
    }

    public List getSpouseRailroadRetirementIncomeList() {
        return this.spouseRailroadRetirementIncome;
    }

    public List getSpouseRealAssetList() {
        return this.spouseRealAsset;
    }

    public List getSpouseRelationshipList() {
        return this.spouseRelationship;
    }

    public List getSpouseRelationshipCodeList() {
        return this.spouseRelationshipCode;
    }

    public List getSpouseSocialSecurityIncomeList() {
        return this.spouseSocialSecurityIncome;
    }

    public List getSpouseSSNList() {
        return this.spouseSSN;
    }

    public List getSpouseStocksAssetList() {
        return this.spouseStocksAsset;
    }

    public List getSpouseTotalIncomeList() {
        return this.spouseTotalIncome;
    }

    public List getSpouseUnemploymentIncomeList() {
        return this.spouseUnemploymentIncome;
    }

    public List getSpouseUSCivilServiceIncomeList() {
        return this.spouseUSCivilServiceIncome;
    }

    public List getSpouseValidList() {
        return this.spouseValid;
    }

    public List getSpouseWorkersCompIncomeList() {
        return this.spouseWorkersCompIncome;
    }

    public void setSpouseActiveList(List spouseActive) {
        this.spouseActive = spouseActive;
    }

    public void setSpouseMarriageDateList(List spouseMarriageDate) {
        this.spouseMarriageDate = spouseMarriageDate;
    }

    public void setSpouseCashAssetList(List spouseCashAsset) {
        this.spouseCashAsset = spouseCashAsset;
    }

    public void setSpouseContributedToSupportList(List spouseContributedToSupport) {
        this.spouseContributedToSupport = spouseContributedToSupport;
    }

    public void setSpouseDebtList(List spouseDebt) {
        this.spouseDebt = spouseDebt;
    }

    public void setSpouseDisplaySSNList(List spouseDisplaySSN) {
        this.spouseDisplaySSN = spouseDisplaySSN;
    }

    public void setSpouseEduExpensesList(List spouseEduExpenses) {
        this.spouseEduExpenses = spouseEduExpenses;
    }

    public void setSpouseFinacialsHashCodeList(List spouseFinacialsHashCode) {
        this.spouseFinacialsHashCode = spouseFinacialsHashCode;
    }

    public void setSpouseFinacialsIdList(List spouseFinacialsId) {
        this.spouseFinacialsId = spouseFinacialsId;
    }

    public void setSpouseGenderList(List spouseGender) {
        this.spouseGender = spouseGender;
    }

    public void setSpouseGenderCodeList(List spouseGenderCode) {
        this.spouseGenderCode = spouseGenderCode;
    }

    public void setSpouseInactiveDateList(List spouseInactiveDate) {
        this.spouseInactiveDate = spouseInactiveDate;
    }

    public void setSpouseIncomeFromRanchList(List spouseIncomeFromRanch) {
        this.spouseIncomeFromRanch = spouseIncomeFromRanch;
    }

    public void setSpouseInterestDividentAnuityIncomeList(List spouseInterestDividentAnuityIncome) {
        this.spouseInterestDividentAnuityIncome = spouseInterestDividentAnuityIncome;
    }

    public void setSpouseLivedWithPatientList(List spouseLivedWithPatient) {
        this.spouseLivedWithPatient = spouseLivedWithPatient;
    }

    public void setSpouseMilitaryRetirementIncomeList(List spouseMilitaryRetirementIncome) {
        this.spouseMilitaryRetirementIncome = spouseMilitaryRetirementIncome;
    }

    public void setSpouseNameList(List spouseName) {
        this.spouseName = spouseName;
    }

    public void setSpouseOtherAssetList(List spouseOtherAsset) {
        this.spouseOtherAsset = spouseOtherAsset;
    }

    public void setSpouseOtherIncomeList(List spouseOtherIncome) {
        this.spouseOtherIncome = spouseOtherIncome;
    }

    public void setSpouseOtherRetirementIncomeList(List spouseOtherRetirementIncome) {
        this.spouseOtherRetirementIncome = spouseOtherRetirementIncome;
    }

    public void setSpouseRailroadRetirementIncomeList(List spouseRailroadRetirementIncome) {
        this.spouseRailroadRetirementIncome = spouseRailroadRetirementIncome;
    }

    public void setSpouseRealAssetList(List spouseRealAsset) {
        this.spouseRealAsset = spouseRealAsset;
    }

    public void setSpouseRelationshipList(List spouseRelationship) {
        this.spouseRelationship = spouseRelationship;
    }

    public void setSpouseRelationshipCodeList(List spouseRelationshipCode) {
        this.spouseRelationshipCode = spouseRelationshipCode;
    }

    public void setSpouseSocialSecurityIncomeList(List spouseSocialSecurityIncome) {
        this.spouseSocialSecurityIncome = spouseSocialSecurityIncome;
    }

    public void setSpouseSSNList(List spouseSSN) {
        this.spouseSSN = spouseSSN;
    }

    public void setSpouseStocksAssetList(List spouseStocksAsset) {
        this.spouseStocksAsset = spouseStocksAsset;
    }

    public void setSpouseTotalIncomeList(List spouseTotalIncome) {
        this.spouseTotalIncome = spouseTotalIncome;
    }

    public void setSpouseUnemploymentIncomeList(List spouseUnemploymentIncome) {
        this.spouseUnemploymentIncome = spouseUnemploymentIncome;
    }

    public void setSpouseUSCivilServiceIncomeList(List spouseUSCivilServiceIncome) {
        this.spouseUSCivilServiceIncome = spouseUSCivilServiceIncome;
    }

    public void setSpouseValidList(List spouseValid) {
        this.spouseValid = spouseValid;
    }

    public void setSpouseWorkersCompIncomeList(List spouseWorkersCompIncome) {
        this.spouseWorkersCompIncome = spouseWorkersCompIncome;
    }

    public Boolean getBtFinancialInd() {
        return this.btFinancialInd;
    }

    public void setBtFinancialInd(Boolean btFinancialInd) {
        this.btFinancialInd = btFinancialInd;
    }

    public List getContributedToSpousalSupport() {
        return this.contributedToSpousalSupport;
    }

    public void setContributedToSpousalSupport(List contributedToSpousalSupport) {
        this.contributedToSpousalSupport = contributedToSpousalSupport;
    }

    public String getContributedToSpousalSupport(int index) {
        return (String)this.contributedToSpousalSupport.get(index);
    }

    public void setContributedToSpousalSupport(int index, String contributedToSpousalSupport) {
        this.setElement(this.contributedToSpousalSupport, index, contributedToSpousalSupport);
    }
}

