/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.ui.conversion;

import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.ui.conversion.CommonConversionServiceImpl;
import gov.va.med.esr.service.VOASearchResultBean;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommonVOAResubmissionConversionService
extends CommonConversionServiceImpl
implements Serializable {
    private static final long serialVersionUID = 3974958152565946756L;
    private CommonVOAResubmissionConversionService voaConversionService;
    public static final String PENDING_IDENTITY_TRAITS = "Pending Identity Traits Update";
    public static final String PERSON_NOT_FOUND = "Person not found";
    public static final String PROXY_PF_FAILED = "Proxy PF Add Failed";
    public static final String PCE = "Pending Catastrophic Edit (PCE)";
    public static final String PERSON_INFO_NOT_ACCEPTED = "Person Info Not Accepted";
    public static final String CHECK_PERSON_INFO = "person on the VOA submitted form was not accepted";
    public static final String CHECK_PROXY_PF = "VOA Workflow Case has been created";
    public static final String TXT_1010EZ = "1010EZ";
    public static final String TXT_1010EZR = "1010EZR";
    public static final String TXT_1010HS = "1010HS";
    public static final String TXT_1010SH = "1010SH";
    public static final String TXT_1010CG = "1010CG";
    public static final String TXT_21526EZ = "21526EZ";
    public static final BigDecimal ID_1010EZ = new BigDecimal(1);
    public static final BigDecimal ID_1010EZR = new BigDecimal(2);
    public static final BigDecimal ID_1010HS = new BigDecimal(3);
    public static final BigDecimal ID_1010SH = new BigDecimal(4);
    public static final BigDecimal ID_1010CG = new BigDecimal(5);
    public static final BigDecimal ID_21526EZ = new BigDecimal(6);
    public static final BigDecimal CODE_FEMALE = new BigDecimal(1009252);
    public static final BigDecimal CODE_MALE = new BigDecimal(1009253);
    public static final String FEMALE = "Female";
    public static final String MALE = "Male";
    private String applicationId = null;
    private BigDecimal personId = null;
    private String lastName = null;
    private String firstName = null;
    private String dateOfBirth = null;
    private String ssn = null;
    private Date responseTimeStamp = null;
    private String errorText = null;
    private String fullQualifiedId = null;
    private Date receiveTimeStamp = null;
    private String formType = null;
    private Gender gender = null;

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (!(source instanceof Object[]) || !(target instanceof VOASearchResultBean)) {
            throw new ConversionServiceException("Type mismatch: Can't convert from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
        CommonVOAResubmissionConversionService.convert((Object[])source, (VOASearchResultBean)target);
    }

    public static VOASearchResultBean convert(Object[] objArray, VOASearchResultBean voaBean) throws ConversionServiceException {
        VOASearchResultBean bean = voaBean;
        try {
            bean.setApplicationId((BigDecimal)objArray[0]);
            if (objArray[1] != null) {
                bean.setFullQualifiedId((String)objArray[1]);
            }
            bean.setLastName((String)objArray[2]);
            bean.setFirstName((String)objArray[3]);
            bean.setSsn(CommonVOAResubmissionConversionService.FormatSSN((String)objArray[4]));
            bean.setDob((Date)objArray[5]);
            int genderRes = CODE_FEMALE.compareTo((BigDecimal)objArray[6]);
            if (genderRes == 0) {
                bean.setGender(FEMALE);
            } else {
                genderRes = CODE_MALE.compareTo((BigDecimal)objArray[6]);
                if (genderRes == 0) {
                    bean.setGender(MALE);
                }
            }
            bean.setReqRecdDate(new SimpleDateFormat("MM/dd/yyyy").format((Date)objArray[7]));
            String errorValue = (String)objArray[9];
            if (errorValue.contains(PCE)) {
                bean.setErrorText(PENDING_IDENTITY_TRAITS);
            } else if (errorValue.contains(PERSON_NOT_FOUND)) {
                bean.setErrorText(PERSON_NOT_FOUND);
            } else if (errorValue.contains(CHECK_PROXY_PF)) {
                bean.setErrorText(PROXY_PF_FAILED);
            } else if (errorValue.contains(CHECK_PERSON_INFO)) {
                bean.setErrorText(PERSON_INFO_NOT_ACCEPTED);
            }
            int res = ID_1010EZ.compareTo((BigDecimal)objArray[8]);
            if (res == 0) {
                bean.setFormTypeValue(TXT_1010EZ);
                bean.setFormType(ID_1010EZ);
            } else if (ID_21526EZ.compareTo((BigDecimal)objArray[8]) == 0) {
                bean.setFormTypeValue(TXT_21526EZ);
                bean.setFormType(ID_21526EZ);
            } else {
                res = ID_1010EZR.compareTo((BigDecimal)objArray[8]);
                if (res == 0) {
                    bean.setFormTypeValue(TXT_1010EZR);
                    bean.setFormType(ID_1010EZR);
                } else {
                    res = ID_1010EZR.compareTo((BigDecimal)objArray[8]);
                    if (res == 0) {
                        bean.setFormTypeValue(TXT_1010EZR);
                        bean.setFormType(ID_1010EZR);
                    } else {
                        res = ID_1010EZR.compareTo((BigDecimal)objArray[8]);
                        if (res == 0) {
                            bean.setFormTypeValue(TXT_1010EZR);
                            bean.setFormType(ID_1010EZR);
                        } else {
                            res = ID_1010EZR.compareTo((BigDecimal)objArray[8]);
                            if (res == 0) {
                                bean.setFormTypeValue(TXT_1010EZR);
                                bean.setFormType(ID_1010EZR);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
        return voaBean;
    }

    public CommonVOAResubmissionConversionService getVOAResubmissionConversionService() {
        return this.voaConversionService;
    }

    public void setVOAResubmissionConversionService(CommonVOAResubmissionConversionService voaConversionService) {
        this.voaConversionService = voaConversionService;
    }

    protected static String FormatSSN(String ssn) {
        if (ssn != null && ssn.length() == 9 && ssn.indexOf("-") == -1) {
            StringBuffer hypenSsn = new StringBuffer();
            hypenSsn.append(ssn.substring(0, 3));
            hypenSsn.append("-");
            hypenSsn.append(ssn.substring(3, 5));
            hypenSsn.append("-");
            hypenSsn.append(ssn.substring(5));
            return hypenSsn.toString();
        }
        return ssn;
    }
}

