/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.ui.conversion;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.ui.conversion.CommonConversionServiceImpl;
import gov.va.med.esr.common.ui.conversion.CommonFinancialsDependentConversionService;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.common.ui.form.RelationFinancialInfoBean;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.common.util.CommonJspUtils;
import gov.va.med.esr.common.util.CommonNameHelper;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommonFinancialDetailsConversionService
extends CommonConversionServiceImpl {
    private CommonFinancialsDependentConversionService dependentConversionService;

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        FinancialDetailsForm form = null;
        if (source instanceof Person) {
            person = (Person)((Object)source);
            if (!(target instanceof FinancialDetailsForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type FinancialDetailsForm.");
            }
            form = (FinancialDetailsForm)target;
        } else {
            throw new ConversionServiceException("Source object is of type " + source.getClass().getName() + " and must be of type Person.");
        }
        this.convertPersonToForm(person, form);
    }

    protected void convertPersonToForm(Person person, FinancialDetailsForm form) throws ConversionServiceException {
        try {
            FinancialStatement ftmt;
            boolean isAddAPerson = form.isAddAPerson();
            String year = form.getIncomeYear();
            if (year == null || year.equals("null") || year.equals("")) {
                throw new ConversionServiceException("Unable to convert Person to FinancialDetailsForm, no IncomeYear selected");
            }
            HashSet otherNames = new HashSet(person.getNames());
            Name name = Name.getNameOfType(otherNames, NameType.LEGAL_NAME.getName());
            if (name != null) {
                form.setName(CommonNameHelper.formatNameFirstNameFirst(name));
            }
            form.setIncomeTestAvaliableInd(false);
            form.setPost2005formatInd(true);
            IncomeTest test = person.getIncomeTest(new Integer(year));
            if (test != null && test.getEntityKey() == null) {
                form.setNewIncomeTestInd(true);
            } else {
                form.setNewIncomeTestInd(false);
            }
            if (test != null) {
                form.setIncomeTestAvaliableInd(true);
                form.setPendingAdjudication(test.isPendingAdjudication());
                form.setBtFinancialInd(test.getBtFinancialInd());
                if (test.getEffectiveDate() != null) {
                    form.setTestEffDate(CommonJspUtils.displayValue(test.getEffectiveDate(), "MM/dd/yyyy"));
                }
                form.setSendForAdjudication(this.getYesNoNoData(test.getSendForAdjudication()));
                if (test.getSendForAdjudication() != null) {
                    form.setAskAdjudicationQuestion(true);
                }
                form.setAgreeToPayDeductible(this.getYesNoNoData(test.getAgreesToPayDeductible()));
                form.setDiscloseFinIncome(this.getYesNoNoData(test.getDiscloseFinancialInformation()));
                form.setSourceOfTest(this.getLookupCode((Lookup)test.getSource()));
            }
            if ((ftmt = person.getFinancialStatement(new Integer(year))) != null) {
                if (ftmt.getIsPost2005Format() != null) {
                    form.setPost2005formatInd(ftmt.getIsPost2005Format());
                }
                form.setMarriedLastCalendarYear(this.getYesNoNoData(ftmt.getMarriedLastCalendarYear()));
                this.convertVeteranFinancialAmountsToForm(ftmt, form);
                int spouseCount = 0;
                Set spouseFinancials = ftmt.getSpouseFinancials();
                SpouseFinancials sf = ftmt.getRecentSpouseFinancials();
                for (SpouseFinancials spFin : spouseFinancials) {
                    SpouseFinancialInfoBean sbean = new SpouseFinancialInfoBean();
                    this.convertSpouseFinancialsToBean(spFin, sbean);
                    this.convertSpouseFinancialAmountsToBean(spFin, sbean);
                    if (StringUtils.isEmpty((String)sbean.getDisplaySSN())) {
                        sbean.setDisplaySSN("UNKNOWN");
                    }
                    if (isAddAPerson) {
                        this.addSpouseToForm(spouseCount, form, sbean);
                        ++spouseCount;
                        form.setSpouseInfo(sbean);
                        continue;
                    }
                    if (sf != null) {
                        if (sf.getEntityKey() != null) {
                            if (!sf.getEntityKey().equals(spFin.getEntityKey())) continue;
                            form.setSpouseInfo(sbean);
                            continue;
                        }
                        if (!sf.equals((Object)spFin)) continue;
                        form.setSpouseInfo(sbean);
                        continue;
                    }
                    this.addSpouseToForm(spouseCount, form, sbean);
                    ++spouseCount;
                }
                int depCount = 0;
                Set dependentFinancials = ftmt.getDependentFinancials();
                for (DependentFinancials df : dependentFinancials) {
                    DependentFinancialInfoBean bean = new DependentFinancialInfoBean();
                    this.convertDependentFinancialsToBean(df, bean);
                    this.convertDependentFinancialAmountsToBean(df, bean);
                    if (StringUtils.isEmpty((String)bean.getDisplaySSN())) {
                        bean.setDisplaySSN("UNKNOWN");
                    }
                    this.addDependentToForm(depCount, form, bean);
                    ++depCount;
                }
                ArrayList depInfoList = new ArrayList();
                form.setDependentInfoList(depInfoList);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to FinancialDetailsForm.", ex);
        }
    }

    private void convertVeteranFinancialAmountsToForm(FinancialStatement ftmt, FinancialDetailsForm form) {
        for (Financial e : ftmt.getIncome().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName())) {
                form.setTotalEmploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName())) {
                form.setOtherIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName())) {
                form.setNetIncomeFromFarmRanchOrBusiness(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName())) {
                form.setUSCivilServiceIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName())) {
                form.setInterestDividentAnuityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName())) {
                form.setUnemploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName())) {
                form.setSocialSecurityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName())) {
                form.setMilitaryRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName())) {
                form.setRailroadRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName())) {
                form.setOtherRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName())) continue;
            form.setWorkersCompIncome(e.getAmount().toString());
        }
        for (Financial e : ftmt.getExpenses().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Expense)e).getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getName())) {
                form.setEducationExpense(e.getAmount().toString());
            }
            if (StringUtils.equals((String)((Expense)e).getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL.getName())) {
                form.setNonReimbMedicalExpense(e.getAmount().toString());
            }
            if (StringUtils.equals((String)((Expense)e).getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName())) {
                form.setFuneralBurialExpense(e.getAmount().toString());
            }
            if (!StringUtils.equals((String)((Expense)e).getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName())) continue;
            form.setAdjustedMedicalExpense(e.getAmount().toString());
        }
        for (Financial e : ftmt.getAssets().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_CASH.getName())) {
                form.setCashAndBankAccountAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_REAL_ESTATE.getName())) {
                form.setRealPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_OTHER.getName())) {
                form.setOtherPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_STOCKS_AND_BONDS.getName())) continue;
            form.setStocksAsset(e.getAmount().toString());
        }
        if (ftmt.getDebt() != null && ftmt.getDebt().getAmount() != null) {
            form.setDebt(ftmt.getDebt().getAmount().toString());
        }
    }

    private void convertDependentFinancialAmountsToBean(DependentFinancials ftmt, DependentFinancialInfoBean bean) {
        for (Financial e : ftmt.getIncome().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName())) {
                bean.setTotalEmploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName())) {
                bean.setOtherIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName())) {
                bean.setNetIncomeFromFarmRanchOrBusiness(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName())) {
                bean.setUSCivilServiceIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName())) {
                bean.setInterestDividentAnuityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName())) {
                bean.setUnemploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName())) {
                bean.setSocialSecurityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName())) {
                bean.setMilitaryRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName())) {
                bean.setRailroadRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName())) {
                bean.setOtherRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName())) continue;
            bean.setWorkersCompIncome(e.getAmount().toString());
        }
        for (Financial e : ftmt.getExpenses().values()) {
            if (e.getAmount() == null || !StringUtils.equals((String)((Expense)e).getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.getName())) continue;
            bean.setEducationExpense(e.getAmount().toString());
        }
        for (Financial e : ftmt.getAssets().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_CASH.getName())) {
                bean.setCashAndBankAccountAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_REAL_ESTATE.getName())) {
                bean.setRealPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_OTHER.getName())) {
                bean.setOtherPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_STOCKS_AND_BONDS.getName())) continue;
            bean.setStocksAsset(e.getAmount().toString());
        }
    }

    private void convertSpouseFinancialAmountsToBean(SpouseFinancials ftmt, SpouseFinancialInfoBean bean) throws Exception {
        for (Financial e : ftmt.getIncome().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName())) {
                bean.setTotalEmploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName())) {
                bean.setOtherIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName())) {
                bean.setNetIncomeFromFarmRanchOrBusiness(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName())) {
                bean.setUSCivilServiceIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName())) {
                bean.setInterestDividentAnuityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName())) {
                bean.setUnemploymentIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName())) {
                bean.setSocialSecurityIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName())) {
                bean.setMilitaryRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName())) {
                bean.setRailroadRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName())) {
                bean.setOtherRetirementIncome(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Income)e).getType().getCode(), (String)IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName())) continue;
            bean.setWorkersCompIncome(e.getAmount().toString());
        }
        for (Financial e : ftmt.getAssets().values()) {
            if (e.getAmount() == null) continue;
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_CASH.getName())) {
                bean.setCashAndBankAccountAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_REAL_ESTATE.getName())) {
                bean.setRealPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_OTHER.getName())) {
                bean.setOtherPropertyAsset(e.getAmount().toString());
                continue;
            }
            if (!StringUtils.equals((String)((Asset)e).getType().getCode(), (String)AssetType.CODE_STOCKS_AND_BONDS.getName())) continue;
            bean.setStocksAsset(e.getAmount().toString());
        }
        if (ftmt.getDebt() != null && ftmt.getDebt().getAmount() != null) {
            bean.setDebt(ftmt.getDebt().getAmount().toString());
        }
    }

    private void addSpouseToForm(int depIndex, FinancialDetailsForm form, SpouseFinancialInfoBean bean) {
        form.addSpouse();
        form.setSpouseActive(depIndex, bean.isActive() ? "true" : "false");
        form.setSpouseFinacialsId(depIndex, bean.getFinancialsId());
        form.setSpouseName(depIndex, bean.getName());
        form.setSpouseSSN(depIndex, bean.getSsn());
        form.setSpouseRelationshipCode(depIndex, bean.getRelationshipCode());
        form.setSpouseRelationship(depIndex, bean.getRelationship());
        form.setSpouseGenderCode(depIndex, bean.getGenderCode());
        form.setSpouseGender(depIndex, bean.getGender());
        form.setSpouseMarriageDate(depIndex, bean.getEffectiveDate());
        form.setSpouseValid(depIndex, bean.getValidDependent());
        form.setSpouseInactiveDate(depIndex, bean.getInactiveDate());
        form.setSpouseLivedWithPatient(depIndex, bean.getLivedWithVeteran());
        form.setSpouseContributedToSupport(depIndex, bean.getContributedToSupport());
        form.setSpouseTotalIncome(depIndex, bean.getTotalEmploymentIncome());
        form.setSpouseIncomeFromRanch(depIndex, bean.getNetIncomeFromFarmRanchOrBusiness());
        form.setSpouseOtherIncome(depIndex, bean.getOtherIncome());
        form.setSpouseEduExpenses(depIndex, bean.getEducationExpense());
        form.setSpouseCashAsset(depIndex, bean.getCashAndBankAccountAsset());
        form.setSpouseRealAsset(depIndex, bean.getRealPropertyAsset());
        form.setSpouseOtherAsset(depIndex, bean.getOtherPropertyAsset());
        form.setSpouseStocksAsset(depIndex, bean.getStocksAsset());
        form.setSpouseUSCivilServiceIncome(depIndex, bean.getUSCivilServiceIncome());
        form.setSpouseInterestDividentAnuityIncome(depIndex, bean.getInterestDividentAnuityIncome());
        form.setSpouseUnemploymentIncome(depIndex, bean.getUnemploymentIncome());
        form.setSpouseSocialSecurityIncome(depIndex, bean.getSocialSecurityIncome());
        form.setSpouseMilitaryRetirementIncome(depIndex, bean.getMilitaryRetirementIncome());
        form.setSpouseRailroadRetirementIncome(depIndex, bean.getRailroadRetirementIncome());
        form.setSpouseOtherRetirementIncome(depIndex, bean.getOtherRetirementIncome());
        form.setSpouseWorkersCompIncome(depIndex, bean.getWorkersCompIncome());
        form.setSpouseDisplaySSN(depIndex, bean.getDisplaySSN());
        form.setSpouseDebt(depIndex, bean.getDebt());
        form.setContributedToSpousalSupport(depIndex, bean.getContributedToSpouseInd());
    }

    private void addDependentToForm(int depIndex, FinancialDetailsForm form, DependentFinancialInfoBean bean) {
        form.addDependent();
        form.setDepFinacialsId(depIndex, bean.getFinancialsId());
        form.setDepName(depIndex, bean.getName());
        form.setDepSSN(depIndex, bean.getSsn());
        form.setDepRelationshipCode(depIndex, bean.getRelationshipCode());
        form.setDepRelationship(depIndex, bean.getRelationship());
        form.setDepGenderCode(depIndex, bean.getGenderCode());
        form.setDepGender(depIndex, bean.getGender());
        form.setDepEffectiveDate(depIndex, bean.getEffectiveDate());
        form.setDepValid(depIndex, bean.getValidDependent());
        form.setDepInactiveDate(depIndex, bean.getInactiveDate());
        form.setDepLivedWithPatient(depIndex, bean.getLivedWithVeteran());
        form.setDepContributedToSupport(depIndex, bean.getContributedToSupport());
        form.setDepAmtContributed(depIndex, bean.getAmtContributed());
        form.setDepHasIncome(depIndex, bean.getHasIncome());
        form.setDepIncomeAvailableToPatient(depIndex, bean.getIncomeAvailableToPatient());
        form.setDepAttendedSchool(depIndex, bean.getAttendedSchool());
        form.setDepIncapableOfSelfSupport(depIndex, bean.getIncapableOfSelfSupport());
        form.setDepTotalIncome(depIndex, bean.getTotalEmploymentIncome());
        form.setDepIncomeFromRanch(depIndex, bean.getNetIncomeFromFarmRanchOrBusiness());
        form.setDepOtherIncome(depIndex, bean.getOtherIncome());
        form.setDepEduExpenses(depIndex, bean.getEducationExpense());
        form.setDepCashAsset(depIndex, bean.getCashAndBankAccountAsset());
        form.setDepRealAsset(depIndex, bean.getRealPropertyAsset());
        form.setDepOtherAsset(depIndex, bean.getOtherPropertyAsset());
        form.setDepStocksAsset(depIndex, bean.getStocksAsset());
        form.setDepUSCivilServiceIncome(depIndex, bean.getUSCivilServiceIncome());
        form.setDepInterestDividentAnuityIncome(depIndex, bean.getInterestDividentAnuityIncome());
        form.setDepUnemploymentIncome(depIndex, bean.getUnemploymentIncome());
        form.setDepSocialSecurityIncome(depIndex, bean.getSocialSecurityIncome());
        form.setDepMilitaryRetirementIncome(depIndex, bean.getMilitaryRetirementIncome());
        form.setDepRailroadRetirementIncome(depIndex, bean.getRailroadRetirementIncome());
        form.setDepOtherRetirementIncome(depIndex, bean.getOtherRetirementIncome());
        form.setDepWorkersCompIncome(depIndex, bean.getWorkersCompIncome());
        form.setDepDisplaySSN(depIndex, bean.getDisplaySSN());
    }

    public List getDependentInfoList(FinancialStatement ftmt) throws Exception {
        ArrayList<RelationFinancialInfoBean> depInfoList = new ArrayList<RelationFinancialInfoBean>();
        Set spouseFinancials = ftmt.getSpouseFinancials();
        for (SpouseFinancials sf : spouseFinancials) {
            SpouseFinancialInfoBean sbean = new SpouseFinancialInfoBean();
            this.convertSpouseFinancialsToBean(sf, sbean);
            if (StringUtils.isEmpty((String)sbean.getDisplaySSN())) {
                sbean.setDisplaySSN("UNKNOWN");
            }
            depInfoList.add(sbean);
        }
        Set dependentFinancials = ftmt.getDependentFinancials();
        for (DependentFinancials df : dependentFinancials) {
            DependentFinancialInfoBean bean = new DependentFinancialInfoBean();
            this.convertDependentFinancialsToBean(df, bean);
            if (StringUtils.isEmpty((String)bean.getDisplaySSN())) {
                bean.setDisplaySSN("UNKNOWN");
            }
            depInfoList.add(bean);
        }
        return depInfoList;
    }

    public CommonFinancialsDependentConversionService getDependentConversionService() {
        return this.dependentConversionService;
    }

    public void setDependentConversionService(CommonFinancialsDependentConversionService dependentConversionService) {
        this.dependentConversionService = dependentConversionService;
    }

    public void convertSpouseFinancialsToBean(SpouseFinancials spFins, SpouseFinancialInfoBean bean) {
        this.getDependentConversionService().convertSpouseFinancialsToBean(spFins, bean);
    }

    public void convertDependentFinancialsToBean(DependentFinancials depFin, DependentFinancialInfoBean bean) {
        this.getDependentConversionService().convertDependentFinancialsToBean(depFin, bean);
    }
}

