/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.EligibilityFactorRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationFieldMessage;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import org.apache.commons.lang.Validate;

public class EligibilityFactorRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements EligibilityFactorRuleService {
    private static final long serialVersionUID = -314967322970039187L;
    public static final String DISABILITY_COMPENSATION_UNKNOWN_NOT_ALLOWED_KEY = "DISABILITY_COMPENSATION_UNKNOWN_NOT_ALLOWED";
    public static final String DISABILITY_COMPENSATION_FIELDNAME = "isReceivingCompensation";
    private String newVeteranRuleParameters = null;
    private String manageSpecialFactorsRuleParameters = null;
    private String processSpecialFactorsRuleParameters = null;
    private LookupService lookupService;

    @Override
    public void processMonetaryBenefitAward(MonetaryBenefitAward mb, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (mb != null) {
            MonetaryBenefitAward monetaryBenefitAward = onFile.getMonetaryBenefitAward();
            if (monetaryBenefitAward == null) {
                monetaryBenefitAward = new MonetaryBenefitAward();
                onFile.setMonetaryBenefitAward(monetaryBenefitAward);
            }
            this.getMergeRuleService().mergeMonetaryBenefitAward(mb, monetaryBenefitAward);
        } else {
            onFile.setMonetaryBenefitAward(null);
        }
    }

    @Override
    public void manageMonetaryBenefitAward(MonetaryBenefitAward mb, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (mb != null) {
            this.validateMonetaryBenefit(mb, onFile);
            MonetaryBenefitAward monetaryBenefitAward = onFile.getMonetaryBenefitAward();
            if (monetaryBenefitAward == null) {
                monetaryBenefitAward = new MonetaryBenefitAward();
                monetaryBenefitAward.setPerson(onFile);
                onFile.setMonetaryBenefitAward(monetaryBenefitAward);
            }
            this.getMergeRuleService().mergeMonetaryBenefitAward(mb, monetaryBenefitAward);
        } else {
            onFile.setMonetaryBenefitAward(null);
        }
    }

    @Override
    public void processServiceConnectionAward(ServiceConnectionAward sc, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (sc != null) {
            ServiceConnectionAward serviceConnectionAward = onFile.getServiceConnectionAward();
            if (serviceConnectionAward == null) {
                serviceConnectionAward = new ServiceConnectionAward();
                onFile.setServiceConnectionAward(serviceConnectionAward);
            }
            this.getMergeRuleService().mergeServiceConnectionAward(sc, serviceConnectionAward);
        } else {
            onFile.setServiceConnectionAward(null);
        }
    }

    @Override
    public void manageSpecialFactors(Person incoming, Person onFile) throws ServiceException {
        this.doProcessSpecialFactor(incoming, null, onFile, true);
    }

    @Override
    public void processSpecialFactors(Person incoming, VAFacility sendingFacility, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        this.doProcessSpecialFactor(incoming, sendingFacility, onFile, isUpdateFromGUI);
    }

    @Override
    public void manageEligibilityVerification(EligibilityVerification incoming, Person onFile) throws ServiceException {
        this.doProcessEligibilityVerification(incoming, onFile, true);
    }

    @Override
    public void processEligibilityVerification(EligibilityVerification incoming, Person onFile) throws ServiceException {
        this.doProcessEligibilityVerification(incoming, onFile, false);
    }

    private void doProcessEligibilityVerification(EligibilityVerification incoming, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            EligibilityVerification eligibilityVerification = onFile.getEligibilityVerification();
            if (eligibilityVerification == null) {
                eligibilityVerification = new EligibilityVerification();
                onFile.setEligibilityVerification(eligibilityVerification);
            }
            this.getMergeRuleService().mergeEligibilityVerification(incoming, eligibilityVerification);
            if (isUpdateFromGUI) {
                String statusCode;
                Person pristine = this.getPristinePerson(onFile);
                EligibilityVerification pristineEligibilityVerification = pristine != null ? pristine.getEligibilityVerification() : null;
                String pristineStatusCode = pristineEligibilityVerification != null && pristineEligibilityVerification.getEligibilityStatus() != null ? pristineEligibilityVerification.getEligibilityStatus().getCode() : null;
                String string = statusCode = incoming.getEligibilityStatus() != null ? incoming.getEligibilityStatus().getCode() : null;
                if (statusCode != null && !statusCode.equals(pristineStatusCode)) {
                    eligibilityVerification.setAacIndicator(this.getLookupService().getAACIndicatorByCode(AACIndicator.CODE_DATA_ACCEPTED.getCode()));
                }
            }
        } else {
            onFile.setEligibilityVerification(null);
        }
    }

    @Override
    public void processIncompetenceRuling(IncompetenceRuling incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        this.getMergeRuleService().mergeIncompetenceRuling(incoming, onFile);
    }

    @Override
    public void manageEnrollmentOverride(EnrollmentOverride incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            Person pristine = this.getPristinePerson(onFile);
            ValidationMessages messages = this.getRuleValidationService().validateReceivedEnrollment(incoming.getPerson(), onFile, pristine, true);
            if (messages != null && !messages.isEmpty()) {
                throw new ValidationServiceException(messages);
            }
            EnrollmentOverride enrollmentOverride = onFile.getEnrollmentOverride();
            if (enrollmentOverride == null) {
                enrollmentOverride = new EnrollmentOverride();
                onFile.setEnrollmentOverride(enrollmentOverride);
            }
            this.getMergeRuleService().mergeEnrollmentOverride(incoming, enrollmentOverride);
        } else {
            onFile.setEnrollmentOverride(null);
        }
    }

    @Override
    public void manageNewVeteranFromAddPerson(Person incoming, Person onFile) throws ServiceException {
        this.doProcessNewVeteran(incoming, onFile, true);
    }

    @Override
    public void processNewVeteran(Person incoming, Person onFile) throws ServiceException {
        this.doProcessNewVeteran(incoming, onFile, false);
    }

    @Override
    public void processEmergencyResponseIndicator(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        this.getMergeRuleService().mergeEmergencyResponseIndicator(incoming, onFile);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.newVeteranRuleParameters, (String)"newVeteranRuleParameters property is required");
        Validate.notNull((Object)this.manageSpecialFactorsRuleParameters, (String)"manageSpecialFactorsRuleParameters property is required");
        Validate.notNull((Object)this.processSpecialFactorsRuleParameters, (String)"processSpecialFactorsRuleParameters property is required");
    }

    public String getNewVeteranRuleParameters() {
        return this.newVeteranRuleParameters;
    }

    public void setNewVeteranRuleParameters(String newVeteranRuleParameters) {
        this.newVeteranRuleParameters = newVeteranRuleParameters;
    }

    public String getManageSpecialFactorsRuleParameters() {
        return this.manageSpecialFactorsRuleParameters;
    }

    public void setManageSpecialFactorsRuleParameters(String manageSpecialFactorsRuleParameters) {
        this.manageSpecialFactorsRuleParameters = manageSpecialFactorsRuleParameters;
    }

    public String getProcessSpecialFactorsRuleParameters() {
        return this.processSpecialFactorsRuleParameters;
    }

    public void setProcessSpecialFactorsRuleParameters(String processSpecialFactorsRuleParameters) {
        this.processSpecialFactorsRuleParameters = processSpecialFactorsRuleParameters;
    }

    private void doProcessNewVeteran(Person incoming, Person onFile, boolean isAddPerson) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine);
        data.setFromAddNewPerson(isAddPerson);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EligFactorRuleSvc doProcNewVet : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getNewVeteranRuleParameters()), (RuleDataAware)data);
    }

    private void doProcessSpecialFactor(Person incoming, VAFacility sendingFacility, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, sendingFacility, isUpdateFromGUI);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EligFactorRuleSvc doProcSpecFactor : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        if (isUpdateFromGUI) {
            this.invokeRuleFlow(this.getRuleParameters(this.getManageSpecialFactorsRuleParameters()), (RuleDataAware)data);
        } else {
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessSpecialFactorsRuleParameters()), (RuleDataAware)data);
        }
    }

    @Override
    public void processSpecialFactors(Person incoming, VAFacility sendingFacility, Person onFile, boolean isUpdateFromGUI, EEResultInfo clvInfo) throws ServiceException {
        this.doProcessSpecialFactor(incoming, sendingFacility, onFile, isUpdateFromGUI, clvInfo);
    }

    private void doProcessSpecialFactor(Person incoming, VAFacility sendingFacility, Person onFile, boolean isUpdateFromGUI, EEResultInfo clvInfo) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, sendingFacility, isUpdateFromGUI);
        data.setEEResultInfo(clvInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EligFactorRuleSvc doProcSpecFactor : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        if (isUpdateFromGUI) {
            this.invokeRuleFlow(this.getRuleParameters(this.getManageSpecialFactorsRuleParameters()), (RuleDataAware)data);
        } else {
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessSpecialFactorsRuleParameters()), (RuleDataAware)data);
        }
    }

    @Override
    public void validateMonetaryBenefit(MonetaryBenefitAward incomingMBA, Person onFile) throws ValidationServiceException {
        MonetaryBenefit incomingDC;
        Validate.notNull((Object)((Object)onFile), (String)"An on-file Person must not be null.");
        boolean error = false;
        boolean incomingIsUnknown = false;
        if (incomingMBA != null && (incomingDC = incomingMBA.getDisabilityCompensation()) != null && incomingDC.getMonetaryBenefitIndicator() != null && incomingDC.getMonetaryBenefitIndicator().getCode().equals(Indicator.UNKOWN.getCode())) {
            incomingIsUnknown = true;
        }
        if (incomingIsUnknown) {
            MonetaryBenefit onfileDC;
            MonetaryBenefitAward onfileMBA = onFile.getMonetaryBenefitAward();
            MonetaryBenefit monetaryBenefit = onfileDC = onfileMBA != null ? onfileMBA.getDisabilityCompensation() : null;
            if (onfileDC == null || onfileDC.getMonetaryBenefitIndicator() != null && !onfileDC.getMonetaryBenefitIndicator().getCode().equals(Indicator.UNKOWN.getCode())) {
                error = true;
            }
        }
        if (error) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add((ValidationMessage)new ValidationFieldMessage(DISABILITY_COMPENSATION_FIELDNAME, DISABILITY_COMPENSATION_UNKNOWN_NOT_ALLOWED_KEY));
            throw new ValidationServiceException(validationMessages);
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

