/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.rule.data.ExternalSystemsInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.data.SSNVerificationResponseInputData;
import gov.va.med.esr.common.rule.service.DemographicRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class DemographicRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements DemographicRuleService {
    private static final long serialVersionUID = -8898454511019380373L;
    private String manageDemographicRuleParameters = null;
    private String processDemographicRuleParameters = null;
    private String processExternalServicesRuleParameters = null;
    private String processSSNVerificationResponseRuleParameters = null;
    private String manageIdentityTraitsRuleParameters = null;
    private LookupService lookupService;

    @Override
    public Person manageDemographicInfo(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran incoming must not be null");
        ValidationMessages messages = this.getRuleValidationService().validateDemographic(incoming, true);
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService manageDemInfo : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getManageDemographicRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, true));
        return onFile;
    }

    @Override
    public void processDemographicInfo(VAFacility sendingFacility, Person incoming, Person onFile, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran incoming must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService processDemInfo : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getProcessDemographicRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, sendingFacility, isDataFromGUI));
    }

    @Override
    public void processDemographicInfo(VAFacility sendingFacility, Person incoming, Person onFile, boolean isDataFromGUI, boolean isDataFromMVI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran incoming must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService processDemInfo : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getProcessDemographicRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, sendingFacility, isDataFromGUI, isDataFromMVI));
    }

    @Override
    public void processDemographicInfo(VAFacility sendingFacility, Person incoming, Person onFile, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran incoming must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService processDemInfo : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getProcessDemographicRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, sendingFacility, verificationInfo));
    }

    @Override
    public void processSocialSecurityInfo(Set ssn, Person onFile) throws ServiceException {
    }

    @Override
    public void manageIdentityTraits(Person incoming, Person onFile) throws ServiceException {
        ValidationMessages messages = this.getRuleValidationService().validateIdentityTraits(incoming, true);
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService manageIdtraits : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getManageIdentityTraitsRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, true));
    }

    @Override
    public void processSocialSecurityInfo(SSN ssn, Person onFile) throws ServiceException {
    }

    @Override
    public void processSSNVerificationResponse(SSASSNVerificationData incoming, Person result, SSASSNVerificationData resultSSNVerificationData, Relation relation) throws ServiceException {
        Person pristine;
        Validate.notNull((Object)"Incoming SSASSNVerificationData cannot be null");
        Person person = pristine = result != null ? this.getPristinePerson(result) : null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicoRuleService processSSNResponse : incoming" + (Object)((Object)incoming) + " person: " + (Object)((Object)result)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getProcessSSNVerificationResponseRuleParameters()), (RuleDataAware)new SSNVerificationResponseInputData(incoming, result, pristine, resultSSNVerificationData, relation));
    }

    @Override
    public void processExternalDemographicChanges(Set changes, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        for (DemographicsChangeEvent demographicsChangeEvent : changes) {
            ExternalSystemsInputData data = new ExternalSystemsInputData(onFile, demographicsChangeEvent);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessExternalServicesRuleParameters()), (RuleDataAware)data);
        }
    }

    @Override
    public void attachDeathRecordFromIdm(Person incoming, Date dateOfDeath) throws ServiceException {
        DeathRecord deathRecord = incoming.getDeathRecord();
        if (deathRecord == null) {
            deathRecord = new DeathRecord();
            incoming.setDeathRecord(deathRecord);
        }
        incoming.getDeathRecord().setDeathDate(ImpreciseDateUtils.createImpreciseDateWithoutTime(dateOfDeath));
        incoming.getDeathRecord().setDeathReportDate(this.getTransactionDate());
        incoming.getDeathRecord().setLazarusDate(null);
        incoming.getDeathRecord().setDataSource(this.getLookupService().getDeathDataSourceByCode(DeathDataSource.CODE_DEATH_CERT_ON_FILE.getCode()));
        incoming.getDeathRecord().setFacilityReceived(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.manageDemographicRuleParameters, (String)"manageDemographicRuleParameters property is required");
        Validate.notNull((Object)this.processDemographicRuleParameters, (String)"processDemographicRuleParameters property is required");
        Validate.notNull((Object)this.processExternalServicesRuleParameters, (String)"processExternalServicesRuleParameters property is required");
    }

    public String getManageDemographicRuleParameters() {
        return this.manageDemographicRuleParameters;
    }

    public void setManageDemographicRuleParameters(String manageDemographicRuleParameters) {
        this.manageDemographicRuleParameters = manageDemographicRuleParameters;
    }

    public String getProcessDemographicRuleParameters() {
        return this.processDemographicRuleParameters;
    }

    public void setProcessDemographicRuleParameters(String processDemographicRuleParameters) {
        this.processDemographicRuleParameters = processDemographicRuleParameters;
    }

    public String getProcessExternalServicesRuleParameters() {
        return this.processExternalServicesRuleParameters;
    }

    public void setProcessExternalServicesRuleParameters(String processExternalServicesRuleParameters) {
        this.processExternalServicesRuleParameters = processExternalServicesRuleParameters;
    }

    public String getProcessSSNVerificationResponseRuleParameters() {
        return this.processSSNVerificationResponseRuleParameters;
    }

    public void setProcessSSNVerificationResponseRuleParameters(String processSSNVerificationResponseRuleParameters) {
        this.processSSNVerificationResponseRuleParameters = processSSNVerificationResponseRuleParameters;
    }

    public String getManageIdentityTraitsRuleParameters() {
        return this.manageIdentityTraitsRuleParameters;
    }

    public void setManageIdentityTraitsRuleParameters(String manageIdentityTraitsRuleParameters) {
        this.manageIdentityTraitsRuleParameters = manageIdentityTraitsRuleParameters;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

