/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.HandBookMailQueueDAO;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.service.CommunicationRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonLockedException;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

public class CommunicationRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements CommunicationRuleService {
    private static final long serialVersionUID = 112127217356394622L;
    private String handleUndeliverableMailRuleParameters = null;
    private String manageCommunicationsLogRuleParameters = null;
    private String triggerAutomaticLettersRuleParameters = null;
    private String processMailResponsesRuleParameters = null;
    private CommsLogEntryDAO commsLogEntryDAO = null;
    private HandBookMailQueueDAO handBookMailQueueDAO = null;
    private String demographicServiceName = null;
    private String handBookServiceName = null;
    private BeanFactory beanFactory;
    private LookupService lookupService;

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @Override
    public void handleUndeliverableMail(List commsLogEntries) throws ServiceException {
        if (commsLogEntries != null && commsLogEntries.size() > 0) {
            for (CommsLogEntry incoming : commsLogEntries) {
                CommsLogEntry onFile = null;
                try {
                    onFile = (CommsLogEntry)((Object)this.getCommsLogEntryDAO().getByKey(incoming.getEntityKey()));
                }
                catch (DAOException e) {
                    throw new ServiceException("Failed to find comms log", (Throwable)e);
                }
                this.doProcessCommsRules(this.getRuleParameters(this.getHandleUndeliverableMailRuleParameters()), incoming, onFile);
            }
        }
    }

    @Override
    public void handleUndeliverableHandbook(HandBookMailQueue incoming) throws ServiceException {
        if (incoming != null) {
            HandBookMailQueue onFile = null;
            try {
                onFile = (HandBookMailQueue)((Object)this.getHandBookMailQueueDAO().getByKey(incoming.getEntityKey()));
            }
            catch (DAOException e) {
                throw new ServiceException("Failed to find HandBookMailQueue", (Throwable)e);
            }
            this.doProcessCommsRules(this.getRuleParameters(this.getHandleUndeliverableMailRuleParameters()), incoming, onFile);
        }
    }

    @Override
    public ValidationMessages processLetterSendRequest(Person person, ComLetterTemplateType formNumber, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, List logs, String categoryType) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"The person must not be null");
        Validate.notNull((Object)((Object)formNumber), (String)"The formNumber must not be null");
        Validate.notNull((Object)((Object)mailType), (String)"The mailType must not be null");
        return this.getRuleValidationService().validateLetterSendRequest(person, formNumber, workflowCaseId, mailType, override, logs, categoryType, null);
    }

    @Override
    public void manageCommunicationsLog(CommsLogEntry incoming, CommsLogEntry onFile) throws ServiceException {
        this.doProcessCommsRules(this.getRuleParameters(this.getManageCommunicationsLogRuleParameters()), incoming, onFile, false);
    }

    @Override
    public void triggerAutomaticLetters(Person person, Integer incomeYear, boolean reviewOnly, Clock.Type clockType) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"person must not be null");
        Person pristine = this.getPristinePerson(person);
        CommsInputData data = new CommsInputData(person, pristine);
        data.setReviewOnly(reviewOnly);
        data.setIncomeYearForCurrentTest(incomeYear);
        data.setFiredClockType(clockType);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerAutomaticLettersRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void triggerAutomaticLetters(Person person, Clock.Type clockType, String subject) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"person must not be null");
        Person pristine = this.getPristinePerson(person);
        CommsInputData data = new CommsInputData(person, pristine);
        data.setReviewOnly(false);
        data.setFiredClockType(clockType);
        data.setSubject(subject);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerAutomaticLettersRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void triggerAutomaticLetters(Person person, IVMFinancialInfo info) throws ServiceException {
        this.doTriggerAutomaticLetters(person, null, false, null, null, info, "IVM_FINAL_LETTERS");
    }

    private void doTriggerAutomaticLetters(Person person, Integer incomeYear, boolean reviewOnly, Clock.Type clockType, String subject, IVMFinancialInfo info, String useCaseName) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"person must not be null");
        Person pristine = this.getPristinePerson(person);
        CommsInputData data = new CommsInputData(person, pristine);
        data.setReviewOnly(reviewOnly);
        data.setIncomeYearForCurrentTest(incomeYear);
        data.setFiredClockType(clockType);
        data.setSubject(subject);
        data.setIvmFinancialInfo(info);
        data.setUseCaseName(useCaseName);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerAutomaticLettersRuleParameters()), (RuleDataAware)data);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void handleMailingResponses(List responses) {
        if (responses != null && responses.size() > 0) {
            for (CommsLogEntry incoming : responses) {
                CommsLogEntry onFile = null;
                try {
                    onFile = (CommsLogEntry)((Object)this.getCommsLogEntryDAO().getByKey(incoming.getEntityKey()));
                    this.doProcessCommsRules(this.getRuleParameters(this.getProcessMailResponsesRuleParameters()), incoming, onFile);
                }
                catch (DAOException e) {
                    this.logger.error((Object)("Failed to find comms log: " + incoming.getCommsLogIdString()), (Throwable)e);
                }
                catch (PersonLockedException ex) {
                    this.logger.error((Object)("Failed to handleMailingResponses for CommsLogEntry id=" + incoming.getCommsLogIdString() + " because received a PersonLockedException"));
                }
                catch (ServiceException ex) {
                    this.logger.error((Object)("Failed to handleMailingResponses for CommsLogEntry id=" + incoming.getCommsLogIdString()), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void handleMailingResponses(CommsLogEntry incoming) {
        if (incoming != null) {
            CommsLogEntry onFile = null;
            try {
                onFile = (CommsLogEntry)((Object)this.getCommsLogEntryDAO().getByKey(incoming.getEntityKey()));
                this.doProcessCommsRules(this.getRuleParameters(this.getProcessMailResponsesRuleParameters()), incoming, onFile);
            }
            catch (DAOException e) {
                this.logger.error((Object)("Failed to find comms log: " + incoming.getCommsLogIdString()), (Throwable)e);
            }
            catch (PersonLockedException ex) {
                this.logger.error((Object)("Failed to handleMailingResponses for CommsLogEntry id=" + incoming.getCommsLogIdString() + " because received a PersonLockedException"));
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("Failed to handleMailingResponses for CommsLogEntry id=" + incoming.getCommsLogIdString()), (Throwable)ex);
            }
        }
    }

    @Override
    public void handleHandbookMailingResponse(HandBookMailQueue incoming) throws ServiceException {
        if (incoming != null) {
            HandBookMailQueue onFile = null;
            try {
                onFile = (HandBookMailQueue)((Object)this.getHandBookMailQueueDAO().getByKey(incoming.getEntityKey()));
                this.doProcessCommsRules(this.getRuleParameters(this.getProcessMailResponsesRuleParameters()), incoming, onFile);
            }
            catch (DAOException e) {
                this.logger.error((Object)("Failed to find handbookMailQueue: " + incoming.getId()), (Throwable)e);
            }
            catch (PersonLockedException ex) {
                this.logger.error((Object)("Failed to handleHandbookMailingResponse for HandBookMailQueue id=" + incoming.getId() + " because received a PersonLockedException"));
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("Failed to handleHandbookMailingResponse for HandBookMailQueue id=" + incoming.getId()), (Throwable)ex);
            }
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.handleUndeliverableMailRuleParameters, (String)"handleUndeliverableMailRuleParameters property is required");
        Validate.notNull((Object)this.manageCommunicationsLogRuleParameters, (String)"manageCommunicationsLogRuleParameters property is required");
        Validate.notNull((Object)this.triggerAutomaticLettersRuleParameters, (String)"triggerAutomaticLettersRuleParameters property is required");
        Validate.notNull((Object)this.processMailResponsesRuleParameters, (String)"processMailResponsesRuleParameters property is required");
    }

    public String getHandleUndeliverableMailRuleParameters() {
        return this.handleUndeliverableMailRuleParameters;
    }

    public void setHandleUndeliverableMailRuleParameters(String handleUndeliverableMailRuleParameters) {
        this.handleUndeliverableMailRuleParameters = handleUndeliverableMailRuleParameters;
    }

    public String getManageCommunicationsLogRuleParameters() {
        return this.manageCommunicationsLogRuleParameters;
    }

    public void setManageCommunicationsLogRuleParameters(String manageCommunicationsLogRuleParameters) {
        this.manageCommunicationsLogRuleParameters = manageCommunicationsLogRuleParameters;
    }

    public String getTriggerAutomaticLettersRuleParameters() {
        return this.triggerAutomaticLettersRuleParameters;
    }

    public void setTriggerAutomaticLettersRuleParameters(String triggerAutomaticLettersRuleParameters) {
        this.triggerAutomaticLettersRuleParameters = triggerAutomaticLettersRuleParameters;
    }

    public String getProcessMailResponsesRuleParameters() {
        return this.processMailResponsesRuleParameters;
    }

    public void setProcessMailResponsesRuleParameters(String processMailResponsesRuleParameters) {
        this.processMailResponsesRuleParameters = processMailResponsesRuleParameters;
    }

    private void doProcessCommsRules(RuleParameters parameters, CommsLogEntry incoming, CommsLogEntry onFile, boolean overrideRequest) throws ServiceException {
        CommsInputData data = this.createCommsInputData(incoming, onFile);
        data.setOverrideRequest(overrideRequest);
        CommsLogEntry pristine = null;
        if (incoming.getEntityKey() != null) {
            try {
                pristine = (CommsLogEntry)((Object)this.getCommsLogEntryDAO().getByKey(incoming.getEntityKey()));
            }
            catch (DAOException e) {
                throw new ServiceException("Failed to find comms log", (Throwable)e);
            }
        } else {
            pristine = (CommsLogEntry)((Object)incoming.clone());
        }
        data.setPristineCommsLogEntry(pristine);
        this.invokeRuleFlow(parameters, (RuleDataAware)data);
    }

    private void doProcessCommsRules(RuleParameters parameters, CommsLogEntry incoming, CommsLogEntry onFile) throws ServiceException {
        CommsInputData data = this.createCommsInputData(incoming, onFile);
        this.invokeRuleFlow(parameters, (RuleDataAware)data);
        try {
            this.getCommsLogEntryDAO().update(onFile);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to update comms log", (Throwable)e);
        }
        if (data.isAddressChanged()) {
            this.getPersonService().save((Person)data.getResultData());
        }
    }

    private CommsInputData createCommsInputData(CommsLogEntry incoming, CommsLogEntry onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"The incoming log entry must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"The onFile log entry must not be null");
        Validate.notNull((Object)incoming.getPersonId(), (String)"The person id must not be null");
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(incoming.getPersonId().toString()));
        Address updatedMailingAddress = ((DemographicService)this.getComponent(this.getDemographicServiceName())).getUpdatedLetterAddress(incoming);
        Address mailingAddress = ((DemographicService)this.getComponent(this.getDemographicServiceName())).getLetterAddress(person);
        Validate.notNull((Object)((Object)person), (String)"The person must not be null");
        return new CommsInputData(person, incoming, onFile, mailingAddress, updatedMailingAddress);
    }

    private void doProcessCommsRules(RuleParameters parameters, HandBookMailQueue incoming, HandBookMailQueue onFile) throws ServiceException {
        CommsInputData data = this.createCommsInputData(incoming, onFile);
        this.invokeRuleFlow(parameters, (RuleDataAware)data);
        try {
            this.getHandBookMailQueueDAO().update(onFile);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to update comms log", (Throwable)e);
        }
        if (data.isAddressChanged()) {
            this.getPersonService().save((Person)data.getResultData());
        }
    }

    private CommsInputData createCommsInputData(HandBookMailQueue incoming, HandBookMailQueue onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"The incoming handbookMailQueue must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"The onFile handbookMailQueue must not be null");
        Validate.notNull((Object)incoming.getPersonId(), (String)"The person id must not be null");
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(incoming.getPersonId().toString()));
        Address handbookAddress = ((HandBookService)this.getComponent(this.getHandBookServiceName())).getHandBookMailingAddress(incoming);
        incoming.setAddress(handbookAddress);
        Address updatedMailingAddress = ((DemographicService)this.getComponent(this.getDemographicServiceName())).getUpdatedLetterAddress(incoming);
        Address mailingAddress = ((DemographicService)this.getComponent(this.getDemographicServiceName())).getLetterAddress(person);
        Validate.notNull((Object)((Object)person), (String)"The person must not be null");
        return new CommsInputData(person, incoming, onFile, mailingAddress, updatedMailingAddress);
    }

    public CommsLogEntryDAO getCommsLogEntryDAO() {
        return this.commsLogEntryDAO;
    }

    public void setCommsLogEntryDAO(CommsLogEntryDAO commsLogEntryDAO) {
        this.commsLogEntryDAO = commsLogEntryDAO;
    }

    public HandBookMailQueueDAO getHandBookMailQueueDAO() {
        return this.handBookMailQueueDAO;
    }

    public void setHandBookMailQueueDAO(HandBookMailQueueDAO handBookMailQueueDAO) {
        this.handBookMailQueueDAO = handBookMailQueueDAO;
    }

    public String getDemographicServiceName() {
        return this.demographicServiceName;
    }

    public void setDemographicServiceName(String demographicServiceName) {
        this.demographicServiceName = demographicServiceName;
    }

    public String getHandBookServiceName() {
        return this.handBookServiceName;
    }

    public void setHandBookServiceName(String handBookServiceName) {
        this.handBookServiceName = handBookServiceName;
    }
}

