/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.SpecialFactorInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class SpecialFactorInputParameter
extends BaseParameter
implements SpecialFactorInput {
    private static final long serialVersionUID = -1946680451967672718L;
    private static final String CL_ERROR_REASON_NOT_SUPPORT = "ES data on file does not support CL eligibility.";
    private static final String CL_ERROR_REASON_UPDATE_INELIGIBLE = "ES CL eligibility updated with CLEAR ineligibility.";
    private static final String VOA_CLE_CANNOT_BE_DETERMINED = "Veteran CL Eligibility cannot be determined";

    @Override
    public boolean isPartOfShadFile() {
        return this.getIncomingPerson().getShad() != null && this.getIncomingPerson().getShad().getShadIndicator() != null && this.getIncomingPerson().getShad().getShadIndicator().toBoolean() != null ? this.getIncomingPerson().getShad().getShadIndicator().toBoolean() : false;
    }

    @Override
    public boolean isPartOfShadFile(Person person) {
        return person != null && person.getShad() != null && person.getShad().getShadIndicator() != null && person.getShad().getShadIndicator().toBoolean() != null ? person.getShad().getShadIndicator().toBoolean() : false;
    }

    @Override
    public AgentOrangeExposure getAgentOrangeExposure() {
        return (AgentOrangeExposure)this.getSpecialFactor(AgentOrangeExposure.class, this.getIncomingPerson());
    }

    @Override
    public void setResultAgentOrangeExposure(AgentOrangeExposure exposure) throws RuleException {
        if (exposure == null) {
            try {
                AgentOrangeExposure aoe = this.getResultPerson().getAgentOrangeExposure();
                if (aoe != null) {
                    Indicator ind = (Indicator)this.getLookupService().getByCode(Indicator.class, Indicator.NO.getCode());
                    aoe.setAgentOrangeExposureIndicator(ind);
                    aoe.setLocation(null);
                }
            }
            catch (Exception ex) {
                new RuleException("Indicator code NO not found", (Throwable)ex);
            }
        } else {
            try {
                String ind = exposure.getLocation() != null ? Indicator.YES.getCode() : Indicator.NO.getCode();
                Indicator indicator = (Indicator)this.getLookupService().getByCode(Indicator.class, ind);
                exposure.setAgentOrangeExposureIndicator(indicator);
            }
            catch (Exception ex) {
                new RuleException("Indicator code NO not found", (Throwable)ex);
            }
            this.updateSpecialFactor(exposure, this.getResultPerson());
        }
    }

    @Override
    public EnvironmentalContaminationExposure getEnvironmentalContaminationExposure() {
        return (EnvironmentalContaminationExposure)this.getSpecialFactor(EnvironmentalContaminationExposure.class, this.getIncomingPerson());
    }

    @Override
    public void setResultEnvironmentalContaminants(EnvironmentalContaminationExposure exposure) throws RuleException {
        if (exposure == null) {
            try {
                EnvironmentalContaminationExposure envc = this.getResultPerson().getEnvironmentalContaminationExposure();
                if (envc != null) {
                    Indicator ind = (Indicator)this.getLookupService().getByCode(Indicator.class, Indicator.NO.getCode());
                    envc.setEnvironmentalContaminationExposureIndicator(ind);
                }
            }
            catch (Exception ex) {
                new RuleException("Indicator code NO not found", (Throwable)ex);
            }
        } else {
            this.updateSpecialFactor(exposure, this.getResultPerson());
        }
    }

    @Override
    public RadiationExposure getRadiationExposure() {
        return (RadiationExposure)this.getSpecialFactor(RadiationExposure.class, this.getIncomingPerson());
    }

    @Override
    public void setResultRadiationExposure(RadiationExposure exposure) throws RuleException {
        if (exposure == null) {
            try {
                RadiationExposure rad = this.getResultPerson().getRadiationExposure();
                if (rad != null) {
                    Indicator ind = (Indicator)this.getLookupService().getByCode(Indicator.class, Indicator.NO.getCode());
                    rad.setRadiationExposureIndicator(ind);
                    rad.setExposureMethod(null);
                }
            }
            catch (Exception ex) {
                new RuleException("Indicator code NO not found", (Throwable)ex);
            }
        } else {
            try {
                String ind = exposure.getExposureMethod() != null ? Indicator.YES.getCode() : Indicator.NO.getCode();
                Indicator indicator = (Indicator)this.getLookupService().getByCode(Indicator.class, ind);
                exposure.setRadiationExposureIndicator(indicator);
            }
            catch (Exception ex) {
                new RuleException("Indicator code NO not found", (Throwable)ex);
            }
            this.updateSpecialFactor(exposure, this.getResultPerson());
        }
    }

    @Override
    public AgentOrangeExposureLocation getAgentOrangeLocation() {
        AgentOrangeExposure agentorange = this.getAgentOrangeExposure();
        return agentorange != null ? agentorange.getLocation() : null;
    }

    @Override
    public void setResultAgentOrangeLocation(AgentOrangeExposureLocation location) {
        Person onFile = this.getResultPerson();
        AgentOrangeExposure exposure = this.getResultAgentOrange();
        if (exposure == null) {
            exposure = new AgentOrangeExposure();
            onFile.addSpecialFactor(exposure);
        }
        exposure.setLocation(location);
    }

    @Override
    public RadiationExposureMethod getRadiationExposureMethod() {
        RadiationExposure exposure = this.getRadiationExposure();
        return exposure != null ? exposure.getExposureMethod() : null;
    }

    @Override
    public void setResultRadiationExposureMethod(RadiationExposureMethod method) {
        Person onFile = this.getResultPerson();
        RadiationExposure exposure = this.getResultRadiationExposure();
        if (exposure == null) {
            exposure = new RadiationExposure();
            onFile.addSpecialFactor(exposure);
        }
        exposure.setExposureMethod(method);
    }

    @Override
    public AgentOrangeExposure getPristineAgentOrange() {
        return (AgentOrangeExposure)this.getSpecialFactor(AgentOrangeExposure.class, this.getPristinePerson());
    }

    @Override
    public AgentOrangeExposureLocation getPristineAgentOrangeLocation() {
        AgentOrangeExposure agentorange = this.getPristineAgentOrange();
        return agentorange != null ? agentorange.getLocation() : null;
    }

    @Override
    public RadiationExposure getPristineRadiationExposure() {
        return (RadiationExposure)this.getSpecialFactor(RadiationExposure.class, this.getPristinePerson());
    }

    @Override
    public RadiationExposureMethod getPristineRadiationExposureMethod() {
        RadiationExposure exposure = this.getPristineRadiationExposure();
        return exposure != null ? exposure.getExposureMethod() : null;
    }

    @Override
    public AgentOrangeExposure getResultAgentOrange() {
        return (AgentOrangeExposure)this.getSpecialFactor(AgentOrangeExposure.class, this.getResultPerson());
    }

    @Override
    public AgentOrangeExposureLocation getResultAgentOrangeLocation() {
        return this.getResultAgentOrange() != null ? this.getResultAgentOrange().getLocation() : null;
    }

    @Override
    public RadiationExposure getResultRadiationExposure() {
        return (RadiationExposure)this.getSpecialFactor(RadiationExposure.class, this.getResultPerson());
    }

    @Override
    public RadiationExposureMethod getResultRadiationExposureMethod() {
        return this.getResultRadiationExposure() != null ? this.getResultRadiationExposure().getExposureMethod() : null;
    }

    @Override
    public Boolean getAgentOrangeExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getIncomingPerson().getAgentOrangeExposure());
    }

    @Override
    public Boolean getEnvironmentalContaminationExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getIncomingPerson().getEnvironmentalContaminationExposure());
    }

    @Override
    public Boolean getPristineAgentOrangeIndicator() {
        return this.convertSFIndicatorToBoolean(this.getPristinePerson().getAgentOrangeExposure());
    }

    @Override
    public Boolean getPristineRadiationExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getPristinePerson().getRadiationExposure());
    }

    @Override
    public Boolean getPristineEnvironmentalContaminationExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getPristinePerson().getEnvironmentalContaminationExposure());
    }

    @Override
    public Boolean getRadiationExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getIncomingPerson().getRadiationExposure());
    }

    @Override
    public Boolean getResultAgentOrangeIndicator() {
        return this.convertSFIndicatorToBoolean(this.getResultPerson().getAgentOrangeExposure());
    }

    @Override
    public Boolean getResultRadiationExposureIndicator() {
        return this.convertSFIndicatorToBoolean(this.getResultPerson().getRadiationExposure());
    }

    private void updateSpecialFactor(SpecialFactor factor, Person person) throws RuleException {
        Validate.notNull((Object)((Object)factor), (String)"A special factor cannot be null");
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        try {
            this.getMergeRuleService().mergeSpecialFactor(factor, person);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to update special factor", (Throwable)e);
        }
    }

    private Boolean convertSFIndicatorToBoolean(SpecialFactor sf) {
        return sf != null && sf.getSpecialFactorIndicator() != null ? sf.getSpecialFactorIndicator().toBoolean() : null;
    }

    private SpecialFactor getSpecialFactor(Class type, Person person) {
        Validate.notNull((Object)type, (String)"A special factor class type must not be null");
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        return person.getSpecialFactorByType(type);
    }

    @Override
    public Boolean getAOTreatmentAuthorityIndicator() throws ServiceException {
        return this.getSystemParameterService().getAOTreatmentAuthorityIndicator();
    }

    @Override
    public Date getAOTreatmentAuthorityExpirationDate() throws ServiceException {
        return this.getSystemParameterService().getAOTreatmentAuthorityExpirationDate();
    }

    @Override
    public Boolean getECTreamentAuthorityIndicator() throws ServiceException {
        return this.getSystemParameterService().getECTreamentAuthorityIndicator();
    }

    @Override
    public Date getECTreatmentAuthorityExpirationDate() throws ServiceException {
        return this.getSystemParameterService().getECTreatmentAuthorityExpirationDate();
    }

    @Override
    public boolean isRadiationExposureMethodChnged() {
        RadiationExposureMethod resultREM;
        RadiationExposureMethod pristinREM = this.getPristineRadiationExposureMethod();
        return !this.isEqual((Object)pristinREM, (Object)(resultREM = this.getResultRadiationExposureMethod()));
    }

    @Override
    public boolean isAgentOrangeLocationChnged() {
        AgentOrangeExposureLocation resultAgentOrangeLocation;
        AgentOrangeExposureLocation pristineAgentOrangeLocation = this.getPristineAgentOrangeLocation();
        return !this.isEqual((Object)pristineAgentOrangeLocation, (Object)(resultAgentOrangeLocation = this.getResultAgentOrangeLocation()));
    }

    @Override
    public CampLejeuneVerification getCampLejeuneVerification() {
        return (CampLejeuneVerification)this.getSpecialFactor(CampLejeuneVerification.class, this.getIncomingPerson());
    }

    @Override
    public CampLejeuneVerification getPristineCampLejeuneVerification() {
        return (CampLejeuneVerification)this.getSpecialFactor(CampLejeuneVerification.class, this.getPristinePerson());
    }

    @Override
    public CampLejeuneVerification getResultCampLejeuneVerification() {
        return (CampLejeuneVerification)this.getSpecialFactor(CampLejeuneVerification.class, this.getResultPerson());
    }

    @Override
    public void setResultCampLejeuneVerification(CampLejeuneVerification clv) throws RuleException {
        if (clv != null) {
            this.updateSpecialFactor(clv, this.getResultPerson());
        }
    }

    @Override
    public void setErrorReasonNotSupport() {
        EEResultInfo info;
        EEResultInfo eEResultInfo = info = this.getBaseData() != null ? this.getBaseData().getEEResultInfo() : null;
        if (info != null) {
            info.setCLVErrorReason(CL_ERROR_REASON_NOT_SUPPORT);
        }
    }

    @Override
    public void setErrorReasonUpdatedIneligible() {
        EEResultInfo info;
        EEResultInfo eEResultInfo = info = this.getBaseData() != null ? this.getBaseData().getEEResultInfo() : null;
        if (info != null) {
            info.setCLVErrorReason(CL_ERROR_REASON_UPDATE_INELIGIBLE);
        }
    }

    @Override
    public void setErrorReasonVOACLENotDetermined() {
        EEResultInfo info;
        EEResultInfo eEResultInfo = info = this.getBaseData() != null ? this.getBaseData().getEEResultInfo() : null;
        if (info != null) {
            info.setCLVErrorReason(VOA_CLE_CANNOT_BE_DETERMINED);
        }
    }

    @Override
    public void setResultCampLejeuneVerificationForCLEAR(CampLejeuneVerification clv) throws RuleException {
        if (clv != null) {
            CampLejeuneVerification resultCLV = this.getResultCampLejeuneVerification();
            if (resultCLV != null && resultCLV.getSpecialFactorIndicator() != null) {
                ImpreciseDate outputDate = resultCLV.getRegistrationDate();
                ImpreciseDate incomingDate = clv.getRegistrationDate();
                if (outputDate != null) {
                    if (incomingDate != null && CommonDateUtils.isDateAfter(incomingDate, outputDate)) {
                        clv.setRegistrationDate(outputDate);
                    } else if (incomingDate == null) {
                        clv.setRegistrationDate(outputDate);
                    }
                } else {
                    clv.setRegistrationDate(new ImpreciseDate(new Date()));
                }
            }
            Indicator resultIndicator = resultCLV == null ? null : resultCLV.getSpecialFactorIndicator();
            this.updateSpecialFactor(clv, this.getResultPerson());
            this.getResultPerson().getCampLejeuneVerification().setSpecialFactorIndicator(resultIndicator);
        }
    }

    @Override
    public void setResultCampLejeuneVerificationForMS(CampLejeuneVerification clv) throws RuleException {
        if (!this.isIgnoreInOn() && clv != null) {
            this.updateSpecialFactor(clv, this.getResultPerson());
        }
    }

    @Override
    public Boolean getCampLejeuneIndicator() {
        return this.convertSFIndicatorToBoolean(this.getIncomingPerson().getCampLejeuneVerification());
    }

    @Override
    public Boolean getPristineCampLejeuneIndicator() {
        return this.convertSFIndicatorToBoolean(this.getPristinePerson().getCampLejeuneVerification());
    }

    @Override
    public Boolean getResultCampLejeuneIndicator() {
        return this.convertSFIndicatorToBoolean(this.getResultPerson().getCampLejeuneVerification());
    }

    @Override
    public void setResultCampLejeuneIndicator(Boolean id) throws RuleException {
        try {
            Person onFile = this.getResultPerson();
            CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
            if (clv == null) {
                clv = new CampLejeuneVerification();
                onFile.addSpecialFactor(clv);
            }
            if (id == null) {
                clv.setSpecialFactorIndicator(null);
            } else if (id.booleanValue()) {
                clv.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            } else {
                clv.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
            }
        }
        catch (Exception ex) {
            new RuleException("Indicator code NO not found", (Throwable)ex);
        }
    }

    @Override
    public CampLejeuneVerificationType getCampLejeuneVerificationType() throws UnknownLookupTypeException, UnknownLookupCodeException {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        if (clv == null) {
            return null;
        }
        if (!this.isCampLejeuneVerificationMethodBlank()) {
            return null;
        }
        CampLejeuneVerificationType clvtype = (CampLejeuneVerificationType)this.getLookupService().getByCode(CampLejeuneVerificationType.class, CampLejeuneVerificationType.VERIFICATION_OTHER.getCode());
        clv.setVerificationType(clvtype);
        return clv.getVerificationType();
    }

    @Override
    public CampLejeuneVerificationType getPristineCampLejeuneVerificationType() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null ? clv.getVerificationType() : null;
    }

    @Override
    public CampLejeuneVerificationType getResultCampLejeuneVerificationType() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null ? clv.getVerificationType() : null;
    }

    @Override
    public void setResultCampLejeuneVerificationType(CampLejeuneVerificationType clvtype) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        clv.setVerificationType(clvtype);
    }

    @Override
    public boolean isCampLejeuneVerificationMethodBlank() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null && clv.getInternalCampLejeuneVerificationMethods() != null && clv.getInternalCampLejeuneVerificationMethods().size() > 0;
    }

    @Override
    public Set getCampLejeuneVerificationMethods() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null && clv.getInternalCampLejeuneVerificationMethods() != null && clv.getInternalCampLejeuneVerificationMethods().size() > 0 ? clv.getInternalCampLejeuneVerificationMethods() : null;
    }

    @Override
    public Set getPristineCampLejeuneVerificationMethods() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null && clv.getInternalCampLejeuneVerificationMethods() != null ? clv.getInternalCampLejeuneVerificationMethods() : null;
    }

    @Override
    public Set getResultCampLejeuneVerificationMethods() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null && clv.getInternalCampLejeuneVerificationMethods() != null ? clv.getInternalCampLejeuneVerificationMethods() : null;
    }

    @Override
    public void setResultCampLejeuneVerificationMethods(Set<CampLejeuneVerificationMethod> clvmethods) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        if ((clv = this.getResultCampLejeuneVerification()).getInternalCampLejeuneVerificationMethods() != null && clv.getInternalCampLejeuneVerificationMethods().size() > 0) {
            clv.removeAllCampLejeuneVerificationMethods();
        }
        if (clv != null) {
            for (CampLejeuneVerificationMethod clvm : clvmethods) {
                clv.addCampLejeuneVerificationMethod(clvm);
            }
        }
    }

    @Override
    public CampLejeuneChangeSource getCampLejeuneChangeSource() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null ? clv.getChangeSource() : null;
    }

    @Override
    public CampLejeuneChangeSource getPristineCampLejeuneChangeSource() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null ? clv.getChangeSource() : null;
    }

    @Override
    public CampLejeuneChangeSource getResultCampLejeuneChangeSource() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null ? clv.getChangeSource() : null;
    }

    @Override
    public void setResultCampLejeuneChangeSource(CampLejeuneChangeSource clvsource) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        clv.setChangeSource(clvsource);
    }

    @Override
    public VAFacility getCampLejeuneChangeSite() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null ? clv.getChangeSite() : null;
    }

    @Override
    public VAFacility getPristineCampLejeuneChangeSite() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null ? clv.getChangeSite() : null;
    }

    @Override
    public VAFacility getResultCampLejeuneChangeSite() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null ? clv.getChangeSite() : null;
    }

    @Override
    public void setResultCampLejeuneChangeSite(VAFacility clvsite) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        clv.setChangeSite(clvsite);
    }

    @Override
    public Date getCampLejeuneChangeDate() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null ? clv.getChangeDate() : null;
    }

    @Override
    public Date getPristineCampLejeuneChangeDate() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null ? clv.getChangeDate() : null;
    }

    @Override
    public Date getResultCampLejeuneChangeDate() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null ? clv.getChangeDate() : null;
    }

    @Override
    public void setResultCampLejeuneChangeDate(Date clvdate) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        clv.setChangeDate(clvdate);
    }

    @Override
    public String getCampLejeuneComments() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv != null ? clv.getComments() : null;
    }

    @Override
    public String getPristineCampLejeuneComments() {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv != null ? clv.getComments() : null;
    }

    @Override
    public String getResultCampLejeuneComments() {
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        return clv != null ? clv.getComments() : null;
    }

    @Override
    public void setResultCampLejeuneChangeDate(String comments) {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        clv.setComments(comments);
    }

    @Override
    public void setResultCLRegDateToIncomingCLRegDate() {
        CampLejeuneVerification clvIn;
        Person onFile = this.getResultPerson();
        CampLejeuneVerification clv = this.getResultCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            onFile.addSpecialFactor(clv);
        }
        if ((clvIn = this.getCampLejeuneVerification()) == null) {
            clv.setRegistrationDate(new ImpreciseDate(new Date()));
        } else {
            clv.setRegistrationDate(clvIn.getRegistrationDate());
        }
    }

    @Override
    public boolean isCurrentCLBlank() {
        Person onFile = this.getPristinePerson();
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        return clv == null || clv.getSpecialFactorIndicator() == null || !clv.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) && !clv.getSpecialFactorIndicator().getCode().equals(Indicator.NO.getCode());
    }

    @Override
    public boolean isInComingCLYesBlank() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        return clv == null || clv.getSpecialFactorIndicator() == null || Indicator.YES.getCode().equals(clv.getSpecialFactorIndicator().getCode());
    }

    @Override
    public void updateCLVByCurrent() throws RuleException {
        CampLejeuneVerification clv = this.getPristineCampLejeuneVerification();
        if (clv == null) {
            clv = new CampLejeuneVerification();
            clv.setSpecialFactorIndicator(null);
        }
        this.updateSpecialFactor(clv, this.getResultPerson());
    }

    @Override
    public void UpdateResultChangeSiteToHEC() throws UnknownLookupTypeException, UnknownLookupCodeException {
        VAFacility vafac = this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode());
        this.setResultCampLejeuneChangeSite(vafac);
    }

    @Override
    public void UpdateResultChangeSourceToVOA() throws UnknownLookupTypeException, UnknownLookupCodeException {
        CampLejeuneChangeSource clcs = (CampLejeuneChangeSource)this.getLookupService().getByCode(CampLejeuneChangeSource.class, CampLejeuneChangeSource.CODE_VOA.getCode());
        this.setResultCampLejeuneChangeSource(clcs);
    }

    @Override
    public boolean IsEligibilityNonVeteran() {
        Eligibility code = this.getIncomingPerson().getEnrollmentDetermination().getPrimaryEligibility();
        return code != null && code.getType() != null && (code.getType().getCode().equals(EligibilityType.ALLIED_VETERAN.getCode()) || code.getType().getCode().equals(EligibilityType.OTHER_FEDERAL_AGENCY.getCode()) || code.getType().getCode().equals(EligibilityType.COLLATERAL_OF_VETERAN.getCode()) || code.getType().getCode().equals(EligibilityType.CHAMPVA.getCode()) || code.getType().getCode().equals(EligibilityType.EMPLOYEE.getCode()) || code.getType().getCode().equals(EligibilityType.SHARING_AGREEMENT.getCode()) || code.getType().getCode().equals(EligibilityType.TRICARE_CHAMPUS.getCode()) || code.getType().getCode().equals(EligibilityType.HUMANTARIAN_EMERGENCY.getCode()));
    }

    @Override
    public boolean IsCurrentCEligibilityVerified() {
        return this.getResultPerson().getEligibilityVerification().getEligibilityStatus().getCode().equals(EligibilityStatus.CODE_VERIFIED.getCode());
    }

    @Override
    public void setVistaCLV() throws RuleException, UnknownLookupTypeException, UnknownLookupCodeException {
        Person onFile = this.getResultPerson();
        CampLejeuneVerification campLejeuneVerification = onFile.getCampLejeuneVerification();
        campLejeuneVerification.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
        campLejeuneVerification.setChangeSite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        campLejeuneVerification.setChangeSource(this.getLookupService().getCampLejeuneChangeSourceByCode(CampLejeuneChangeSource.CODE_HEC.getCode()));
        campLejeuneVerification.setRegistrationDate(null);
        campLejeuneVerification.setComments(null);
        campLejeuneVerification.removeAllCampLejeuneVerificationMethods();
    }

    @Override
    public void setChangeSiteSourceHEC() throws RuleException, UnknownLookupTypeException, UnknownLookupCodeException {
        this.UpdateResultChangeSiteToHEC();
        CampLejeuneChangeSource clcs = (CampLejeuneChangeSource)this.getLookupService().getByCode(CampLejeuneChangeSource.class, CampLejeuneChangeSource.CODE_HEC.getCode());
        this.setResultCampLejeuneChangeSource(clcs);
    }

    @Override
    public boolean isFromVOA() {
        CampLejeuneVerification clv = this.getCampLejeuneVerification();
        if (clv != null && clv.getChangeSource() != null) {
            return clv.getChangeSource().getCode().equals(CampLejeuneChangeSource.CODE_VOA.getCode());
        }
        return false;
    }

    @Override
    public boolean isFromVista() {
        return this.isMessageFromVista();
    }

    @Override
    public boolean isFromClear() {
        if (this.getCampLejeuneVerification() != null && this.getCampLejeuneVerification().getChangeSource() != null) {
            return CampLejeuneChangeSource.CODE_CLEAR.getCode().equals(this.getCampLejeuneVerification().getChangeSource().getCode());
        }
        return false;
    }

    @Override
    public void setNotSupportErrorReason() {
        EEResultInfo info;
        EEResultInfo eEResultInfo = info = this.getBaseData() != null ? this.getBaseData().getEEResultInfo() : null;
        if (info != null) {
            info.setCLVErrorReason(CL_ERROR_REASON_NOT_SUPPORT);
        }
    }

    @Override
    public void setUpdatedIneligibleErrorReason() {
        EEResultInfo info;
        EEResultInfo eEResultInfo = info = this.getBaseData() != null ? this.getBaseData().getEEResultInfo() : null;
        if (info != null) {
            info.setCLVErrorReason(CL_ERROR_REASON_UPDATE_INELIGIBLE);
        }
    }

    public boolean isIgnoreInOn() throws RuleException {
        CampLejeuneVerification clvIn = this.getCampLejeuneVerification();
        CampLejeuneVerification clvOn = this.getResultCampLejeuneVerification();
        return this.isIgnore(clvIn, clvOn);
    }

    @Override
    public boolean isIgnorePOn() throws RuleException {
        CampLejeuneVerification clvIn = this.getPristineCampLejeuneVerification();
        CampLejeuneVerification clvOn = this.getResultCampLejeuneVerification();
        return this.isIgnore(clvIn, clvOn);
    }

    public boolean isIgnore(CampLejeuneVerification clvIn, CampLejeuneVerification clvOn) throws RuleException {
        boolean iSSame = false;
        try {
            if (!(clvIn != null && clvIn.getSpecialFactorIndicator() != null && (clvIn.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) || clvIn.getSpecialFactorIndicator().getCode().equals(Indicator.NO.getCode())) || clvOn != null && clvOn.getSpecialFactorIndicator() != null && (clvOn.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) || clvOn.getSpecialFactorIndicator().getCode().equals(Indicator.NO.getCode())))) {
                return true;
            }
            if (clvIn == null || clvIn.getSpecialFactorIndicator() == null || !clvIn.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) && !clvIn.getSpecialFactorIndicator().getCode().equals(Indicator.NO.getCode())) {
                clvIn.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
            } else if (clvOn == null || clvOn.getSpecialFactorIndicator() == null || !clvOn.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) && !clvOn.getSpecialFactorIndicator().getCode().equals(Indicator.NO.getCode())) {
                return false;
            }
            if (clvIn.getSpecialFactorIndicator() != null && clvOn.getSpecialFactorIndicator() != null && !clvIn.getSpecialFactorIndicator().getCode().equals(clvOn.getSpecialFactorIndicator().getCode())) {
                return false;
            }
            if (clvIn.getChangeDate() != null && clvOn.getChangeDate() != null && clvIn.getChangeDate().compareTo(clvOn.getChangeDate()) != 0) {
                return false;
            }
            if (clvIn.getChangeDate() != null && clvOn.getChangeDate() == null) {
                return false;
            }
            if (clvIn.getChangeDate() == null && clvOn.getChangeDate() != null) {
                return false;
            }
            if (clvIn.getComments() != null && clvOn.getComments() != null && !clvIn.getComments().equals(clvOn.getComments())) {
                return false;
            }
            if (clvIn.getComments() != null && clvOn.getComments() == null) {
                return false;
            }
            if (clvIn.getComments() == null && clvOn.getComments() != null) {
                return false;
            }
            if (clvIn.getInternalCampLejeuneVerificationMethods().size() != clvOn.getInternalCampLejeuneVerificationMethods().size()) {
                return false;
            }
            for (CampLejeuneVerificationMethod clvmIn : clvIn.getInternalCampLejeuneVerificationMethods()) {
                for (CampLejeuneVerificationMethod clvmOn : clvOn.getInternalCampLejeuneVerificationMethods()) {
                    if (!clvmIn.getVerificationType().getCode().equals(clvmOn.getVerificationType().getCode())) continue;
                    iSSame = true;
                }
                if (!iSSame) {
                    return false;
                }
                iSSame = false;
            }
            return true;
        }
        catch (Exception ex) {
            new RuleException("Indicator code NO not found", (Throwable)ex);
            return true;
        }
    }

    @Override
    public boolean isPersonJustAdded() {
        return this.getIncomingPerson().isJustAdded();
    }
}

