/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.PHDataSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.PurpleHeartInput;
import gov.va.med.esr.common.rule.data.PHInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class PurpleHeartInputParameter
extends BaseParameter
implements PurpleHeartInput {
    private static final long serialVersionUID = 4295682708902703724L;
    private Person priorPersonForPurpleHeart = null;
    private PurpleHeartDocument resultPurpleHeartDocument = null;
    private Date dateOfBirth = null;

    @Override
    public String getPurpleHeartIndicator() throws RuleException {
        return this.getPurpleHeartIndicator(this.getIncomingPerson());
    }

    @Override
    public String getPurpleHeartStatus() throws RuleException {
        return this.getPurpleHeartStatus(this.getIncomingPerson());
    }

    @Override
    public String getVeteranPurpleHeartIndicator() {
        return this.getPurpleHeartIndicator(this.getPristinePerson());
    }

    @Override
    public void setPurpleHeart(String indicator) {
        if (indicator != null) {
            this.setPurpleHeartIndicator("Y".equals(indicator) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setPurpleHeartIndicator(Boolean indicator) {
        PurpleHeart incoming;
        if (indicator != null && (incoming = this.getIncomingPurpleHeart()) != null) {
            RejectionRemark remark = incoming.getRejectionRemark();
            incoming.setRejectionRemark(Boolean.TRUE.equals(indicator) ? null : remark);
            incoming.setPhIndicator(indicator);
        }
    }

    @Override
    public void setPurpleHeartStatus(String status) throws RuleException {
        try {
            PurpleHeart result = this.getIncomingPurpleHeart();
            if (result != null) {
                result.setStatus(this.getLookupService().getDecorationStatusByCode(status));
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set Purple Heart Status", (Throwable)e);
        }
    }

    @Override
    public void setRejectedRemarks(String remark) throws RuleException {
        try {
            PurpleHeart result = this.getIncomingPurpleHeart();
            if (result != null) {
                result.setRejectionRemark(remark == null ? null : this.getLookupService().getRejectionRemarkByCode(remark));
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set Rejected Remarks", (Throwable)e);
        }
    }

    @Override
    public VAFacility getReceivedFacility() {
        PurpleHeart purpleHeart = this.getIncomingPurpleHeart();
        return purpleHeart != null ? purpleHeart.getFacility() : null;
    }

    @Override
    public void setReceivedFacility(VAFacility facility) {
        PurpleHeart result = this.getIncomingPurpleHeart();
        if (result != null) {
            result.setFacility(facility);
        }
    }

    @Override
    public void updatePurpleHeart() throws RuleException {
        PurpleHeart incoming = this.getIncomingPurpleHeart();
        if (incoming != null) {
            try {
                PurpleHeart result = this.getResultPurpleHeart();
                if (result == null) {
                    result = new PurpleHeart();
                    this.getResultPerson().addDecoration(result);
                }
                this.getMergeRuleService().mergePurpleHeart(incoming, result);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to update Purple Heart", (Throwable)e);
            }
        } else {
            this.getResultPerson().removeAllDecorations();
        }
    }

    @Override
    public void updatePurpleHeartRegistry() throws ServiceException {
    }

    @Override
    public PurpleHeart getVeteranPurpleHeart() {
        Person pristine = this.getPristinePerson();
        return pristine.getPurpleHeart();
    }

    @Override
    public boolean isUpdateFromHEC() {
        return super.isUpdateFromGUI();
    }

    @Override
    public PurpleHeart getPurpleHeart() {
        return this.getHelperService().getPurpleHeart(this.getIncomingPerson());
    }

    @Override
    public Boolean getPHDocumentAcceptable() {
        return this.isPHDocumentAcceptable(this.getIncomingPerson());
    }

    @Override
    public String getPHRejectedRemarks() {
        PurpleHeart ph = this.getIncomingPurpleHeart();
        return ph != null && ph.getRejectionRemark() != null ? ph.getRejectionRemark().getCode() : null;
    }

    @Override
    public String getVeteranPHRejectedRemarks() {
        PurpleHeart ph = this.getVeteranPurpleHeart();
        return ph != null && ph.getRejectionRemark() != null ? ph.getRejectionRemark().getCode() : null;
    }

    @Override
    public Boolean getPriorPHDocumentAcceptable() throws RuleException {
        if (this.priorPersonForPurpleHeart == null) {
            this.priorPersonForPurpleHeart = this.getPriorPersonForPurpleHeart();
        }
        return this.isPHDocumentAcceptable(this.priorPersonForPurpleHeart);
    }

    @Override
    public String getPriorPurpleHeartStatus() throws RuleException {
        if (this.priorPersonForPurpleHeart == null) {
            this.priorPersonForPurpleHeart = this.getPriorPersonForPurpleHeart();
        }
        return this.priorPersonForPurpleHeart != null ? this.getPurpleHeartStatus(this.priorPersonForPurpleHeart) : null;
    }

    @Override
    public boolean is37DayClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.PH_37_DAY_CLOCK.getName().equals(fired.getName()) : false;
    }

    @Override
    public void start37DayLetterClock() throws RuleException {
        try {
            this.getScheduledTaskService().startPHLetterClock(this.getIncomingPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start 37 day clock", (Throwable)e);
        }
    }

    @Override
    public void acceptPHFromUI() throws RuleException {
        this.updatePurpleHeart();
    }

    @Override
    public void acceptPHFromMSDS() throws RuleException {
        PurpleHeart incoming = this.getIncomingPurpleHeart();
        if (incoming != null) {
            try {
                PurpleHeart result = this.getResultPurpleHeart();
                if (result == null) {
                    result = new PurpleHeart();
                    this.getResultPerson().addDecoration(result);
                }
                this.getMergeRuleService().mergePurpleHeart(incoming, result);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to update Purple Heart", (Throwable)e);
            }
        }
    }

    @Override
    public void cancelPHLetterClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.PH_37_DAY_CLOCK, Clock.Group.PH_CLOCK_GROUP);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel PH letter clock", (Throwable)e);
        }
    }

    @Override
    public void cancelPHPendingClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.PH_14_DAY_CLOCK, Clock.Group.PH_CLOCK_GROUP);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel PH pending clock", (Throwable)e);
        }
    }

    @Override
    public void updatePHPendingClock() throws RuleException {
        try {
            this.getScheduledTaskService().startPHPendingClock(this.getIncomingPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start PH pending clock", (Throwable)e);
        }
    }

    @Override
    public Date getVeteranReceivedDate() {
        PurpleHeartDocument phd = this.getAcceptablePHDocument(this.getPristinePerson());
        return phd != null ? phd.getReceivedDate() : null;
    }

    @Override
    public Date getVeteranDateOfBirth() {
        if (this.dateOfBirth == null) {
            this.dateOfBirth = this.getDateOfBirth(this.getIncomingPerson());
        }
        return this.dateOfBirth;
    }

    @Override
    public boolean hasPHPendingClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.PH_14_DAY_CLOCK.getName().equals(fired.getName()) : false;
    }

    @Override
    public boolean isFirstDocumentReceived() {
        PurpleHeart incoming = this.getIncomingPurpleHeart();
        PurpleHeart current = this.getVeteranPurpleHeart();
        return current != null && current.getDocuments().size() > 0 || incoming != null && incoming.getDocuments().size() > 0;
    }

    @Override
    public boolean isAdditionalDocumentReceived() {
        PurpleHeart incoming = this.getIncomingPurpleHeart();
        PurpleHeart current = this.getVeteranPurpleHeart();
        if (incoming != null && current != null) {
            return current.getDocuments().size() > 0 && incoming.getDocuments().size() > current.getDocuments().size();
        }
        return false;
    }

    @Override
    public void setLoginDate(Date loginDate) {
        PurpleHeartDocument result = this.getLatestPurpleHeartDocument();
        if (result != null) {
            result.setLoginDate(loginDate);
        }
    }

    @Override
    public void setStatusUpdateDate(Date statusUpdateDate) {
        PurpleHeart result = this.getIncomingPurpleHeart();
        if (result != null) {
            result.setStatusLastEditDate(statusUpdateDate);
        }
    }

    @Override
    public String getDocumentType() {
        PurpleHeartDocument phd = this.getIncomingPurpleHeartDocument();
        return phd != null && phd.getDocumentType() != null ? phd.getDocumentType().getCode() : null;
    }

    @Override
    public Date getReceivedDate() {
        PurpleHeartDocument phd = this.getIncomingPurpleHeartDocument();
        return phd != null ? phd.getReceivedDate() : null;
    }

    @Override
    public Boolean getDocumentAcceptable() {
        PurpleHeartDocument phd = this.getIncomingPurpleHeartDocument();
        return phd != null ? phd.getAcceptable() : null;
    }

    @Override
    public String getPurpleHeartStatus(Person person) {
        PurpleHeart purpleHeart = person != null ? person.getPurpleHeart() : null;
        DecorationStatus status = purpleHeart != null ? purpleHeart.getStatus() : null;
        return status != null ? status.getCode() : null;
    }

    @Override
    public String getPurpleHeartIndicator(Person person) {
        PurpleHeart purpleHeart = person != null ? person.getPurpleHeart() : null;
        Boolean indicator = purpleHeart != null ? purpleHeart.getPhIndicator() : null;
        String flag = null;
        if (indicator != null) {
            flag = Boolean.TRUE.equals(indicator) ? "Y" : "N";
        }
        return flag;
    }

    @Override
    public void setPHDocumentAcceptableIndicator(String indicator) {
        PurpleHeart ph;
        if (indicator != null && (ph = this.getIncomingPurpleHeart()) != null) {
            PurpleHeartDocument document = this.getLatestPurpleHeartDocument();
            if (document == null) {
                document = new PurpleHeartDocument();
                ph.addDocument(document);
            }
            document.setAcceptable("Y".equals(indicator) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setAssignedContactUser(String user) throws RuleException {
        PurpleHeart purpleHeart = this.getIncomingPerson().getPurpleHeart();
        if (purpleHeart != null) {
            purpleHeart.setAssignedContactUser(user);
        }
    }

    @Override
    public void setDocumentType(String documentType) throws RuleException {
        PurpleHeartDocument doc = this.getOrCreatePHDocument(this.getIncomingPerson().getPurpleHeart());
        if (doc != null && documentType != null) {
            try {
                doc.setDocumentType((PHDocumentType)this.getLookupService().getByCode(PHDocumentType.class, documentType));
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set Purple Heart Document Type");
            }
        }
    }

    @Override
    public void setPHDocumentDataSource(String dataSource) throws RuleException {
        PurpleHeartDocument doc = this.getOrCreatePHDocument(this.getIncomingPerson().getPurpleHeart());
        if (doc != null && dataSource != null) {
            try {
                doc.setDataSource((PHDataSource)this.getLookupService().getByCode(PHDataSource.class, dataSource));
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set Purple Heart Document Data Source");
            }
        }
    }

    @Override
    public void setPHDocumentReceivedDate(Date receivedDate) {
        PurpleHeartDocument doc = this.getOrCreatePHDocument(this.getIncomingPerson().getPurpleHeart());
        if (doc != null) {
            doc.setReceivedDate(receivedDate);
        }
    }

    @Override
    public void setPHFacilityByCode(String facilityCode) throws RuleException {
        PurpleHeart purpleHeart = this.getIncomingPerson().getPurpleHeart();
        if (purpleHeart != null && facilityCode != null) {
            try {
                purpleHeart.setFacility(this.getLookupService().getVaFacilityByCode(facilityCode));
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set PH Facility");
            }
        }
    }

    @Override
    public void setPHLastUpdatedByUser(String user) throws RuleException {
        PurpleHeart purpleHeart = this.getIncomingPerson().getPurpleHeart();
        if (purpleHeart != null) {
            purpleHeart.setStatusLastUpdateUser(user);
        }
    }

    @Override
    public Date getPHDocReceivedDateFromMSDSmessage() {
        PurpleHeart purpleHeart = this.getIncomingPerson().getPurpleHeart();
        PurpleHeartDocument doc = this.getOrCreatePHDocument(purpleHeart);
        return doc != null ? doc.getReceivedDate() : null;
    }

    private PurpleHeartDocument getOrCreatePHDocument(PurpleHeart purpleHeart) {
        PurpleHeartDocument doc;
        Set docs = purpleHeart != null ? purpleHeart.getDocuments() : new HashSet();
        PurpleHeartDocument purpleHeartDocument = doc = docs.size() > 0 ? (PurpleHeartDocument)docs.iterator().next() : null;
        if (purpleHeart != null && doc == null) {
            doc = new PurpleHeartDocument();
            purpleHeart.addDocument(doc);
        }
        return doc;
    }

    private PurpleHeart getIncomingPurpleHeart() {
        Person incoming = this.getIncomingPerson();
        return incoming.getPurpleHeart();
    }

    private PurpleHeart getResultPurpleHeart() {
        Person result = this.getResultPerson();
        return result.getPurpleHeart();
    }

    private Person getPriorPersonForPurpleHeart() throws RuleException {
        return this.getPriorEEPerson();
    }

    private PHInputData getPHInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof PHInputData) {
            return (PHInputData)ruleDataAware;
        }
        return null;
    }

    private PurpleHeartDocument getIncomingPurpleHeartDocument() {
        return this.getPHInputData() != null ? this.getPHInputData().getIncomingPurpleHeartDocument() : null;
    }

    @Override
    public Boolean isPHDocumentAcceptable(Person person) {
        Set docs;
        Boolean docAcceptable = null;
        PurpleHeart ph = person != null ? person.getPurpleHeart() : null;
        Set set = docs = ph != null ? ph.getDocuments() : null;
        if (docs != null && docs.size() > 0) {
            for (PurpleHeartDocument phd : docs) {
                if (phd.getAcceptable() == null || !(docAcceptable = phd.getAcceptable()).booleanValue()) continue;
                return docAcceptable;
            }
        }
        return docAcceptable;
    }

    @Override
    public Boolean getFirstAssessedDocumentAcceptable() {
        ArrayList documents;
        PurpleHeart ph = this.getIncomingPurpleHeart();
        if (ph != null && (documents = new ArrayList(ph.getDocuments())) != null && documents.size() > 0) {
            Collections.sort(documents);
            for (int i = 0; i < documents.size(); ++i) {
                PurpleHeartDocument doc = (PurpleHeartDocument)documents.get(i);
                if (doc.getAcceptable() == null) continue;
                return doc.getAcceptable();
            }
        }
        return null;
    }

    @Override
    public Boolean getSecondAssessedDocumentAcceptable() {
        PurpleHeart ph = this.getIncomingPurpleHeart();
        if (ph != null) {
            ArrayList documents = new ArrayList(ph.getDocuments());
            Boolean firstDocAcceptable = null;
            if (documents != null && documents.size() > 0) {
                Collections.sort(documents);
                for (int i = 0; i < documents.size(); ++i) {
                    PurpleHeartDocument doc = (PurpleHeartDocument)documents.get(i);
                    if (doc.getAcceptable() == null) continue;
                    if (firstDocAcceptable == null) {
                        firstDocAcceptable = doc.getAcceptable();
                        continue;
                    }
                    return doc.getAcceptable();
                }
            }
        }
        return null;
    }

    private PurpleHeartDocument getAcceptablePHDocument(Person person) {
        Set docs;
        PurpleHeart ph = person != null ? person.getPurpleHeart() : null;
        Set set = docs = ph != null ? ph.getDocuments() : null;
        if (docs != null && docs.size() > 0) {
            for (PurpleHeartDocument phd : docs) {
                if (phd.getAcceptable() == null || !phd.getAcceptable().booleanValue()) continue;
                return phd;
            }
        }
        return null;
    }

    private PurpleHeartDocument getLatestPurpleHeartDocument() {
        if (this.resultPurpleHeartDocument == null) {
            this.resultPurpleHeartDocument = this.initLatestPurpleHeartDocument();
        }
        return this.resultPurpleHeartDocument;
    }

    private PurpleHeartDocument initLatestPurpleHeartDocument() {
        PurpleHeart ph = this.getIncomingPurpleHeart();
        PurpleHeartDocument latest = null;
        if (ph != null) {
            Set docs = ph != null ? ph.getDocuments() : null;
            for (PurpleHeartDocument phd : docs) {
                if (phd.getEntityKey() == null || phd.getCreatedOn() == null) {
                    return phd;
                }
                if (latest == null) {
                    latest = phd;
                    continue;
                }
                if (latest.getModifiedOn() == null || !this.isAfter(phd.getModifiedOn(), latest.getModifiedOn())) continue;
                return phd;
            }
        }
        return latest;
    }
}

