/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.rule.EGTInput;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.EgtInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;
import java.util.Set;

public class EGTParameter
extends BaseParameter
implements EGTInput {
    private static final long serialVersionUID = 5599678794687343432L;

    @Override
    public boolean isNewEGTSetting() {
        EGTSetting egtSetting = this.getEGTSetting();
        return egtSetting == null || egtSetting.getEntityKey() == null;
    }

    @Override
    public String getEGTType() throws RuleException {
        EGTSetting egtSetting = this.getEGTSetting();
        return egtSetting != null && egtSetting.getType() != null ? egtSetting.getType().getCode() : null;
    }

    @Override
    public String getEGTPriorityGroup() throws RuleException {
        EGTSetting egtSetting = this.getEGTSetting();
        return egtSetting != null && egtSetting.getPriorityGroup() != null ? egtSetting.getPriorityGroup().getCode() : null;
    }

    @Override
    public Date getEGTEffectiveDate() throws RuleException {
        EGTSetting egtSetting = this.getEGTSetting();
        return egtSetting != null ? egtSetting.getEffectiveDate() : null;
    }

    @Override
    public boolean isRetroactiveFurureEGTSettingExists() throws RuleException {
        boolean flag;
        block3: {
            flag = false;
            try {
                EGTSetting egtSetting = this.getEGTSetting();
                EntityKey egtSettingKey = egtSetting.getEntityKey();
                Set futureEGTs = this.getEgtService().getFutureEGTSettings();
                if (futureEGTs == null || futureEGTs.isEmpty()) break block3;
                Date currentDate = this.getCurrentDate();
                for (EGTSetting egt : futureEGTs) {
                    if (egt == null || egtSettingKey != null && egtSettingKey.equals(egt.getEntityKey()) || this.getProcessEGTStartDate(egt) != null || this.isAfter(egt.getEffectiveDate(), currentDate)) continue;
                    flag = true;
                    break;
                }
            }
            catch (Exception ex) {
                throw new RuleException("Error while getting the future retroactive EGT counts", (Throwable)ex);
            }
        }
        return flag;
    }

    @Override
    public void setEnrollmentSubPriority(String subGroup) throws RuleException {
        try {
            EGTSetting egtSetting = this.getResultEGTSetting();
            EnrollmentPrioritySubGroup enrollmentPrioritySubGroup = (EnrollmentPrioritySubGroup)this.getLookupService().getByCode(EnrollmentPrioritySubGroup.class, subGroup);
            egtSetting.setPrioritySubGroup(enrollmentPrioritySubGroup);
        }
        catch (Exception ex) {
            throw new RuleException("Error while setting the enrollment sub priority", (Throwable)ex);
        }
    }

    @Override
    public Date getCurrentEGTEffectiveDate() throws RuleException {
        EGTSetting es = this.getCurrentEGTSetting();
        return es != null ? es.getEffectiveDate() : null;
    }

    @Override
    public boolean isCalcEnrPriorityGreaterThanEGT() throws RuleException {
        try {
            String egtPriority = this.getCurrentEGTPriorityGroup();
            String priority = this.getCalculatedPriorityCode();
            if (priority == null || egtPriority == null) {
                return false;
            }
            return priority.compareTo(egtPriority) > 0;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get EGT priority", (Throwable)e);
        }
    }

    @Override
    public boolean isCalcEnrPriorityLessThanEGT() throws RuleException {
        try {
            String egtPriority = this.getCurrentEGTPriorityGroup();
            String priority = this.getCalculatedPriorityCode();
            if (priority == null || egtPriority == null) {
                return false;
            }
            return priority.compareTo(egtPriority) < 0;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get EGT priority", (Throwable)e);
        }
    }

    @Override
    public boolean isCurrentEGTPriorityLessThan(String priority) throws RuleException {
        String egtPriority = this.getCurrentEGTPriorityGroup();
        return priority != null && egtPriority != null ? egtPriority.compareTo(priority) < 0 : false;
    }

    @Override
    public String getCurrentEGTPriorityGroup() throws RuleException {
        EGTSetting currentEGTSetting = this.getCurrentEGTSetting();
        return currentEGTSetting != null && currentEGTSetting.getPriorityGroup() != null ? currentEGTSetting.getPriorityGroup().getCode() : null;
    }

    @Override
    public String getCurrentEGTPrioritySubGroup() throws RuleException {
        EGTSetting currentEGTSetting = this.getCurrentEGTSetting();
        return currentEGTSetting != null && currentEGTSetting.getPrioritySubGroup() != null ? currentEGTSetting.getPrioritySubGroup().getCode() : null;
    }

    @Override
    public Date getProcessEGTStartDate() {
        return this.getProcessEGTStartDate(this.getEGTSetting());
    }

    @Override
    public Date getPristineEGTEffectiveDate() {
        return null;
    }

    @Override
    public Date getEGTEffectiveStartDate() {
        return null;
    }

    @Override
    public void setEGTProcessStatus(String status) {
    }

    @Override
    public void startEGTProcess() {
    }

    @Override
    public boolean isRequestToTerminateEGTProcess() {
        return false;
    }

    @Override
    public void terminateEGTProcess() {
    }

    @Override
    public void updateEGTRecord() throws RuleException {
        try {
            this.getMergeRuleService().mergeEGTSetting(this.getEGTSetting(), this.getResultEGTSetting());
        }
        catch (Exception ex) {
            throw new RuleException("Error while updating the EGT settings", (Throwable)ex);
        }
    }

    private String getCalculatedPriorityCode() throws ServiceException {
        EnrollmentDetermination ed = null;
        ed = this.getRuleDataAware() instanceof EEInputData ? ((EEInputData)this.getRuleDataAware()).getResultEnrollmentDetermination() : (this.getResultPerson() != null ? this.getHelperService().getEnrollmentDetermination(this.getResultPerson()) : null);
        return ed != null && ed.getPriorityGroup() != null ? ed.getPriorityGroup().getCode() : null;
    }

    private Date getProcessEGTStartDate(EGTSetting egtSetting) {
        EGTProcessStatistic processStatistic = egtSetting != null ? egtSetting.getProcessStatistic() : null;
        return processStatistic != null ? processStatistic.getProcessStartDate() : null;
    }

    private EGTSetting getEGTSetting() {
        return this.getEgtInputData() != null ? this.getEgtInputData().getIncomingEGTSetting() : null;
    }

    private EGTSetting getResultEGTSetting() {
        return this.getEgtInputData() != null ? this.getEgtInputData().getResultEGTSetting() : null;
    }

    private EgtInputData getEgtInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        return ruleDataAware instanceof EgtInputData ? (EgtInputData)ruleDataAware : null;
    }
}

