/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.ContactInformationInput;
import gov.va.med.esr.common.rule.data.AddressInputData;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.ExternalSystemsInputData;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.common.rule.data.accessor.PropertyAccessor;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class ContactInformationInputParameter
extends BaseParameter
implements ContactInformationInput {
    private static final long serialVersionUID = 6875166494032709168L;
    private Set updatedVeteranAddresses = null;
    private Address incomingAddress = null;
    private Address pristineAddress = null;
    private Address resultAddress = null;
    private AddressInputData addressInputData = null;

    @Override
    public EntityKey getEntityKey() {
        ExternalSystemsInputData esi = this.getExternalSystemsInputData();
        if (esi != null) {
            gov.va.med.esr.service.external.person.EntityKey key;
            DemographicsChangeEvent demographicsChangeEvent = esi.getDemographicsChangeEvent();
            gov.va.med.esr.service.external.person.EntityKey entityKey = key = demographicsChangeEvent != null ? demographicsChangeEvent.getEntityKey() : null;
            if (key != null && demographicsChangeEvent != null && demographicsChangeEvent.getChangeType() != null) {
                if (demographicsChangeEvent.getChangeType().equals(DemographicsChangeType.ADDRESS_CHANGE)) {
                    return CommonEntityKeyFactory.createAddressEntityKey(key.getKey());
                }
                if (demographicsChangeEvent.getChangeType().equals(DemographicsChangeType.EMAIL_CHANGE)) {
                    return CommonEntityKeyFactory.createEmailEntityKey(key.getKey());
                }
                if (demographicsChangeEvent.getChangeType().equals(DemographicsChangeType.PHONE_CHANGE)) {
                    return CommonEntityKeyFactory.createPhoneEntityKey(key.getKey());
                }
            }
        }
        if (this.getCommsInputData() != null) {
            Address address = this.getCommsInputData().getMailingAddress();
            return address != null ? address.getEntityKey() : null;
        }
        if (this.getAssociation() != null) {
            return this.getAssociation() != null ? this.getAssociation().getEntityKey() : null;
        }
        EntityKey entityKey = super.getEntityKey();
        if (entityKey == null) {
            if (this.getPristineAddress() != null) {
                entityKey = this.getPristineAddress().getEntityKey();
            } else if (this.getIncomingAddress() != null) {
                entityKey = EntityKeyFactory.createEntityKey((Serializable)Integer.valueOf(123), (Integer)1, Address.class);
            }
        }
        return entityKey;
    }

    @Override
    public boolean isAddressTypeExisted() {
        boolean found = false;
        Set addresses = this.getUpdatedVeteranAddresses();
        for (Address addressFromDb : addresses) {
            if (addressFromDb.getType() == null) continue;
            String addressType = addressFromDb.getType().getCode();
            if (!this.getAddressType(this.getIncomingAddress()).equals(addressType)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean isAddressDeleted() {
        Address incoming = this.getIncomingAddress();
        return incoming != null && incoming.getType().getCode().equals(AddressType.CODE_PERMANENT_ADDRESS.getName()) && this.incomingAddress.getEndDate() != null;
    }

    @Override
    public Person getPerson() {
        return this.getIncomingPerson();
    }

    @Override
    public Date getAddressStartDate() {
        return this.getIncomingAddress() != null ? this.getPreciseDate(this.getIncomingAddress().getStartDate()) : null;
    }

    @Override
    public Date getAddressEndDate() {
        return this.getIncomingAddress() != null ? this.getPreciseDate(this.getIncomingAddress().getEndDate()) : null;
    }

    @Override
    public Date getPristineAddressStartDate() {
        return this.getPristineAddress() != null ? this.getPreciseDate(this.getPristineAddress().getStartDate()) : null;
    }

    @Override
    public Date getPristineAddressEndDate() {
        return this.getPristineAddress() != null ? this.getPreciseDate(this.getPristineAddress().getEndDate()) : null;
    }

    @Override
    public void setAddressEndDate(Date d) {
        this.getResultAddress().setEndDate(this.getImpreciseDate(d));
    }

    @Override
    public Association getAssociation() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getAssociation() : null;
    }

    @Override
    public String getAssociationType() {
        return this.getAssociation() != null ? this.getAssociation().getType().getCode() : null;
    }

    @Override
    public String getAddressLineOne() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine1()) ? address.getLine1() : null;
    }

    @Override
    public String getPristineAddressLineOne() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine1()) ? address.getLine1() : null;
    }

    @Override
    public String getAddressLineTwo() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine2()) ? address.getLine2() : null;
    }

    @Override
    public String getPristineAddressLineTwo() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine2()) ? address.getLine2() : null;
    }

    @Override
    public String getAddressLineThree() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine3()) ? address.getLine3() : null;
    }

    @Override
    public String getPristineAddressLineThree() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getLine3()) ? address.getLine3() : null;
    }

    @Override
    public String getCity() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCity()) ? address.getCity() : null;
    }

    @Override
    public String getPristineCity() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCity()) ? address.getCity() : null;
    }

    @Override
    public String getCounty() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCounty()) ? address.getCounty() : null;
    }

    @Override
    public String getPristineCounty() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCounty()) ? address.getCounty() : null;
    }

    @Override
    public String getPristineAddressStateCode() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getState()) ? address.getState() : null;
    }

    @Override
    public String getProvince() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getProvince()) ? address.getProvince() : null;
    }

    @Override
    public String getPristineProvince() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getProvince()) ? address.getProvince() : null;
    }

    @Override
    public String getCountry() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCountry()) ? address.getCountry() : null;
    }

    @Override
    public String getPristineCountry() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getCountry()) ? address.getCountry() : null;
    }

    @Override
    public BadAddressReason getBadAddressReasonText() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getBadAddressReason() : null;
    }

    @Override
    public BadAddressReason getPristineBadAddressReasonText() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getBadAddressReason() : null;
    }

    @Override
    public boolean isBadAddressReasonTextRemoved() {
        BadAddressReason incoming = this.getBadAddressReasonText();
        BadAddressReason pristine = this.getPristineBadAddressReasonText();
        return incoming == null && pristine != null;
    }

    @Override
    public BadAddressReason getResultBadAddressReasonText() {
        return this.getResultAddress() != null ? this.getResultAddress().getBadAddressReason() : null;
    }

    @Override
    public AddressChangeSource getSourceOfChange() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getChangeSource() : null;
    }

    @Override
    public AddressChangeSource getPristineSourceOfChange() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getChangeSource() : null;
    }

    @Override
    public String getPhoneNumber() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getPhoneNumber() : null;
    }

    @Override
    public String getPristinePhoneNumber() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getPhoneNumber() : null;
    }

    @Override
    public void setAddressLineOne(String line) {
        this.getResultAddress().setLine1(line);
    }

    @Override
    public void setAddressLineTwo(String line) {
        this.getResultAddress().setLine2(line);
    }

    @Override
    public void setAddressLineThree(String line) {
        this.getResultAddress().setLine3(line);
    }

    @Override
    public void setCity(String city) {
        this.getResultAddress().setCity(city);
    }

    @Override
    public void setCounty(String county) {
        this.getResultAddress().setCounty(county);
    }

    @Override
    public void setChangeDate(Date date) {
        this.getResultAddress().setChangeDate(date);
    }

    @Override
    public void setProvince(String province) {
        this.getResultAddress().setProvince(province);
    }

    @Override
    public void setCountry(String country) {
        this.getResultAddress().setCountry(country);
    }

    public void setBadAddressReasonText(BadAddressReason text) {
        this.getResultAddress().setBadAddressReason(text);
    }

    @Override
    public void setSourceOfChange(AddressChangeSource value) {
        this.getResultAddress().setChangeSource(value);
    }

    @Override
    public void setPhoneNumber(String text) {
        this.getResultAddress().setPhoneNumber(text);
    }

    @Override
    public boolean isVeteranAddressMatched() {
        String incomingAddresType = this.getAddressType(this.getIncomingAddress());
        String currentAddresType = this.getAddressType(this.getPristineAddress());
        return this.isEqual(incomingAddresType, currentAddresType);
    }

    @Override
    public boolean isAddressDateValid() {
        return true;
    }

    @Override
    public boolean isAddressActive() {
        Address incoming = this.getIncomingAddress();
        return incoming != null ? incoming.isActive() : true;
    }

    @Override
    public boolean isAddressTypeEqual(String type) {
        String incoming = null;
        ExternalSystemsInputData esi = this.getExternalSystemsInputData();
        if (esi != null) {
            if (esi.getDemographicsChangeEvent().getEntityKey() != null && esi.getDemographicsChangeEvent().getEntityKey().getKey() != null && esi.getDemographicsChangeEvent().getChangeType().equals(DemographicsChangeType.ADDRESS_CHANGE)) {
                Person person = this.getIncomingPerson();
                EntityKey key = CommonEntityKeyFactory.createAddressEntityKey(this.getExternalSystemsInputData().getDemographicsChangeEvent().getEntityKey().getKey().toString());
                if (key != null) {
                    Address address = person.getAddressByEntityKey(key);
                    incoming = address != null ? this.getAddressType(address) : null;
                }
            }
        } else {
            incoming = this.getAddressType(this.getIncomingAddress());
        }
        return incoming != null ? this.isEqual(incoming, type) : false;
    }

    @Override
    public boolean isAddressTypeValid() {
        String incomingAddressType = this.getAddressType(this.getIncomingAddress());
        return this.isEqual(incomingAddressType, AddressType.CODE_PERMANENT_ADDRESS.getName()) || this.isEqual(incomingAddressType, AddressType.CODE_CONFIDENTIAL_ADDRESS.getName()) || this.isEqual(incomingAddressType, AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName());
    }

    @Override
    public boolean isAddressAfter() {
        Date incoming = this.getUpdatedDate(this.getIncomingAddress());
        Date current = this.getUpdatedDate(this.getPristineAddress());
        return this.isAfter(incoming, current);
    }

    @Override
    public boolean isAddressUpdateDateEqual() {
        Date incoming = this.getUpdatedDate(this.getIncomingAddress());
        Date current = this.getUpdatedDate(this.getPristineAddress());
        return this.isEqual(incoming, current);
    }

    @Override
    public boolean isAddressStateValid() {
        return true;
    }

    @Override
    public void setVeteranAddressStateCode(String value) {
        this.getResultAddress().setState(value);
    }

    @Override
    public void setVeteranAddressZipCode(String value) {
        this.getResultAddress().setZipCode(value);
    }

    @Override
    public void setVeteranAddressProvinceCode(String value) {
        this.getResultAddress().setProvince(value);
    }

    @Override
    public void setVeteranAddressPostalCode(String value) {
        this.getResultAddress().setPostalCode(value);
    }

    @Override
    public void createVeteranAddress() {
        this.updateSetOfAddressWithNewAddressInfo(this.getIncomingAddress(), this.updatedVeteranAddresses);
    }

    @Override
    public void expireVeteranAddress() {
        this.retireCurrentAddress(this.getIncomingAddress(), this.getUpdatedVeteranAddresses());
    }

    @Override
    public void updateVeteranAddress() {
        this.updateSetOfCurrentAddressWithUpdatedAddressInfo(this.getIncomingAddress(), this.getUpdatedVeteranAddresses());
    }

    @Override
    public Date getVeteranAddressUpdatedDate() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getChangeDate() : null;
    }

    @Override
    public Date getAddressUpdatedDate() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getChangeDate() : null;
    }

    @Override
    public void setAddressUpdatedDate(Date date) {
        Address address = this.getResultAddress();
        if (address != null) {
            address.setChangeDate(date);
        }
    }

    @Override
    public String getAddressStateCode() {
        Address address = this.getIncomingAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getState()) ? address.getState() : null;
    }

    @Override
    public String getAddressZipCode() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getZipCode() : null;
    }

    @Override
    public String getPostalCode() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getPostalCode() : null;
    }

    @Override
    public String getPristinePostalCode() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getPostalCode() : null;
    }

    @Override
    public AddressType getAddressTypeCode() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getType() : null;
    }

    @Override
    public Date getChangeDate() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getChangeDate() : null;
    }

    @Override
    public VAFacility getChangeSite() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getChangeSite() : null;
    }

    @Override
    public String getZipPlus4() {
        return this.getIncomingAddress() != null ? this.getIncomingAddress().getZipPlus4() : null;
    }

    @Override
    public String getPristineZipPlus4() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getZipPlus4() : null;
    }

    @Override
    public String getPristineAddressZipCode() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getZipCode() : null;
    }

    @Override
    public void setAddressTypeCode(AddressType addressType) {
        this.getResultAddress().setType(addressType);
    }

    @Override
    public void setZipPlus4(String value) {
        this.getResultAddress().setZipPlus4(value);
    }

    @Override
    public void setBadAddressReasonText(BadAddressReason.Code text) throws RuleException {
        try {
            if (text != null) {
                this.getResultAddress().setBadAddressReason(this.getLookupService().getBadAddressReasonByCode(text.getName()));
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set enrollment priority", (Throwable)e);
        }
    }

    @Override
    public String getPOAAddressLineOne() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getLine1() : null;
    }

    @Override
    public String getPOAAddressStateCode() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getState() : null;
    }

    @Override
    public String getPOAAddressZipCode() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getZipCode() : null;
    }

    @Override
    public String getPOAAddressProvince() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getProvince() : null;
    }

    @Override
    public String getPOAAddressPostalCode() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getPostalCode() : null;
    }

    @Override
    public String getPOACity() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getCity() : null;
    }

    @Override
    public String getPOAAddressCountry() {
        Address address = this.getLetterMailingAddress();
        return address != null ? address.getCounty() : null;
    }

    @Override
    public Address getUpdatedLetterAddress() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getUpdatedMailingAddress() : null;
    }

    @Override
    public boolean isCurrentConfidentialAddressEqualOriginalLetterAddress() {
        return this.isCurrentMailingAddressSameAsOriginal();
    }

    @Override
    public boolean isCurrentTemporaryAddressEqualOriginalLetterAddress() {
        return this.isCurrentMailingAddressSameAsOriginal();
    }

    @Override
    public Date getUpdatedDate(Address address) {
        return address != null ? address.getChangeDate() : null;
    }

    private void updateSetOfAddressWithNewAddressInfo(Address newAddress, Set addresses) {
        if (addresses != null) {
            try {
                Address address = this.getMergeRuleService().mergeAddress(newAddress, new Address());
                this.getResultPerson().addAddress(address);
            }
            catch (ServiceException ex) {
                this.logger.debug((Object)"Failed to add/merge a new Address", (Throwable)ex);
                throw new RuntimeException("Failed to add/merge a new Address", ex);
            }
        }
    }

    private void updateSetOfCurrentAddressWithUpdatedAddressInfo(Address updatedAddress, Set addresses) {
        if (addresses != null) {
            boolean isUpdated = false;
            Iterator iter = addresses.iterator();
            while (iter.hasNext()) {
                try {
                    Address currentAddress = (Address)iter.next();
                    if (currentAddress.getType() == null || !this.isEqual(currentAddress.getType().getCode(), updatedAddress.getType().getCode())) continue;
                    this.getMergeRuleService().mergeAddress(updatedAddress, currentAddress);
                    isUpdated = true;
                    if (!this.isMessageFromVOA() || updatedAddress == null || updatedAddress.getCountry() != null || !AddressType.CODE_PERMANENT_ADDRESS.equals((Object)updatedAddress.getType()) && !AddressType.CODE_CONFIDENTIAL_ADDRESS.equals((Object)updatedAddress.getType()) && !AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.equals((Object)updatedAddress.getType())) continue;
                    currentAddress.setCountry(Country.CODE_USA.getCode());
                }
                catch (ServiceException ex) {
                    this.logger.debug((Object)"Failed to merge an Address", (Throwable)ex);
                    throw new RuntimeException("Failed to merge an Address", ex);
                }
            }
            if (!isUpdated) {
                try {
                    Address currentAddress = new Address();
                    this.getMergeRuleService().mergeAddress(updatedAddress, currentAddress);
                    if (this.isMessageFromVOA() && updatedAddress != null && updatedAddress.getCountry() == null && (AddressType.CODE_PERMANENT_ADDRESS.equals((Object)updatedAddress.getType()) || AddressType.CODE_CONFIDENTIAL_ADDRESS.equals((Object)updatedAddress.getType()) || AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.equals((Object)updatedAddress.getType()))) {
                        currentAddress.setCountry(Country.CODE_USA.getCode());
                    }
                    this.getResultPerson().addAddress(currentAddress);
                }
                catch (ServiceException ex) {
                    this.logger.debug((Object)"Failed to add/merge an Address", (Throwable)ex);
                    throw new RuntimeException("Failed to add/merge an Address", ex);
                }
            }
        }
    }

    private void retireCurrentAddress(Address newAddress, Set addresses) {
        if (addresses != null) {
            for (Object obj : addresses) {
                Address currentAddress;
                if (!(obj instanceof Address) || (currentAddress = (Address)obj).getType() == null || newAddress == null || newAddress.getType() == null || !this.isEqual(currentAddress.getType().getCode(), newAddress.getType().getCode())) continue;
                currentAddress.setEndDate(this.getImpreciseDate(Calendar.getInstance().getTime()));
                currentAddress.setChangeDate(newAddress.getChangeDate());
            }
        }
    }

    private String getAddressType(Address address) {
        return address != null && address.getType() != null ? address.getType().getCode() : null;
    }

    @Override
    public boolean isAddressChanged() {
        if (this.getPristineAddress() == null && this.getIncomingAddress() != null) {
            return true;
        }
        return !this.isEqual(this.getAddressLineOne(), this.getPristineAddressLineOne()) || !this.isEqual(this.getCity(), this.getPristineCity()) || !this.isEqual(this.getAddressStateCode(), this.getPristineAddressStateCode()) || !this.isEqual(this.getAddressZipCode(), this.getPristineAddressZipCode()) || !this.isEqual(this.getProvince(), this.getPristineProvince()) || !this.isEqual(this.getPostalCode(), this.getPristinePostalCode()) || !this.isEqual(this.getCountry(), this.getPristineCountry());
    }

    private Address getIncomingAddress() {
        if (this.incomingAddress == null) {
            DemographicAccessor accessor = this.getDemographicAccessor();
            this.incomingAddress = accessor != null ? accessor.getAddress(PropertyAccessor.DataType.INCOMING) : null;
        }
        return this.incomingAddress;
    }

    private Address getPristineAddress() {
        if (this.pristineAddress == null) {
            DemographicAccessor accessor = this.getDemographicAccessor();
            this.pristineAddress = accessor != null ? accessor.getAddress(PropertyAccessor.DataType.PRISTINE) : null;
        }
        return this.pristineAddress;
    }

    @Override
    public boolean isValidUSAState() {
        return this.isValidUSAState(this.getAddressStateCode());
    }

    private boolean isValidUSAState(String stateCode) {
        boolean valid = false;
        try {
            State state = this.getLookupService().getStateByCode(stateCode);
            if (state != null) {
                valid = true;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return valid;
    }

    private Set getUpdatedVeteranAddresses() {
        if (this.updatedVeteranAddresses == null) {
            this.updatedVeteranAddresses = this.getAddressInputData() != null ? this.getAddressInputData().getUpdatedVeteranAddresses() : null;
        }
        return this.updatedVeteranAddresses;
    }

    private AddressInputData getAddressInputData() {
        RuleDataAware data;
        if (this.addressInputData == null && (data = this.getRuleDataAware()) instanceof AddressInputData) {
            this.addressInputData = (AddressInputData)data;
        }
        return this.addressInputData;
    }

    private Association getOnFileAssociation() {
        return this.getAddressInputData().getOnFileAssociation();
    }

    private Address getResultAddress() {
        if (this.resultAddress == null) {
            if (this.getCommsInputData() != null) {
                this.resultAddress = this.getCommsInputData().getMailingAddress();
                this.getCommsInputData().setAddressChanged(true);
            } else {
                Address address = this.resultAddress = this.getAddressInputData() != null ? this.getAddressInputData().getResultAddress() : null;
                if (this.resultAddress == null && this.getAssociation() != null) {
                    Address newAddress = new Address();
                    this.getOnFileAssociation().setAddress(newAddress);
                    return newAddress;
                }
                if (this.resultAddress == null && this.getIncomingAddress() != null && this.getIncomingAddress().getType() != null) {
                    this.resultAddress = Address.getAddressOfType(this.getResultPerson().getAddresses(), this.getIncomingAddress().getType().getCode());
                    if (this.resultAddress == null) {
                        this.resultAddress = new Address();
                        this.getResultPerson().addAddress(this.resultAddress);
                    }
                }
            }
        }
        return this.resultAddress;
    }

    private Date getPreciseDate(ImpreciseDate date) {
        return date != null ? ImpreciseDateUtils.getDateWithDefault(date) : null;
    }

    private ImpreciseDate getImpreciseDate(Date date) {
        return date != null ? new ImpreciseDate(date) : null;
    }

    @Override
    protected AbstractKeyedEntity getKeyedEntity() {
        return this.getResultAddress();
    }

    private boolean isCurrentMailingAddressSameAsOriginal() {
        CommsInputData cid = this.getCommsInputData();
        if (cid != null) {
            Address current = cid.getMailingAddress();
            Address original = cid.getUpdatedMailingAddress();
            if (original == null && current != null) {
                return true;
            }
        }
        return false;
    }

    private Address getLetterMailingAddress() {
        CommsInputData commsInputData = this.getCommsInputData();
        CommsLogEntry commsLogEntry = commsInputData != null ? commsInputData.getCommsLogEntry() : null;
        return commsLogEntry != null ? commsLogEntry.getAddress() : null;
    }

    @Override
    public boolean isIncomingAddressFieldsAllNull() {
        return StringUtils.isEmpty((String)this.getAddressLineOne()) && StringUtils.isEmpty((String)this.getAddressLineTwo()) && StringUtils.isEmpty((String)this.getAddressLineThree()) && StringUtils.isEmpty((String)this.getAddressStateCode()) && StringUtils.isEmpty((String)this.getAddressZipCode()) && StringUtils.isEmpty((String)this.getCity()) && StringUtils.isEmpty((String)this.getCountry()) && StringUtils.isEmpty((String)this.getCounty()) && StringUtils.isEmpty((String)this.getProvince()) && StringUtils.isEmpty((String)this.getPostalCode()) && StringUtils.isEmpty((String)this.getZipPlus4());
    }

    @Override
    public boolean isVerificationInfoNotNull() {
        return this.getAddressInputData().getVerificationInfo() != null;
    }

    @Override
    public void setTempAddressFlaginVerificationInfo(boolean tempAddressUpdateMoreRecent) {
        this.getAddressInputData().getVerificationInfo().setTempAddressUpdateMoreRecent(tempAddressUpdateMoreRecent);
    }
}

