/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.ClinicalFactorInput;
import gov.va.med.esr.common.rule.data.ClinicalDeterminationInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.service.MatchRuleService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ClinicalFactorInputParameter
extends BaseParameter
implements ClinicalFactorInput {
    private static final long serialVersionUID = 2004163891862166279L;
    private CatastrophicDisability catastrophicDisability = null;
    private CatastrophicDisability veteranCD = null;
    private MilitarySexualTrauma militarySexualTrauma = null;
    private MilitarySexualTrauma veteranMilitarySexualTrauma = null;
    private NoseThroatRadium noseThroatRadium = null;
    private NoseThroatRadium veteranNoseThroatRadium = null;
    private ClinicalDetermination clinicalDetermination = null;
    private ClinicalDeterminationInputData clinicalDeterminationInputData = null;
    private CatastrophicDisability priorCD = null;

    @Override
    public String getSendingFacilityCode() {
        VAFacility sendingFacility = super.getSendingFacility();
        return sendingFacility != null ? sendingFacility.getCode() : null;
    }

    @Override
    public CatastrophicDisability getCatastrophicDisability() {
        if (this.catastrophicDisability == null) {
            this.catastrophicDisability = this.getCatastrophicDisability(this.getIncomingPerson());
        }
        return this.catastrophicDisability;
    }

    @Override
    public String getCatastrophicDisabilityIndicator() {
        CatastrophicDisability cd = this.getCatastrophicDisability();
        return this.getCatastrophicDisabilityIndicator(cd);
    }

    @Override
    public String getCatastrophicDisabilityIndicator(Person person) {
        CatastrophicDisability cd = this.getCatastrophicDisability(person);
        return this.getCatastrophicDisabilityIndicator(cd);
    }

    private String getCatastrophicDisabilityIndicator(CatastrophicDisability cd) {
        return cd != null && cd.isCatastrophicallyDisabled() != null && cd.isCatastrophicallyDisabled() != false ? "Y" : "N";
    }

    @Override
    public Date getDateOfDecision() {
        CatastrophicDisability cd = this.getCatastrophicDisability();
        return cd != null ? cd.getDecisionDate() : null;
    }

    @Override
    public String getMethodOfDetermination() {
        CatastrophicDisability cd = this.getCatastrophicDisability();
        CDDeterminationMethod method = cd != null ? cd.getDeterminationMethod() : null;
        return method != null ? method.getCode() : null;
    }

    @Override
    public String getDeterminingSite() {
        CatastrophicDisability cd = this.getCatastrophicDisability();
        return cd != null && cd.getDeterminationFacility() != null ? cd.getDeterminationFacility().getCode() : null;
    }

    @Override
    public Date getDateOfReview() {
        CatastrophicDisability cd = this.getVeteranCatastrophicDisability();
        return cd != null ? cd.getReviewDate() : null;
    }

    @Override
    public Date getCatastrophicReviewDate() {
        return this.getDateOfReview();
    }

    @Override
    public CatastrophicDisability getVeteranCatastrophicDisability() {
        if (this.veteranCD == null) {
            this.veteranCD = this.getCatastrophicDisability(this.getPristinePerson());
        }
        return this.veteranCD;
    }

    @Override
    public String getVeteranCatastrophicDisabilityIndicator() {
        CatastrophicDisability cd = this.getVeteranCatastrophicDisability();
        return cd != null && cd.isCatastrophicallyDisabled() != null && cd.isCatastrophicallyDisabled() != false ? "Y" : "N";
    }

    @Override
    public Date getVeteranDateOfDecision() {
        CatastrophicDisability cd = this.getVeteranCatastrophicDisability();
        return cd != null ? cd.getDecisionDate() : null;
    }

    @Override
    public String getVeteranMethodOfDetermination() {
        CatastrophicDisability cd = this.getVeteranCatastrophicDisability();
        CDDeterminationMethod method = cd != null ? cd.getDeterminationMethod() : null;
        return method != null ? method.getCode() : null;
    }

    @Override
    public String getVeteranDeterminingSite() {
        CatastrophicDisability cd = this.getVeteranCatastrophicDisability();
        return cd != null && cd.getDeterminationFacility() != null ? cd.getDeterminationFacility().getCode() : null;
    }

    @Override
    public void updateVeteranDisability() {
        try {
            CatastrophicDisability veteranCD = this.getCatastrophicDisability(this.getResultPerson());
            if (veteranCD == null) {
                veteranCD = new CatastrophicDisability();
                this.getMergeRuleService().mergeCatastrophicDisability(this.getCatastrophicDisability(), veteranCD, false);
                this.getResultPerson().addClinicalDetermination(veteranCD);
            } else {
                this.getMergeRuleService().mergeCatastrophicDisability(this.getCatastrophicDisability(), veteranCD, false);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge an CatastrophicDisability", (Throwable)e);
            throw new RuntimeException("Failed to merge an CatastrophicDisability", e);
        }
    }

    @Override
    public void updateCDDescriptorsOnly() {
        try {
            CatastrophicDisability veteranCD = this.getCatastrophicDisability(this.getResultPerson());
            if (veteranCD != null) {
                this.getMergeRuleService().mergeCatastrophicDisabilityCDDescriptorsOnly(this.getCatastrophicDisability(), veteranCD, true);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge a CatastrophicDisability with CDDescriptor(s)", (Throwable)e);
            throw new RuntimeException("Failed to merge a CatastrophicDisability with CDDescriptor(s)", e);
        }
    }

    @Override
    public void removeVeteranDisability() {
        Person resultPerson = this.getResultPerson();
        CatastrophicDisability veteranCD = this.getCatastrophicDisability(resultPerson);
        if (veteranCD != null) {
            resultPerson.removeClinicalDetermination(veteranCD);
        }
    }

    private CatastrophicDisability getCatastrophicDisability(Person person) {
        return (CatastrophicDisability)this.getHelperService().getClinicalDetermination(CatastrophicDisability.class, person);
    }

    @Override
    public MilitarySexualTrauma getMilitarySexualTrauma() {
        if (this.militarySexualTrauma == null) {
            this.militarySexualTrauma = this.getMST(this.getIncomingPerson());
        }
        return this.militarySexualTrauma;
    }

    @Override
    public String getMSTStatus() {
        MilitarySexualTrauma mst = this.getMilitarySexualTrauma();
        return mst != null && mst.getStatus() != null ? mst.getStatus().getCode() : null;
    }

    @Override
    public String getMSTIndicator() {
        MilitarySexualTrauma mst = this.getMilitarySexualTrauma();
        return mst != null ? "Y" : "N";
    }

    @Override
    public Date getMSTStatusChangeDate() {
        MilitarySexualTrauma mst = this.getMilitarySexualTrauma();
        return mst != null ? mst.getStatusChangeDate() : null;
    }

    @Override
    public String getScreenedReportsMSTIndicator() {
        MilitarySexualTrauma mst = this.getMilitarySexualTrauma();
        return mst != null && mst.getStatus() != null ? mst.getStatus().getCode() : null;
    }

    @Override
    public String getSiteDeterminingMST() {
        MilitarySexualTrauma mst = this.getMilitarySexualTrauma();
        return mst != null && mst.getDeterminationFacility() != null ? mst.getDeterminationFacility().getStationNumber() : null;
    }

    @Override
    public MilitarySexualTrauma getVeteranMST() {
        if (this.veteranMilitarySexualTrauma == null) {
            this.veteranMilitarySexualTrauma = this.getMST(this.getPristinePerson());
        }
        return this.veteranMilitarySexualTrauma;
    }

    @Override
    public String getVeteranMSTStatus() {
        MilitarySexualTrauma mst = this.getVeteranMST();
        return mst != null && mst.getStatus() != null ? mst.getStatus().getCode() : null;
    }

    @Override
    public Date getVeteranMSTStatusChangedDate() {
        MilitarySexualTrauma mst = this.getVeteranMST();
        return mst != null ? mst.getStatusChangeDate() : null;
    }

    @Override
    public boolean isReceivedMSTSameAsVeteran() {
        return false;
    }

    @Override
    public void updateVeteranMST() {
        try {
            MilitarySexualTrauma vetMST = this.getMST(this.getResultPerson());
            if (vetMST == null) {
                vetMST = new MilitarySexualTrauma();
                this.getMergeRuleService().mergeMilitarySexualTrauma(this.getMilitarySexualTrauma(), vetMST);
                this.getResultPerson().addClinicalDetermination(vetMST);
            } else {
                this.getMergeRuleService().mergeMilitarySexualTrauma(this.getMilitarySexualTrauma(), vetMST);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge an MilitarySexualTrauma", (Throwable)e);
            throw new RuntimeException("Failed to merge an MilitarySexualTrauma", e);
        }
    }

    @Override
    public SpinalCordInjury getVeternSpinalCordInjury() {
        if (!this.isMessageFromVOA()) {
            return null;
        }
        return this.getPristinePerson().getSpinalCordInjury();
    }

    @Override
    public void updateVeternSpinalCordInjury() {
        SpinalCordInjury sci = this.getIncomingPerson().getSpinalCordInjury();
        if (sci != null) {
            sci.setPerson(null);
        }
        this.getResultPerson().setSpinalCordInjury(sci);
    }

    private MilitarySexualTrauma getMST(Person person) {
        return (MilitarySexualTrauma)this.getHelperService().getClinicalDetermination(MilitarySexualTrauma.class, person);
    }

    @Override
    public NoseThroatRadium getNoseThroatRadium() {
        if (this.noseThroatRadium == null) {
            this.noseThroatRadium = this.getNTR(this.getIncomingPerson());
        }
        return this.noseThroatRadium;
    }

    @Override
    public Date getNTRVerificationDate() {
        NoseThroatRadium ntr = this.getNoseThroatRadium();
        return ntr != null ? ntr.getVerificationDate() : null;
    }

    @Override
    public String getNTRStationNumber() {
        NoseThroatRadium ntr = this.getNoseThroatRadium();
        return ntr != null && ntr.getVerificationFacility() != null ? ntr.getVerificationFacility().getStationNumber() : null;
    }

    @Override
    public String getNTRVerificationMethod() {
        NoseThroatRadium ntr = this.getNoseThroatRadium();
        return ntr != null && ntr.getVerificationMethod() != null ? ntr.getVerificationMethod().getCode() : null;
    }

    @Override
    public NoseThroatRadium getVeteranNTR() {
        if (this.veteranNoseThroatRadium == null) {
            this.veteranNoseThroatRadium = this.getNTR(this.getPristinePerson());
        }
        return this.veteranNoseThroatRadium;
    }

    @Override
    public Date getNTRVerificationDateForVeteran() {
        NoseThroatRadium ntr = this.getVeteranNTR();
        return ntr != null ? ntr.getVerificationDate() : null;
    }

    @Override
    public void updateVeteranNTR() {
        try {
            NoseThroatRadium vetNTR = this.getNTR(this.getResultPerson());
            if (vetNTR == null) {
                vetNTR = new NoseThroatRadium();
                this.getMergeRuleService().mergeNoseThroatRadium(this.getNoseThroatRadium(), vetNTR);
                this.getResultPerson().addClinicalDetermination(vetNTR);
            } else {
                this.getMergeRuleService().mergeNoseThroatRadium(this.getNoseThroatRadium(), vetNTR);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge an NoseThroatRadium", (Throwable)e);
            throw new RuntimeException("Failed to merge an NoseThroatRadium", e);
        }
    }

    @Override
    public void updateVeteranNTRFromVOA() {
        try {
            NoseThroatRadium vetNTR = this.getNTR(this.getResultPerson());
            NoseThroatRadium incomingNTR = (NoseThroatRadium)((Object)this.getNoseThroatRadium().clone());
            incomingNTR.setDiagnosisVerifiedDate(null);
            if (vetNTR == null) {
                vetNTR = new NoseThroatRadium();
                this.getMergeRuleService().mergeNoseThroatRadium(incomingNTR, vetNTR);
                this.getResultPerson().addClinicalDetermination(vetNTR);
            } else {
                this.getMergeRuleService().mergeNoseThroatRadium(incomingNTR, vetNTR);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge an NoseThroatRadium", (Throwable)e);
            throw new RuntimeException("Failed to merge an NoseThroatRadium", e);
        }
    }

    @Override
    public void removeVeteranNTR() {
        NoseThroatRadium veteranNTR = this.getNTR(this.getResultPerson());
        this.getResultPerson().removeClinicalDetermination(veteranNTR);
    }

    @Override
    public boolean isReceivedNTRDataSameAsVeteran() {
        NoseThroatRadium ntr = this.getNoseThroatRadium();
        NoseThroatRadium veteranNTR = this.getVeteranNTR();
        if (ntr == null && veteranNTR == null) {
            return true;
        }
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)ntr.getVerificationMethod(), (Object)veteranNTR.getVerificationMethod());
        builder.append((Object)ntr.getVerificationFacility(), (Object)veteranNTR.getVerificationFacility());
        builder.append((Object)ntr.getReceivingTreatment(), (Object)veteranNTR.getReceivingTreatment());
        builder.append((Object)ntr.getFromAviatorServiceBefore1955(), (Object)veteranNTR.getFromAviatorServiceBefore1955());
        builder.append((Object)ntr.getFromSubmarinerServiceBefore1965(), (Object)veteranNTR.getFromSubmarinerServiceBefore1965());
        builder.append((Object)ntr.getDiagnosedWithCancer(), (Object)veteranNTR.getDiagnosedWithCancer());
        builder.append((Object)ntr.getDiagnosisVerifiedDate(), (Object)veteranNTR.getDiagnosisVerifiedDate());
        return builder.isEquals();
    }

    private NoseThroatRadium getNTR(Person person) {
        return (NoseThroatRadium)this.getHelperService().getClinicalDetermination(NoseThroatRadium.class, person);
    }

    @Override
    public ClinicalDetermination getClinicalDetermination() {
        if (this.clinicalDetermination == null) {
            ClinicalDeterminationInputData clinicalDeterminationInputData = this.getClinicalDeterminationInputData();
            this.clinicalDetermination = clinicalDeterminationInputData != null ? clinicalDeterminationInputData.getIncomingClinicalDetermination() : this.getHelperService().getClinicalDetermination(ClinicalDetermination.class, this.getIncomingPerson());
        }
        return this.clinicalDetermination;
    }

    private ClinicalDeterminationInputData getClinicalDeterminationInputData() {
        RuleDataAware ruleDataAware;
        if (this.clinicalDeterminationInputData == null && (ruleDataAware = this.getRuleDataAware()) instanceof ClinicalDeterminationInputData) {
            this.clinicalDeterminationInputData = (ClinicalDeterminationInputData)ruleDataAware;
        }
        return this.clinicalDeterminationInputData;
    }

    @Override
    public boolean isScoreEmptyForConditionCode() {
        Set conditions;
        Set set = conditions = this.getCatastrophicDisability() != null ? this.getCatastrophicDisability().getConditions() : null;
        if (conditions != null) {
            for (CDCondition cdCondition : conditions) {
                if (cdCondition == null || cdCondition.getScore() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDiagnosisContained(String code) {
        Set setOfDiagnoses;
        Set set = setOfDiagnoses = this.getCatastrophicDisability() != null ? this.getCatastrophicDisability().getDiagnoses() : null;
        if (setOfDiagnoses != null && !setOfDiagnoses.isEmpty()) {
            for (CDDiagnosis cdDiagnosis : setOfDiagnoses) {
                Diagnosis diagnosis = cdDiagnosis.getDiagnosis();
                if (diagnosis == null || !diagnosis.getCode().equals(code)) continue;
                return true;
            }
        } else {
            if (setOfDiagnoses != null && setOfDiagnoses.isEmpty()) {
                return true;
            }
            if (setOfDiagnoses == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getPriorCatastrophicDisabilityIndicator() throws RuleException {
        if (this.priorCD == null) {
            this.priorCD = this.getPriorCatastrophicDisability(this.getIncomingPerson());
        }
        return this.priorCD != null ? "Y" : "N";
    }

    @Override
    public Date getCDDecisionDate(Person person) {
        CatastrophicDisability cd = person.getCatastrophicDisability();
        return cd != null ? cd.getDecisionDate() : null;
    }

    @Override
    public Date getCDReviewDate(Person person) {
        CatastrophicDisability cd = person.getCatastrophicDisability();
        return cd != null ? cd.getReviewDate() : null;
    }

    @Override
    public boolean isCDDescriptorDataChanged() {
        boolean changed = false;
        CatastrophicDisability cdIncoming = this.getCatastrophicDisability(this.getIncomingPerson());
        CatastrophicDisability cdOnFile = this.getCatastrophicDisability(this.getPristinePerson());
        if (cdIncoming == null && cdOnFile != null) {
            return true;
        }
        if (cdIncoming != null && cdOnFile == null) {
            return true;
        }
        if (cdIncoming == null && cdOnFile == null) {
            return false;
        }
        if (ObjectUtils.equals((Object)cdIncoming.getCDDescriptors().size(), (Object)cdOnFile.getCDDescriptors().size())) {
            for (CDDescriptor descriptor : cdIncoming.getCDDescriptors()) {
                CDDescriptor matched = (CDDescriptor)this.getMatchRuleService().findMatchingElement((AbstractEntity)descriptor, cdOnFile.getCDDescriptors());
                if (matched != null) continue;
                changed = true;
                break;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private MatchRuleService getMatchRuleService() {
        MatchRuleService service = null;
        service = this.getMergeRuleService().getMatchRuleService();
        return service;
    }

    @Override
    public boolean hasIncomingCDDescriptors() {
        CatastrophicDisability cd = this.getCatastrophicDisability(this.getIncomingPerson());
        return cd != null ? cd.getCDDescriptors().size() > 0 : false;
    }

    private CatastrophicDisability getPriorCatastrophicDisability(Person person) throws RuleException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null ");
        Person priorPerson = this.getPriorEEPerson();
        if (priorPerson != null) {
            return this.getCatastrophicDisability(priorPerson);
        }
        return null;
    }
}

