/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.rule.AssociationInput;
import gov.va.med.esr.common.rule.data.AssociationInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.service.MatchRuleService;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.Set;

public class AssociationInputParameter
extends BaseParameter
implements AssociationInput {
    private static final long serialVersionUID = -3382095639273222712L;
    private Association association = null;
    private Association associationOnFile = null;
    private String fName = null;
    private String lName = null;
    private String organizationName = null;
    private String associationTypeCode = null;
    private String relationship = null;
    private Date lastUpdatedDate = null;
    private Date onFileLastUpdatedDate = null;
    private Name representativeName = null;
    private Date deactivationDate = null;
    private Date dateOfBirth = null;

    @Override
    public EntityKey getEntityKey() {
        if (this.getExternalSystemsInputData() != null) {
            DemographicsChangeEvent demographicsChangeEvent = this.getExternalSystemsInputData().getDemographicsChangeEvent();
            gov.va.med.esr.service.external.person.EntityKey key = demographicsChangeEvent != null ? demographicsChangeEvent.getEntityKey() : null;
            return key != null ? CommonEntityKeyFactory.createAssociationEntityKey(key.getKey()) : null;
        }
        return this.getPristineAssociation() != null ? this.getPristineAssociation().getEntityKey() : null;
    }

    @Override
    public String getRelationshipType() {
        if (this.relationship == null) {
            this.relationship = this.getAssociation() != null ? this.getAssociation().getRelationship() : null;
        }
        return StringUtils.isNotEmpty((String)this.relationship) ? this.relationship : null;
    }

    @Override
    public Date getVeteranDateOfBirth() {
        if (this.dateOfBirth == null) {
            this.dateOfBirth = this.getDateOfBirth(this.getIncomingPerson());
        }
        return this.dateOfBirth;
    }

    @Override
    public Date getDeactivationDate() {
        if (this.deactivationDate == null) {
            this.deactivationDate = this.getAssociation() != null ? this.getAssociation().getDeactivationDate() : null;
        }
        return this.deactivationDate;
    }

    @Override
    public Date getpristineDeactivationDate() {
        return this.getPristineAssociation() != null ? this.getPristineAssociation().getDeactivationDate() : null;
    }

    @Override
    public String getPristineRelationshipType() {
        String pRelationship = this.getPristineAssociation() != null ? this.getPristineAssociation().getRelationship() : null;
        return StringUtils.isNotEmpty((String)pRelationship) ? pRelationship : null;
    }

    @Override
    public String getAssociationType() {
        if (this.associationTypeCode == null) {
            AssociationType type = this.getAssociation() != null ? this.getAssociation().getType() : null;
            this.associationTypeCode = type != null ? type.getCode() : null;
        }
        return StringUtils.isNotEmpty((String)this.associationTypeCode) ? this.associationTypeCode : null;
    }

    @Override
    public String getOrganizationName() {
        if (this.organizationName == null) {
            this.organizationName = this.getAssociation() != null ? this.getAssociation().getOrganizationName() : null;
        }
        return StringUtils.isNotEmpty((String)this.organizationName) ? this.organizationName : null;
    }

    @Override
    public String getPristineOrganizationName() {
        String pOrgName = this.getPristineAssociation() != null ? this.getPristineAssociation().getOrganizationName() : null;
        return StringUtils.isNotEmpty((String)pOrgName) ? pOrgName : null;
    }

    @Override
    public boolean isNameProvided() {
        Name name = this.getName();
        return name != null && (StringUtils.isNotEmpty((String)name.getFamilyName()) || StringUtils.isNotEmpty((String)name.getGivenName()));
    }

    @Override
    public Name getName() {
        if (this.representativeName == null) {
            this.representativeName = this.getAssociation() != null ? this.getAssociation().getRepresentativeName() : null;
        }
        return this.representativeName;
    }

    @Override
    public Name getPristineName() {
        return this.getPristineAssociation() != null ? this.getPristineAssociation().getRepresentativeName() : null;
    }

    @Override
    public String getAddressLineOne() {
        Address addr = this.getAddress();
        return addr != null ? addr.getLine1() : null;
    }

    @Override
    public String getPristineAddressLineOne() {
        Address addr = this.getPristineAddress();
        return addr != null ? addr.getLine1() : null;
    }

    @Override
    public String getAddressLineTwo() {
        Address addr = this.getAddress();
        return addr != null ? addr.getLine2() : null;
    }

    @Override
    public String getPristineAddressLineTwo() {
        Address addr = this.getPristineAddress();
        return addr != null ? addr.getLine2() : null;
    }

    @Override
    public String getAddressLineThree() {
        Address addr = this.getAddress();
        return addr != null ? addr.getLine3() : null;
    }

    @Override
    public String getPristineAddressLineThree() {
        Address addr = this.getPristineAddress();
        return addr != null ? addr.getLine3() : null;
    }

    @Override
    public String getCity() {
        Address addr = this.getAddress();
        return addr != null ? addr.getCity() : null;
    }

    @Override
    public String getPristineCity() {
        Address addr = this.getPristineAddress();
        return addr != null ? addr.getCity() : null;
    }

    @Override
    public String getCounty() {
        Address addr = this.getAddress();
        return addr != null ? addr.getCounty() : null;
    }

    @Override
    public String getPristineCounty() {
        Address addr = this.getPristineAddress();
        return addr != null ? addr.getCounty() : null;
    }

    @Override
    public String getAddressStateCode() {
        Address address = this.getAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getState()) ? address.getState() : null;
    }

    @Override
    public String getPristineAddressStateCode() {
        Address address = this.getPristineAddress();
        return address != null && StringUtils.isNotEmpty((String)address.getState()) ? address.getState() : null;
    }

    @Override
    public String getAddressZipCode() {
        return this.getAddress() != null ? this.getAddress().getZipCode() : null;
    }

    @Override
    public String getPristineAddressZipCode() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getZipCode() : null;
    }

    @Override
    public String getAddressZipPlus4() {
        return this.getAddress() != null ? this.getAddress().getZipPlus4() : null;
    }

    @Override
    public String getPristineAddressZipPlus4() {
        return this.getPristineAddress() != null ? this.getPristineAddress().getZipPlus4() : null;
    }

    @Override
    public String getPrimaryPhone() {
        String phone = this.getAssociation() != null ? this.getAssociation().getPrimaryPhone() : null;
        return StringUtils.isNotEmpty((String)phone) ? phone : null;
    }

    @Override
    public String getPristinePrimaryPhone() {
        String phone = this.getPristineAssociation() != null ? this.getPristineAssociation().getPrimaryPhone() : null;
        return StringUtils.isNotEmpty((String)phone) ? phone : null;
    }

    @Override
    public String getAssociationFirstName() {
        if (this.fName == null) {
            this.fName = this.getName() != null ? this.getName().getGivenName() : null;
        }
        return StringUtils.isNotEmpty((String)this.fName) ? this.fName : null;
    }

    @Override
    public String getAssociationLastName() {
        if (this.lName == null) {
            this.lName = this.getName() != null ? this.getName().getFamilyName() : null;
        }
        return StringUtils.isNotEmpty((String)this.lName) ? this.lName : null;
    }

    @Override
    public Date getAssociationDateTimeLastUpdated() {
        if (this.lastUpdatedDate == null) {
            this.lastUpdatedDate = this.getAssociation() != null ? this.getAssociation().getLastUpdateDate() : null;
        }
        return this.lastUpdatedDate;
    }

    @Override
    public Date getAssociationDateTimeLastUpdatedOnFile() {
        if (this.onFileLastUpdatedDate == null) {
            Association incoming = this.getAssociation();
            Set current = this.getPristinePerson().getAssociations();
            MatchRuleService mrs = this.getMergeRuleService().getMatchRuleService();
            Association association = (Association)mrs.findMatchingElement((AbstractEntity)incoming, current);
            this.onFileLastUpdatedDate = association != null ? association.getLastUpdateDate() : null;
        }
        return this.onFileLastUpdatedDate;
    }

    @Override
    public boolean isAssociationOnFile() {
        boolean newRecord = false;
        Association incoming = this.getAssociation();
        if (this.isUpdateFromGUI()) {
            Association onFileAssociation = incoming.getEntityKey() != null ? this.getPristinePerson().getAssociationByEntityKey(incoming.getEntityKey()) : null;
            newRecord = onFileAssociation != null;
        } else {
            boolean bl = newRecord = this.getResultAssociation() != null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Incoming data from GUI ? " + this.isUpdateFromGUI()));
            this.logger.debug((Object)("Incoming association " + incoming.toString()));
            this.logger.debug((Object)("Is a record on file ? " + !newRecord));
        }
        return newRecord;
    }

    @Override
    public boolean isVAGuardianExist() {
        String type = AssociationType.CODE_GUARDIAN_VA.getCode();
        Association vaGuardian = Association.getAssociationOfType(this.getPristinePerson().getAssociations(), type);
        return vaGuardian != null;
    }

    @Override
    public void updateAssociation(String type) throws RuleException {
        Association updated = Association.getAssociationOfType(this.getResultPerson().getAssociations(), type);
        Association incoming = Association.getAssociationOfType(this.getIncomingPerson().getAssociations(), type);
        if (updated != null && incoming != null) {
            try {
                this.getMergeRuleService().mergeAssociation(incoming, updated);
            }
            catch (ServiceException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to merge an association of typr " + type), (Throwable)e);
                }
                throw new RuleException("Failed to merge an association of type " + type, (Throwable)e);
            }
        }
    }

    @Override
    public void deactivateAssociationByType() throws RuleException {
        Association incoming = this.getAssociation();
        if (incoming != null && incoming.getType() != null) {
            String type = incoming.getType().getCode();
            Association updated = Association.getAssociationOfType(this.getResultPerson().getAssociations(), type);
            if (updated != null) {
                updated.setDeactivationDate(new Date());
            }
        }
    }

    @Override
    public void acceptAssociationTypeForTheVeteran() {
        try {
            Association incoming = this.getAssociation();
            Association resultAssociation = null;
            resultAssociation = this.isUpdateFromGUI() ? (incoming.getEntityKey() != null ? this.getResultPerson().getAssociationByEntityKey(incoming.getEntityKey()) : null) : this.getResultAssociation();
            if (resultAssociation != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Accept and merge association " + incoming.toString()));
                }
                this.getMergeRuleService().mergeAssociation(incoming, resultAssociation);
            } else {
                this.addNewAssociation();
            }
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge an association", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge an association", e);
        }
    }

    @Override
    public void addNewAssociation() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Accept and add a new association " + this.getAssociation() != null ? this.getAssociation().toString() : "Null"));
            }
            Association newAssociation = new Association();
            this.getMergeRuleService().mergeAssociation(this.getAssociation(), newAssociation);
            this.getResultPerson().addAssociation(newAssociation);
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to add an association", (Throwable)e);
            }
            throw new RuntimeException("Failed to add an association", e);
        }
    }

    private Address getAddress() {
        return this.getAssociation() != null ? this.getAssociation().getAddress() : null;
    }

    private Address getPristineAddress() {
        Address pristineAddress = new Address();
        if (this.getPristineAssociation() != null && this.getPristineAssociation().getAddress() != null) {
            pristineAddress = this.getPristineAssociation().getAddress();
        }
        return pristineAddress;
    }

    private Association getAssociation() {
        if (this.association == null) {
            this.association = this.getAssociationInputData() != null ? this.getAssociationInputData().getIncomingAssociation() : null;
        }
        return this.association;
    }

    @Override
    public Association getResultAssociation() {
        Association incoming = this.getAssociation();
        Set result = this.getResultPerson().getAssociations();
        MatchRuleService mrs = this.getMergeRuleService().getMatchRuleService();
        return (Association)mrs.findMatchingElement((AbstractEntity)incoming, result);
    }

    public Association getPristineAssociation() {
        if (this.associationOnFile == null) {
            Association incoming = this.getAssociation();
            Set current = this.getPristinePerson().getAssociations();
            MatchRuleService mrs = this.getMergeRuleService().getMatchRuleService();
            this.associationOnFile = (Association)mrs.findMatchingElement((AbstractEntity)incoming, current);
        }
        return this.associationOnFile;
    }

    private AssociationInputData getAssociationInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof AssociationInputData) {
            return (AssociationInputData)ruleDataAware;
        }
        return null;
    }
}

