/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.common.rule.data.accessor.PropertyAccessor;
import java.util.Set;

public class AddressInputData
extends BaseData
implements DemographicAccessor {
    private static final long serialVersionUID = -8430111235679047716L;
    private Set updatedVeteranAddresses = null;
    private Address pristineAddress = null;
    private Address resultAddress = null;
    private Address incomingAddress = null;
    private Association onFileAssociation = null;
    private VerificationInfo verificationInfo = null;

    public AddressInputData(Address incoming) {
        super(incoming.getPerson());
        this.setIncomingAddress(incoming);
        this.setResultAddress(null);
        this.setPristineAddress(null);
    }

    public AddressInputData(Address incoming, Person onFile, Person pristine) {
        super(incoming.getPerson(), onFile, pristine);
        if (incoming.getType() != null) {
            Address found = Address.getAddressOfType(pristine.getAddresses(), incoming.getType().getCode());
            this.setIncomingAddress(incoming);
            this.setPristineAddress(found);
            this.setResultAddress(null);
            this.setUpdatedVeteranAddresses(onFile.getAddresses());
        }
    }

    public AddressInputData(Address incoming, InsurancePolicy onFilePolicy) {
        super(onFilePolicy.getPerson());
        this.setIncomingAddress(incoming);
    }

    public AddressInputData(Address incoming, Association onFileAssociation) {
        super(incoming.getAssociation().getPerson(), onFileAssociation.getPerson());
        this.setIncomingAddress(incoming);
        this.setResultAddress(onFileAssociation.getAddress());
        this.setPristineAddress(onFileAssociation.getAddress());
        this.setOnFileAssociation(onFileAssociation);
    }

    public AddressInputData(Address incoming, Person onFile, Person pristine, VAFacility sendingFacility) {
        this(incoming, onFile, pristine);
        this.setSendingFacility(sendingFacility);
    }

    public AddressInputData(Address incoming, Person onFile, Person pristine, VAFacility sendingFacility, VerificationInfo veriInfo) {
        this(incoming, onFile, pristine);
        this.setSendingFacility(sendingFacility);
        this.setVerificationInfo(veriInfo);
    }

    public Address getIncomingAddress() {
        return this.incomingAddress;
    }

    public void setIncomingAddress(Address incomingAddress) {
        this.incomingAddress = incomingAddress;
    }

    public Address getPristineAddress() {
        return this.pristineAddress;
    }

    public void setPristineAddress(Address pristineAddress) {
        this.pristineAddress = pristineAddress;
    }

    public Address getResultAddress() {
        return this.resultAddress;
    }

    public void setResultAddress(Address resultAddress) {
        this.resultAddress = resultAddress;
    }

    public Set getUpdatedVeteranAddresses() {
        return this.updatedVeteranAddresses;
    }

    public void setUpdatedVeteranAddresses(Set updatedVeteranAddresses) {
        this.updatedVeteranAddresses = updatedVeteranAddresses;
    }

    public Association getOnFileAssociation() {
        return this.onFileAssociation;
    }

    public void setOnFileAssociation(Association onFileAssociation) {
        this.onFileAssociation = onFileAssociation;
    }

    @Override
    public Address getAddress(PropertyAccessor.DataType dataType) {
        if (dataType == null) {
            return null;
        }
        Address add = null;
        if (dataType.isIncoming()) {
            add = this.getIncomingAddress();
        } else if (dataType.isPristine()) {
            add = this.getPristineAddress();
        } else if (dataType.isResult()) {
            add = this.getResultAddress();
        }
        return add;
    }

    public VerificationInfo getVerificationInfo() {
        return this.verificationInfo;
    }

    public void setVerificationInfo(VerificationInfo verificationInfo) {
        this.verificationInfo = verificationInfo;
    }
}

