/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportVBAQueryStatus;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class VBAStatusQueryDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -2129466633314231407L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        ReportParameterSet parameters;
        Query query = null;
        query = this.getNameResolver() != null ? this.getNamedQuery(this.getNameResolver().getReportName(config), session) : this.getNamedQuery(session);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
        if (parameters == null) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID());
        }
        query.setDate("startDate", parameters.getFromDate());
        query.setDate("endDate", parameters.getToDate());
        Set vbaQueryStatuses = parameters.getVBAQueryStatuses();
        query.setParameterList("vbaQueryStatusList", (Collection)this.getVBAQueryStatusIds(vbaQueryStatuses));
        return query;
    }

    private List getVBAQueryStatusIds(Set vbaQueryStatuses) {
        Iterator i = vbaQueryStatuses != null ? vbaQueryStatuses.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportVBAQueryStatus qryStatus = (ReportVBAQueryStatus)i.next();
            if (qryStatus == null) continue;
            list.add(((AACIndicator)qryStatus.getLookup()).getIdentifier());
        }
        return list;
    }
}

