/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class QM11ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -4042897274862070508L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        ReportParameterSet parameters;
        Query query = null;
        query = this.getNameResolver() != null ? this.getNamedQuery(this.getNameResolver().getReportName(config), session) : this.getNamedQuery(session);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
        if (parameters == null) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID());
        }
        query.setDate("startDate", parameters.getFromDate());
        query.setDate("endDate", parameters.getToDate());
        List functionalGroupIds = this.getLookupIds(parameters.getFunctionalGroups());
        query.setParameterList("functionalGroupList", (Collection)functionalGroupIds);
        Set casTypes = parameters.getWkfCaseTypes();
        List wkfTypeIds = null;
        wkfTypeIds = casTypes != null && casTypes.size() > 0 ? this.getLookupIds(parameters.getWkfCaseTypes()) : this.getLookupIds(WkfCaseType.class);
        query.setParameterList("wkfCaseTypeList", (Collection)wkfTypeIds);
        boolean runReportByUser = parameters.getRunReportByUser();
        if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())) {
            Integer days = parameters.getOutlierDays();
            if (days == null) {
                days = new Integer(0);
            }
            query.setInteger("days", days.intValue());
            Integer records = parameters.getRandomNumberOfRecords();
            if (records == null) {
                records = new Integer(0);
            }
            query.setInteger("records", records.intValue());
        }
        return query;
    }
}

