/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatus;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class P8GReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 1L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            Date endDate = parameters.getToDate();
            if (endDate == null) {
                throw new ReportDataException("Missing End Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && !StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    List visns = this.getFacilitityIds(parameters.getFacilities());
                    if (visns != null && !visns.isEmpty()) {
                        query.setParameterList("visns", visns.toArray());
                    } else {
                        ArrayList<Integer> facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setParameterList("visns", facilities);
                    }
                    if (parameters.isNoVISNPresent()) {
                        query.setString("noVISN", "noVISN");
                    } else {
                        query.setString("noVISN", "VISN");
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        ArrayList<Integer> facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setParameterList("facilities", facilities);
                        query.setString("is_all", "all");
                    } else {
                        query.setParameterList("facilities", (Collection)this.getFacilitityIds(reportFacilities));
                        query.setString("is_all", "notAll");
                    }
                }
            }
        }
        return query;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            list.add(((VAFacility)rFacility.getLookup()).getIdentifier());
        }
        return list;
    }

    private List getEnrollmentStatusIds(Set reportEnrollmentStatus) {
        ArrayList<String> list;
        block3: {
            Iterator i;
            block2: {
                list = new ArrayList<String>();
                if (reportEnrollmentStatus != null && !reportEnrollmentStatus.isEmpty()) break block2;
                Set pendingEs = EnrollmentStatus.getPendingEnrollmentStatuses();
                if (pendingEs == null) break block3;
                Iterator iter = pendingEs.iterator();
                while (iter.hasNext()) {
                    list.add((String)iter.next());
                }
                break block3;
            }
            Iterator iterator = i = reportEnrollmentStatus != null ? reportEnrollmentStatus.iterator() : null;
            while (i != null && i.hasNext()) {
                ReportEnrollmentStatus rEnrollmentStatus = (ReportEnrollmentStatus)i.next();
                if (rEnrollmentStatus == null) continue;
                list.add(((EnrollmentStatus)rEnrollmentStatus.getLookup()).getCode());
            }
        }
        return list;
    }
}

