/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.report.BaseReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class Cor1ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 1186984553660142327L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            String code;
            ArrayList<String> queryList;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            Date endDate = parameters.getToDate();
            if (endDate == null) {
                throw new ReportDataException("Missing End Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
            ArrayList<String> emptyList = new ArrayList<String>();
            emptyList.add("");
            if (parameters.getAllLetterRejectReasons()) {
                query.setString("is_reject_all", "all");
                query.setParameterList("letterRejectReasons", emptyList);
            } else {
                query.setString("is_reject_all", "notAll");
                queryList = new ArrayList<String>();
                Set rejectReasons = parameters.getLetterRejectReasons();
                if (rejectReasons.size() > 0) {
                    for (BaseReportLookupParameter param : rejectReasons) {
                        code = param.getLookup().getCode();
                        queryList.add(code);
                    }
                } else {
                    queryList = emptyList;
                }
                query.setParameterList("letterRejectReasons", queryList);
            }
            if (parameters.getAllLetterErrorTypes()) {
                query.setString("is_error_all", "all");
                query.setParameterList("letterErrorTypes", emptyList);
            } else {
                query.setString("is_error_all", "notall");
                queryList = new ArrayList();
                Set errorReasons = parameters.getLetterErrorTypes();
                if (errorReasons.size() > 0) {
                    for (BaseReportLookupParameter param : errorReasons) {
                        code = param.getLookup().getCode();
                        queryList.add(code);
                    }
                } else {
                    queryList = emptyList;
                }
                query.setParameterList("letterErrorTypes", queryList);
            }
        }
        return query;
    }
}

