/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.BaseReportLookupParameter;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPeriod;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.common.report.data.ParameterConfig;
import gov.va.med.esr.common.report.data.ReportParameterConfig;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportPersister;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.Validate;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;

public class DatabaseReportPersister
extends AbstractComponent
implements ReportPersister {
    private static final long serialVersionUID = 8051680457792536251L;
    public static final String NEW_LINE = "\n";
    public static final String COLON = ": ";
    public static final String COMMA = ", ";
    public static final String SPACE = " ";
    private ReportDAO reportDAO = null;
    private MailService mailService = null;
    private SimpleMailMessage messageTemplate = null;
    private ReportParameterConfig reportParameterConfig;
    private MessageSource messageSource;
    private String esrWebUrl = null;

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.reportDAO, (String)"A report DAO must be configured");
        Validate.notNull((Object)this.mailService, (String)"A mail service must be configured");
        Validate.notNull((Object)this.esrWebUrl, (String)"The ESR Web URL must be configured.");
        Validate.notNull((Object)this.messageTemplate, (String)"A message template must be configured");
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public void setReportDAO(ReportDAO reportDAO) {
        this.reportDAO = reportDAO;
    }

    public String getEsrWebUrl() {
        return this.esrWebUrl;
    }

    public void setEsrWebUrl(String esrWebUrl) {
        this.esrWebUrl = esrWebUrl;
    }

    public void setMessageTemplate(SimpleMailMessage template) {
        this.messageTemplate = template;
    }

    public ReportParameterConfig getReportParameterConfig() {
        return this.reportParameterConfig;
    }

    public void setReportParameterConfig(ReportParameterConfig reportParameterConfig) {
        this.reportParameterConfig = reportParameterConfig;
    }

    public void persist(ReportConfiguration config, ByteArrayOutputStream stream) throws ReportException {
        block4: {
            byte[] content = (byte[])stream.toByteArray().clone();
            CompletedReport report = this.createCompletedReport(config, stream);
            report.setReportParameterText(this.getConfigParams(config));
            try {
                this.reportDAO.saveCompletedReport(report);
            }
            catch (DAOException e) {
                throw new ReportException("Failed to persist a report", (Throwable)e);
            }
            try {
                this.sendNotificationMail(config, report, content);
            }
            catch (MailException e) {
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info((Object)"Failed to send notification message", (Throwable)e);
            }
        }
    }

    protected void sendNotificationMail(ReportConfiguration config, CompletedReport report, byte[] content) throws MailException {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
        String email = reportSetup.getEmail();
        if (!StringUtils.isBlank((String)email)) {
            StandardReport generatedReport = reportSetup.getReport();
            String code = generatedReport.getCode();
            String desc = generatedReport.getDescription();
            String reportType = generatedReport.getType() != null ? generatedReport.getType().getDescription() : "";
            StringBuffer text = new StringBuffer();
            text.append("The following HECMS report is available for your viewing:");
            text.append("\nReport Type: ").append(reportType);
            text.append("\nReport ID: ").append(code);
            text.append("\nReport Title: ").append(desc);
            text.append("\nDate Run: ").append(report.getCompletedDate());
            text.append("\n\nPlease access the HECMS via this weblink '").append(this.esrWebUrl).append("' to login into the system.");
            text.append("\n\nIf you have any questions please call the HEC for assistance.");
            SimpleMailMessage message = new SimpleMailMessage(this.messageTemplate);
            message.setTo(StringUtils.split((String)email, (String)","));
            StringBuffer subject = new StringBuffer("HEC Notification of Report Available for Viewing");
            subject.append(" - ").append(code).append(" - ").append(desc).append(".");
            message.setSubject(subject.toString());
            this.mailService.send(text.toString(), message);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Sending generated reports " + generatedReport.getDescription() + " to " + email));
            }
        }
    }

    protected CompletedReport createCompletedReport(ReportConfiguration config, ByteArrayOutputStream stream) throws ReportException {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
        UserPrincipal user = reportCriteria != null ? reportCriteria.getReportUser() : null;
        ESRUserPrincipal esr_user = user instanceof ESRUserPrincipal ? (ESRUserPrincipal)user : null;
        ReportParameterSet reportParam = reportSetup != null ? reportSetup.getParameterSet() : null;
        CompletedReport report = new CompletedReport();
        report.setCompletedDate(Calendar.getInstance().getTime());
        report.setUser(esr_user);
        report.setStandardReport(reportSetup.getReport());
        report.setFileType(reportParam.getFileType());
        try {
            stream.flush();
            report.setReportFileContent(stream.toByteArray());
            stream.close();
        }
        catch (IOException e) {
            throw new ReportException("Failed to write a report to a stream ", (Throwable)e);
        }
        return report;
    }

    private String getConfigParams(ReportConfiguration config) {
        Map parameterMap = this.getReportParameterConfig() != null ? this.getReportParameterConfig().getParameterMap() : null;
        Map reportIDParamMap = parameterMap != null && config != null ? (Map)parameterMap.get(config.getReportName()) : null;
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
        return reportIDParamMap != null && reportSetup != null ? this.getConfigParams(reportSetup, reportIDParamMap, this.getMessageSource()) : null;
    }

    private String getConfigParams(ReportSetup reportSetup, Map repParamsMap, MessageSource messageResources) {
        ReportRunFrequency frequency;
        if (reportSetup == null || repParamsMap == null || messageResources == null) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        String dispProperty = null;
        for (String key : repParamsMap.keySet()) {
            ParameterConfig property = (ParameterConfig)repParamsMap.get(key);
            if (property == null) continue;
            try {
                dispProperty = messageResources.getMessage(property.getLabel(), null, Locale.getDefault());
                Object obj = PropertyUtils.getProperty((Object)((Object)reportSetup), (String)property.getParameterName());
                if (property.getParameterName() == null || !property.isDisplayParameter() || obj == null) continue;
                strBuff.append(dispProperty).append(COLON);
                strBuff.append(this.getParamValue(obj, NEW_LINE));
            }
            catch (Exception e) {}
        }
        ReportRunFrequency reportRunFrequency = frequency = reportSetup.getSchedule() != null ? reportSetup.getSchedule().getRunFrequency() : null;
        if (frequency != null) {
            strBuff.append("Schedule Type: ").append(this.getParamValue((Object)frequency, NEW_LINE));
        }
        return strBuff.toString();
    }

    private String getParamValue(Object obj, String separator) {
        StringBuffer str = new StringBuffer();
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            str.append(DateUtils.format((Date)((Date)obj), (String)"MM/dd/yyyy")).append(separator);
        } else if (obj instanceof AbstractNamedLookup) {
            String name = ((AbstractNamedLookup)obj).getName();
            name = name == null ? ((AbstractNamedLookup)obj).getDescription() : name;
            str.append(name).append(separator);
        } else if (obj instanceof BaseReportLookupParameter) {
            str.append(((BaseReportLookupParameter)obj).getLookup().getDescription()).append(separator);
        } else if (obj instanceof ReportPeriod) {
            str = this.getReportPeriodParamValue((ReportPeriod)((Object)obj));
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            int size = collection.size();
            int index = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (++index < size) {
                    str.append(this.getParamValue(iter.next(), COMMA));
                    continue;
                }
                str.append(this.getParamValue(iter.next(), NEW_LINE));
            }
        } else {
            str.append(obj.toString()).append(NEW_LINE);
        }
        return str.toString();
    }

    private StringBuffer getReportPeriodParamValue(ReportPeriod obj) {
        StringBuffer str = new StringBuffer();
        if (obj != null) {
            ReportPeriodType reportPeriodType = obj.getType();
            String reportPeriod = reportPeriodType.getCode();
            if (ReportPeriodType.CODE_ALL_FISCAL_YEARS.getCode().equals(reportPeriod) || ReportPeriodType.CODE_FISCAL_YEAR.getCode().equals(reportPeriod)) {
                str.append(this.getParamValue((Object)reportPeriodType, COLON));
                str.append(obj.getYear()).append(NEW_LINE);
            } else if (ReportPeriodType.CODE_QUARTERLY.getCode().equals(reportPeriod)) {
                str.append(this.getParamValue((Object)reportPeriodType, COLON));
                str.append(obj.getYear()).append(SPACE);
                str.append(this.getParamValue((Object)obj.getQuarter(), SPACE)).append("Quarter");
            } else if (ReportPeriodType.CODE_DATE_RANGE.getCode().equals(reportPeriod) && obj.getFromDate() != null && obj.getToDate() != null) {
                str.append(this.getParamValue((Object)reportPeriodType, COLON));
                str.append(DateUtils.format((Date)obj.getFromDate(), (String)"MM/dd/yyyy")).append(" - ");
                str.append(DateUtils.format((Date)obj.getToDate(), (String)"MM/dd/yyyy")).append(NEW_LINE);
            }
        }
        return str;
    }
}

