/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class CompositeReportBuilder
extends ConfigurableReportBuilder {
    private static final long serialVersionUID = 1325536722208589025L;
    private Map queryNames = null;
    private Map requiredDataSources = null;

    public void setQueryNames(Map queryNames) {
        this.queryNames = queryNames;
    }

    public void setRequiredDataSources(Map requiredDataSources) {
        this.requiredDataSources = requiredDataSources;
    }

    protected ReportData doRequestData(ReportConfiguration configuration) throws ReportException {
        Object tmp;
        ReportDataService service = this.getReportDataService(configuration);
        QueryCriteria criteria = configuration.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportParameterSet paramsSet = reportCriteria.getReportSetup() != null ? reportCriteria.getReportSetup().getParameterSet() : null;
        ReportFormat format = paramsSet.getReportFormat() != null ? paramsSet.getReportFormat() : null;
        StringBuffer reportName = new StringBuffer();
        reportName.append(configuration.getReportName());
        if (format != null && format.getDescription() != null) {
            reportName.append(".").append(StringUtils.deleteWhitespace((String)format.getDescription()));
        }
        String flag = (tmp = this.requiredDataSources.get(reportName.toString())) != null && tmp.equals("true") ? (String)tmp : "false";
        boolean dataforMasterReport = new Boolean(flag);
        JasperReportData data = new JasperReportData(new ArrayList());
        tmp = this.queryNames.get(reportName.toString());
        List subReports = tmp instanceof List ? (List)tmp : null;
        int totalOfReports = subReports != null ? subReports.size() : 0;
        for (int i = 0; i < totalOfReports; ++i) {
            String queryName = subReports.get(i).toString();
            try {
                ReportConfiguration reportConfig = new ReportConfiguration(queryName, configuration.getReportID(), configuration.getReportOutputType(), configuration.getReportOutputName());
                reportConfig.setQueryCriteria(configuration.getQueryCriteria());
                reportConfig.setReportUser(configuration.getReportUser());
                reportConfig.setResourceMapping(configuration.getResourceMapping());
                reportConfig.setReportTitle(configuration.getReportTitle());
                if (dataforMasterReport && i == 0) {
                    data = service.requestReportData(reportConfig);
                    continue;
                }
                ReportData subReportData = service.requestReportData(reportConfig);
                if (subReportData == null || !(subReportData instanceof JasperReportData)) continue;
                configuration.addResourceMapping((Object)queryName, (Object)((JasperReportData)subReportData).getJasperDataSource());
                continue;
            }
            catch (IOException e) {
                throw new ReportException("Failed to create a report configuration for a subreport", (Throwable)e);
            }
        }
        return data;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.queryNames, (String)"A queryNames must be configured");
        Validate.notNull((Object)this.requiredDataSources, (String)"A requiredDataSources must be configured");
    }
}

