/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.workflow.hibernate;

import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.workflow.WorkflowDAO;
import gov.va.med.esr.service.WorkflowSearchCriteria;
import gov.va.med.esr.service.WorkflowSearchResultBean;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.SortElement;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class WorkflowDAOImpl
extends GenericDAOImpl
implements WorkflowDAO {
    private static final long serialVersionUID = -603229775263841625L;
    private static final String SELECT_COUNT_CLAUSE = "SELECT COUNT(*)";
    private static final String SELECT_WKF_CLAUSE = "select fg.description groupType,  w.wkf_case_id workflowCaseID, w.person_id personID, ct.description caseType, w.record_created_date createdOn, a.WKF_CASE_ASSIGNMENT_DATE assignmentDate, u.full_name assignedTo ";
    private static final String FROM_WKF_CLAUSE = " from wkf_case w, wkf_case_status_detail s, wkf_case_assignment a, user_group_type fg, wkf_case_type ct, wkf_case_status_type st, users u where w.wkf_case_id = s.wkf_case_id and w.wkf_case_id = a.wkf_case_id and w.STD_USERGROUPTYPE_ID = fg.id and w.WKF_CASE_TYPE_ID = ct.id and s.WKF_CASE_STATUS_TYPE_ID = st.id and a.WKF_CASE_ASSIGNED_TO = u.username(+) ";
    private static final String PERSON_OPEN_CASES_COUNT_QRY = "workflowCaseQuery_getOpenCasesCountForPerson";
    private static final String MOST_RECENTLY_ADDED_CASE_QRY = "workflowCaseQuery_getMostRecentlyAddedWorkFlowCase";
    private static final String OPEN_MATCHING_CASES_QRY = "workflowCaseQuery_getExistingMatchingWorkFlowCase";
    private static Map uiFieldToColumnMap = new HashMap();

    @Override
    public List getWorkItems(WorkflowSearchCriteria wkfsearchCriteria) throws DAOException {
        HashMap<String, WorkflowSearchCriteria> contextData = new HashMap<String, WorkflowSearchCriteria>();
        contextData.put("wkfsearchCriteria", wkfsearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query dataQuery = WorkflowDAOImpl.this.getSearchSelectDataQueryString(session, (WorkflowSearchCriteria)this.getContextData().get("wkfsearchCriteria"));
                return dataQuery.list();
            }
        };
        List workItems = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        for (int i = 0; i < workItems.size(); ++i) {
            this.loadLazyProperties((WorkflowCase)workItems.get(i));
        }
        return workItems;
    }

    @Override
    public List find(SearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        WorkflowSearchCriteria wkfsearchCriteria = (WorkflowSearchCriteria)searchQueryInfo;
        HashMap<String, WorkflowSearchCriteria> contextData = new HashMap<String, WorkflowSearchCriteria>();
        contextData.put("wkfsearchCriteria", wkfsearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                WorkflowSearchCriteria targetQueryInfo = (WorkflowSearchCriteria)this.getContextData().get("wkfsearchCriteria");
                Query countQuery = WorkflowDAOImpl.this.getSearchSelectCountQueryString(session, targetQueryInfo);
                Query dataQuery = WorkflowDAOImpl.this.getSearchSelectDataQueryString(session, targetQueryInfo);
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)targetQueryInfo);
                try {
                    List results = queryExecutor.executeQuery();
                    ArrayList<WorkflowSearchResultBean> items = new ArrayList<WorkflowSearchResultBean>();
                    ArrayList personids = new ArrayList();
                    for (Object[] objArray : results) {
                        WorkflowSearchResultBean bean = new WorkflowSearchResultBean();
                        bean.setGroupType((String)objArray[0]);
                        bean.setWorkflowCaseID((BigDecimal)objArray[1]);
                        bean.setPersonId((BigDecimal)objArray[2]);
                        bean.setCaseType((String)objArray[3]);
                        bean.setCreatedOn((Date)objArray[4]);
                        bean.setAssignmentDate((Date)objArray[5]);
                        bean.setAssignedTo((String)objArray[6]);
                        items.add(bean);
                    }
                    return items;
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    @Override
    public int getOpenCasesCount(PersonEntityKey personEntityKey) throws DAOException {
        int openCases = 0;
        String[] paramNames = new String[]{"personId"};
        Object[] paramValues = new BigDecimal[]{(BigDecimal)personEntityKey.getKeyValue()};
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(PERSON_OPEN_CASES_COUNT_QRY, paramNames, paramValues);
        openCases = results == null || results.isEmpty() ? 0 : (Integer)results.get(0);
        return openCases;
    }

    @Override
    public WorkflowCase getMostRecentlyCreatedWorkflowItem(PersonEntityKey personEntityKey) throws DAOException {
        WorkflowCase wkfCase = null;
        String[] paramNames = new String[]{"personId"};
        Object[] paramValues = new BigDecimal[]{(BigDecimal)personEntityKey.getKeyValue()};
        List workItems = super.getHibernateTemplate().findByNamedQueryAndNamedParam(MOST_RECENTLY_ADDED_CASE_QRY, paramNames, paramValues);
        if (workItems != null && workItems.size() > 0) {
            wkfCase = (WorkflowCase)workItems.get(0);
        }
        return wkfCase;
    }

    @Override
    public List getMatchingOpenCasesForAWorkItem(WorkflowCase workFlowCase) throws DAOException {
        PersonEntityKey key = workFlowCase.getPersonEntityKey();
        String[] paramNames = new String[]{"personId", "caseType", "errorMessageText"};
        Object[] paramValues = new Object[]{(BigDecimal)key.getKeyValue(), workFlowCase.getCaseType(), workFlowCase.getErrorMessage()};
        List workflowCaseList = super.getHibernateTemplate().findByNamedQueryAndNamedParam(OPEN_MATCHING_CASES_QRY, paramNames, paramValues);
        return workflowCaseList;
    }

    @Override
    public int getWorkItemsCount(WorkflowSearchCriteria workflowSearchCriteria) throws DAOException {
        HashMap<String, WorkflowSearchCriteria> contextData = new HashMap<String, WorkflowSearchCriteria>();
        contextData.put("workflowSearchCriteria", workflowSearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = WorkflowDAOImpl.this.getSearchSelectCountQueryString(session, (WorkflowSearchCriteria)this.getContextData().get("workflowSearchCriteria"));
                return new Integer(WorkflowDAOImpl.this.executeCountQuery(query));
            }
        };
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    private Query getSearchSelectCountQueryString(Session session, WorkflowSearchCriteria searchCriteria) {
        ArrayList paramList = new ArrayList();
        ArrayList valueList = new ArrayList();
        String queryString = SELECT_COUNT_CLAUSE + this.getSearchFromClause(searchCriteria) + this.getSearchWhereClause(searchCriteria, paramList, valueList);
        SQLQuery query = session.createSQLQuery(queryString);
        for (int i = 0; i < paramList.size(); ++i) {
            Object parValue = valueList.get(i);
            if (parValue != null && parValue instanceof List) {
                query.setParameterList((String)paramList.get(i), (Collection)((List)parValue));
                continue;
            }
            query.setParameter((String)paramList.get(i), valueList.get(i));
        }
        return query;
    }

    private Query getSearchSelectDataQueryString(Session session, WorkflowSearchCriteria searchCriteria) {
        ArrayList paramList = new ArrayList();
        ArrayList valueList = new ArrayList();
        String queryString = "select fg.description groupType,  w.wkf_case_id workflowCaseID, w.person_id personID, ct.description caseType, w.record_created_date createdOn, a.WKF_CASE_ASSIGNMENT_DATE assignmentDate, u.full_name assignedTo  " + this.getSearchFromClause(searchCriteria) + this.getSearchWhereClause(searchCriteria, paramList, valueList) + this.getSearchOrderByClause(searchCriteria.getSortElements());
        SQLQuery query = session.createSQLQuery(queryString);
        for (int i = 0; i < paramList.size(); ++i) {
            Object parValue = valueList.get(i);
            if (parValue != null && parValue instanceof List) {
                query.setParameterList((String)paramList.get(i), (Collection)((List)parValue));
                continue;
            }
            query.setParameter((String)paramList.get(i), parValue);
        }
        return query;
    }

    private String getSearchOrderByClause(List sortElements) {
        StringBuffer clauseBuffer = new StringBuffer();
        if (sortElements != null) {
            for (SortElement sortElement : sortElements) {
                String databaseColumn = (String)uiFieldToColumnMap.get(sortElement.getSortColumn());
                if (databaseColumn != null) {
                    if (clauseBuffer.length() > 0) {
                        clauseBuffer.append(", ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                        continue;
                    }
                    clauseBuffer.append(" ORDER BY ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                    continue;
                }
                return "";
            }
        }
        return clauseBuffer.toString();
    }

    private String getSearchFromClause(WorkflowSearchCriteria searchCriteria) {
        return FROM_WKF_CLAUSE;
    }

    private int executeCountQuery(Query query) throws HibernateException {
        List results = query.list();
        int count = 0;
        if (results.size() > 0) {
            Object resultCount = results.get(0);
            count = BigDecimal.class.isAssignableFrom(resultCount.getClass()) ? ((BigDecimal)resultCount).intValue() : ((Integer)resultCount).intValue();
        }
        return count;
    }

    private String getSearchWhereClause(WorkflowSearchCriteria searchCriteria, List paramList, List valueList) {
        List personids;
        ArrayList<String> criteriaList = new ArrayList<String>();
        if (searchCriteria.getFunctionalGroup() != null) {
            criteriaList.add("w.STD_USERGROUPTYPE_ID = :functionalGroup");
            paramList.add("functionalGroup");
            valueList.add(searchCriteria.getFunctionalGroup().getIdentifier());
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getItemNumber())) {
            criteriaList.add("w.wkf_case_id = :itemNumber");
            paramList.add("itemNumber");
            valueList.add(new BigDecimal(searchCriteria.getItemNumber()));
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getAssignedTo())) {
            criteriaList.add("a.WKF_CASE_ASSIGNED_TO = :assignedTo");
            paramList.add("assignedTo");
            valueList.add(searchCriteria.getAssignedTo());
        }
        if (searchCriteria.getItemType() != null) {
            criteriaList.add("w.wkf_case_type_id = :caseType");
            paramList.add("caseType");
            valueList.add(searchCriteria.getItemType().getIdentifier());
        }
        if (searchCriteria.getItemStatus() != null) {
            criteriaList.add("s.WKF_CASE_STATUS_TYPE_ID = :itemStatus");
            paramList.add("itemStatus");
            valueList.add(searchCriteria.getItemStatus().getIdentifier());
        } else if (searchCriteria.isOpenItems()) {
            criteriaList.add("st.code <> '" + WkfCaseStatusType.CLOSED.getName() + "'");
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getPersonId())) {
            criteriaList.add("w.person_id = :personId");
            paramList.add("personId");
            valueList.add(new BigDecimal(searchCriteria.getPersonId()));
        }
        Date createDateFrom = searchCriteria.getCreateDateFrom();
        Date createDateTo = searchCriteria.getCreateDateTo();
        Date assignedDateFrom = searchCriteria.getAssignedDateFrom();
        Date assignedDateTo = searchCriteria.getAssignedDateTo();
        Date assignedDate = searchCriteria.getAssignedDate();
        Date createDate = searchCriteria.getCreateDate();
        if (createDate != null) {
            createDateFrom = createDate;
            createDateTo = createDate;
        }
        if (createDateFrom != null) {
            criteriaList.add(" w.record_created_date >= :createDateFrom");
            paramList.add("createDateFrom");
            valueList.add(createDateFrom);
        }
        if (createDateTo != null) {
            criteriaList.add(" w.record_created_date < :createDateTo");
            paramList.add("createDateTo");
            valueList.add(this.nextDay(createDateTo));
        }
        if (assignedDate != null) {
            assignedDateFrom = assignedDate;
            assignedDateTo = assignedDate;
        }
        if (assignedDateFrom != null) {
            criteriaList.add(" a.WKF_CASE_ASSIGNMENT_DATE >= :assignedDateFrom");
            paramList.add("assignedDateFrom");
            valueList.add(assignedDateFrom);
        }
        if (assignedDateTo != null) {
            criteriaList.add(" a.WKF_CASE_ASSIGNMENT_DATE < :assignedDateTo");
            paramList.add("assignedDateTo");
            valueList.add(this.nextDay(assignedDateTo));
        }
        if (searchCriteria.isAssignedItems()) {
            criteriaList.add("a.WKF_CASE_ASSIGNED_TO is not null");
        }
        if (searchCriteria.isUnassignedItems()) {
            criteriaList.add("a.WKF_CASE_ASSIGNED_TO is null");
        }
        if (searchCriteria.isOverdueItems()) {
            Date currentDate = DateUtils.getCurrentDate();
            criteriaList.add(" w.CASE_DUE_DATE is not null and  w.CASE_DUE_DATE < :currentDate ");
            paramList.add("currentDate");
            valueList.add(currentDate);
        }
        if ((personids = searchCriteria.getPersonIds()) != null && personids.size() > 0) {
            criteriaList.add("w.person_id in (:personIDs)");
            paramList.add("personIDs");
            valueList.add(personids);
        }
        StringBuffer whereClause = new StringBuffer();
        if (!criteriaList.isEmpty()) {
            for (int index = 0; index < criteriaList.size(); ++index) {
                whereClause.append(" and ").append(criteriaList.get(index));
            }
        }
        return whereClause.toString();
    }

    public Object getByKey(EntityKey key) throws DAOException {
        Object entity = super.getByKey(key);
        if (entity != null && entity instanceof WorkflowCase) {
            WorkflowCase wfCase = (WorkflowCase)entity;
            this.loadLazyProperties(wfCase);
        }
        return entity;
    }

    private void loadLazyProperties(WorkflowCase wfCase) {
        this.accessSet(wfCase.getComments());
        this.accessSet(wfCase.getAssignmentHistory());
        this.accessSet(wfCase.getStatusHistory());
    }

    private Date nextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private void accessSet(Set set) {
        block0: {
            Iterator i = set.iterator();
            if (!i.hasNext()) break block0;
            Object obj = i.next();
        }
    }

    static {
        uiFieldToColumnMap.put("result.groupType", "groupType");
        uiFieldToColumnMap.put("result.shortVPID", "shortVPID");
        uiFieldToColumnMap.put("result.shortVPID", "personID");
        uiFieldToColumnMap.put("result.personID", "personID");
        uiFieldToColumnMap.put("result.workflowCaseID", "workflowCaseID");
        uiFieldToColumnMap.put("result.caseType", "caseType");
        uiFieldToColumnMap.put("result.createdOn", "createdOn");
        uiFieldToColumnMap.put("result.assignmentDate", "assignmentDate");
        uiFieldToColumnMap.put("result.assignedTo", "assignedTo");
    }
}

