/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.security.hibernate;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.EEServiceRequest;
import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.common.model.security.EEServiceUser;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.model.security.UserLastLoginInfo;
import gov.va.med.esr.common.model.security.UserLogin;
import gov.va.med.esr.common.persistent.security.SecurityDAO;
import gov.va.med.esr.service.PasswordChangeHistory;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.RolePrincipalImpl;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SecurityDAOImpl
extends GenericDAOImpl
implements SecurityDAO {
    private static final long serialVersionUID = -2161487908175786748L;
    private static final String FIND_BY_USER_NAME = "userPrincipal_FindByUserName";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_USERID = "userid";
    private static final String PARAM_FUNCTIONAL_GROUP_NAME = "functinalGroupName";
    private static final String PARAM_ROLE_NAME = "roleName";
    private static final String PARAM_REQUEST_ID = "requestId";
    private static final String FIELD_USERNAME = "name";
    private static final String FIELD_GIVEN_NAME = "givenName";
    private static final String FIELD_FAMILY_NAME = "familyName";
    private static final String FIELD_MIDDLE_NAME = "middleName";
    private static final String QRY_FIND_ALL_CAPABILITIES = "capabilitySet_FindAll";
    private static final String QRY_FIND_ALL_ROLES = "rolePrincipal_FindAll";
    private static final String QRY_FIND_ALL_USERS = "userPrincipal_FindAll";
    private static final String QRY_LOOKUP_USER = "userPrincipal_lookupUser";
    private static final String QRY_LOOKUP_USER_BY_FULLNAME = "userPrincipal_lookupUserByFullname";
    private static final String QRY_FIND_USERS_BY_ROLE_NAME = "userPrincipal_FindByUserRoleName";
    private static final String QRY_FIND_USERS_BY_FUNCTIONAL_GROUP = "userPrincipal_FindByUserFunctionalGroup";
    private static final String QRY_FIND_USERS_BY_ROLE_NAME_AND_FUNCTIONAL_GROUP = "userPrincipal_FindByUserRoleNameAndFunctionalGroup";
    private static final String QRY_FIND_USERS_BY_CAPABILITY_NAME = "userPrincipal_FindByUserCapabilityName";
    private static final String QRY_PASSWORD_CHANGE_HISTORY = "userPrincipal_passwordChangeHistory";
    private static final String QRY_SERVICE_REQUEST_ALL = "servicerequest_all";
    private static final String QRY_SERVICE_REQUEST_BYNAME = "servicerequest_byName";
    private static final String QRY_SERVICE_REQUESTLITE_ALL = "servicerequestlite_all";
    private static final String QRY_SERVICE_REQUESTLITE_BYNAME = "servicerequestlitelite_byName";
    private static final String QRY_SERVICE_USER_ALL = "serviceuser_all";
    private static final String QRY_SERVICE_USER_BYUSERNAME = "serviceuser_byUserName";
    private static final String QRY_SERVICE_REQUEST_FIELDS_BY_REQ_ID = "eeServiceRequest.fieldsSet";

    @Override
    public UserPrincipal findUserByUsername(String username) throws DAOException {
        Validate.notNull((Object)username, (String)"NULL username not allowed.");
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{username};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_BY_USER_NAME, paramNames, paramValues);
            return results == null || results.isEmpty() ? null : (UserPrincipal)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find UserPrincipal by username.", (Throwable)e);
        }
    }

    @Override
    public UserPrincipal findUser(UserPrincipal userPrincipal) throws DAOException, MaxRecordsExceededException {
        Validate.notNull((Object)userPrincipal, (String)"NULL userPrincipal not allowed.");
        try {
            HashMap<String, UserPrincipal> contextData = new HashMap<String, UserPrincipal>();
            contextData.put("userPrincipal", userPrincipal);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    UserPrincipal targetUserPrincipal = (UserPrincipal)this.getContextData().get("userPrincipal");
                    Criteria criteria = session.createCriteria(ESRUserPrincipalImpl.class);
                    if (StringUtils.isNotEmpty((String)targetUserPrincipal.getName())) {
                        criteria.add(Expression.ilike((String)"name", (Object)targetUserPrincipal.getName().trim()));
                    }
                    if (StringUtils.isNotEmpty((String)targetUserPrincipal.getFamilyName())) {
                        criteria.add(Expression.ilike((String)SecurityDAOImpl.FIELD_FAMILY_NAME, (Object)targetUserPrincipal.getFamilyName().trim()));
                    }
                    if (StringUtils.isNotEmpty((String)targetUserPrincipal.getGivenName())) {
                        criteria.add(Expression.ilike((String)SecurityDAOImpl.FIELD_GIVEN_NAME, (Object)targetUserPrincipal.getGivenName().trim()));
                    }
                    if (targetUserPrincipal.getMiddleName() != null) {
                        criteria.add(Expression.ilike((String)SecurityDAOImpl.FIELD_MIDDLE_NAME, (Object)targetUserPrincipal.getMiddleName().trim()));
                    }
                    return criteria.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results == null || results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                throw new MaxRecordsExceededException(results.size(), 1);
            }
            return (UserPrincipal)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find UserPrincipal by username.", (Throwable)e);
        }
    }

    @Override
    public UserPrincipal getUserById(EntityKey userId) throws DAOException {
        Validate.notNull((Object)userId, (String)"User identifier can not be null.");
        Validate.notNull((Object)userId.getKeyValue(), (String)"User identifier can not be null.");
        try {
            return (UserPrincipal)this.getHibernateTemplate().get(ESRUserPrincipalImpl.class, userId.getKeyValue());
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get an entity " + ESRUserPrincipalImpl.class.getName() + " by id " + userId.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public UserLastLoginInfo getUserLastLoginInfo(EntityKey userId) throws DAOException {
        Validate.notNull((Object)userId, (String)"User identifier can not be null.");
        Validate.notNull((Object)userId.getKeyValue(), (String)"User identifier can not be null.");
        UserLastLoginInfo loginInfo = new UserLastLoginInfo();
        try {
            HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
            contextData.put("userId", userId);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    String hqlQuery = "select max(successfulLoginDate) as successDate, max(failedLoginDate) as failedDate FROM   UserLogin WHERE  USERID = " + ((EntityKey)this.getContextData().get("userId")).getKeyValueAsString();
                    Query query = session.createQuery(hqlQuery);
                    return query.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results != null && results.size() > 0) {
                Object[] data = (Object[])results.get(0);
                loginInfo.setSuccessfulLoginDate((Date)data[0]);
                loginInfo.setFailedLoginDate((Date)data[1]);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get User Login Info " + UserLastLoginInfo.class.getName() + " by user id " + userId.getKeyValueAsString(), (Throwable)e);
        }
        return loginInfo;
    }

    @Override
    public List getAllCapabilitySets() throws DAOException {
        List sets = this.find(QRY_FIND_ALL_CAPABILITIES);
        if (sets != null && sets.size() > 0) {
            AbstractDAOAction callback = new AbstractDAOAction(){

                public Object execute(Session session) {
                    String hqlQuery = "select distinct(PERMISSION_SET_ID) from USER_PERMISSION_SETS union select distinct(PERMISSION_SET_ID) from ROLE_PERMISSION_SETS";
                    SQLQuery query = session.createSQLQuery(hqlQuery);
                    return query.list();
                }
            };
            List assigned = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (assigned != null && assigned.size() > 0) {
                HashSet assignedSetIds = new HashSet(assigned);
                for (CapabilitySet set : sets) {
                    if (assignedSetIds.contains(set.getEntityKey().getKeyValue())) {
                        set.setAssigned(Boolean.TRUE);
                        continue;
                    }
                    set.setAssigned(Boolean.FALSE);
                }
            }
        }
        return sets;
    }

    @Override
    public List getAllRoles() throws DAOException {
        List roles = this.find(QRY_FIND_ALL_ROLES);
        if (roles != null && roles.size() > 0) {
            AbstractDAOAction callback = new AbstractDAOAction(){

                public Object execute(Session session) {
                    String sqlQuery = "select distinct(ROLE_ID) from USER_ROLES";
                    SQLQuery query = session.createSQLQuery(sqlQuery);
                    return query.list();
                }
            };
            List assigned = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (assigned != null && assigned.size() > 0) {
                HashSet assignedSetIds = new HashSet(assigned);
                for (ESRRolePrincipalImpl role : roles) {
                    if (assignedSetIds.contains(role.getEntityKey().getKeyValue())) {
                        role.setAssigned(Boolean.TRUE);
                        continue;
                    }
                    role.setAssigned(Boolean.FALSE);
                }
            }
        }
        return roles;
    }

    @Override
    public CapabilitySet findCapabilitySetByName(String name) throws DAOException {
        Validate.notNull((Object)name, (String)"NULL name not allowed.");
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("name", name);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Criteria criteria = session.createCriteria(CapabilitySet.class);
                    criteria.add(Expression.ilike((String)"name", (Object)((String)this.getContextData().get("name")).trim()));
                    return criteria.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results == null || results.isEmpty()) {
                return null;
            }
            return (CapabilitySet)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find CapabilitySet by Name.", (Throwable)e);
        }
    }

    @Override
    public RolePrincipalImpl findRoleByName(String name) throws DAOException {
        Validate.notNull((Object)name, (String)"NULL name not allowed.");
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("name", name);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Criteria criteria = session.createCriteria(RolePrincipalImpl.class);
                    criteria.add(Expression.ilike((String)"name", (Object)((String)this.getContextData().get("name")).trim()));
                    return criteria.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results == null || results.isEmpty()) {
                return null;
            }
            return (RolePrincipalImpl)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find Role by Name.", (Throwable)e);
        }
    }

    @Override
    public List findDeletedRoles() throws DAOException {
        return null;
    }

    @Override
    public List findDeletedCapabilitySets() throws DAOException {
        return null;
    }

    @Override
    public List findAllUsers() throws DAOException {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        try {
            List results = this.find(QRY_FIND_ALL_USERS);
            for (Object[] data : results) {
                ESRUserPrincipalImpl user = this.buildUser(data);
                users.add(user);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to find all users.", (Throwable)e);
        }
        return users;
    }

    @Override
    public List findUsersByRoleName(String roleName) throws DAOException {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{roleName};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_FIND_USERS_BY_ROLE_NAME, paramNames, paramValues);
            for (Object[] data : results) {
                ESRUserPrincipalImpl user = this.buildUser(data);
                users.add(user);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to find User list by role name.", (Throwable)e);
        }
        return users;
    }

    @Override
    public List findUsersByFunctionalGroup(FunctionalGroup functionalGroup) throws DAOException {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        if (functionalGroup == null) {
            return users;
        }
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{functionalGroup.getCode()};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_FIND_USERS_BY_FUNCTIONAL_GROUP, paramNames, paramValues);
            for (Object[] data : results) {
                ESRUserPrincipalImpl user = this.buildUser(data);
                users.add(user);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to find User list by Functional Group.", (Throwable)e);
        }
        return users;
    }

    @Override
    public List findUsersByRoleAndFunctionalGroup(FunctionalGroup functionalGroup, String roleName) throws DAOException {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        if (functionalGroup == null) {
            return users;
        }
        try {
            String[] paramNames = new String[]{PARAM_FUNCTIONAL_GROUP_NAME, PARAM_ROLE_NAME};
            Object[] paramValues = new String[]{functionalGroup.getCode(), roleName};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_FIND_USERS_BY_ROLE_NAME_AND_FUNCTIONAL_GROUP, paramNames, paramValues);
            for (Object[] data : results) {
                ESRUserPrincipalImpl user = this.buildUser(data);
                users.add(user);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to find User list by Role and Functional Group.", (Throwable)e);
        }
        return users;
    }

    @Override
    public List findUsersByCapabilityCode(String capabilityCode) throws DAOException {
        ArrayList<ESRUserPrincipalImpl> users = new ArrayList<ESRUserPrincipalImpl>();
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{capabilityCode};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_FIND_USERS_BY_CAPABILITY_NAME, paramNames, paramValues);
            for (Object[] data : results) {
                ESRUserPrincipalImpl user = this.buildUser(data);
                users.add(user);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to User list by role name", (Throwable)e);
        }
        return users;
    }

    @Override
    public Lookup getByCode(String userName) throws DAOException {
        ESRUserPrincipalImpl user = null;
        try {
            Iterator i;
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{userName};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_LOOKUP_USER, paramNames, paramValues);
            if (results != null & results.size() > 0 && (i = results.iterator()).hasNext()) {
                Object[] data = (Object[])i.next();
                user = this.buildUser(data);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to getByCode.", (Throwable)e);
        }
        if (user == null) {
            user = this.buildDefaultUser(userName);
        }
        return user;
    }

    @Override
    public Lookup getByFullname(String userName) throws DAOException {
        ESRUserPrincipalImpl user = null;
        try {
            Iterator i;
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{userName + "%"};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_LOOKUP_USER_BY_FULLNAME, paramNames, paramValues);
            if (results != null & results.size() > 0 && (i = results.iterator()).hasNext()) {
                Object[] data = (Object[])i.next();
                user = this.buildUser(data);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to getByFullName.", (Throwable)e);
        }
        return user;
    }

    @Override
    public void updateAndLog(UserPrincipal userPrincipal, UserLogin userLogin) throws DAOException {
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)userPrincipal;
        ESRUserPrincipalImpl userinDB = (ESRUserPrincipalImpl)this.getUserById(user.getEntityKey());
        this.merge(user, userinDB);
        this.update(userinDB);
        this.insertObject((Object)userLogin);
    }

    @Override
    public void updatePassword(UserPrincipal userPrincipal) throws DAOException {
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)userPrincipal;
        ESRUserPrincipalImpl userinDB = (ESRUserPrincipalImpl)this.getUserById(user.getEntityKey());
        userinDB.setPassword(user.getPassword());
        userinDB.setPasswordChangeDate(user.getPasswordChangeDate());
        userinDB.setFailAttemptCount(user.getFailAttemptCount());
        userinDB.setPasswordExpireDate(user.getPasswordExpireDate());
        this.update(userinDB);
    }

    @Override
    public List getPasswordChangeHistory(EntityKey userId) throws DAOException {
        ArrayList<PasswordChangeHistory> pwdHistory = new ArrayList<PasswordChangeHistory>();
        try {
            String[] paramNames = new String[]{PARAM_USERID};
            Object[] paramValues = new Object[]{userId.getKeyValue()};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_PASSWORD_CHANGE_HISTORY, paramNames, paramValues);
            for (Object[] data : results) {
                pwdHistory.add(new PasswordChangeHistory((Date)data[0], (String)data[1], (String)data[2]));
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to User list by role name", (Throwable)e);
        }
        return pwdHistory;
    }

    @Override
    public List getEEServiceRequests() throws DAOException {
        List requests = null;
        try {
            requests = super.getHibernateTemplate().findByNamedQuery(QRY_SERVICE_REQUEST_ALL);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
        return requests;
    }

    @Override
    public List getEEServiceLiteRequests() throws DAOException {
        List requests = null;
        try {
            requests = super.getHibernateTemplate().findByNamedQuery(QRY_SERVICE_REQUESTLITE_ALL);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
        return requests;
    }

    @Override
    public EEServiceRequest getEEServiceRequest(EntityKey eeServiceRequestId) throws DAOException {
        Validate.notNull((Object)eeServiceRequestId, (String)"eeServiceRequestId identifier can not be null.");
        Validate.notNull((Object)eeServiceRequestId.getKeyValue(), (String)"eeServiceRequest identifier can not be null.");
        try {
            return (EEServiceRequest)((Object)this.getHibernateTemplate().get(EEServiceRequest.class, eeServiceRequestId.getKeyValue()));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get an entity " + EEServiceRequest.class.getName() + " by id " + eeServiceRequestId.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public EEServiceRequestLite getEEServiceRequestLite(EntityKey eeServiceRequestId) throws DAOException {
        Validate.notNull((Object)eeServiceRequestId, (String)"eeServiceRequestId identifier can not be null.");
        Validate.notNull((Object)eeServiceRequestId.getKeyValue(), (String)"eeServiceRequest identifier can not be null.");
        try {
            return (EEServiceRequestLite)((Object)this.getHibernateTemplate().get(EEServiceRequestLite.class, eeServiceRequestId.getKeyValue()));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get an entity " + EEServiceRequestLite.class.getName() + " by id " + eeServiceRequestId.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public EEServiceRequest getEEServiceRequestByName(String name) throws DAOException {
        Validate.notNull((Object)name, (String)"NULL rquest not allowed.");
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{name};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_SERVICE_REQUEST_BYNAME, paramNames, paramValues);
            return results == null || results.isEmpty() ? null : (EEServiceRequest)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find EEServiceRequest by name.", (Throwable)e);
        }
    }

    @Override
    public Set getEEServiceRequestFieldsByRequest(EntityKey eeServiceRequestId) throws DAOException {
        Validate.notNull((Object)eeServiceRequestId, (String)"eeServiceRequestId identifier can not be null.");
        Validate.notNull((Object)eeServiceRequestId.getKeyValue(), (String)"eeServiceRequest identifier can not be null.");
        try {
            String[] paramNames = new String[]{PARAM_REQUEST_ID};
            Object[] paramValues = new String[]{eeServiceRequestId.getKeyValueAsString()};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_SERVICE_REQUEST_FIELDS_BY_REQ_ID, paramNames, paramValues);
            if (results != null && results.size() > 0) {
                HashSet fields = new HashSet();
                fields.addAll(results);
                return fields;
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get an fields   by id " + eeServiceRequestId.getKeyValue(), (Throwable)e);
        }
        return null;
    }

    @Override
    public EEServiceRequestLite getEEServiceRequestLiteByName(String name) throws DAOException {
        Validate.notNull((Object)name, (String)"NULL rquest not allowed.");
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{name};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_SERVICE_REQUESTLITE_BYNAME, paramNames, paramValues);
            return results == null || results.isEmpty() ? null : (EEServiceRequestLite)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find EEServiceRequest by name.", (Throwable)e);
        }
    }

    @Override
    public List getEEServiceUsers() throws DAOException {
        List requests = null;
        try {
            requests = super.getHibernateTemplate().findByNamedQuery(QRY_SERVICE_USER_ALL);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
        return requests;
    }

    @Override
    public EEServiceUser getEEServiceUserByName(String name) throws DAOException {
        Validate.notNull((Object)name, (String)"NULL rquest not allowed.");
        try {
            String[] paramNames = new String[]{"name"};
            Object[] paramValues = new String[]{name};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_SERVICE_USER_BYUSERNAME, paramNames, paramValues);
            return results == null || results.isEmpty() ? null : (EEServiceUser)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed find EEServiceRequest by name.", (Throwable)e);
        }
    }

    @Override
    public EEServiceUser getEEServiceUserById(EntityKey eeServiceUserId) throws DAOException {
        Validate.notNull((Object)eeServiceUserId, (String)"eeServiceRequestId identifier can not be null.");
        Validate.notNull((Object)eeServiceUserId.getKeyValue(), (String)"eeServiceRequest identifier can not be null.");
        try {
            return (EEServiceUser)((Object)this.getHibernateTemplate().get(EEServiceUser.class, eeServiceUserId.getKeyValue()));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get an entity " + EEServiceRequest.class.getName() + " by id " + eeServiceUserId.getKeyValue(), (Throwable)e);
        }
    }

    private void merge(ESRUserPrincipalImpl user, ESRUserPrincipalImpl userinDB) {
        userinDB.setInitialLoginDate(user.getInitialLoginDate());
        userinDB.setSignatureVerified(user.getSignatureVerified());
        userinDB.setLockDate(user.getLockDate());
        userinDB.setFailAttemptCount(user.getFailAttemptCount());
    }

    private ESRUserPrincipalImpl buildUser(Object[] data) {
        ESRUserPrincipalImpl user = new ESRUserPrincipalImpl((String)data[0]);
        user.setFullName((String)data[1]);
        user.setGivenName((String)data[2]);
        user.setFamilyName((String)data[3]);
        user.setMiddleName((String)data[4]);
        return user;
    }

    private ESRUserPrincipalImpl buildDefaultUser(String userName) {
        ESRUserPrincipalImpl user = new ESRUserPrincipalImpl(userName);
        user.setFullName(userName);
        user.setGivenName(userName);
        return user;
    }
}

