/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.registry.hibernate;

import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.persistent.registry.RegistryDAO;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class RegistryDAOImpl
extends GenericDAOImpl
implements RegistryDAO {
    private static final long serialVersionUID = -6542039226053051792L;
    public static final String CLASS_NAME_PH_REGISTRY = "PurpleHeart";
    public static final String CLASS_NAME_POW_REGISTRY = "PrisonerOfWar";
    public static final String CLASS_NAME_SHAD_REGISTRY = "SHAD";
    public static final String CLASS_NAME_MS_SITE_RECORD = "MilitaryServiceSiteRecord";
    public static final String CLASS_NAME_MS_EPISODE = "MilitaryServiceEpisode";
    public static final String SELECT_CLAUSE_COUNT_QUERY = "select count(distinct r.identifier)";
    public static final String SELECT_CLAUSE_DATA_QUERY = "select distinct new gov.va.med.esr.service.RegistrySearchResultBean(r.identifier,rt.ssn,rt.firstName,rt.middleName,rt.lastName,rt.registryType,r.person.identifier)";
    public static final String GET_REGISTRY_TRAIT = "from RegistryTrait as rt where upper(rt.firstName) = upper(:firstName) and upper(rt.lastName) = upper(:lastName) and rt.registryType = :registryType";
    public static final String GET_LATEST_BATCH_NUMBER = "registrySummary_Latest";

    @Override
    public Registry getById(EntityKey entityKey, RegistryType registryType) throws DAOException {
        Registry registry = null;
        if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), (String)registryType.getCode())) {
            registry = this.getPHRegistryById(entityKey);
        } else if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType.getCode())) {
            registry = this.getPOWRegistryById(entityKey);
        } else if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType.getCode())) {
            registry = this.getSHADRegistryById(entityKey);
        }
        return registry;
    }

    @Override
    public PurpleHeart getPHRegistryById(EntityKey entityKey) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("purpleHeart_Identifier", "identifier", (Object)entityKey.getKeyValue());
            return results.isEmpty() ? null : (PurpleHeart)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the purple heart registry by identifier", (Throwable)e);
        }
    }

    @Override
    public PrisonerOfWar getPOWRegistryById(EntityKey entityKey) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("prisonerOfWar_Identifier", "identifier", (Object)entityKey.getKeyValue());
            return results.isEmpty() ? null : (PrisonerOfWar)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the prisoner of war registry by identifier", (Throwable)e);
        }
    }

    @Override
    public PrisonerOfWar getPOWRegistryByIcn(String icn) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("prisonerOfWar_Icn", "icn", (Object)icn);
            return results.isEmpty() || results.size() > 1 ? null : (PrisonerOfWar)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the prisoner of war registry by icn", (Throwable)e);
        }
    }

    @Override
    public SHAD getSHADRegistryById(EntityKey entityKey) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("shad_Identifier", "identifier", (Object)entityKey.getKeyValue());
            return results.isEmpty() ? null : (SHAD)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the shad registry by identifier", (Throwable)e);
        }
    }

    @Override
    public Registry getRegistry(Person person, RegistryType type) throws DAOException {
        Registry registry = null;
        try {
            if (person != null && type != null) {
                String firstName;
                String ssn = person.getOfficialSsn() != null ? person.getOfficialSsn().getFormattedSsnText() : null;
                Name name = person.getLegalName();
                String lastName = name != null ? name.getFamilyName() : null;
                String string = firstName = name != null ? name.getGivenName() : null;
                if (StringUtils.isNotEmpty((String)ssn) && StringUtils.isNotEmpty((String)lastName) && StringUtils.isNotEmpty((String)firstName)) {
                    String className = this.getRegistryClassName(type.getCode());
                    String query = " from " + className + " as r where r.registryTrait.ssn = :ssn and upper(r.registryTrait.lastName) = upper(:lastName) and upper(r.registryTrait.firstName) like upper(:firstName)";
                    String[] paramName = new String[]{"ssn", "lastName", "firstName"};
                    Object[] paramValue = new String[]{ssn, lastName, firstName};
                    HibernateTemplate tpl = this.getHibernateTemplate();
                    List results = tpl.findByNamedParam(query, paramName, paramValue);
                    registry = results.size() > 0 ? (Registry)((Object)results.get(0)) : null;
                }
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the shad registry by criteria", (Throwable)e);
        }
        return registry;
    }

    @Override
    public void save(Registry registry) throws DAOException {
        try {
            HibernateTemplate tmplt = this.getHibernateTemplate();
            tmplt.saveOrUpdate((Object)registry);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to save registry", (Throwable)e);
        }
    }

    @Override
    public RegistryTrait getRegistryTrait(Registry registry) throws DAOException {
        Validate.notNull((Object)((Object)registry), (String)"Registry must not be null");
        RegistryTrait trait = registry.getRegistryTrait();
        Validate.notNull((Object)((Object)trait), (String)"RegistryTrait must not be null");
        HashMap<String, RegistryTrait> contextData = new HashMap<String, RegistryTrait>();
        contextData.put("trait", trait);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                RegistryTrait targetTrait = (RegistryTrait)((Object)this.getContextData().get("trait"));
                boolean isPOW = StringUtils.equals((String)targetTrait.getRegistryType().getCode(), (String)RegistryType.CODE_POW_REGISTRY.getCode());
                String hqlQuery = "from RegistryTrait as rt where upper(rt.firstName) = upper(:firstName) and upper(rt.lastName) = upper(:lastName) and rt.registryType = :registryType and rt.ssn = :ssn";
                hqlQuery = "from RegistryTrait as rt where upper(rt.firstName) = upper(:firstName) and upper(rt.lastName) = upper(:lastName) and rt.registryType = :registryType and rt.ssn = :ssn";
                boolean setSsn = true;
                if (isPOW && StringUtils.isEmpty((String)targetTrait.getSsn())) {
                    hqlQuery = RegistryDAOImpl.GET_REGISTRY_TRAIT;
                    setSsn = false;
                }
                Query query = session.createQuery(hqlQuery);
                query.setString("firstName", targetTrait.getFirstName());
                query.setString("lastName", targetTrait.getLastName());
                query.setEntity("registryType", (Object)targetTrait.getRegistryType());
                if (setSsn) {
                    query.setString("ssn", targetTrait.getSsn());
                }
                return query.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        return results != null && !results.isEmpty() ? (RegistryTrait)((Object)results.get(0)) : null;
    }

    @Override
    public List find(SearchQueryInfo criteria) throws DAOException, MaxRecordsExceededException {
        RegistrySearchCriteria searchCriteria = (RegistrySearchCriteria)criteria;
        String registryType = searchCriteria.getRegistryType() != null ? searchCriteria.getRegistryType().getCode() : null;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("registryType", registryType);
        contextData.put("searchCriteria", searchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                List results = new ArrayList();
                String targetRegistryType = (String)this.getContextData().get("registryType");
                RegistrySearchCriteria targetQueryInfo = (RegistrySearchCriteria)this.getContextData().get("searchCriteria");
                ArrayList paramList = new ArrayList();
                ArrayList valueList = new ArrayList();
                String whereClause = RegistryDAOImpl.this.createWhereClause(targetQueryInfo, paramList, valueList);
                try {
                    if (targetRegistryType != null) {
                        String fromClause = RegistryDAOImpl.this.buildFromCaluse(targetQueryInfo, targetRegistryType);
                        results = RegistryDAOImpl.this.find(session, targetQueryInfo, RegistryDAOImpl.this.buildCountQuery(fromClause, whereClause), RegistryDAOImpl.this.buildDataQuery(fromClause, whereClause, targetRegistryType), paramList, valueList);
                    } else {
                        List shadResults;
                        List powResults;
                        String fromClause = RegistryDAOImpl.this.buildFromCaluse(targetQueryInfo, RegistryType.CODE_PH_REGISTRY.getCode());
                        List phResults = RegistryDAOImpl.this.find(session, targetQueryInfo, RegistryDAOImpl.this.buildCountQuery(fromClause, whereClause), RegistryDAOImpl.this.buildDataQuery(fromClause, whereClause, RegistryType.CODE_PH_REGISTRY.getCode()), paramList, valueList);
                        if (phResults != null && !phResults.isEmpty()) {
                            results.addAll(phResults);
                        }
                        if ((powResults = RegistryDAOImpl.this.find(session, targetQueryInfo, RegistryDAOImpl.this.buildCountQuery(fromClause = RegistryDAOImpl.this.buildFromCaluse(targetQueryInfo, RegistryType.CODE_POW_REGISTRY.getCode()), whereClause), RegistryDAOImpl.this.buildDataQuery(fromClause, whereClause, RegistryType.CODE_POW_REGISTRY.getCode()), paramList, valueList)) != null && !powResults.isEmpty()) {
                            results.addAll(powResults);
                        }
                        if ((shadResults = RegistryDAOImpl.this.find(session, targetQueryInfo, RegistryDAOImpl.this.buildCountQuery(fromClause = RegistryDAOImpl.this.buildFromCaluse(targetQueryInfo, RegistryType.CODE_SHAD_REGISTRY.getCode()), whereClause), RegistryDAOImpl.this.buildDataQuery(fromClause, whereClause, RegistryType.CODE_SHAD_REGISTRY.getCode()), paramList, valueList)) != null && !shadResults.isEmpty()) {
                            results.addAll(shadResults);
                        }
                    }
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
                return results;
            }
        };
        List results = null;
        try {
            results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
        if (results != null) {
            int maxAllowedRecords = criteria.getMaxAllowedRecords();
            int totalResults = results.size();
            if (totalResults > criteria.getMaxAllowedRecords()) {
                throw new MaxRecordsExceededException(totalResults, maxAllowedRecords);
            }
            criteria.setTotalNumberOfEntries(totalResults);
        }
        return results;
    }

    @Override
    public RegistryLoadStatistics getMostRecentRegistrySummaryByType(RegistryType registryType) throws DAOException {
        try {
            List results = null;
            HibernateTemplate tpl = this.getHibernateTemplate();
            results = registryType != null ? tpl.findByNamedQueryAndNamedParam("registrySummary_RegistryType", "registryType", (Object)registryType) : tpl.findByNamedQuery(GET_LATEST_BATCH_NUMBER);
            return results.isEmpty() ? null : (RegistryLoadStatistics)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get Latest Registry Summary By Registry Type " + registryType.getCode(), (Throwable)e);
        }
    }

    private List find(Session session, RegistrySearchCriteria searchCriteria, String strCountQuery, String strDataQuery, List paramList, List valueList) throws DAOException, MaxRecordsExceededException {
        List results = null;
        try {
            Query countQuery = session.createQuery(strCountQuery);
            Query dataQuery = session.createQuery(strDataQuery);
            for (int i = 0; i < paramList.size(); ++i) {
                countQuery.setParameter((String)paramList.get(i), valueList.get(i));
                dataQuery.setParameter((String)paramList.get(i), valueList.get(i));
            }
            PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)searchCriteria);
            results = queryExecutor.executeQuery();
        }
        catch (HibernateException ex) {
            throw new DAOException("An error occurred while getting message registry entries.", (Throwable)ex);
        }
        return results;
    }

    private String buildCountQuery(String fromClause, String whereClause) {
        return SELECT_CLAUSE_COUNT_QUERY + fromClause + whereClause;
    }

    private String buildDataQuery(String fromClause, String whereClause, String registryType) {
        return this.buildSelectClause(registryType) + fromClause + whereClause;
    }

    private String buildSelectClause(String registryType) {
        if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), (String)registryType)) {
            return "select distinct new gov.va.med.esr.service.RegistrySearchResultBean(r.identifier,rt.ssn,rt.firstName,rt.middleName,rt.lastName,rt.registryType,r.person.identifier,r.status)";
        }
        if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType)) {
            return "select distinct new gov.va.med.esr.service.RegistrySearchResultBean(r.identifier,rt.ssn,rt.firstName,rt.middleName,rt.lastName,rt.registryType,r.person.identifier,r.powIndicator)";
        }
        if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType)) {
            return "select distinct new gov.va.med.esr.service.RegistrySearchResultBean(r.identifier,rt.ssn,rt.firstName,rt.middleName,rt.lastName,rt.registryType,r.person.identifier,r.shadIndicator)";
        }
        return SELECT_CLAUSE_DATA_QUERY;
    }

    private String buildFromCaluse(RegistrySearchCriteria searchCriteria, String registryType) {
        String registryClassName = this.getRegistryClassName(registryType);
        String fromClause = " from " + registryClassName + " as r JOIN r.registryTrait as rt ";
        if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), (String)registryType)) {
            fromClause = fromClause + " LEFT JOIN r.status as st ";
        }
        if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType)) {
            fromClause = fromClause + " LEFT JOIN r.powIndicator as ind ";
        }
        if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType)) {
            fromClause = fromClause + " LEFT JOIN r.shadIndicator as ind ";
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getMilitaryServiceNumber())) {
            fromClause = fromClause + " LEFT JOIN r.registryTrait.internalRegistryTraitDetails as rtd ";
            fromClause = fromClause + " LEFT JOIN r.person as p";
            fromClause = fromClause + " LEFT JOIN p.militaryService.internalMilitaryServiceSiteRecords as mssr";
            fromClause = fromClause + " LEFT JOIN mssr.internalMilitaryServiceEpisodes as mse";
        }
        return fromClause;
    }

    private String getRegistryClassName(String registryType) {
        String registryClassName = null;
        if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), (String)registryType)) {
            registryClassName = CLASS_NAME_PH_REGISTRY;
        }
        if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType)) {
            registryClassName = CLASS_NAME_POW_REGISTRY;
        }
        if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType)) {
            registryClassName = CLASS_NAME_SHAD_REGISTRY;
        }
        return registryClassName;
    }

    private String createWhereClause(RegistrySearchCriteria searchCriteria, List paramList, List valueList) {
        ArrayList<String> criteriaList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)searchCriteria.getSsn())) {
            criteriaList.add("rt.ssn = :ssn");
            paramList.add("ssn");
            valueList.add(searchCriteria.getSsn());
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getLastName())) {
            criteriaList.add("upper(rt.lastName) = upper(:lastName)");
            paramList.add("lastName");
            valueList.add(searchCriteria.getLastName());
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getFirstName())) {
            String firstName = searchCriteria.getFirstName();
            if (firstName.length() == 1) {
                criteriaList.add("upper(rt.firstName) like upper(:firstName)");
                paramList.add("firstName");
                valueList.add(searchCriteria.getFirstName() + "%");
            } else {
                criteriaList.add("upper(rt.firstName) = upper(:firstName)");
                paramList.add("firstName");
                valueList.add(searchCriteria.getFirstName());
            }
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getMilitaryServiceNumber())) {
            criteriaList.add("(rtd.militaryServiceNumber = :militaryServiceNumber or mse.serviceNumber = :militaryServiceNumber)");
            paramList.add("militaryServiceNumber");
            valueList.add(searchCriteria.getMilitaryServiceNumber());
        }
        StringBuffer whereClause = new StringBuffer();
        if (!criteriaList.isEmpty()) {
            whereClause.append(" where ").append(criteriaList.get(0));
            for (int index = 0; index < criteriaList.size(); ++index) {
                whereClause.append(" and ").append(criteriaList.get(index));
            }
        }
        return whereClause.toString();
    }
}

