/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PreferredFacilityDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.util.List;
import org.hibernate.HibernateException;

public class PreferredFacilityDAOImpl
extends GenericDAOImpl
implements PreferredFacilityDAO {
    private static final long serialVersionUID = -3490525038789642102L;
    private boolean isDataClean = true;
    private static final String GET_BY_VPID = "PF_personQuery_GetByVPID";
    private static final String PARAM_FOR_GET_BY_VPID = "VPIDValue";
    private static final String GET_CHILD_VAFACILITY = "childVaFacilityQuery_GetByIds";
    private static final String GET_ENROLLMENT_COUNT = "PF_GetEnrollmentCount";
    private static final String PARAM_PERSON_ID = "personId";

    @Override
    public PreferredFacilityPerson getPreferredFacilityPersonByVPID(VPIDEntityKey key) throws DAOException {
        if (key == null) {
            return null;
        }
        List persons = this.findByNamedQueryAndNamedParam(GET_BY_VPID, PARAM_FOR_GET_BY_VPID, key.getVPID());
        this.verifyDataIntegrity(key, persons);
        return persons.size() >= 1 ? persons.get(0) : null;
    }

    private void verifyDataIntegrity(VPIDEntityKey vpid, List persons) throws DAOException {
        if (persons.size() > 1) {
            if (this.isDataClean) {
                throw new DAOException("Found more than one Person for VPID: " + vpid.getVPID());
            }
            if (this.logger.isErrorEnabled()) {
                Object firstObject;
                Object personId = firstObject = persons.get(0);
                if (firstObject instanceof Person) {
                    personId = ((Person)((Object)firstObject)).getPersonEntityKey().getKeyValueAsString();
                } else if (firstObject instanceof Object[]) {
                    personId = ((Object[])firstObject)[0];
                }
                this.logger.error((Object)("The data is not clean since there is more than one (actually " + persons.size() + ") Person for VPID: " + vpid.getVPID() + " - arbitrarily choosing first one, it has personId=" + personId));
            }
        }
    }

    @Override
    public List getChildVaFacility(List parentSiteIds) throws DAOException {
        try {
            List results = this.findByNamedQueryAndNamedParam(GET_CHILD_VAFACILITY, "siteId", parentSiteIds);
            return results;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get  Child VAFacility by Id.", (Throwable)e);
        }
    }

    @Override
    public int getEnrollmentRecordCount(PersonEntityKey personId) throws DAOException {
        List count = this.findByNamedQueryAndNamedParam(GET_ENROLLMENT_COUNT, PARAM_PERSON_ID, personId.getKeyValue());
        return (Integer)count.get(0);
    }
}

