/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.persistent.person.PersonMergeDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class PersonMergeDAOImpl
extends GenericDAOImpl
implements PersonMergeDAO {
    private static final String PRIMARY_PERSON_ENTITY_KEYS_CONTEXT_KEY = "primaryPersonEntityKeys";
    private static final String SEARCH_QUERY_INFO_CONTEXT_KEY = "searchQueryInfo";
    private static final String FIND_PERSON_MERGE_BY_PERSON_ID = "personMerge_FindByPersonId";
    private static final String FIND_PERSON_MERGE_BY_DEPRECATED_ID = "personMerge_FindByDeprecatedPersonId";
    private static final String FIND_PERSON_MERGE_BY_PRIMARY_DEPRECATED_PERSON_IDS = "personMerge_FindByPrimaryDeprecatedPersonIds";
    private static final String PARAM_PERSON_ID = "personId";
    private static final String FIND_NOT_COMPLETED_PERSON_MERGE_BY_PRIMARY_PERSON_ENTITY_KEYS = "personMerge_FindNotCompletedByPrimaryPersonEntityKeys";
    private static final String FIND_NOT_COMPLETED_PERSON_MERGE_BY_PRIMARY_PERSON_ENTITY_KEYS_COUNT = "personMerge_FindNotCompletedByPrimaryPersonEntityKeysCount";
    private static final String FIND_PERSON_MERGE_BY_PERSON_IDS = "personMerge_FindByPersonIds";
    private static final String PARAM_PERSON_ID1 = "personId1";
    private static final String PARAM_PERSON_ID2 = "personId2";
    private static final String PARAM_PERSON_IDS = "personIds";
    private static final String LOAD_ALL_NOT_COMPLETED = "personMerge_FindAllNotCompleted";
    private static final String LOAD_ALL_NOT_COMPLETED_WHERE = "  MERGE_END_DATE IS NULL ";
    private static final String PERSON_MERGE_COLUMNS = " PERSON_MERGE_ID, PRIMARY_PERSON_ID, DEPRECATED_PERSON_ID, MERGE_RECORD_LOCKED_FLAG, MERGE_START_DATE, MERGE_END_DATE, RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY, RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT, MERGE_DATA_TEXT ";
    private static final String PERSON_MERGE_TABLE = " PERSON_MERGE ";
    private static final String LOAD_ALL_NOT_COMPLETED_SELECT_QUERY = "SELECT  PERSON_MERGE_ID, PRIMARY_PERSON_ID, DEPRECATED_PERSON_ID, MERGE_RECORD_LOCKED_FLAG, MERGE_START_DATE, MERGE_END_DATE, RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY, RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT, MERGE_DATA_TEXT  FROM  PERSON_MERGE  WHERE   MERGE_END_DATE IS NULL ";
    private static final String LOAD_ALL_NOT_COMPLETED_COUNT_QUERY = "SELECT COUNT(*) FROM  PERSON_MERGE  WHERE   MERGE_END_DATE IS NULL ";
    private static final long serialVersionUID = -7683550608719051161L;

    @Override
    public PersonMergeInfo getPersonMergeInfo(PersonIdEntityKey personId) throws DAOException {
        Validate.notNull((Object)personId, (String)"Person Id can not be null.");
        try {
            List results = this.findByNamedQueryAndNamedParam(FIND_PERSON_MERGE_BY_PERSON_ID, PARAM_PERSON_ID, new BigDecimal(personId.getKeyValueAsString()));
            return results == null || results.isEmpty() ? null : (PersonMergeInfo)((Object)results.get(0));
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find PersonMergeInfo by personId.", (Throwable)ex);
        }
    }

    @Override
    public PersonMergeInfo getPersonMergeInfoByDeprecatedId(PersonIdEntityKey personId) throws DAOException {
        Validate.notNull((Object)personId, (String)"Person Id can not be null.");
        try {
            List results = this.findByNamedQueryAndNamedParam(FIND_PERSON_MERGE_BY_DEPRECATED_ID, PARAM_PERSON_ID, new BigDecimal(personId.getKeyValueAsString()));
            return results == null || results.isEmpty() ? null : (PersonMergeInfo)((Object)results.get(0));
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find PersonMergeInfo by personId.", (Throwable)ex);
        }
    }

    @Override
    public List loadAllNotCompleted() throws DAOException {
        try {
            return this.getHibernateTemplate().findByNamedQuery(LOAD_ALL_NOT_COMPLETED);
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find all non-completed PersonMergeInfo objects.");
        }
    }

    @Override
    public List loadAllNotCompleted(SearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        try {
            Date startDate = new Date();
            HashMap<String, SearchQueryInfo> contextData = new HashMap<String, SearchQueryInfo>();
            contextData.put(SEARCH_QUERY_INFO_CONTEXT_KEY, searchQueryInfo);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) throws DAOException {
                    Query countQuery = session.createQuery(" select count(*) FROM PersonMergeInfo pm  WHERE  pm.mergeEndDate = null ");
                    Query dataQuery = session.createQuery(" FROM   PersonMergeInfo pm  WHERE  pm.mergeEndDate = null ORDER BY  pm.primaryPersonIdentifier");
                    SearchQueryInfo targetQueryInfo = (SearchQueryInfo)this.getContextData().get(PersonMergeDAOImpl.SEARCH_QUERY_INFO_CONTEXT_KEY);
                    PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, targetQueryInfo);
                    try {
                        return queryExecutor.executeQuery();
                    }
                    catch (MaxRecordsExceededException e) {
                        throw new DAOException("max records exceeded", (Throwable)e);
                    }
                }
            };
            List results = null;
            try {
                results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            }
            catch (HibernateSystemException e) {
                MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
                if (rootCause != null) {
                    throw rootCause;
                }
                throw e;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Total time to perform person merge search: " + (new Date().getTime() - startDate.getTime()) + " ms."));
            }
            return results;
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find all non-completed PersonMergeInfo objects.");
        }
    }

    @Override
    public List findNotCompletedByPrimaryPersonEntityKeys(List personEntityKeys, SearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        Validate.notEmpty((Collection)personEntityKeys, (String)"personEntityKeys cannot be empty");
        Validate.notNull((Object)searchQueryInfo, (String)"searchQueryInfo cannot be empty");
        try {
            Date startDate = new Date();
            HashMap contextData = new HashMap();
            contextData.put(PRIMARY_PERSON_ENTITY_KEYS_CONTEXT_KEY, personEntityKeys);
            contextData.put(SEARCH_QUERY_INFO_CONTEXT_KEY, searchQueryInfo);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) throws DAOException {
                    Query countQuery = session.getNamedQuery(PersonMergeDAOImpl.FIND_NOT_COMPLETED_PERSON_MERGE_BY_PRIMARY_PERSON_ENTITY_KEYS_COUNT);
                    Query dataQuery = session.getNamedQuery(PersonMergeDAOImpl.FIND_NOT_COMPLETED_PERSON_MERGE_BY_PRIMARY_PERSON_ENTITY_KEYS);
                    List personEntityKeys = (List)this.getContextData().get(PersonMergeDAOImpl.PRIMARY_PERSON_ENTITY_KEYS_CONTEXT_KEY);
                    Iterator personEntityKeysIterator = personEntityKeys.iterator();
                    ArrayList<BigDecimal> personIds = new ArrayList<BigDecimal>();
                    while (personEntityKeysIterator.hasNext()) {
                        PersonEntityKey personEntityKey = (PersonEntityKey)personEntityKeysIterator.next();
                        personIds.add(new BigDecimal(personEntityKey.getKeyValueAsString()));
                    }
                    countQuery.setParameterList(PersonMergeDAOImpl.PARAM_PERSON_IDS, personIds);
                    dataQuery.setParameterList(PersonMergeDAOImpl.PARAM_PERSON_IDS, personIds);
                    SearchQueryInfo searchQueryInfo = (SearchQueryInfo)this.getContextData().get(PersonMergeDAOImpl.SEARCH_QUERY_INFO_CONTEXT_KEY);
                    PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, searchQueryInfo);
                    try {
                        return queryExecutor.executeQuery();
                    }
                    catch (MaxRecordsExceededException e) {
                        throw new DAOException("max records exceeded", (Throwable)e);
                    }
                }
            };
            List results = null;
            try {
                results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            }
            catch (HibernateSystemException e) {
                MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
                if (rootCause != null) {
                    throw rootCause;
                }
                throw e;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Total time to perform findNotCompletedByPrimaryPersonIds(): " + (new Date().getTime() - startDate.getTime()) + " ms."));
            }
            return results;
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find non-completed PersonMergeInfo objects.", (Throwable)ex);
        }
    }

    @Override
    public PersonMergeInfo findByPersonIds(PersonIdEntityKey personId1, PersonIdEntityKey personId2) throws DAOException {
        Validate.notNull((Object)personId1, (String)"Person Id 1 can not be null.");
        Validate.notNull((Object)personId2, (String)"Person Id 2 can not be null.");
        String[] paramNames = new String[]{PARAM_PERSON_ID1, PARAM_PERSON_ID2};
        Object[] values = new Object[]{new BigDecimal(personId1.getKeyValueAsString()), new BigDecimal(personId2.getKeyValueAsString())};
        try {
            List results = this.findByNamedQueryAndNamedParam(FIND_PERSON_MERGE_BY_PERSON_IDS, paramNames, values);
            return results == null || results.isEmpty() ? null : (PersonMergeInfo)((Object)results.get(0));
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find PersonMergeInfo by personId.", (Throwable)ex);
        }
    }

    @Override
    public List findByPrimaryDeprecatedIds(PersonIdEntityKey primaryPersonId, PersonIdEntityKey deprecatedPersonId) throws DAOException {
        Validate.notNull((Object)primaryPersonId, (String)"Primary Person Id can not be null.");
        Validate.notNull((Object)deprecatedPersonId, (String)"Deprecated Person Id can not be null.");
        String[] paramNames = new String[]{PARAM_PERSON_ID1, PARAM_PERSON_ID2};
        Object[] values = new Object[]{new BigDecimal(primaryPersonId.getKeyValueAsString()), new BigDecimal(deprecatedPersonId.getKeyValueAsString())};
        try {
            List results = this.findByNamedQueryAndNamedParam(FIND_PERSON_MERGE_BY_PRIMARY_DEPRECATED_PERSON_IDS, paramNames, values);
            return results == null || results.isEmpty() ? null : results;
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to find PersonMergeInfo by primary and deprecated personIds.", (Throwable)ex);
        }
    }
}

