/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.service.PersonSearchQueryInfo;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.ObjectUtils;
import gov.va.med.fw.util.SortElement;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.ps.model.PersonVPID;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class PersonDAOImpl
extends GenericDAOImpl
implements PersonDAO {
    private static final long serialVersionUID = -477687582162034031L;
    private boolean isDataClean = true;
    private static final String GET_BY_VPID = "personQuery_GetByVPID";
    private static final String PARAM_FOR_GET_BY_VPID = "VPIDValue";
    private static final String GET_VPID_BY_PERSONID = "personQuery_GetVPIDByPersonId";
    private static final String GET_PERSONID_BY_VPID = "personQuery_GetPersonIdByVPID";
    private static final String PARAM_PERSONID = "personId";
    private static final String PARAM_VPID = "VPIDValue";
    private static final String PARAM_VOA_IND = "voaInd";
    private static final String UPDATE_VOA_IND = "personQuery_UpdateVOAIndicator";
    private static final String GET_VPIDS_BY_PERSONIDS = "personQuery_GetVPIDSByPersonIds";
    private static final String GET_PERSONIDS_BY_VPIDS = "personQuery_GetPersonIdsByVPIDs";
    private static final String PARAM_PERSONIDS = "personIds";
    private static final String PARAM_VPIDS = "VPIDValues";
    private static final String GET_VPIDID_BY_VPIDVALUE = "personVPID_GetByVPID";
    private static final Map uiFieldToColumnMap = new HashMap();
    private static final String COLUMN_PERSON_ID = "p.identifier";
    private static final String COLUMN_VPID_VALUE = "p.VPIDValue";
    private static final String COLUMN_SENSITIVE_RECORD = "p.sensitiveRecord";
    private static final String COLUMN_MILITARY_SERVICE_NUMBER = "mse.serviceNumber";
    private static final String COLUMN_CLAIM_FOLDER_NUMBER = "p.claimFolderNumber";
    private static final String COLUMN_ED_ID = "ed.identifier";
    private static final String TABLE_PERSON = "Person p";
    private static final String TABLE_MILITARY_SERVICE_SITE_RECORDS = "p.militaryService.internalMilitaryServiceSiteRecords sites";
    private static final String TABLE_MILITARY_SERVICE_EPISODE = "sites.internalMilitaryServiceEpisodes mse";
    private static final String TABLE_ENROLLMENT_DETERMINATION = "p.internalEnrollmentDeterminations ed";
    private static final String SELECT_COUNT_CLAUSE = "SELECT COUNT(*)";
    private static final String SELECT_RETRIEVE_DATA_CLAUSE = "SELECT p.identifier, p.VPIDValue, p.sensitiveRecord, ed.identifier";
    private static final String FROM_PERSON = " FROM Person p ";
    private static final String FROM_PERSON_ED = " FROM Person p LEFT OUTER JOIN p.internalEnrollmentDeterminations ed ";
    private static final String SEARCH_FROM_CLAUSE = " FROM Person p LEFT OUTER JOIN p.internalEnrollmentDeterminations ed  WHERE p.identifier in (SELECT p.identifier FROM Person p  ";
    private static final String FROM_CLAUSE_ADD_MS_JOIN = " JOIN p.militaryService.internalMilitaryServiceSiteRecords sites JOIN sites.internalMilitaryServiceEpisodes mse ";
    private static final String IS_NULL = "is null";
    private static final int NUM_SEARCH_PARAMS = 2;

    @Override
    public Person getByVPID(VPIDEntityKey key) throws DAOException {
        if (key == null) {
            return null;
        }
        List persons = this.findByNamedQueryAndNamedParam(GET_BY_VPID, "VPIDValue", VPIDEntityKeyImpl.getLongVPID(key.getVPID()));
        this.verifyDataIntegrity(key, persons);
        return persons.size() >= 1 ? persons.get(0) : null;
    }

    @Override
    public Map getIdsByVPIDs(List vpids) throws DAOException {
        if (vpids == null || vpids.size() <= 0) {
            return null;
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        try {
            List results = this.findByNamedQueryAndNamedParam(GET_PERSONIDS_BY_VPIDS, PARAM_VPIDS, vpids);
            if (results == null || results.isEmpty()) {
                return null;
            }
            for (int i = 0; i < results.size(); ++i) {
                Object[] values = (Object[])results.get(i);
                String vpid = (String)values[0];
                BigDecimal personid = (BigDecimal)values[1];
                resultMap.put(vpid, personid);
            }
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to get personids by vpids.", (Throwable)ex);
        }
        return resultMap;
    }

    @Override
    public Map getVPIDsbyIds(List personids) throws DAOException {
        if (personids == null || personids.size() <= 0) {
            return null;
        }
        HashMap<BigDecimal, String> resultMap = new HashMap<BigDecimal, String>();
        try {
            List results = this.findByNamedQueryAndNamedParam(GET_VPIDS_BY_PERSONIDS, PARAM_PERSONIDS, personids);
            if (results == null || results.isEmpty()) {
                return null;
            }
            for (int i = 0; i < results.size(); ++i) {
                Object[] values = (Object[])results.get(i);
                String vpid = (String)values[0];
                BigDecimal personid = (BigDecimal)values[1];
                resultMap.put(personid, vpid);
            }
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to get vpids by personIds.", (Throwable)ex);
        }
        return resultMap;
    }

    private void verifyDataIntegrity(VPIDEntityKey vpid, List persons) throws DAOException {
        if (persons.size() > 1) {
            if (this.isDataClean) {
                throw new DAOException("Found more than one Person for VPID: " + vpid.getVPID());
            }
            if (this.logger.isErrorEnabled()) {
                Object firstObject;
                Object personId = firstObject = persons.get(0);
                if (firstObject instanceof Person) {
                    personId = ((Person)((Object)firstObject)).getPersonEntityKey().getKeyValueAsString();
                } else if (firstObject instanceof Object[]) {
                    personId = ((Object[])firstObject)[0];
                }
                this.logger.error((Object)("The data is not clean since there is more than one (actually " + persons.size() + ") Person for VPID: " + vpid.getVPID() + " - arbitrarily choosing first one, it has personId=" + personId));
            }
        }
    }

    @Override
    public Person getSearchResultsByVPID(VPIDEntityKey key) throws DAOException {
        try {
            HashMap<String, VPIDEntityKey> contextData = new HashMap<String, VPIDEntityKey>();
            contextData.put("key", CommonEntityKeyFactory.createVPIDEntityKey(VPIDEntityKeyImpl.getLongVPID(key.getVPID())));
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query dataQuery = PersonDAOImpl.this.getSearchSelectDataQueryString(session, (VPIDEntityKey)this.getContextData().get("key"));
                    dataQuery.setFirstResult(0);
                    dataQuery.setMaxResults(Integer.MAX_VALUE);
                    return dataQuery.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            this.verifyDataIntegrity(key, results);
            Person person = null;
            if (results.size() >= 1) {
                Object[] data = (Object[])results.get(0);
                person = this.buildPersonFromSearchResults(data);
            }
            return person;
        }
        catch (HibernateException ex) {
            throw new DAOException("An error occurred while getting a Person by VPID " + key.getVPID() + ".", (Throwable)ex);
        }
    }

    @Override
    public void updateVOAIndicator(Person person) throws DAOException {
        Query query = super.getSession().getNamedQuery(UPDATE_VOA_IND);
        query.setParameter(PARAM_VOA_IND, (Object)person.getVOAIndicator());
        query.setParameter(PARAM_PERSONID, (Object)((BigDecimal)person.getEntityKey().getKeyValue()));
        int updateCount = query.executeUpdate();
        if (updateCount < 1 && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Person VOAIndicator not updated with person: " + person.getEntityKey().getKeyValue() + " for msgControlId=" + person.getVOAIndicator()));
        }
    }

    private Person buildPersonFromSearchResults(Object[] resultData) {
        Person person = new Person(CommonEntityKeyFactory.createVPIDEntityKey((String)resultData[1]));
        this.setPersonId(person, (Serializable)resultData[0]);
        person.setSensitiveRecord((Boolean)resultData[2]);
        Serializable enrollmentDeterminationId = (Serializable)resultData[3];
        if (enrollmentDeterminationId != null) {
            person.setEnrollmentDetermination(new EnrollmentDetermination());
        }
        return person;
    }

    @Override
    public List find(PersonSearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        try {
            Date startDate = new Date();
            HashMap<String, PersonSearchQueryInfo> contextData = new HashMap<String, PersonSearchQueryInfo>();
            contextData.put("searchQueryInfo", searchQueryInfo);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) throws DAOException {
                    PersonSearchQueryInfo targetQueryInfo = (PersonSearchQueryInfo)this.getContextData().get("searchQueryInfo");
                    Query countQuery = PersonDAOImpl.this.getSearchSelectCountQueryString(session, targetQueryInfo);
                    Query dataQuery = PersonDAOImpl.this.getSearchSelectDataQueryString(session, targetQueryInfo);
                    PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)targetQueryInfo);
                    try {
                        return queryExecutor.executeQuery();
                    }
                    catch (MaxRecordsExceededException e) {
                        throw new DAOException("max records exceeded", (Throwable)e);
                    }
                }
            };
            List results = null;
            try {
                results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            }
            catch (HibernateSystemException e) {
                MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
                if (rootCause != null) {
                    throw rootCause;
                }
                throw e;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Total time to perform person search: " + (new Date().getTime() - startDate.getTime()) + " ms."));
                this.logger.info((Object)("Size of search results: " + ObjectUtils.getObjectSize((Object)results) + " bytes."));
            }
            ArrayList<Person> processedResults = new ArrayList<Person>(results.size());
            for (int index = 0; index < results.size(); ++index) {
                Object[] data = (Object[])results.get(index);
                Person person = this.buildPersonFromSearchResults(data);
                processedResults.add(person);
            }
            return processedResults;
        }
        catch (HibernateException ex) {
            throw new DAOException("An error occurred while finding a person.", (Throwable)ex);
        }
    }

    private Query getSearchSelectCountQueryString(Session session, PersonSearchQueryInfo searchQueryInfo) throws HibernateException {
        ArrayList paramList = new ArrayList(2);
        ArrayList valueList = new ArrayList(2);
        Query query = session.createQuery(PersonDAOImpl.getSearchSelectCountClause() + PersonDAOImpl.getSearchFromClause(searchQueryInfo) + this.getSearchWhereClause(searchQueryInfo, paramList, valueList) + ")");
        this.prepareQuery(query, paramList, valueList);
        return query;
    }

    private Query getSearchSelectDataQueryString(Session session, VPIDEntityKey key) throws HibernateException {
        ArrayList paramList = new ArrayList(1);
        ArrayList valueList = new ArrayList(1);
        Query query = session.createQuery(PersonDAOImpl.getSearchSelectRetrieveDataClause() + FROM_PERSON_ED + this.getSearchWhereClause(key, paramList, valueList));
        this.prepareQuery(query, paramList, valueList);
        return query;
    }

    private Query getSearchSelectDataQueryString(Session session, PersonSearchQueryInfo searchQueryInfo) throws HibernateException {
        ArrayList paramList = new ArrayList(2);
        ArrayList valueList = new ArrayList(2);
        Query query = session.createQuery(PersonDAOImpl.getSearchSelectRetrieveDataClause() + PersonDAOImpl.getSearchFromClause(searchQueryInfo) + this.getSearchWhereClause(searchQueryInfo, paramList, valueList) + this.getSearchOrderByClause(searchQueryInfo.getSortElements()) + ")");
        this.prepareQuery(query, paramList, valueList);
        return query;
    }

    private static String getSearchSelectRetrieveDataClause() {
        return SELECT_RETRIEVE_DATA_CLAUSE;
    }

    private static String getSearchSelectCountClause() {
        return SELECT_COUNT_CLAUSE;
    }

    private static String getSearchFromClause(PersonSearchQueryInfo searchInfo) {
        String returnClause = SEARCH_FROM_CLAUSE;
        if (!StringUtils.isEmpty((String)searchInfo.getMilitaryServiceNumber())) {
            returnClause = returnClause + FROM_CLAUSE_ADD_MS_JOIN;
        }
        return returnClause;
    }

    private String getSearchWhereClause(PersonSearchQueryInfo searchQueryInfo, List paramList, List valueList) {
        ArrayList<String> criteriaList = new ArrayList<String>(2);
        StringBuffer clauseBuffer = new StringBuffer();
        String militaryServiceNumber = StringUtils.trimToNull((String)searchQueryInfo.getMilitaryServiceNumber());
        String cliamFolderNumber = StringUtils.trimToNull((String)searchQueryInfo.getClaimFolderNumber());
        boolean caseSensitive = searchQueryInfo.getCaseSensitive();
        boolean removeEmptyStrings = searchQueryInfo.getRemoveEmptyStrings();
        if (militaryServiceNumber == null) {
            if (!removeEmptyStrings) {
                criteriaList.add("mse.serviceNumber is null");
            }
        } else {
            criteriaList.add(caseSensitive ? "mse.serviceNumber = :militaryServiceNumber" : "upper(mse.serviceNumber) = upper(:militaryServiceNumber)");
            paramList.add("militaryServiceNumber");
            valueList.add(militaryServiceNumber);
        }
        if (cliamFolderNumber == null) {
            if (!removeEmptyStrings) {
                criteriaList.add("p.claimFolderNumber is null");
            }
        } else {
            criteriaList.add("p.claimFolderNumber = :cliamFolderNumber");
            paramList.add("cliamFolderNumber");
            valueList.add(cliamFolderNumber);
        }
        if (paramList.size() > 0) {
            clauseBuffer.append(" WHERE ").append(criteriaList.get(0));
            for (int index = 1; index < criteriaList.size(); ++index) {
                clauseBuffer.append(" AND ").append(criteriaList.get(index));
            }
        }
        return clauseBuffer.toString();
    }

    private String getSearchWhereClause(VPIDEntityKey key, List paramList, List valueList) {
        paramList.add("VPIDValue");
        valueList.add(key.getVPID());
        return " WHERE p.VPIDValue = :VPIDValue";
    }

    private String getSearchOrderByClause(List sortElements) {
        StringBuffer clauseBuffer = new StringBuffer();
        if (sortElements != null) {
            for (SortElement sortElement : sortElements) {
                String databaseColumn = (String)uiFieldToColumnMap.get(sortElement.getSortColumn());
                if (databaseColumn != null) {
                    if (clauseBuffer.length() > 0) {
                        clauseBuffer.append(", ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                        continue;
                    }
                    clauseBuffer.append(" ORDER BY ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                    continue;
                }
                return "";
            }
        }
        return clauseBuffer.toString();
    }

    private void prepareQuery(Query query, List paramList, List valueList) throws HibernateException {
        for (int i = 0; i < paramList.size(); ++i) {
            query.setParameter((String)paramList.get(i), valueList.get(i));
        }
    }

    private void setPersonId(Person person, Serializable id) {
        try {
            Class<?> clazz = Class.forName("gov.va.med.fw.model.AbstractKeyedEntity");
            Method method = clazz.getDeclaredMethod("setIdentifier", Serializable.class);
            method.setAccessible(true);
            method.invoke((Object)person, id);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set identifier.", e);
        }
    }

    public boolean isDataClean() {
        return this.isDataClean;
    }

    public void setIsDataClean(boolean isDataClean) {
        this.isDataClean = isDataClean;
    }

    @Override
    public VPIDEntityKey getVPIDByPersonId(PersonIdEntityKey personId) throws DAOException {
        Validate.notNull((Object)personId, (String)"NULL personId not allowed.");
        try {
            List results = this.findByNamedQueryAndNamedParam(GET_VPID_BY_PERSONID, PARAM_PERSONID, new BigDecimal(personId.getKeyValueAsString()));
            if (results == null || results.isEmpty() || !(results.get(0) instanceof String)) {
                return null;
            }
            return CommonEntityKeyFactory.createVPIDEntityKey((String)results.get(0));
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to get VPIDEntityKey by personId.", (Throwable)ex);
        }
    }

    @Override
    public PersonIdEntityKey getPersonIdByVPID(VPIDEntityKey vpid) throws DAOException {
        try {
            List results = this.findByNamedQueryAndNamedParam(GET_PERSONID_BY_VPID, "VPIDValue", VPIDEntityKeyImpl.getLongVPID(vpid.getVPID()));
            this.verifyDataIntegrity(vpid, results);
            if (results == null || results.isEmpty() || !(results.get(0) instanceof BigDecimal)) {
                return null;
            }
            return CommonEntityKeyFactory.createPersonIdEntityKey((BigDecimal)results.get(0));
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to getPersonIdEntityKey by VPID.", (Throwable)ex);
        }
    }

    @Override
    public PersonVPID getPersonVPIDByVpidValue(VPIDEntityKey vpid) throws DAOException {
        String vpidValue = ((VPIDEntityKeyImpl)vpid).getLongVPID();
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("VPIDValue", vpidValue);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(PersonDAOImpl.GET_VPIDID_BY_VPIDVALUE);
                    session.createQuery(query.getQueryString());
                    query.setString("VPIDValue", (String)this.getContextData().get("VPIDValue"));
                    return query.setMaxResults(1).uniqueResult();
                }
            };
            return (PersonVPID)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get PersonVPID By VPIDValue", (Throwable)e);
        }
    }
}

