/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.persistent.person.EnrollmentApplicationDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.lob.SerializableClob;

public class EnrollmentApplicationDAOImpl
extends GenericDAOImpl
implements EnrollmentApplicationDAO {
    private static final long serialVersionUID = -8511001891879508196L;
    private static final String PARAM_SSN = "ssn";
    private static final String PARAM_ICN = "icn";
    private static final String REGISTRATION_BY_ICN_QUERY = "EnrollmentApplication_by_icn";
    private static final String INPROCESS_PERSON_XML_BY_ICN = "InProcess_Person_Xml_GetByIcn";
    private static final String APPLICATION_STATUS_CODE_BY_ICN = "Application_Status_Code_GetByIcn";

    public void saveInProcess(EnrollmentApplication ea) throws DAOException {
        this.saveObject((Object)ea);
    }

    @Override
    public EnrollmentApplication getByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        try {
            List results = this.findByNamedQueryAndNamedParam(REGISTRATION_BY_ICN_QUERY, PARAM_ICN, icn);
            this.verifyDataIntegrity(icn, results);
            return results.size() == 0 ? null : (EnrollmentApplication)((Object)results.get(0));
        }
        catch (Exception e) {
            throw new DAOException("getByIcn failed for icn: " + icn, (Throwable)e);
        }
    }

    @Override
    public List getApplicationStatusCodeListByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        try {
            return this.findByNamedQueryAndNamedParam(APPLICATION_STATUS_CODE_BY_ICN, PARAM_ICN, icn);
        }
        catch (Exception e) {
            throw new DAOException("getByIcn failed for icn: " + icn, (Throwable)e);
        }
    }

    @Override
    public SerializableClob getInProcessPersonXmlByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        try {
            List results = this.findByNamedQueryAndNamedParam(INPROCESS_PERSON_XML_BY_ICN, PARAM_ICN, icn);
            this.verifyDataIntegrity(icn, results);
            if (results.size() > 0) {
                return (SerializableClob)results.get(0);
            }
        }
        catch (Exception e) {
            throw new DAOException("getInProcessPersonByIcn failed for icn: " + icn, (Throwable)e);
        }
        return null;
    }

    private void verifyDataIntegrity(String icn, List results) throws DAOException {
        if (results.size() > 1) {
            throw new DAOException("Found more than one record in AplicationInProcess for ICN(VPID): " + icn);
        }
    }
}

