/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import com.thoughtworks.xstream.XStream;
import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.person.ApplicationInProcessDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.lob.SerializableClob;

public class ApplicationInProcessDAOImpl
extends GenericDAOImpl
implements ApplicationInProcessDAO {
    private static final long serialVersionUID = 8030055516741362319L;
    public static final String APPLICATION_SSN_QUERY = "ApplicationInProcess_GetBySsn";
    public static final String INPROCESS_PERSON_ICN_QUERY = "InProcess_Person_GetByIcn";
    public static final String COMPLETE_PERSON_ICN_QUERY = "Complete_Person_GetByIcn";
    public static final String APPLICATION_ICN_QUERY = "ApplicationInProcess_GetByIcn";
    public static final String GET_AIP_BY_EAID = "ApplicationInProcess_GetAIPByEAID";
    public static final String PARAM_SSN = "ssn";
    public static final String PARAM_ICN = "icn";
    public static final String PARAM_EAID = "eaid";

    @Override
    public ApplicationInProcess getByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        try {
            List results = this.findByNamedQueryAndNamedParam(APPLICATION_ICN_QUERY, PARAM_ICN, icn);
            this.verifyDataIntegrity(icn, results);
            return results.size() == 0 ? null : (ApplicationInProcess)((Object)results.get(0));
        }
        catch (Exception e) {
            throw new DAOException("getByIcn failed for icn: " + icn, (Throwable)e);
        }
    }

    @Override
    public Person getInProcessPersonByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        Person p = null;
        try {
            List results = this.findByNamedQueryAndNamedParam(INPROCESS_PERSON_ICN_QUERY, PARAM_ICN, icn);
            this.verifyDataIntegrity(icn, results);
            if (results.size() > 0) {
                SerializableClob clob = (SerializableClob)results.get(0);
                p = this.deserializeXML(clob);
            }
        }
        catch (Exception e) {
            throw new DAOException("getInProcessPersonByIcn failed for icn: " + icn, (Throwable)e);
        }
        return p;
    }

    @Override
    public Person getCompletedPersonByIcn(String icn) throws DAOException {
        Validate.notNull((Object)icn, (String)"ICN cannot be null");
        Person p = null;
        try {
            List results = this.findByNamedQueryAndNamedParam(COMPLETE_PERSON_ICN_QUERY, PARAM_ICN, icn);
            this.verifyDataIntegrity(icn, results);
            if (results.size() > 0) {
                SerializableClob clob = (SerializableClob)results.get(0);
                p = this.deserializeXML(clob);
            }
        }
        catch (Exception e) {
            throw new DAOException("getInProcessPersonByIcn failed for icn: " + icn, (Throwable)e);
        }
        return p;
    }

    private void verifyDataIntegrity(String icn, List results) throws DAOException {
        if (results.size() > 1) {
            throw new DAOException("Found more than one record in AplicationInProcess for ICN(VPID): " + icn);
        }
    }

    public Person deserializeXML(SerializableClob clob) {
        Person p = null;
        XStream xstream = new XStream();
        try {
            p = (Person)((Object)xstream.fromXML(clob.getAsciiStream()));
        }
        catch (SQLException e) {
            this.logger.error((Object)("Error in ApplicationInProcessDAOImpl.deserializeXML \n" + e.toString()));
        }
        return p;
    }
}

