/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.SeedingLogEntryDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SeedingLogEntryDAOImpl
extends GenericDAOImpl
implements SeedingLogEntryDAO {
    private static final long serialVersionUID = -4381743890002053737L;

    @Override
    public SeedingLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("seedingLogEntryQuery_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (SeedingLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the seeding log entry by identifier", (Throwable)e);
        }
    }

    @Override
    public List find(Person person) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("seedingLogEntryQuery_FindByPerson", "personId", (Object)((BigDecimal)person.getEntityKey().getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public List findPersonId(BigDecimal personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("seedingLogEntryQuery_FindByPerson", "personId", (Object)personId);
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }
}

