/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class MsdsMessageLogEntryDAOImpl
extends GenericDAOImpl
implements MsdsMessageLogEntryDAO {
    private static final long serialVersionUID = -4381743890002053737L;

    @Override
    public MsdsMessageLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("MsdsMessageLogEntryQuery_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (MsdsMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", (Throwable)e);
        }
    }

    @Override
    public MsdsMessageLogEntry getByControlId(BigDecimal controlIdentifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("MsdsMessageLogEntryQuery_ControlIdentifier", "controlIdentifier", (Object)controlIdentifier);
            return results.isEmpty() ? null : (MsdsMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public List find(Person person) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("MsdsMessageLogEntryQuery_FindByPerson", "personId", (Object)((BigDecimal)person.getEntityKey().getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public MsdsMessageLogEntry findClockSetEntry(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId"};
            Object[] values = new Object[]{(BigDecimal)personId.getKeyValue()};
            List results = tpl.findByNamedQueryAndNamedParam("MsdsmessageLogEntryQuery_clock", params, values);
            return results.isEmpty() ? null : (MsdsMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public Integer findCompleteCount(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId"};
            Object[] values = new Object[]{(BigDecimal)personId.getKeyValue()};
            List results = tpl.findByNamedQueryAndNamedParam("MsdsMessageLogEntryQuery_Complete", params, values);
            return (Integer)results.iterator().next();
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }
}

