/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.lookup.hibernate;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.persistent.lookup.StateDAO;
import gov.va.med.esr.common.persistent.lookup.hibernate.LookupsDAOImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.util.HashMap;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public class StateDAOImpl
extends LookupsDAOImpl
implements StateDAO {
    private static final long serialVersionUID = -7086520428025810712L;
    private String queryNameGetByCode = null;
    private String queryNameGetByName = null;

    @Override
    public State getStateByCode(String code) throws DAOException {
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("code", code);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(StateDAOImpl.this.queryNameGetByCode);
                    query.setString("code", (String)this.getContextData().get("code"));
                    if (StateDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(StateDAOImpl.this.getCacheRegion());
                    }
                    return query.setMaxResults(1).uniqueResult();
                }
            };
            return (State)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get State by name.", (Throwable)e);
        }
    }

    @Override
    public State getStateByName(String name) throws DAOException {
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("name", name);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(StateDAOImpl.this.queryNameGetByName);
                    query.setString("name", (String)this.getContextData().get("name"));
                    if (StateDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(StateDAOImpl.this.getCacheRegion());
                    }
                    return query.setMaxResults(1).uniqueResult();
                }
            };
            return (State)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get State by name.", (Throwable)e);
        }
    }

    @Override
    public String getQueryNameGetByCode() {
        return this.queryNameGetByCode;
    }

    @Override
    public void setQueryNameGetByCode(String queryNameGetByCode) {
        this.queryNameGetByCode = queryNameGetByCode;
    }

    public String getQueryNameGetByName() {
        return this.queryNameGetByName;
    }

    public void setQueryNameGetByName(String queryNameGetByName) {
        this.queryNameGetByName = queryNameGetByName;
    }
}

