/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.persistent.history.FinancialsHistoryDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAOImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public class FinancialsHistoryDAOImpl
extends HistoryDAOImpl
implements FinancialsHistoryDAO {
    private static final long serialVersionUID = -6539765663679727611L;
    public static final String FILTER_INCOME_YEAR = "incomeYearFilter";
    public static final String FILTER_PAR_INCOME_YEAR = "incomeYear";

    @Override
    public Set getHistoryChangeTimes(EntityKey entityKey, Integer incomeYear) throws DAOException {
        Validate.notNull((Object)incomeYear, (String)"IncomeYear cannot be null");
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("entityKey", entityKey);
        contextData.put(FILTER_PAR_INCOME_YEAR, incomeYear);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                session.enableFilter(FinancialsHistoryDAOImpl.FILTER_INCOME_YEAR).setParameter(FinancialsHistoryDAOImpl.FILTER_PAR_INCOME_YEAR, this.getContextData().get(FinancialsHistoryDAOImpl.FILTER_PAR_INCOME_YEAR));
                return FinancialsHistoryDAOImpl.this.getHistoryChangeTimes((EntityKey)this.getContextData().get("entityKey"));
            }
        };
        Set ceList = (Set)this.getHibernateTemplate().execute((HibernateCallback)callback);
        TreeSet<FinancialsChangeEvent> financialsCeList = new TreeSet<FinancialsChangeEvent>();
        FinancialsChangeEvent fce = null;
        ChangeEvent ce2 = null;
        for (ChangeEvent ce2 : ceList) {
            fce = new FinancialsChangeEvent(ce2.getTimeStamp(), ce2.getEntityKey(), incomeYear);
            financialsCeList.add(fce);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("FinancialsHistoryDAO getchangeTimes: " + financialsCeList));
        }
        return financialsCeList;
    }

    @Override
    public HistoricalInfo getHistoryByChangeTime(FinancialsChangeEvent fce) throws DAOException {
        if (fce != null) {
            HashMap<String, FinancialsChangeEvent> contextData = new HashMap<String, FinancialsChangeEvent>();
            contextData.put("fce", fce);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) throws DAOException {
                    FinancialsChangeEvent targetChangeEvent = (FinancialsChangeEvent)this.getContextData().get("fce");
                    session.enableFilter(FinancialsHistoryDAOImpl.FILTER_INCOME_YEAR).setParameter(FinancialsHistoryDAOImpl.FILTER_PAR_INCOME_YEAR, (Object)targetChangeEvent.getIncomeYear());
                    return FinancialsHistoryDAOImpl.this.doGetHistoryByChangeTime(targetChangeEvent);
                }
            };
            return (HistoricalInfo)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        return null;
    }

    @Override
    public IncomeTest findConversionBaseTest(IncomeTest incomeTest) throws DAOException {
        IncomeTest test;
        if (incomeTest == null) {
            return null;
        }
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("baseId", incomeTest.getEntityKey());
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("ivmReversalQuery_findConversionBase");
                q.setMaxResults(1);
                q.setParameter("baseId", (Object)((EntityKey)this.getContextData().get("baseId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        IncomeTest incomeTest2 = test = iter.hasNext() ? (IncomeTest)((Object)iter.next()) : null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("FinancialsHistoryDAO findconversionBaseTest: " + (Object)((Object)test)));
        }
        return test;
    }

    @Override
    public List getIncomeTestStatusesForIVMReversal(final Serializable key) throws DAOException {
        Validate.notNull((Object)key, (String)"Entity key cannot be null");
        HashMap<String, Serializable> contextData = new HashMap<String, Serializable>();
        contextData.put("baseHistoryId", key);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("IncomeTestStatusQuery_GetHistoryByChangeTime");
                q.setParameter("baseHistoryId", (Object)key);
                return q.list();
            }
        };
        List statuses = (List)this.getHibernateTemplate().execute((HibernateCallback)callback);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("FinancialsHistoryDAO getITstatusForIVMReversal: " + statuses));
        }
        return statuses;
    }

    protected HistoricalInfo doGetHistoryByChangeTime(FinancialsChangeEvent fce) throws DAOException {
        return super.getHistoryByChangeTime(fce);
    }
}

