/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.ee.hibernate;

import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.persistent.ee.VoaFileAttachmentDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.hibernate.Query;

public class VoaFileAttachmentDAOImpl
extends GenericDAOImpl
implements VoaFileAttachmentDAO {
    private static final long serialVersionUID = 757631389841938318L;
    private static final String FIND_ATTACHMENT_BY_PERSON_ID = "findAttachmentByPersonId";
    private static final String FIND_ATTACHMENT_BY_APPLICATION_ID = "findAttachmentByApplicationId";
    private static final String UPDATE_ATTACHMENT_WITH_PERSON_ID = "updateAttachmentWithPersonId";
    private static final String PARAM_PERSONID = "personId";
    private static final String PARAM_MESCONTROLLID = "msgControlId";

    @Override
    public List findVoaAttachmentByPersonId(BigDecimal personId) throws DAOException {
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ATTACHMENT_BY_PERSON_ID, PARAM_PERSONID, (Object)personId);
        return results == null || results.isEmpty() ? null : results;
    }

    @Override
    public List findVoaAttachmentByApplicationId(BigDecimal applicationId) throws DAOException {
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ATTACHMENT_BY_APPLICATION_ID, "applicationId", (Object)applicationId);
        return results == null || results.isEmpty() ? null : results;
    }

    @Override
    public void updateAttachmentAttributes(VoaFileAttachment attachment) throws DAOException {
        super.saveObject((Object)attachment);
    }

    @Override
    public void updateVoaAttachmentWithPersonId(String msgControlId, BigDecimal personId) throws DAOException {
        Query query = super.getSession().getNamedQuery(UPDATE_ATTACHMENT_WITH_PERSON_ID);
        query.setParameter(PARAM_MESCONTROLLID, (Object)msgControlId);
        query.setParameter(PARAM_PERSONID, (Object)personId);
        int updateCount = query.executeUpdate();
        if (updateCount < 1 && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("VoaFileAttachment not updated with persoin: " + personId + " for msgControlId=" + msgControlId));
        }
    }
}

