/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.persistent.comms.HandbookBatchRequestDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class HandbookBatchRequestDAOImpl
extends AbstractDAOImpl
implements HandbookBatchRequestDAO {
    private static final long serialVersionUID = 6580559389115357262L;
    private static final String QRY_HANDBOOK_BATCH_REQUEST_ALL = "handBookBatchRequest_all";
    private static final String QRY_GET_EST_NO_RECORD_FOR_BATCH_REQUEST = "getEstNoOfRecordForBatchRequest";
    private static final String QRY_BATCH_REQ_NEW_IDS = "handBookBatchRequest_new";

    @Override
    public List getHandBookBatchRequests() throws DAOException {
        List requests = null;
        try {
            requests = super.getHibernateTemplate().findByNamedQuery(QRY_HANDBOOK_BATCH_REQUEST_ALL);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
        return requests;
    }

    @Override
    public List getNewHandBookBatchRequestIds() throws DAOException {
        List requests = null;
        try {
            requests = super.getHibernateTemplate().findByNamedQuery(QRY_BATCH_REQ_NEW_IDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandbookBatchRequestsbyIDs results: " + requests));
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get new batch request IDs", (Throwable)e);
        }
        return requests;
    }

    @Override
    public int getEstRecordCountForBatch(String BatchId) throws DAOException {
        int requests = 0;
        try {
            String[] batchIdParamFields = new String[]{"batchRequestId"};
            Object[] batchIdParamValues = new BigDecimal[]{new BigDecimal(BatchId)};
            List result = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_GET_EST_NO_RECORD_FOR_BATCH_REQUEST, batchIdParamFields, batchIdParamValues);
            if (result != null) {
                requests = ((BigDecimal)result.iterator().next()).intValue();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandbookBatchEstCount results: " + requests));
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
        return requests;
    }

    @Override
    public void merge(HandBookBatchRequest batchRequest) throws DAOException {
        super.getHibernateTemplate().merge((Object)batchRequest);
    }
}

