/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.security;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.AbstractPermission;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class UserCapability
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -2136807781054356615L;
    private Capability capability = null;
    private ESRUserPrincipal userPrincipal = null;
    private Date activeDate = null;
    private Date inactiveDate = null;
    private Date oldActiveDate = null;
    private Date oldInactiveDate = null;

    public UserCapability() {
    }

    public UserCapability(ESRUserPrincipalImpl userPrincipal, Capability capability, Date activeDate, Date inactiveDate) {
        Validate.notNull((Object)userPrincipal, (String)"UserPrincipal can not be null in UserCapability");
        Validate.notNull((Object)capability, (String)"Capability can not be null in UserCapability");
        this.userPrincipal = userPrincipal;
        this.capability = capability;
        this.activeDate = activeDate;
        this.inactiveDate = inactiveDate;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public void setCapability(Capability capability) {
        this.capability = capability;
    }

    public ESRUserPrincipal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(ESRUserPrincipal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Date getActiveDate() {
        return this.activeDate;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public Date getInactiveDate() {
        return this.inactiveDate;
    }

    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public Date getOldActiveDate() {
        return this.oldActiveDate;
    }

    public Date getOldInactiveDate() {
        return this.oldInactiveDate;
    }

    private void setOldActiveDate(Date oldActiveDate) {
        this.oldActiveDate = oldActiveDate;
    }

    private void setOldInactiveDate(Date oldInactiveDate) {
        this.oldInactiveDate = oldInactiveDate;
    }

    public boolean isActive() {
        return AbstractPermission.isAssignable(this.activeDate, this.inactiveDate);
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof UserCapability) {
            UserCapability other = (UserCapability)o;
            if (this.getCapability() != null && other.getCapability() != null) {
                return this.getCapability().compareTo(other.getCapability());
            }
        }
        return 1;
    }
}

