/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.security;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipal;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.security.UserCapability;
import gov.va.med.esr.common.model.security.UserCapabilitySet;
import gov.va.med.esr.common.model.security.UserLastLoginInfo;
import gov.va.med.esr.common.model.security.UserRole;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.RolePrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.acegisecurity.GrantedAuthorityImpl;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ESRUserPrincipalImpl
extends UserPrincipalImpl
implements ESRUserPrincipal,
Comparable,
Lookup {
    private static final long serialVersionUID = -3232693004167806247L;
    private String fullName;
    private Date lockDate;
    private Date lastAccessDate;
    private Date inActiveDate;
    private Date initialLoginDate;
    private Date passwordChangeDate;
    private int failAttemptCount;
    private boolean passwordChangeWarningDays;
    private int daysRemainingToExpirePassword;
    private VAFacility facility;
    private String jobTitle;
    private String agreementSignatureCode;
    private Boolean signatureVerified = null;
    private Date passwordCreateDate;
    private Date passwordSuspendDate;
    private Date passwordExpireDate;
    private FunctionalGroup functionalGroup;
    private UserLastLoginInfo userLastLoginInfo = null;
    private Set internalUserRoles = null;
    private Set internalCapabilitySets = null;
    private Set internalCapabilities = null;

    public ESRUserPrincipalImpl() {
    }

    public ESRUserPrincipalImpl(String name) {
        super(name);
    }

    public ESRUserPrincipalImpl(String name, String password) {
        super(name, password);
    }

    @Override
    public String getFullName() {
        if (this.fullName == null) {
            String givenName = this.getGivenName() == null ? "" : this.getGivenName();
            String familyName = this.getFamilyName() == null ? "" : this.getFamilyName();
            this.fullName = givenName + " " + familyName;
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getCode() {
        return this.getName();
    }

    public String getDescription() {
        return this.getFullName();
    }

    @Override
    public int getFailAttemptCount() {
        return this.failAttemptCount;
    }

    public void setFailAttemptCount(int failAttemptCount) {
        this.failAttemptCount = failAttemptCount;
    }

    @Override
    public Date getLastAccessDate() {
        return this.lastAccessDate;
    }

    public void setLastAccessDate(Date lastAccessDate) {
        this.lastAccessDate = lastAccessDate;
    }

    @Override
    public Date getLockDate() {
        return this.lockDate;
    }

    public void setLockDate(Date lockDate) {
        this.lockDate = lockDate;
    }

    @Override
    public Date getInActiveDate() {
        return this.inActiveDate;
    }

    public void setInActiveDate(Date inActiveDate) {
        this.inActiveDate = inActiveDate;
    }

    @Override
    public Date getInitialLoginDate() {
        return this.initialLoginDate;
    }

    public void setInitialLoginDate(Date initialLoginDate) {
        this.initialLoginDate = initialLoginDate;
    }

    @Override
    public Date getPasswordChangeDate() {
        return this.passwordChangeDate;
    }

    public void setPasswordChangeDate(Date passwordChangeDate) {
        this.passwordChangeDate = passwordChangeDate;
    }

    @Override
    public boolean isPasswordChangeWarningDays() {
        return this.passwordChangeWarningDays;
    }

    public void setPasswordChangeWarningDays(boolean passwordChangeWarningDays) {
        this.passwordChangeWarningDays = passwordChangeWarningDays;
    }

    @Override
    public int getDaysRemainingToExpirePassword() {
        return this.daysRemainingToExpirePassword;
    }

    public void setDaysRemainingToExpirePassword(int daysRemainingToExpirePassword) {
        this.daysRemainingToExpirePassword = daysRemainingToExpirePassword;
    }

    public String getAgreementSignatureCode() {
        return this.agreementSignatureCode;
    }

    public void setAgreementSignatureCode(String agreementSignatureCode) {
        this.agreementSignatureCode = agreementSignatureCode;
    }

    public VAFacility getFacility() {
        return this.facility;
    }

    public void setFacility(VAFacility facility) {
        this.facility = facility;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public Date getPasswordCreateDate() {
        return this.passwordCreateDate;
    }

    public void setPasswordCreateDate(Date passwordCreateDate) {
        this.passwordCreateDate = passwordCreateDate;
    }

    public Boolean getSignatureVerified() {
        return this.signatureVerified;
    }

    public void setSignatureVerified(Boolean signatureVerified) {
        this.signatureVerified = signatureVerified;
    }

    public FunctionalGroup getFunctionalGroup() {
        return this.functionalGroup;
    }

    public void setFunctionalGroup(FunctionalGroup functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public UserLastLoginInfo getUserLastLoginInfo() {
        return this.userLastLoginInfo;
    }

    public void setUserLastLoginInfo(UserLastLoginInfo userLastLoginInfo) {
        this.userLastLoginInfo = userLastLoginInfo;
    }

    public Date getFailedLoginDate() {
        return this.userLastLoginInfo == null ? null : this.userLastLoginInfo.getFailedLoginDate();
    }

    public Date getSuccessfulLoginDate() {
        return this.userLastLoginInfo == null ? null : this.userLastLoginInfo.getSuccessfulLoginDate();
    }

    @Override
    public Date getPasswordSuspendDate() {
        return this.passwordSuspendDate;
    }

    public void setPasswordSuspendDate(Date passwordSuspendDate) {
        this.passwordSuspendDate = passwordSuspendDate;
    }

    public void setPasswordExpireDate(Date passwordExpireDate) {
        this.passwordExpireDate = passwordExpireDate;
    }

    @Override
    public Date getPasswordExpireDate() {
        return this.passwordExpireDate;
    }

    public boolean isCapabilityAssigned(Capability capability) {
        return this.getCapabilities().contains(capability);
    }

    public boolean isCapabilitySetAssigned(CapabilitySet capabilitySet) {
        return this.getCapabilitySets().contains(capabilitySet);
    }

    public boolean isRoleAssigned(RolePrincipal rolePrincipal) {
        return this.findUserRole(rolePrincipal) != null;
    }

    public Set getUserRoles() {
        HashSet<RolePrincipal> roles = new HashSet<RolePrincipal>();
        for (UserRole userRole : this.getInternalUserRoles()) {
            RolePrincipal rolePrincipal = userRole.getRolePrincipal();
            if (rolePrincipal == null) continue;
            roles.add(rolePrincipal);
        }
        return roles;
    }

    public void addUserRole(RolePrincipal rolePrincipal) {
        Validate.notNull((Object)rolePrincipal, (String)"Can not add null RolePrincipal");
        if (this.findUserRole(rolePrincipal) == null) {
            UserRole userRole = new UserRole(this, rolePrincipal);
            this.getInternalUserRoles().add(userRole);
        }
    }

    public void removeUserRole(RolePrincipal rolePrincipal) {
        Validate.notNull((Object)rolePrincipal, (String)"Can not remove null RolePrincipal");
        UserRole userRoleToDelete = this.findUserRole(rolePrincipal);
        if (userRoleToDelete != null) {
            this.getInternalUserRoles().remove((Object)userRoleToDelete);
        }
    }

    private Set getInternalUserRoles() {
        if (this.internalUserRoles == null) {
            this.internalUserRoles = new HashSet();
        }
        return this.internalUserRoles;
    }

    private void setInternalUserRoles(Set internalUserRoles) {
        this.internalUserRoles = internalUserRoles;
    }

    @Override
    public Set getCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        Iterator i = this.getInternalCapabilities().iterator();
        while (i.hasNext()) {
            capabilities.add(((UserCapability)i.next()).getCapability());
        }
        return capabilities;
    }

    public List getActiveRoles() {
        ArrayList<ESRRolePrincipalImpl> activeRoles = new ArrayList<ESRRolePrincipalImpl>();
        Set assignedRoles = this.getUserRoles();
        for (ESRRolePrincipalImpl role : assignedRoles) {
            if (!role.isActive()) continue;
            activeRoles.add(role);
        }
        return activeRoles;
    }

    public List getActiveCapabilities() {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (UserCapability userCapability : this.getInternalCapabilities()) {
            if (!userCapability.isActive()) continue;
            capabilities.add(userCapability.getCapability());
        }
        Iterator i = this.getCapabilitySets().iterator();
        while (i.hasNext()) {
            capabilities.addAll(((CapabilitySet)i.next()).getActiveCapabilities());
        }
        i = this.getUserRoles().iterator();
        while (i.hasNext()) {
            capabilities.addAll(((ESRRolePrincipalImpl)i.next()).getActiveCapabilities());
        }
        return capabilities;
    }

    public Set getCapabilitySets() {
        HashSet<CapabilitySet> capabilitySets = new HashSet<CapabilitySet>();
        Iterator i = this.getInternalCapabilitySets().iterator();
        while (i.hasNext()) {
            capabilitySets.add(((UserCapabilitySet)((Object)i.next())).getCapabilitySet());
        }
        return capabilitySets;
    }

    public Set getUserCapabilities() {
        return Collections.unmodifiableSet(this.getInternalCapabilities());
    }

    public void addCapability(Capability capability, Date activeDate, Date inactiveDate) {
        UserCapability userCapability = this.findUserCapability(capability);
        if (userCapability == null) {
            userCapability = new UserCapability(this, capability, activeDate, inactiveDate);
            this.getInternalCapabilities().add(userCapability);
        } else {
            userCapability.setActiveDate(activeDate);
            userCapability.setInactiveDate(inactiveDate);
        }
    }

    public void removeCapability(UserCapability userCapability) {
        this.getInternalCapabilities().remove(userCapability);
    }

    public void removeCapability(Capability capability) {
        UserCapability userCapability = this.findUserCapability(capability);
        if (userCapability != null) {
            this.getInternalCapabilities().remove(userCapability);
        }
    }

    private Set getInternalCapabilities() {
        if (this.internalCapabilities == null) {
            this.internalCapabilities = new HashSet();
        }
        return this.internalCapabilities;
    }

    private void setInternalCapabilities(Set internalCapabilities) {
        this.internalCapabilities = internalCapabilities;
    }

    public Set getUserCapabilitySets() {
        return Collections.unmodifiableSet(this.getInternalCapabilitySets());
    }

    public void addCapabilitySet(CapabilitySet capabilitySet) {
        if (this.findUserCapabilitySet(capabilitySet) == null) {
            UserCapabilitySet userCapabilitySet = new UserCapabilitySet(this, capabilitySet);
            this.getInternalCapabilitySets().add(userCapabilitySet);
        }
    }

    public void removeCapabilitySet(CapabilitySet capabilitySet) {
        UserCapabilitySet userCapabilitySet = this.findUserCapabilitySet(capabilitySet);
        if (userCapabilitySet != null) {
            this.getInternalCapabilitySets().remove((Object)userCapabilitySet);
        }
    }

    public Set getAuthorities() {
        String roleName;
        HashSet<GrantedAuthorityImpl> authorities = new HashSet<GrantedAuthorityImpl>();
        Iterator i = this.getActiveCapabilities().iterator();
        while (i.hasNext()) {
            roleName = ((Capability)i.next()).getCode();
            authorities.add(new GrantedAuthorityImpl(roleName));
        }
        Iterator j = this.getActiveRoles().iterator();
        while (j.hasNext()) {
            roleName = ((ESRRolePrincipal)j.next()).getName();
            authorities.add(new GrantedAuthorityImpl(roleName));
        }
        return authorities;
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof ESRUserPrincipalImpl) {
            return this.getFullName().compareTo(((ESRUserPrincipalImpl)o).getFullName());
        }
        return 1;
    }

    private Set getInternalCapabilitySets() {
        if (this.internalCapabilitySets == null) {
            this.internalCapabilitySets = new HashSet();
        }
        return this.internalCapabilitySets;
    }

    private void setInternalCapabilitySets(Set internalCapabilitySets) {
        this.internalCapabilitySets = internalCapabilitySets;
    }

    private UserRole findUserRole(RolePrincipal rolePrincipal) {
        for (UserRole userRole : this.getInternalUserRoles()) {
            if (!rolePrincipal.getEntityKey().getKeyValueAsString().equals(userRole.getRolePrincipal().getEntityKey().getKeyValueAsString())) continue;
            return userRole;
        }
        return null;
    }

    public UserCapability findUserCapability(Capability capability) {
        for (UserCapability userCapability : this.getInternalCapabilities()) {
            if (!capability.equals(userCapability.getCapability())) continue;
            return userCapability;
        }
        return null;
    }

    private UserCapabilitySet findUserCapabilitySet(CapabilitySet capabilitySet) {
        for (UserCapabilitySet userCapabilitySet : this.getInternalCapabilitySets()) {
            if (!capabilitySet.getEntityKey().getKeyValueAsString().equals(userCapabilitySet.getCapabilitySet().getEntityKey().getKeyValueAsString())) continue;
            return userCapabilitySet;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fullName = null;
        this.lockDate = null;
        this.inActiveDate = null;
        this.passwordChangeDate = null;
        this.failAttemptCount = 0;
        this.internalUserRoles = null;
        this.facility = null;
        this.jobTitle = null;
        this.agreementSignatureCode = null;
        this.signatureVerified = null;
        this.passwordCreateDate = null;
        this.functionalGroup = null;
        this.passwordSuspendDate = null;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("inActiveDate", (Object)this.inActiveDate);
        builder.append("lockDate", (Object)this.lockDate);
        builder.append("failAttemptCount", this.failAttemptCount);
        builder.append("passwordChangeDate", (Object)this.passwordChangeDate);
        builder.append("facility", (Object)this.facility);
        builder.append("jobTitle", (Object)this.jobTitle);
        builder.append("agreementSignatureCode", (Object)this.agreementSignatureCode);
        builder.append("signatureVerified", (Object)this.signatureVerified);
        builder.append("passwordCreateDate", (Object)this.passwordCreateDate);
        builder.append("passwordSuspendDate", (Object)this.passwordSuspendDate);
        builder.append("passwordExpireDate", (Object)this.passwordExpireDate);
        builder.append("functionalGroup", (Object)this.functionalGroup);
    }
}

