/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.registry;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RegistryTrait
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -5938910697096303042L;
    private RegistryType registryType = null;
    private String ssn = null;
    private String prefix = null;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private String suffix = null;
    private String educationalDegree = null;
    private ImpreciseDate deathDate = null;
    private Set internalRegistryTraitDetails = null;

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getEducationalDegree() {
        return this.educationalDegree;
    }

    public void setEducationalDegree(String educationalDegree) {
        this.educationalDegree = educationalDegree;
    }

    public ImpreciseDate getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(ImpreciseDate deathDate) {
        this.deathDate = deathDate;
    }

    public Set getRegistryTraitDetails() {
        return UnmodifiableSet.decorate((Set)this.getInternalRegistryTraitDetails());
    }

    public String getMilitaryServiceNumbers() {
        StringBuffer buffer = new StringBuffer();
        if (this.internalRegistryTraitDetails != null) {
            RegistryTraitDetail rtDetail2 = null;
            for (RegistryTraitDetail rtDetail2 : this.internalRegistryTraitDetails) {
                if (rtDetail2 == null || !StringUtils.isNotBlank((String)rtDetail2.getMilitaryServiceNumber())) continue;
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(rtDetail2.getMilitaryServiceNumber());
            }
        }
        return buffer.toString();
    }

    public Set getMilitaryServiceNumbersAsSet() {
        HashSet<String> set = new HashSet<String>();
        if (this.internalRegistryTraitDetails != null) {
            RegistryTraitDetail rtDetail2 = null;
            for (RegistryTraitDetail rtDetail2 : this.internalRegistryTraitDetails) {
                if (rtDetail2 == null || !StringUtils.isNotBlank((String)rtDetail2.getMilitaryServiceNumber())) continue;
                set.add(rtDetail2.getMilitaryServiceNumber());
            }
        }
        return set;
    }

    public void addRegistryTraitDetail(RegistryTraitDetail registryTraitDetail) {
        this.getInternalRegistryTraitDetails().add(registryTraitDetail);
        registryTraitDetail.setRegistryTrait(this);
    }

    public void addAllRegistryTraitDetails(Set registryTraitDetails) {
        Validate.notEmpty((Collection)registryTraitDetails, (String)"RegistryTraitDetails cannot be null or empty");
        for (Object registryTraitDetail : registryTraitDetails) {
            if (!(registryTraitDetail instanceof RegistryTraitDetail)) continue;
            this.addRegistryTraitDetail((RegistryTraitDetail)((Object)registryTraitDetail));
        }
    }

    public void removeRegistryTraitDetail(RegistryTraitDetail registryTraitDetail) {
        Validate.notNull((Object)((Object)registryTraitDetail), (String)"Null Combat Experience Record specified.");
        this.getInternalRegistryTraitDetails().remove((Object)registryTraitDetail);
        registryTraitDetail.setRegistryTrait(null);
    }

    public RegistryTraitDetail getRegistryTraitDetailByEntityKey(EntityKey identifier) {
        return (RegistryTraitDetail)RegistryTrait.getEntityByEntityKey((Collection)this.getRegistryTraitDetails(), (EntityKey)identifier);
    }

    public RegistryTraitDetail removeRegistryTraitDetailByEntityKey(EntityKey identifier) {
        return (RegistryTraitDetail)RegistryTrait.removeEntityByEntityKey((Collection)this.getInternalRegistryTraitDetails(), (EntityKey)identifier);
    }

    public void removeAllRegistryTraitDetails() {
        this.getInternalRegistryTraitDetails().clear();
    }

    private void setInternalRegistryTraitDetails(Set registryTraitDetails) {
        this.internalRegistryTraitDetails = registryTraitDetails;
    }

    private Set getInternalRegistryTraitDetails() {
        if (this.internalRegistryTraitDetails == null) {
            this.internalRegistryTraitDetails = new HashSet();
        }
        return this.internalRegistryTraitDetails;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("registryType", (Object)this.registryType);
        builder.append("ssn", (Object)this.ssn);
        builder.append("prefix", (Object)this.prefix);
        builder.append("firstName", (Object)this.firstName);
        builder.append("middleName", (Object)this.middleName);
        builder.append("lastName", (Object)this.lastName);
        builder.append("suffix", (Object)this.suffix);
        builder.append("educationalDegree", (Object)this.educationalDegree);
        builder.append("deathDate", (Object)this.deathDate);
    }
}

